/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.chart;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.BindingContext;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.BaseGraphicType;
import kd.bos.form.chart.ChartData;
import kd.bos.form.chart.GaugeSeries;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.Series;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ChartClickArgs;
import kd.bos.form.control.events.ChartClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ISuportClick;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class Chart
extends Control
implements ISuportClick {
    private static Log log = LogFactory.getLog(Chart.class);
    private static final String SPAN_TYPE_PLUGIN = "plugin";
    private boolean is_ShowTitle = false;
    private boolean is_ShowLegend = false;
    private boolean is_ShowTooltip = false;
    private LocaleString name;
    private String titleXAlign = "left";
    private String titleYAlign = "top";
    private boolean is_LegendVertical = false;
    private String legendXAlign = "left";
    private String legendYAlign = "top";
    private Map<String, String> grid = new HashMap<String, String>();
    protected ChartData chartData = new ChartData();
    private Map<String, Object> legendData = new HashMap<String, Object>();
    private Map<String, Object> titleData = new HashMap<String, Object>();
    protected List<ClickListener> clickListeners = new ArrayList<ClickListener>();
    private boolean isMerge = true;
    private Map<String, Object> properties = new HashMap<String, Object>();

    @Override
    public void bindData(BindingContext object) {
        super.bindData(object);
        this.setData(this.chartData);
    }

    @KSMethod
    public void refresh() {
        this.setData(this.chartData);
    }

    @KSMethod
    public void clearData() {
        this.chartData = new ChartData();
    }

    @SimplePropertyAttribute(name="ShowTitle")
    @KSMethod
    public boolean isShowTitle() {
        return this.is_ShowTitle;
    }

    @KSMethod
    public void setShowTitle(boolean isShowTitle) {
        this.is_ShowTitle = isShowTitle;
    }

    @SimplePropertyAttribute(name="ShowLegend")
    @KSMethod
    public boolean isShowLegend() {
        return this.is_ShowLegend;
    }

    @KSMethod
    public void setShowLegend(boolean isShowLegend) {
        this.is_ShowLegend = isShowLegend;
    }

    @SimplePropertyAttribute(name="Name")
    @KSMethod
    public LocaleString getName() {
        return this.name;
    }

    @KSMethod
    public void setName(LocaleString name) {
        this.name = name;
    }

    public void setTitleAlign(XAlign x, YAlign y) {
        this.titleXAlign = x.name();
        this.titleYAlign = y.name();
    }

    @KSMethod
    public String getTitleXAlign() {
        return this.titleXAlign;
    }

    @KSMethod
    public String getTitleYAlign() {
        return this.titleYAlign;
    }

    @SimplePropertyAttribute(name="LegendVertical")
    @KSMethod
    public boolean isLegendVertical() {
        return this.is_LegendVertical;
    }

    @KSMethod
    public void setLegendVertical(boolean isLegendVertical) {
        this.is_LegendVertical = isLegendVertical;
    }

    public void setLegendAlign(XAlign x, YAlign y) {
        this.legendData.put("x", x.name());
        this.legendData.put("y", y.name());
    }

    @KSMethod
    public String getLegendXAlign() {
        return this.legendXAlign;
    }

    @KSMethod
    public String getLegendYAlign() {
        return this.legendYAlign;
    }

    @SimplePropertyAttribute(name="ShowTooltip")
    @KSMethod
    public boolean isShowTooltip() {
        return this.is_ShowTooltip;
    }

    @KSMethod
    public void setShowTooltip(boolean isShowTooltip) {
        this.is_ShowTooltip = isShowTooltip;
    }

    public void setMargin(Position pos, String value) {
        this.grid.put(pos.name(), value);
    }

    protected Map<String, String> getGrid() {
        return this.grid;
    }

    public void setGraphic(List<BaseGraphicType> baseGraphicTypes) {
        this.chartData.setUseGraphic(baseGraphicTypes);
    }

    public List<BaseGraphicType> getGraphic() {
        return this.chartData.getUseGraphic();
    }

    public void addGraphic(BaseGraphicType baseGraphicType) {
        this.chartData.getUseGraphic().add(baseGraphicType);
    }

    public void clearGraphic() {
        this.chartData.getUseGraphic().clear();
    }

    public Axis createXAxis(String name, AxisType type) {
        Axis axis = new Axis();
        axis.setName(name);
        axis.setType(type);
        this.chartData.addXAxis(axis);
        return axis;
    }

    public Axis createYAxis(String name, AxisType type) {
        Axis axis = new Axis();
        axis.setName(name);
        axis.setType(type);
        this.chartData.addYAxis(axis);
        return axis;
    }

    public BarSeries createBarSeries(String name) {
        BarSeries series = new BarSeries();
        series.setName(name);
        Label label = new Label();
        label.setShow(true);
        series.setLabel(label);
        this.chartData.addSeries(series);
        return series;
    }

    public LineSeries createLineSeries(String name) {
        LineSeries series = new LineSeries();
        series.setName(name);
        this.chartData.addSeries(series);
        return series;
    }

    public PieSeries createPieSeries(String name) {
        PieSeries series = new PieSeries();
        series.setName(name);
        this.chartData.addSeries(series);
        return series;
    }

    protected void setData(ChartData data) {
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.setFieldProperty(this.getKey(), "data", this.toCharData(data));
    }

    protected Map<String, Object> toCharData(ChartData data) {
        data.setChart(this);
        return data.toCharData();
    }

    public void chartClick(Map<String, Object> param) {
        log.debug("\u89e6\u53d1 - > chart\u70b9\u51fb\u4e8b\u4ef6");
        String nameTemp = (String)param.get("name");
        String seriesName = (String)param.get("seriesName");
        Number value = 0;
        Number seriesIndex = 0;
        Number dataIndex = 0;
        if (param.get("value") instanceof Number) {
            value = (Number)param.get("value");
        }
        if (param.get("seriesIndex") instanceof Number) {
            seriesIndex = (Number)param.get("seriesIndex");
        }
        if (param.get("dataIndex") instanceof Number) {
            dataIndex = (Number)param.get("dataIndex");
        }
        String componentType = (String)param.get("componentType");
        String seriesType = (String)param.get("seriesType");
        Object color = param.get("color");
        Object data = param.get("data");
        ChartClickArgs args = new ChartClickArgs(componentType, seriesType, seriesIndex, dataIndex, color, data);
        this.fireClick(new ChartClickEvent(this, seriesName, nameTemp, value, args));
    }

    @Override
    public void addClickListener(ClickListener listener) {
        this.clickListeners.add(listener);
    }

    private void fireClick(ChartClickEvent e) {
        if (this.clickListeners != null) {
            for (ClickListener l : this.clickListeners) {
                EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".click"));
                Throwable throwable = null;
                try {
                    l.click(e);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (span == null) continue;
                    if (throwable != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    span.close();
                }
            }
        }
    }

    @Override
    public void addItemClickListener(ItemClickListener listener) {
    }

    public void setLegendPropValue(String prop, Object obj) {
        this.legendData.put(prop, obj);
    }

    public Map<String, Object> getLegendData() {
        return this.legendData;
    }

    public void setTitlePropValue(String prop, Object obj) {
        this.titleData.put(prop, obj);
    }

    public Map<String, Object> getTitleData() {
        return this.titleData;
    }

    public void addTooltip(String key, Object value) {
        this.chartData.addTooltip(key, value);
    }

    @SdkInternal
    public void addFuncPath(List<Object> objLists) {
        this.chartData.addFuncPath(objLists);
    }

    public GaugeSeries createGaugeSeries(String name) {
        GaugeSeries series = new GaugeSeries();
        series.setName(name);
        this.chartData.addSeries(series);
        return series;
    }

    public Series createCustomSeries(String name) {
        Series series = new Series();
        series.setName(name);
        this.chartData.addSeries(series);
        return series;
    }

    @SdkInternal
    public boolean isMerge() {
        return this.isMerge;
    }

    @SdkInternal
    public void setMerge(boolean isMerge) {
        this.isMerge = isMerge;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void addProperty(String key, Object value) {
        if (!StringUtils.isBlank((CharSequence)key) && value != null) {
            this.properties.put(key, value);
        }
    }
}

