/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.chart;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.form.chart.ChartType;
import kd.bos.form.chart.GradientItem;
import kd.bos.form.chart.Series;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class LineSeries
extends Series {
    private static final String COLOR = "color";
    private static final String NORMAL = "normal";

    public LineSeries() {
        this.setType(ChartType.line);
    }

    public boolean isSmooth() {
        Boolean isSmooth = (Boolean)this.getPropValue("smooth");
        return isSmooth != null && isSmooth != false;
    }

    public void setSmooth(boolean smooth) {
        this.setPropValue("smooth", smooth);
    }

    public void setYAxisIndex(int axisIndex) {
        this.setPropValue("yAxisIndex", axisIndex);
    }

    public int getYAxisIndex() {
        Integer axisIndex = (Integer)this.getPropValue("yAxisIndex");
        if (axisIndex != null) {
            return axisIndex;
        }
        return 0;
    }

    public void setXAxisIndex(int axisIndex) {
        this.setPropValue("xAxisIndex", axisIndex);
    }

    public int getXAxisIndex() {
        Integer axisIndex = (Integer)this.getPropValue("xAxisIndex");
        if (axisIndex != null) {
            return axisIndex;
        }
        return 0;
    }

    public void setColor(String color) {
        this.setLineColor(color);
        this.setAreaColor(color);
    }

    public void setLineColor(String color) {
        Map<String, Object> normal = this.getLineNormalStyle();
        normal.put(COLOR, color);
    }

    private Map<String, Object> getLineNormalStyle() {
        HashMap normal;
        HashMap style = (HashMap)this.values.get("lineStyle");
        if (style == null) {
            style = new HashMap();
            this.values.put("lineStyle", style);
        }
        if ((normal = (HashMap)style.get(NORMAL)) == null) {
            normal = new HashMap();
            style.put(NORMAL, normal);
        }
        return normal;
    }

    public void setAreaColor(int beginX, int beginY, int endX, int endY, List<GradientItem> items) {
        Map<String, Object> normal = this.getAreaNormalStyle();
        normal.put(COLOR, this.areaColorToString(beginX, beginY, endX, endY, items));
    }

    private String areaColorToString(int beginX, int beginY, int endX, int endY, List<GradientItem> items) {
        StringBuilder str = new StringBuilder();
        str.append("new echarts.graphic.LinearGradient(");
        str.append(beginX).append(",").append(beginY).append(",").append(endX).append(",").append(endY).append(",[");
        for (int i = 0; i < items.size(); ++i) {
            GradientItem item = items.get(i);
            if (i > 0) {
                str.append(",");
            }
            str.append("{offset:").append(item.getOffset()).append(",color:'").append(item.getColor()).append("'}");
        }
        str.append("])");
        ArrayList<Object> path = new ArrayList<Object>();
        path.add("areaStyle");
        path.add(NORMAL);
        path.add(COLOR);
        this.addFuncPath(path);
        return str.toString();
    }

    public void setData(Number[] data) {
        List<Number> datas = Arrays.asList(data);
        this.values.put("data", datas);
    }

    public void addData(Number data) {
        List<Object> datas = this.getData();
        if (datas == null) {
            datas = new ArrayList<Object>();
            this.values.put("data", datas);
        }
        datas.add(data);
    }
}

