/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.chart.radar;

import java.math.BigDecimal;
import java.util.Map;
import kd.bos.form.BindingContext;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.radar.RadarAxis;
import kd.bos.form.chart.radar.RadarChartData;
import kd.bos.form.chart.radar.RadarSeries;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class RadarChart
extends Chart {
    private static final String VALUE = "value";
    protected RadarChartData radarChartData = new RadarChartData();

    public void addRadarSeries(RadarSeries radarSeries) {
        this.radarChartData.addSeries(radarSeries);
    }

    public void addRadarAxis(RadarAxis radarAxis) {
        this.radarChartData.addRadarAxis(radarAxis);
    }

    public void addVisualMap(Map<String, Object> visualMap) {
        this.radarChartData.addVisualMap(visualMap);
    }

    @Override
    public void bindData(BindingContext object) {
        super.bindData(object);
        this.setData(this.radarChartData);
    }

    protected void setData(RadarChartData data) {
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.setFieldProperty(this.getKey(), "data", this.toCharData(data));
    }

    protected Map<String, Object> toCharData(RadarChartData data) {
        data.setChart(this);
        return data.toCharData();
    }

    @Override
    public void chartClick(Map<String, Object> param) {
        if (!param.containsKey(VALUE)) {
            super.chartClick(param);
            return;
        }
        String values = param.get(VALUE).toString();
        String[] valueArray = values.split(",");
        BigDecimal value = null;
        value = valueArray.length != 1 ? new BigDecimal(valueArray[0].substring(1)) : new BigDecimal(valueArray[0]);
        param.put(VALUE, value);
        super.chartClick(param);
    }
}

