/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.chart.radar;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.ChartData;
import kd.bos.form.chart.Series;
import kd.bos.form.chart.radar.RadarAxis;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class RadarChartData
extends ChartData {
    private static final String ORIENT = "orient";
    private static final String VERTICAL = "vertical";
    private static final String DATA = "data";
    private static final String RADAR = "radar";
    private static final String LEGEND = "legend";
    private static final String VISUALMAP_KEY = "visualMap";
    private List<RadarAxis> radarAxisList = new ArrayList<RadarAxis>();
    private List<Map<String, Object>> UsevisualMap = new ArrayList<Map<String, Object>>();
    private Chart chart;

    public List<Map<String, Object>> getUsevisualMap() {
        return this.UsevisualMap;
    }

    public void addVisualMap(Map<String, Object> visual) {
        this.UsevisualMap.add(visual);
    }

    public List<RadarAxis> getRadarAxis() {
        return this.radarAxisList;
    }

    public void addRadarAxis(RadarAxis radarAxis) {
        this.radarAxisList.add(radarAxis);
    }

    @Override
    public void setChart(Chart chart) {
        this.chart = chart;
    }

    @Override
    protected Chart getChart() {
        return this.chart;
    }

    @Override
    public Map<String, Object> toCharData() {
        Chart chartTemp;
        Map<String, Object> data = super.toCharData();
        if (this.radarAxisList != null && !this.radarAxisList.isEmpty()) {
            ArrayList<Map<String, Object>> radarAxis = new ArrayList<Map<String, Object>>(10);
            for (RadarAxis x : this.radarAxisList) {
                radarAxis.add(x.getValues());
            }
            data.put(RADAR, radarAxis);
        }
        if ((chartTemp = this.getChart()).isShowLegend()) {
            data.put(LEGEND, this.getLegends());
        }
        if (this.UsevisualMap != null) {
            data.put(VISUALMAP_KEY, this.UsevisualMap);
        }
        return data;
    }

    private Map<String, Object> getLegends() {
        HashMap<String, Object> legendMap = new HashMap<String, Object>();
        legendMap.put(DATA, this.getLegendDatas());
        if (this.getChart().isLegendVertical()) {
            legendMap.put(ORIENT, VERTICAL);
        } else {
            legendMap.remove(ORIENT);
        }
        legendMap.putAll(this.getChart().getLegendData());
        return legendMap;
    }

    protected List<String> getLegendDatas() {
        List<Series> seriesList = super.getSeries();
        ArrayList<String> legend = new ArrayList<String>();
        for (Series series : seriesList) {
            List<Object> data = series.getData();
            if (data == null) continue;
            for (Object obj : data) {
                Map val = (Map)obj;
                String name = (String)val.get("name");
                if (legend.contains(name)) continue;
                legend.add(name);
            }
        }
        return legend;
    }
}

