/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.container;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.container.Container;
import kd.bos.form.container.VisualStyle;
import kd.bos.form.control.StepsOption;
import kd.bos.form.control.events.StepEvent;
import kd.bos.form.control.events.WizardStepsListener;
import kd.bos.script.annotations.KSMethod;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class Wizard
extends Container {
    private static final String SPAN_TYPE_PLUGIN = "plugin";
    private List<WizardStepsListener> wizardStepsListeners;
    private List<StepsOption> stepsOptions = new ArrayList<StepsOption>();

    @KSMethod
    public void addWizardStepsListener(WizardStepsListener listener) {
        if (this.wizardStepsListeners == null) {
            this.wizardStepsListeners = new ArrayList<WizardStepsListener>();
        }
        this.wizardStepsListeners.add(listener);
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=StepsOption.class)
    public List<StepsOption> getStepsOptions() {
        return this.stepsOptions;
    }

    public void setStepsOptions(List<StepsOption> stepsOptions) {
        this.stepsOptions = stepsOptions;
    }

    @KSMethod
    public void setWizardStepsOptions(List<StepsOption> stepsOptions) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "setWizardStepsOptions", stepsOptions.stream().map(StepsOption::toMap).collect(Collectors.toList()));
    }

    @KSMethod
    public void setVisualStyle(VisualStyle visualStyle) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.setFieldProperty(this.getKey(), "visualStyle", visualStyle.getValue());
    }

    @KSMethod
    public void setWizardCurrentStep(Map<String, Object> currentStepMap) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "setWizardCurrentStep", currentStepMap);
    }

    public void selectStep(int value) {
        StepEvent event = new StepEvent(this);
        event.setValue(value);
        if (this.wizardStepsListeners != null) {
            for (WizardStepsListener l : this.wizardStepsListeners) {
                EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".update"));
                Throwable throwable = null;
                try {
                    l.update(event);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (span == null) continue;
                    if (throwable != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    span.close();
                }
            }
        }
    }
}

