/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.control;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.ClientActions;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.EntryViewType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.HeaderCellClickEvent;
import kd.bos.form.control.events.HeaderCellClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SelectRowsEvent;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.PagerClickEvent;
import kd.bos.form.events.PagerClickListener;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public abstract class AbstractGrid
extends Container {
    private static final String SPAN_TYPE_PLUGIN = "plugin";
    private static final String MAX_PAGE_ROW = "5000";
    private boolean splitPage;
    protected int pageRow = 20;
    private String maxPageRow;
    private String toolbarLocation = "-1";
    public static final String VIRTUAL_GRID = "VIRTUALVIEWGRID";
    private List<PagerClickListener> pagerClickListeners;
    private static final String SELROWS = "selRows";
    protected List<HyperLinkClickListener> hyperLinkClickListeners;
    protected List<RowClickEventListener> rowClickEventListeners;
    protected List<CellClickListener> cellClickListeners;
    protected List<HeaderCellClickListener> headerCellClickListeners;
    protected List<ItemClickListener> barItemClickListeners = new ArrayList<ItemClickListener>();
    protected List<SelectRowsEventListener> selectRowsListeners;
    private List<Map<String, String>> freezeList;
    private boolean showGridConfig;
    private List<Map<String, String>> initField;
    private String columnWidthStyle;
    private String pageType = "";
    private boolean isPagerChanged;

    @SimplePropertyAttribute
    public List<Map<String, String>> getFreezeList() {
        return this.freezeList;
    }

    public void setFreezeList(List<Map<String, String>> freezeList) {
        this.freezeList = freezeList;
    }

    @SimplePropertyAttribute(name="ShowGridConfig")
    public boolean isShowGridConfig() {
        return this.showGridConfig;
    }

    public void setShowGridConfig(boolean showGridConfig) {
        this.showGridConfig = showGridConfig;
    }

    @SimplePropertyAttribute
    public List<Map<String, String>> getInitField() {
        return this.initField;
    }

    public void setInitField(List<Map<String, String>> initField) {
        this.initField = initField;
    }

    @SimplePropertyAttribute(name="ColumnWidthStyle")
    public String getColumnWidthStyle() {
        return this.columnWidthStyle;
    }

    public void setColumnWidthStyle(String columnWidthStyle) {
        this.columnWidthStyle = columnWidthStyle;
    }

    @Override
    @SdkInternal
    public void postBack(Object value) {
        Map state = (Map)value;
        GridState gridState = this.getEntryState();
        boolean isFocusRowChanged = false;
        int oldFocusRow = 0;
        int newFocusRow = 0;
        List newRows = (List)state.get(SELROWS);
        List oldRows = (List)gridState.get(SELROWS);
        for (Map.Entry entry : state.entrySet()) {
            if ("row".equals(entry.getKey())) {
                int newRow;
                int oldRow = gridState.getFocusRow();
                if (oldRow == (newRow = entry.getValue() == null ? oldRow : (Integer)entry.getValue())) continue;
                oldFocusRow = oldRow;
                newFocusRow = newRow;
                isFocusRowChanged = true;
                gridState.put((String)entry.getKey(), entry.getValue());
                continue;
            }
            gridState.put((String)entry.getKey(), entry.getValue());
        }
        if (isFocusRowChanged) {
            this.focusedRowChanged(newFocusRow, oldFocusRow);
        }
        if (!this.isEqualsRow(newRows, oldRows)) {
            this.selectRowsChanged(newRows, oldRows);
        }
    }

    @KSMethod
    @SdkInternal
    public boolean isEqualsRow(List<Integer> newRows, List<Integer> oldRows) {
        Integer value;
        String key;
        int i;
        if (newRows == null && oldRows == null) {
            return true;
        }
        if (newRows == null && oldRows != null && oldRows.size() == 0) {
            return true;
        }
        if (oldRows == null && newRows != null && newRows.size() == 0) {
            return true;
        }
        if (newRows == null || oldRows == null || newRows.size() != oldRows.size()) {
            return false;
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (i = 0; i < newRows.size(); ++i) {
            key = String.valueOf(newRows.get(i));
            if (map.containsKey(key)) {
                value = (Integer)map.get(key);
                value = value + 1;
                map.put(key, value);
                continue;
            }
            map.put(key, 1);
        }
        for (i = 0; i < oldRows.size(); ++i) {
            key = String.valueOf(oldRows.get(i));
            if (!map.containsKey(key)) {
                return false;
            }
            value = (Integer)map.get(key);
            value = value - 1;
            map.put(key, value);
        }
        for (i = 0; i < newRows.size(); ++i) {
            Integer value2 = (Integer)map.get(String.valueOf(newRows.get(i)));
            if (value2 == 0) continue;
            return false;
        }
        return true;
    }

    @KSMethod
    public void selectRowsChanged(List<Integer> newRows, List<Integer> oldRows) {
        SelectRowsEvent evt = new SelectRowsEvent(this, newRows, oldRows);
        if (this.selectRowsListeners != null) {
            for (SelectRowsEventListener l : this.selectRowsListeners) {
                EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".selectRowsChange"));
                Throwable throwable = null;
                try {
                    l.selectRowsChange(evt);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (span == null) continue;
                    if (throwable != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    span.close();
                }
            }
        }
    }

    protected void focusedRowChanged(int newRow, int oldRow) {
    }

    @KSMethod
    @SimplePropertyAttribute(name="SplitPage")
    public boolean isSplitPage() {
        return this.splitPage;
    }

    @KSMethod
    public void setSplitPage(boolean splitPage) {
        this.splitPage = splitPage;
    }

    @SimplePropertyAttribute(name="PageType")
    public String getPageType() {
        return this.pageType;
    }

    public void setPageType(String type) {
        this.pageType = type;
    }

    @KSMethod
    @SimplePropertyAttribute
    @DefaultValueAttribute(value="20")
    public int getPageRow() {
        if (this.view != null) {
            GridState entryState = this.getEntryState();
            int statePageRows = entryState.getPageRows();
            return statePageRows != 0 ? statePageRows : this.pageRow;
        }
        return this.pageRow;
    }

    @KSMethod
    public void setPageRow(int pageRow) {
        this.pageRow = pageRow;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="5000")
    public String getMaxPageRow() {
        return this.maxPageRow;
    }

    public void setMaxPageRow(String maxPageRow) {
        this.maxPageRow = maxPageRow;
    }

    @SimplePropertyAttribute(name="ToolbarLocation")
    @DefaultValueAttribute(value="-1")
    public String getToolbarLocation() {
        return this.toolbarLocation;
    }

    public void setToolbarLocation(String toolbarLocation) {
        this.toolbarLocation = toolbarLocation;
    }

    @KSMethod
    public void addSelectRowsListener(SelectRowsEventListener listener) {
        if (this.selectRowsListeners == null) {
            this.selectRowsListeners = new ArrayList<SelectRowsEventListener>();
        }
        this.selectRowsListeners.add(listener);
    }

    @KSMethod
    public void showGridHelp() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setFormId("ide_griduserhelp");
        this.getView().showForm(showParameter);
    }

    @KSMethod
    public void addPagerClickListener(PagerClickListener listener) {
        if (this.pagerClickListeners == null) {
            this.pagerClickListeners = new ArrayList<PagerClickListener>();
        }
        this.pagerClickListeners.add(listener);
    }

    @KSMethod
    public GridState getEntryState() {
        IClientViewProxy proxy = (IClientViewProxy)this.view.getService(IClientViewProxy.class);
        GridState entryState = proxy.getEntryState(this.getEntryKey());
        if (entryState.getPageRows() == 0) {
            if (this.pageRow != 0) {
                entryState.setPageRows(this.pageRow);
            } else {
                entryState.setPageRows(20);
            }
        }
        return entryState;
    }

    @KSMethod
    public void clearEntryState() {
        this.selectRows(new int[0], -1);
        GridState gridState = this.getEntryState();
        gridState.put("selDatas", null);
        gridState.put("fieldKey", null);
        gridState.setScrollStart(0);
        gridState.setScrollLimit(1000);
        gridState.setSelectPageAllRows(false);
    }

    @KSMethod
    public String getEntryKey() {
        return this.getKey();
    }

    @KSMethod
    public void addHyperClickListener(HyperLinkClickListener listener) {
        if (this.hyperLinkClickListeners == null) {
            this.hyperLinkClickListeners = new ArrayList<HyperLinkClickListener>();
        }
        this.hyperLinkClickListeners.add(listener);
    }

    @KSMethod
    public void addCellClickListener(CellClickListener listener) {
        if (this.cellClickListeners == null) {
            this.cellClickListeners = new ArrayList<CellClickListener>();
        }
        this.cellClickListeners.add(listener);
    }

    @KSMethod
    public void addHeaderCellClickListener(HeaderCellClickListener listener) {
        if (this.headerCellClickListeners == null) {
            this.headerCellClickListeners = new ArrayList<HeaderCellClickListener>();
        }
        this.headerCellClickListeners.add(listener);
    }

    @KSMethod
    public void addRowClickListener(RowClickEventListener listener) {
        if (this.rowClickEventListeners == null) {
            this.rowClickEventListeners = new CopyOnWriteArrayList<RowClickEventListener>();
        }
        this.rowClickEventListeners.add(listener);
    }

    @KSMethod
    @SdkInternal
    public void clickHeaderCell(String fieldKey) {
        HeaderCellClickEvent evt = new HeaderCellClickEvent(this, fieldKey);
        if (this.headerCellClickListeners != null) {
            for (HeaderCellClickListener l : this.headerCellClickListeners) {
                EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".headerCellClick"));
                Throwable throwable = null;
                try {
                    l.headerCellClick(evt);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (span == null) continue;
                    if (throwable != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    span.close();
                }
            }
        }
    }

    @KSMethod
    @SdkInternal
    public void itemClick(String id, String operationKey) {
        BeforeItemClickEvent evt = new BeforeItemClickEvent(this, id, operationKey);
        this.fireBeforeItemClick(evt);
        if (!evt.isCancel()) {
            if (StringUtils.isNotBlank((CharSequence)operationKey)) {
                this.getView().invokeOperation(operationKey);
            }
            ItemClickEvent evt1 = new ItemClickEvent(this, id, operationKey);
            this.fireItemClick(evt1);
        }
    }

    private void fireBeforeItemClick(BeforeItemClickEvent e) {
        for (ItemClickListener l : this.barItemClickListeners) {
            EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".beforeItemClick"));
            Throwable throwable = null;
            try {
                l.beforeItemClick(e);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                span.close();
            }
        }
    }

    private void fireItemClick(ItemClickEvent e) {
        for (ItemClickListener l : this.barItemClickListeners) {
            EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".itemClick"));
            Throwable throwable = null;
            try {
                l.itemClick(e);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                span.close();
            }
        }
    }

    @KSMethod
    public void clickCell(String fieldKey, int row) {
        CellClickEvent evt = new CellClickEvent(this, row, fieldKey);
        if (this.cellClickListeners != null) {
            for (CellClickListener l : this.cellClickListeners) {
                EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".cellClick"));
                Throwable throwable = null;
                try {
                    l.cellClick(evt);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (span == null) continue;
                    if (throwable != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    span.close();
                }
            }
        }
    }

    @KSMethod
    public void doubleClickCell(String fieldKey, int row) {
        CellClickEvent evt = new CellClickEvent(this, row, fieldKey);
        if (this.cellClickListeners != null) {
            for (CellClickListener l : this.cellClickListeners) {
                EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".cellDoubleClick"));
                Throwable throwable = null;
                try {
                    l.cellDoubleClick(evt);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (span == null) continue;
                    if (throwable != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    span.close();
                }
            }
        }
    }

    @KSMethod
    public void entryRowDoubleClick(Integer row) {
        this.doubleClickCell(this.getEntryState().getFocusField(), row);
        RowClickEvent evt = new RowClickEvent(this, row);
        if (this.rowClickEventListeners != null) {
            for (RowClickEventListener l : this.rowClickEventListeners) {
                EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".entryRowDoubleClick"));
                Throwable throwable = null;
                try {
                    l.entryRowDoubleClick(evt);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (span == null) continue;
                    if (throwable != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    span.close();
                }
            }
        }
    }

    @KSMethod
    public void entryRowClick(Integer row) {
        this.clickCell(this.getEntryState().getFocusField(), row);
        RowClickEvent evt = new RowClickEvent(this, row);
        if (this.rowClickEventListeners != null) {
            for (RowClickEventListener l : this.rowClickEventListeners) {
                EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".entryRowClick"));
                Throwable throwable = null;
                try {
                    l.entryRowClick(evt);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (span == null) continue;
                    if (throwable != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    span.close();
                }
            }
        }
        GridState myEntryState = this.getEntryState();
        Map<String, Object> state = myEntryState.getState();
        List selectedList = (List)state.get(SELROWS);
        int selectedRowsCount = 0;
        if (selectedList != null) {
            selectedRowsCount = selectedList.size();
        }
        HashMap<String, Integer> selectedDataInfo = new HashMap<String, Integer>();
        selectedDataInfo.put("selectedRowsCount", selectedRowsCount);
        this.clientViewProxy.invokeControlMethod(this.getKey(), "setSelectedDataInfo", selectedDataInfo);
    }

    @KSMethod
    public void selectRows(int[] rowIndex, int focusRowIndex) {
        this.selectRows(rowIndex, focusRowIndex, false);
    }

    protected int getSelectedRowsCount(int selectedRowsCount) {
        return selectedRowsCount;
    }

    @SdkInternal
    public boolean isStopSelectRow() {
        return false;
    }

    protected void selectRows(int[] rowIndex, int focusRowIndex, boolean forceRefocus) {
        if (this.isStopSelectRow()) {
            return;
        }
        int oldfocusRow = this.getEntryState().getFocusRow();
        this.clientViewProxy.selectRows(this.getEntryKey(), rowIndex, focusRowIndex);
        HashMap<String, Integer> selectedDataInfo = new HashMap<String, Integer>();
        selectedDataInfo.put("selectedRowsCount", this.getSelectedRowsCount(rowIndex.length));
        this.clientViewProxy.invokeControlMethod(this.getKey(), "setSelectedDataInfo", selectedDataInfo);
        if (forceRefocus || oldfocusRow != focusRowIndex) {
            this.focusedRowChanged(oldfocusRow, focusRowIndex);
        }
    }

    @KSMethod
    public void selectRows(int rowIndex) {
        this.selectRows(rowIndex, false);
    }

    @KSMethod
    public void selectRows(int rowIndex, boolean forceRefocus) {
        int row = rowIndex < 0 ? -1 : rowIndex;
        int[] rows = null;
        rows = row < 0 ? new int[]{} : new int[]{row};
        this.selectRows(rows, row, forceRefocus);
    }

    @KSMethod
    public void focusCell(int rowIndex, String colKey) {
        this.clientViewProxy.focusCell(this.getEntryKey(), rowIndex, colKey);
    }

    @KSMethod
    public void setPageRows(int rows) {
        GridState myEntryState = this.getEntryState();
        myEntryState.setCurrentPageIndex(1);
        this.firePagerClick(myEntryState.getCurrentPageIndex(), rows);
        myEntryState.setPageRows(rows);
        this.bindData(null);
    }

    protected boolean isPagerChanged() {
        return this.isPagerChanged;
    }

    @SdkInternal
    protected void firePagerClick(int currentPageIndex, int pageRows) {
        this.isPagerChanged = true;
        PagerClickEvent pagerClickEvent = new PagerClickEvent(this, currentPageIndex, pageRows);
        if (this.pagerClickListeners != null) {
            for (PagerClickListener pagerClickListener : this.pagerClickListeners) {
                EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(pagerClickListener.getClass().getName() + ".pagerClick"));
                Throwable throwable = null;
                try {
                    pagerClickListener.pagerClick(pagerClickEvent);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (span == null) continue;
                    if (throwable != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    span.close();
                }
            }
        }
    }

    @KSMethod
    public void hyperLinkClick(String fieldName, int rowIndex) {
        GridState gridState = this.getEntryState();
        gridState.put("hyperLinkRowIndex", rowIndex);
        HyperLinkClickEvent hyperLinkClickEvent = this.createHyperLinkClickEvent(fieldName, rowIndex);
        if (this.hyperLinkClickListeners != null) {
            for (HyperLinkClickListener hyperLinkClickListener : this.hyperLinkClickListeners) {
                EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(hyperLinkClickListener.getClass().getName() + ".hyperLinkClick"));
                Throwable throwable = null;
                try {
                    hyperLinkClickListener.hyperLinkClick(hyperLinkClickEvent);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (span == null) continue;
                    if (throwable != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    span.close();
                }
            }
        }
    }

    @KSMethod
    protected HyperLinkClickEvent createHyperLinkClickEvent(String fieldName, int rowIndex) {
        return new HyperLinkClickEvent(this, fieldName, rowIndex);
    }

    @Deprecated
    public void setCellBackcolor(String fieldKey, String color, int[] rowIndexes) {
        ArrayList rowStyle = new ArrayList();
        HashMap<String, String> mapStyle = new HashMap<String, String>();
        mapStyle.put("bc", color);
        HashMap<String, Object> val = new HashMap<String, Object>();
        val.put("r", rowIndexes);
        val.put("k", fieldKey);
        val.put("s", mapStyle);
        rowStyle.add(val);
        this.clientViewProxy.invokeControlMethod(this.key, "setCellStyle", rowStyle);
    }

    @KSMethod
    public void setCellStyle(List<CellStyle> cellStyles) {
        ClientActions.createCellStyle().addAll(cellStyles).invokeControlMethod(this.clientViewProxy, this.key);
    }

    @KSMethod
    public void setMustInput(String fieldKey, boolean value) {
        this.clientViewProxy.invokeControlMethod(this.key, "setColEditorProp", fieldKey, "mi", value);
    }

    public void setColumnProperty(String fieldKey, String propertyName, Object value) {
        this.clientViewProxy.invokeControlMethod(this.key, "setColProp", fieldKey, propertyName, value);
    }

    @KSMethod
    public void setRowBackcolor(String color, int[] rowIndexes) {
        ClientActions.createRowStyleBuilder().setRows(rowIndexes).setBackColor(color).buildStyle().build().invokeControlMethod(this.clientViewProxy, this.key);
    }

    public void setCustomProperties(String key, int rowIndex, Map<String, Object> props) {
        this.clientViewProxy.invokeControlMethod(this.key, "setCustomProperties", rowIndex, props);
    }

    @KSMethod
    public void hideOperateItems(String key, int rowIndex, List<String> operationKeys) {
        ClientActions.createHideOpItemBuilder().setColumn(key).setRowKey(rowIndex).setOperationKeys(operationKeys).invokeControlMethod(this.clientViewProxy, this.key);
    }

    @KSMethod
    public void showOperateItems(String key, int rowIndex, List<String> operationKeys) {
        ClientActions.createShowOpItemBuilder().setColumn(key).setRowKey(rowIndex).setOperationKeys(operationKeys).invokeControlMethod(this.clientViewProxy, this.key);
    }

    protected List<Object> getAppendRows() {
        return new ArrayList<Object>();
    }

    @KSMethod
    public void setNextpageData(int rows) {
        GridState entryState = this.getEntryState();
        int currentPageIndex = entryState.getCurrentPageIndex() + 1;
        entryState.setCurrentPageIndex(currentPageIndex);
        this.firePagerClick(currentPageIndex, entryState.getPageRows());
        this.clientViewProxy.preInvokeControlMethod(this.getKey(), "appendRows", this.getAppendRows());
    }

    @KSObject
    public static class GridState {
        public static final int DEFAULTPAGEROWS = 20;
        @SdkInternal
        public static final int FORCE_SPLIT_PAGE_ROWS = 1000;
        private String key;
        private Map<String, Object> state;

        public final String getKey() {
            return this.key;
        }

        public GridState(String key, Map<String, Object> state) {
            this.key = key;
            this.state = state;
        }

        public Map<String, Object> getState() {
            return this.state;
        }

        public Map<String, Object> setState(Map<String, Object> state) {
            this.state = state;
            return this.state;
        }

        @KSMethod
        public final boolean getIsClientNewRow() {
            Object ret = this.state.get("isClientNewRow");
            if (ret instanceof Boolean) {
                return (Boolean)ret;
            }
            return false;
        }

        public boolean isKeepPageData() {
            Object ret = this.state.get("isKeepPageData");
            if (ret instanceof Boolean) {
                return (Boolean)ret;
            }
            return true;
        }

        public void setKeepPageData(boolean isKeepPageData) {
            this.state.put("isKeepPageData", isKeepPageData);
        }

        public boolean isSelectAllRows() {
            Object ret = this.state.get("isSelectAllRows");
            if (ret instanceof Boolean) {
                return (Boolean)ret;
            }
            return false;
        }

        public void setSelectAllRows(boolean isSelectAllRows) {
            this.state.put("isSelectAllRows", isSelectAllRows);
        }

        public boolean isHasAllRows() {
            Object ret = this.state.get("isHasAllRows");
            if (ret instanceof Boolean) {
                return (Boolean)ret;
            }
            return false;
        }

        public void setHasAllRows(boolean isSelectAllRows) {
            this.state.put("isHasAllRows", isSelectAllRows);
        }

        @KSMethod
        public Boolean isScrollLoad() {
            Object v = this.state.get("isScrollLoad");
            if (v != null) {
                return Boolean.parseBoolean(v.toString());
            }
            return null;
        }

        public void setScrollLoad(Boolean isScrollLoad) {
            this.state.put("isScrollLoad", isScrollLoad);
        }

        @KSMethod
        public Integer getMaxPageSize() {
            Object v = this.state.get("maxPageSize");
            if (v != null) {
                return Integer.parseInt(v.toString());
            }
            return null;
        }

        public void setMaxPageSize(Integer maxPageSize) {
            this.state.put("maxPageSize", maxPageSize);
        }

        @KSMethod
        public Integer getPageRows() {
            Object v = this.state.get("pageRows");
            if (v == null) {
                return 0;
            }
            Integer pageRows = (Integer)v;
            Integer maxPageSize = this.getMaxPageSize();
            if (maxPageSize != null && pageRows > maxPageSize) {
                return maxPageSize;
            }
            if (maxPageSize == null && pageRows > 1000) {
                return 1000;
            }
            return pageRows;
        }

        public void setPageRows(int count) {
            this.state.put("pageRows", count);
        }

        @KSMethod
        public final boolean isSelectPageAllRows() {
            Object isSelectPageAllRows = this.state.get("isSelectPageAllRows");
            return isSelectPageAllRows == null ? false : (Boolean)isSelectPageAllRows;
        }

        public final void setSelectPageAllRows(boolean isSelectPageAllRows) {
            this.state.put("isSelectPageAllRows", isSelectPageAllRows);
        }

        @KSMethod
        public final int getScrollStart() {
            Object rollStart = this.state.get("scrollStart");
            return rollStart == null ? 0 : (Integer)rollStart;
        }

        public final void setScrollStart(int start) {
            this.state.put("scrollStart", start);
        }

        @KSMethod
        public final int getScrollLimit() {
            Object rollLimit = this.state.get("scrollLimit");
            return rollLimit == null ? 1000 : (Integer)rollLimit;
        }

        public final void setScrollLimit(int limit) {
            this.state.put("scrollLimit", limit);
        }

        @KSMethod
        public final int getFocusRow() {
            Object row = this.state.get("row");
            return row == null ? -1 : (Integer)row;
        }

        public final void setFocusRow(int focusRow) {
            this.state.put("row", focusRow);
        }

        @KSMethod
        public final String getFocusField() {
            Object fieldKey = null;
            fieldKey = this.state.get("fieldKey");
            return fieldKey instanceof String ? (String)fieldKey : "";
        }

        public final void selectRow(int focusRow) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            list.add(focusRow);
            this.state.put(AbstractGrid.SELROWS, list);
        }

        public final void selectRow(int[] selectRow) {
            ArrayList<Integer> list = new ArrayList<Integer>(10);
            for (int i : selectRow) {
                list.add(i);
            }
            this.state.put(AbstractGrid.SELROWS, list);
        }

        @KSMethod
        public final int[] getFocusRows() {
            int[] nArray;
            Object row = this.state.get("row");
            if (row == null) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = 0;
            } else {
                int[] nArray3 = new int[1];
                nArray = nArray3;
                nArray3[0] = (Integer)row;
            }
            return nArray;
        }

        public final void moveUp() {
            ArrayList selRows = (ArrayList)this.state.get(AbstractGrid.SELROWS);
            for (int i = 0; i < selRows.size(); ++i) {
                selRows.set(i, (Integer)selRows.get(i) - 1);
            }
            this.state.put(AbstractGrid.SELROWS, selRows);
            this.state.put("row", this.getFocusRow() - 1);
        }

        public final void moveDown() {
            ArrayList selRows = (ArrayList)this.state.get(AbstractGrid.SELROWS);
            for (int i = 0; i < selRows.size(); ++i) {
                selRows.set(i, (Integer)selRows.get(i) + 1);
            }
            this.state.put(AbstractGrid.SELROWS, selRows);
            this.state.put("row", this.getFocusRow() + 1);
        }

        public final void moveTop() {
            ArrayList selRows = (ArrayList)this.state.get(AbstractGrid.SELROWS);
            for (int i = 0; i < selRows.size(); ++i) {
                selRows.set(i, i);
            }
            this.state.put(AbstractGrid.SELROWS, selRows);
        }

        public final void moveBottom(int rowCount) {
            ArrayList selRows = (ArrayList)this.state.get(AbstractGrid.SELROWS);
            for (int i = selRows.size() - 1; i >= 0; --i) {
                selRows.set(i, --rowCount);
            }
            this.state.put(AbstractGrid.SELROWS, selRows);
        }

        @KSMethod
        public final int[] getSelectedRows() {
            List ret = null;
            try {
                ret = (List)this.state.get(AbstractGrid.SELROWS);
            }
            catch (Exception e) {
                return new int[0];
            }
            if (ret == null) {
                return new int[0];
            }
            int[] a = new int[ret.size()];
            for (int i = 0; i < a.length; ++i) {
                a[i] = (Integer)ret.get(i);
            }
            return a;
        }

        @KSMethod
        public final String[] getClientNewRows() {
            Object otherNewRows = "";
            ArrayList<String> ret = new ArrayList<String>();
            otherNewRows = this.state.get("clientNewRows");
            if (otherNewRows != null && otherNewRows instanceof String) {
                String[] sRows;
                for (String s : sRows = ((String)otherNewRows).split("[,]", -1)) {
                    ret.add(s);
                }
            }
            return ret.toArray(new String[0]);
        }

        @KSMethod
        public Integer getCurrentPageIndex() {
            Object v = this.state.get("pageIndex");
            if (v == null) {
                return 1;
            }
            return (Integer)v;
        }

        public void setCurrentPageIndex(Integer value) {
            this.state.put("pageIndex", value);
        }

        public Object get(String propName) {
            return this.state.get(propName);
        }

        public void put(String propName, Object value) {
            this.state.put(propName, value);
        }

        @KSMethod
        public final String getSortInfo() {
            return (String)this.state.get("sortInfo");
        }

        public final void setSortInfo(String sortInfo) {
            this.state.put("sortInfo", sortInfo);
        }

        @KSMethod
        public final String getColumnQFilter() {
            return (String)this.state.get("columnQFilter");
        }

        public final void setColumnQFilter(String filters) {
            this.state.put("columnQFilter", filters);
        }

        public final void setOldCondition(String oldCondition) {
            this.state.put("oldCondition", oldCondition);
        }

        @KSMethod
        public final String getOldCondition() {
            return (String)this.state.get("oldCondition");
        }

        @KSMethod
        public final EntryViewType getEntryViewType() {
            Object type = this.state.get("entryviewtype");
            if (StringUtils.isBlank((Object)type)) {
                return EntryViewType.GridView;
            }
            for (EntryViewType viewType : EntryViewType.values()) {
                if (!viewType.getValue().equals(type)) continue;
                return viewType;
            }
            return EntryViewType.GridView;
        }

        public final void setEntryViewType(EntryViewType entryViewType) {
            this.state.put("entryviewtype", entryViewType.getValue());
        }

        public final Map<String, Object> getEntryFilter() {
            Object entryFilter = this.state.get("entryFilter");
            LinkedHashMap<String, Serializable> map = new LinkedHashMap<String, Serializable>();
            map.put("entryFilterChanged", Boolean.valueOf(false));
            map.put("filterRowIndexs", new ArrayList());
            return entryFilter instanceof Map ? (Map)entryFilter : map;
        }

        public final void setEntryFilter(Map<String, Object> entryFilter) {
            this.state.put("entryFilter", entryFilter);
        }

        public final Map<String, Object> getEntryFilterStatus() {
            Object entryFilter = this.state.get("entryFilterStatus");
            return entryFilter instanceof Map ? (Map)entryFilter : new LinkedHashMap();
        }

        public final void setEntryFilterStatus(Map<String, Object> entryFilter) {
            this.state.put("entryFilterStatus", entryFilter);
        }
    }
}

