/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.control;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BadgeInfo;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ca.CertInfo;
import kd.bos.form.BindingContext;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IMobileView;
import kd.bos.form.TipsSupport;
import kd.bos.form.control.Control;
import kd.bos.form.control.UrlUtil;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.BeforeUploadEvent;
import kd.bos.form.control.events.ClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ISuportClick;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.attachment.AttachmentInfo;
import kd.bos.mservice.attachment.AttachmentModel;
import kd.bos.mservice.attachment.AttachmentOpType;
import kd.bos.mservice.attachment.FieldType;
import kd.bos.mservice.attachment.IAttachmentManagerService;
import kd.bos.mservice.attachment.IAttachmentService;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.service.ServiceFactory;
import kd.bos.upload.UploadOption;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class Button
extends TipsSupport
implements ISuportClick {
    private static final String SPAN_TYPE_PLUGIN = "plugin";
    private String operationKey;
    private static final Log log = LogFactory.getLog(Button.class);
    protected List<ClickListener> buttonClickListeners = new ArrayList<ClickListener>();
    protected List<ItemClickListener> itemClickListeners = new ArrayList<ItemClickListener>();
    protected List<UploadListener> uploadListeners = new ArrayList<UploadListener>();

    @Override
    @KSMethod
    public void addClickListener(ClickListener listener) {
        this.buttonClickListeners.add(listener);
    }

    @Override
    public void addItemClickListener(ItemClickListener listener) {
        this.itemClickListeners.add(listener);
    }

    @SimplePropertyAttribute
    @KSMethod
    public String getOperationKey() {
        return this.operationKey;
    }

    @KSMethod
    public void setOperationKey(String operationKey) {
        this.operationKey = operationKey;
    }

    @Override
    @SdkInternal
    public void bindData(BindingContext object) {
    }

    @SdkInternal
    @Deprecated
    @KSMethod
    public void showUpload(UploadOption option) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pageId", this.getView().getPageId());
        params.put("key", this.getKey());
        if (option != null) {
            params.put("multiple", option.isMultiple());
            params.put("title", option.getTitle());
            params.put("suffix", option.getSuffix());
            if (option.getLimitSize() <= 0L) {
                params.put("limitSize", Integer.MAX_VALUE);
            } else {
                params.put("limitSize", option.getLimitSize());
            }
        }
        proxy.addAction("getCustomerFile", params);
    }

    @KSMethod
    public void click() {
        BeforeClickEvent e = new BeforeClickEvent(this);
        this.fireBeforeClick(e);
        if (!e.isCancel()) {
            if (StringUtils.isNotBlank((CharSequence)this.operationKey)) {
                this.getView().invokeOperation(this.operationKey);
            }
            this.fireClick(e);
        }
    }

    @KSMethod
    public void itemClick(String id, String operationKey) {
        BeforeItemClickEvent e = new BeforeItemClickEvent(this, id, operationKey);
        this.fireBeforeItemClick(e);
        if (!e.isCancel()) {
            if (StringUtils.isNotBlank((CharSequence)operationKey)) {
                this.getView().invokeOperation(operationKey);
            }
            this.fireItemClick(id, operationKey);
        }
    }

    private void fireItemClick(String id, String operationKey) {
        ItemClickEvent evt = new ItemClickEvent(this, id, operationKey);
        for (ItemClickListener l : this.itemClickListeners) {
            if (!this.isNotOverride(l.getClass(), "itemClick", evt, ItemClickEvent.class)) continue;
            EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".itemClick"));
            Throwable throwable = null;
            try {
                l.itemClick(evt);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                span.close();
            }
        }
    }

    private void fireBeforeItemClick(BeforeItemClickEvent e) {
        for (ItemClickListener l : this.itemClickListeners) {
            if (!this.isNotOverride(l.getClass(), "beforeItemClick", e, BeforeItemClickEvent.class)) continue;
            EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".beforeItemClick"));
            Throwable throwable = null;
            try {
                l.beforeItemClick(e);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                span.close();
            }
        }
    }

    private void fireBeforeClick(BeforeClickEvent e) {
        for (ClickListener l : this.buttonClickListeners) {
            if (!this.isNotOverride(l.getClass(), "beforeClick", e, BeforeClickEvent.class)) continue;
            EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".beforeClick"));
            Throwable throwable = null;
            try {
                l.beforeClick(e);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                span.close();
            }
        }
    }

    private void fireClick(ClickEvent e) {
        if (this.buttonClickListeners != null) {
            for (ClickListener l : this.buttonClickListeners) {
                if (!this.isNotOverride(l.getClass(), "click", e, ClickEvent.class)) continue;
                EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".click"));
                Throwable throwable = null;
                try {
                    l.click(e);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (span == null) continue;
                    if (throwable != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    span.close();
                }
            }
        }
    }

    @KSMethod
    public void addUploadListener(UploadListener listener) {
        this.uploadListeners.add(listener);
    }

    public void beforeUpload(List<Map<String, Object>> attachs) {
        BeforeUploadEvent evt = new BeforeUploadEvent((Object)this, attachs);
        for (UploadListener l : this.uploadListeners) {
            EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".beforeUpload"));
            Throwable throwable = null;
            try {
                l.beforeUpload(evt);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                span.close();
            }
        }
    }

    public void upload(List<Map<String, Object>> attachs) {
        AttachmentModel attachmentModel;
        List infos;
        Throwable throwable;
        EntityTraceSpan span;
        IAttachmentService service = (IAttachmentService)ServiceFactory.getService(IAttachmentService.class);
        IAttachmentManagerService managerService = (IAttachmentManagerService)ServiceFactory.getService(IAttachmentManagerService.class);
        ArrayList<String> fileNameList = new ArrayList<String>(attachs.size());
        ArrayList<String> urlList = new ArrayList<String>(attachs.size());
        boolean newFormat = false;
        for (Map<String, Object> map : attachs) {
            if (!(map instanceof Map)) continue;
            Map<String, Object> attachMap = map;
            fileNameList.add(String.valueOf(attachMap.get("name")));
            urlList.add(String.valueOf(attachMap.get("url")));
            newFormat = Boolean.parseBoolean(String.valueOf(attachMap.get("newFormat")));
        }
        UploadEvent evt = newFormat ? new UploadEvent((Object)this, urlList.toArray(), fileNameList.toArray(), null, this.getKey(), service.isEncrptyPath()) : new UploadEvent((Object)this, attachs.toArray(), this.getKey(), service.isEncrptyPath());
        for (UploadListener l : this.uploadListeners) {
            span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".upload"));
            throwable = null;
            try {
                l.upload(evt);
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    continue;
                }
                span.close();
            }
        }
        if (evt.isCancel()) {
            return;
        }
        for (UploadListener l : this.uploadListeners) {
            span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".afterUpload"));
            throwable = null;
            try {
                l.afterUpload(evt);
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    continue;
                }
                span.close();
            }
        }
        boolean bl = !"mobile".equals(RequestContext.get().getClient()) && !(this.getView() instanceof IMobileView);
        MainEntityType dataEntityType = this.getModel().getDataEntityType();
        String billNo = "";
        if (dataEntityType instanceof BillEntityType && StringUtils.isNotBlank((CharSequence)((BillEntityType)dataEntityType).getBillNo())) {
            billNo = this.getModel().getDataEntity().getString(((BillEntityType)dataEntityType).getBillNo());
        }
        String name = this.getModel().getDataEntityType().getName();
        String parentPageId = this.getView().getFormShowParameter().getParentPageId();
        String parentName = "";
        if (StringUtils.isNotEmpty((CharSequence)parentPageId)) {
            parentName = this.getView().getViewNoPlugin(parentPageId).getModel().getDataEntityType().getName();
        }
        if ((infos = managerService.packageAttachmentInfo(attachs, attachmentModel = new AttachmentModel(bl, this.getKey(), billNo, name, parentName, FieldType.Button, String.valueOf(this.view.getModel().getDataEntity().getPkValue())))).isEmpty()) {
            return;
        }
        for (AttachmentInfo info : infos) {
            if (!StringUtils.isNotEmpty((CharSequence)info.getDownloadUrl())) continue;
            UrlUtil.cacheTempFilePermissionParam(info.getDownloadUrl(), this.view.getFormShowParameter().getFormId(), this.view.getFormShowParameter().getServiceAppId());
        }
        managerService.syncWriteFileBillMapping(infos);
        managerService.afterDoOperation(infos, AttachmentOpType.Upload);
    }

    public void remove(Map<String, Object> attach) {
        Throwable throwable;
        EntityTraceSpan span;
        UploadEvent evt = new UploadEvent((Object)this, attach, this.getKey());
        for (UploadListener l : this.uploadListeners) {
            span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".remove"));
            throwable = null;
            try {
                l.remove(evt);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                span.close();
            }
        }
        if (evt.isCancel()) {
            return;
        }
        for (UploadListener l : this.uploadListeners) {
            span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".afterRemove"));
            throwable = null;
            try {
                l.afterRemove(evt);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    continue;
                }
                span.close();
            }
        }
    }

    @KSMethod
    public CertInfo getCertInfo() {
        CertInfo certInfo = new CertInfo();
        Map states = (Map)((Control)this.getView().getControl((String)this.key)).clientViewProxy.getViewState(this.key);
        Map info = (Map)states.get("certInfo");
        certInfo.setSerialNumber((String)info.get("serialNumber"));
        certInfo.setPublicKey((String)info.get("publicKey"));
        certInfo.setBegin(this.fromISODate((String)info.get("begin")));
        certInfo.setEnd(this.fromISODate((String)info.get("end")));
        certInfo.setIssuer((LocaleString)info.get("issuer"));
        return certInfo;
    }

    private Date formatDate(String time) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            return sdf.parse(time);
        }
        catch (ParseException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    private Date fromISODate(String time) {
        if (!time.matches("\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}.\\d{3}Z")) {
            return null;
        }
        time = time.replaceFirst("T", " ").replaceFirst(".\\d{3}Z", "");
        return this.formatDate(time);
    }

    @KSMethod
    public void setUrl(String url) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.setFieldProperty(this.getKey(), "imageKey", url);
    }

    @KSMethod
    public void setBadgeInfo(BadgeInfo info) {
        if (info != null) {
            this.clientViewProxy.invokeControlMethod(this.getKey(), "setBadgeInfo", info);
        }
    }
}

