/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.control;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormConfig;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.field.events.CodeEditListener;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.utils.KDEncodeUtil;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class CodeEdit
extends Control {
    private static final String SPAN_TYPE_PLUGIN = "plugin";
    private boolean sendSelection;
    private boolean contentEncode;
    private List<CodeEditListener> customHintsListerners = new ArrayList<CodeEditListener>();
    private List<CodeEditListener> hintsListeners = new ArrayList<CodeEditListener>();

    @KSMethod
    public String getText() {
        return this.getTextByKey("v");
    }

    @KSMethod
    public String getSelectionText() {
        if (!this.isSendSelection()) {
            return null;
        }
        return this.getTextByKey("selection");
    }

    private String getTextByKey(String key) {
        if (this.isSendSelection()) {
            IPageCache pageCache = (IPageCache)this.view.getService(IPageCache.class);
            String postData = pageCache.get(this.getPostDataKey());
            if (StringUtils.isBlank((CharSequence)postData)) {
                return "";
            }
            Map postMap = (Map)SerializationUtils.fromJsonString((String)KDEncodeUtil.kdDecoding((String)postData), Map.class);
            String content = postMap.get(key) == null ? "" : postMap.get(key).toString();
            return content;
        }
        IClientViewProxy proxy = (IClientViewProxy)this.view.getService(IClientViewProxy.class);
        String content = (String)proxy.getViewState(this.getKey());
        return KDEncodeUtil.kdDecoding((String)content);
    }

    @Override
    @SdkInternal
    public void postBack(Object postValue) {
        if (this.isSendSelection()) {
            Map map = (Map)postValue;
            IPageCache pageCache = (IPageCache)this.view.getService(IPageCache.class);
            String postData = pageCache.get(this.getPostDataKey());
            if (StringUtils.isBlank((CharSequence)postData)) {
                pageCache.put(this.getPostDataKey(), KDEncodeUtil.kdEncoding((String)this.getKDEncodingType(), (String)SerializationUtils.toJsonString((Object)map)));
            } else {
                Map postMap = (Map)SerializationUtils.fromJsonString((String)KDEncodeUtil.kdDecoding((String)postData), Map.class);
                for (Map.Entry entry : map.entrySet()) {
                    postMap.put(entry.getKey(), entry.getValue());
                }
                pageCache.put(this.getPostDataKey(), KDEncodeUtil.kdEncoding((String)this.getKDEncodingType(), (String)SerializationUtils.toJsonString((Object)postMap)));
            }
        } else {
            super.postBack(postValue);
        }
    }

    private String getPostDataKey() {
        return this.getKey() + "_pd";
    }

    @KSMethod
    public void setText(String text) {
        IClientViewProxy proxy = (IClientViewProxy)this.view.getService(IClientViewProxy.class);
        proxy.setFieldProperty(this.getKey(), "v", text);
        if (this.isSendSelection()) {
            IPageCache pageCache = (IPageCache)this.view.getService(IPageCache.class);
            HashMap<String, String> map = new HashMap<String, String>(1);
            map.put("v", text);
            pageCache.put(this.getPostDataKey(), KDEncodeUtil.kdEncoding((String)this.getKDEncodingType(), (String)SerializationUtils.toJsonString(map)));
        } else {
            proxy.postBack(this.getKey(), text);
        }
    }

    @KSMethod
    public static String decode(String content) {
        return KDEncodeUtil.kdDecoding((String)content);
    }

    @SimplePropertyAttribute(name="SendSelection")
    public boolean isSendSelection() {
        return this.sendSelection;
    }

    public void setSendSelection(boolean sendSelection) {
        this.sendSelection = sendSelection;
    }

    @SimplePropertyAttribute(name="ContentEncode")
    public boolean isContentEncode() {
        return this.contentEncode;
    }

    public void setContentEncode(boolean contentEncode) {
        this.contentEncode = contentEncode;
    }

    @Override
    @SdkInternal
    public Object decode(Object postData) {
        if (this.isSendSelection()) {
            ((Map)postData).replaceAll((k, v) -> KDEncodeUtil.kdDecoding((String)v.toString()));
        } else {
            postData = KDEncodeUtil.kdDecoding((String)postData.toString());
        }
        return postData;
    }

    @SdkInternal
    public void addCustomHintsListerner(CodeEditListener listener) {
        this.customHintsListerners.add(listener);
    }

    @SdkInternal
    public void addHintsListener(CodeEditListener listener) {
        this.hintsListeners.add(listener);
    }

    @SdkInternal
    public void getCustomHints(Map<String, Object> word) {
        for (CodeEditListener listerner : this.customHintsListerners) {
            EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(listerner.getClass().getName() + ".customHints"));
            Throwable throwable = null;
            try {
                listerner.customHints(word);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                span.close();
            }
        }
    }

    @SdkInternal
    public void getHints(Map<String, Object> word) {
        for (CodeEditListener listener : this.hintsListeners) {
            EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(listener.getClass().getName() + ".customTables"));
            Throwable throwable = null;
            try {
                listener.getHints(word);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                span.close();
            }
        }
    }

    private String getKDEncodingType() {
        String encodeType = "";
        FormConfig formConfig = this.getView().getFormShowParameter().getFormConfig();
        if (formConfig != null) {
            encodeType = formConfig.getKdEncoding();
        }
        return encodeType;
    }
}

