/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.control;

import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.TimeZone;
import kd.bos.form.BindingContext;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.service.KDDateFormatUtils;
import kd.bos.service.KDDateUtils;
import kd.sdk.annotation.SdkInternal;

public class DateSelectPanel
extends Control {
    private static final String IS_START = "isStart";

    private void renderControl() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String dateString = (String)formShowParameter.getCustomParam("value");
        boolean isStart = formShowParameter.getCustomParam(IS_START) == null ? false : (Boolean)formShowParameter.getCustomParam(IS_START);
        String minDate = (String)formShowParameter.getCustomParam("minDate");
        String maxDate = (String)formShowParameter.getCustomParam("maxDate");
        Boolean isMustInput = (Boolean)formShowParameter.getCustomParam("mustInput");
        if (isMustInput == null) {
            isMustInput = Boolean.FALSE;
        }
        HashMap<String, Object> clientMeta = new HashMap<String, Object>(7);
        clientMeta.put("value", dateString);
        clientMeta.put("min", minDate);
        clientMeta.put("max", maxDate);
        clientMeta.put(IS_START, isStart);
        clientMeta.put("editor", formShowParameter.getCustomParam("editor"));
        clientMeta.put("today", this.getDate());
        clientMeta.put("mustInput", isMustInput);
        if (formShowParameter.getCustomParam("regionType") != null) {
            int regionType = (Integer)formShowParameter.getCustomParam("regionType");
            clientMeta.put("regionType", regionType);
        }
        this.clientViewProxy.invokeControlMethod(this.getKey(), "loadDateSelectPanel", clientMeta);
    }

    @Override
    @SdkInternal
    public void bindData(BindingContext object) {
        this.renderControl();
        super.bindData(object);
    }

    public void dateChange(String dateString) {
        this.getView().returnDataToParent(dateString);
        this.getView().close();
    }

    private String getDate() {
        DateFormat df = KDDateFormatUtils.getDateTimeFormat((TimeZone)KDDateUtils.getUserTimeZone());
        return df.format(new Date());
    }
}

