/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.control;

import java.util.Map;
import kd.bos.dataentity.entity.EntryInfo;

class EntryGridPageHelper {
    EntryGridPageHelper() {
    }

    protected boolean inCurrentPageIndex(EntryInfo entryInfo, int actualRowCount, int pageIndex, int pageRows) {
        Integer rowCount = entryInfo.getRowCount();
        int startRowIndex = entryInfo.getStartRowIndex();
        int pageSize = entryInfo.getPageSize();
        if (rowCount == null) {
            return true;
        }
        int size = 0;
        size = startRowIndex + pageSize >= rowCount ? actualRowCount - startRowIndex : actualRowCount + pageSize - rowCount;
        int beforePageCount = 0;
        if (startRowIndex > 0 && pageIndex <= (beforePageCount = startRowIndex / pageRows + (startRowIndex % pageRows > 0 ? 1 : 0))) {
            return false;
        }
        int pageCount = size / pageRows + (size % pageRows > 0 ? 1 : 0);
        return pageIndex <= beforePageCount + pageCount;
    }

    protected void ensureEntryData(Map<String, Object> data, EntryInfo entryInfo) {
        if (entryInfo == null || entryInfo.getRowCount() == null) {
            return;
        }
        int rowCount = (Integer)data.get("rowcount");
        int pageRows = (Integer)data.get("pagerows");
        int pageCount = 0;
        int nowpatchSize = 0;
        int otherpatchSize = 0;
        if (entryInfo.getStartRowIndex() + entryInfo.getPageSize() >= entryInfo.getRowCount()) {
            nowpatchSize = rowCount - entryInfo.getStartRowIndex();
            otherpatchSize = entryInfo.getStartRowIndex();
        } else {
            nowpatchSize = rowCount + entryInfo.getPageSize() - entryInfo.getRowCount();
            otherpatchSize = entryInfo.getRowCount() - entryInfo.getPageSize();
        }
        if (otherpatchSize <= 0) {
            return;
        }
        int nowpatchPageCount = nowpatchSize / pageRows + (nowpatchSize % pageRows > 0 ? 1 : 0);
        int otherpatchPageCount = otherpatchSize / pageRows + (otherpatchSize % pageRows > 0 ? 1 : 0);
        rowCount = nowpatchPageCount * pageRows + otherpatchSize;
        pageCount = nowpatchPageCount + otherpatchPageCount;
        if (nowpatchSize == 0 && entryInfo.getStartRowIndex() > 0) {
            data.put("pageindex", (Integer)data.get("pageindex") + 1);
        }
        data.put("rowcount", rowCount);
        data.put("datacount", rowCount);
        data.put("pagecount", pageCount);
    }
}

