/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.control;

import java.io.Serializable;
import java.util.ArrayList;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.userconfig.UserConfig;
import kd.bos.userconfig.UserConfigQuery;
import kd.bos.userconfig.UserConfigWriter;

public class EntryGridRowConfig
implements Serializable {
    private static final long serialVersionUID = 5036875648325639541L;
    public static final String KEY_PREFIX = "entrygridrowconfig_";
    private int pageRows;

    @SimplePropertyAttribute
    public int getPageRows() {
        return this.pageRows;
    }

    public void setPageRows(int pageRows) {
        this.pageRows = pageRows;
    }

    public boolean store(String profileKey) {
        ArrayList<IDataEntityType> dts = new ArrayList<IDataEntityType>();
        dts.add(OrmUtils.getDataEntityType(this.getClass()));
        DcJsonSerializer ser = new DcJsonSerializer(dts);
        return EntryGridRowConfig.saveSetting(RequestContext.get().getCurrUserId(), EntryGridRowConfig.getUserConfigKey(profileKey), ser.serializeToString((Object)this, null));
    }

    private static String getUserConfigKey(String profileKey) {
        return KEY_PREFIX + profileKey;
    }

    private static boolean saveSetting(long userID, String key, String setting) {
        UserConfigWriter userConfigWriter = new UserConfigWriter();
        UserConfig userConfig = EntryGridRowConfig.getUserConfigByCache(userID, key);
        if (userConfig != null && setting.equalsIgnoreCase(userConfig.getSetting())) {
            return true;
        }
        if (userConfig != null) {
            userConfig.setSetting(setting);
        } else {
            userConfig = new UserConfig();
            userConfig.setKey(key);
            userConfig.setUserId(userID);
            userConfig.setSetting(setting);
        }
        StringBuilder errorMessage = new StringBuilder();
        boolean isSuccess = userConfigWriter.saveUserConfig(userConfig, errorMessage);
        return isSuccess;
    }

    public static int readUserPageRows(String profileKey) {
        return (Integer)ThreadCache.get((Object)EntryGridRowConfig.getUserConfigKey(profileKey), () -> {
            EntryGridRowConfig config = EntryGridRowConfig.readEntryGridRowConfig(EntryGridRowConfig.getUserConfigKey(profileKey));
            if (config != null) {
                return config.getPageRows();
            }
            return 0;
        });
    }

    private static EntryGridRowConfig readEntryGridRowConfig(String configKey) {
        UserConfig userConfig = EntryGridRowConfig.getUserConfigByCache(RequestContext.get().getCurrUserId(), configKey);
        if (userConfig != null && StringUtils.isNotBlank((CharSequence)userConfig.getSetting())) {
            String setting = userConfig.getSetting();
            ArrayList<IDataEntityType> dts = new ArrayList<IDataEntityType>(1);
            dts.add(OrmUtils.getDataEntityType(EntryGridRowConfig.class));
            DcJsonSerializer ser = new DcJsonSerializer(dts);
            return (EntryGridRowConfig)ser.deserializeFromString(setting, null);
        }
        return null;
    }

    private static UserConfig getUserConfigByCache(long userID, String key) {
        UserConfigQuery userConfigQuery = new UserConfigQuery();
        return userConfigQuery.getUserConfig(key, userID);
    }
}

