/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.control;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.IDataModelChangeListener;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.BinderMap;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.field.FieldEdit;

public class EntryGridTotalListener
implements IDataModelChangeListener {
    private IFormView view;
    private boolean hasBinderMap;
    private BinderMap binderMap;

    public EntryGridTotalListener(IFormView view) {
        this.view = view;
        this.setHasBinderMap(view.getFormShowParameter().getFormConfig().isHasBinderMap());
    }

    private boolean isHasBinderMap() {
        return this.hasBinderMap;
    }

    private void setHasBinderMap(boolean hasBinderMap) {
        this.hasBinderMap = hasBinderMap;
    }

    private IDataModel getModel() {
        return this.view.getModel();
    }

    private <T extends Control> T getControl(String controlName) {
        return this.view.getControl(controlName);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
    }

    public void initPropertyChanged(PropertyChangedArgs e) {
        this.propertyChanged(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        List<FieldEdit> ctls = this.getFieldEdits(name);
        for (FieldEdit ctl : ctls) {
            EntryGrid grid;
            if (!(ctl instanceof DecimalEdit) || ctl.isFlatField() || (grid = this.getEntryGrid(ctl)) == null) continue;
            ArrayList<Tuple<BigDecimal, BigDecimal>> valueList = new ArrayList<Tuple<BigDecimal, BigDecimal>>(e.getChangeSet().length);
            for (ChangeData changeData : e.getChangeSet()) {
                BigDecimal oldValue = this.toBigDecimal(changeData.getOldValue());
                BigDecimal newValue = this.toBigDecimal(changeData.getNewValue());
                if (oldValue == null) {
                    oldValue = BigDecimal.ZERO;
                }
                if (newValue == null) {
                    newValue = BigDecimal.ZERO;
                }
                valueList.add((Tuple<BigDecimal, BigDecimal>)new Tuple((Object)oldValue, (Object)newValue));
            }
            grid.onBatchAmountChange(ctl.getKey(), valueList);
        }
    }

    private BigDecimal toBigDecimal(Object o) {
        if (o == null) {
            return BigDecimal.ZERO;
        }
        if (o instanceof String && StringUtils.isEmpty((CharSequence)o.toString())) {
            return BigDecimal.ZERO;
        }
        if (o instanceof BigDecimal) {
            return (BigDecimal)o;
        }
        if (o instanceof Number) {
            if (o instanceof Float) {
                return new BigDecimal(Float.toString(((Float)o).floatValue()));
            }
            if (o instanceof Double) {
                return new BigDecimal(Double.toString((Double)o));
            }
            return BigDecimal.valueOf(((Number)o).doubleValue());
        }
        return new BigDecimal(o.toString());
    }

    private EntryGrid getEntryGrid(FieldEdit fieldEdit) {
        String entryKey = fieldEdit.getEntryKey();
        if (!StringUtils.isBlank((CharSequence)entryKey)) {
            EntryGrid entryGrid = null;
            if (StringUtils.isNotBlank((CharSequence)fieldEdit.getEntryControlKey())) {
                entryGrid = (EntryGrid)fieldEdit.getView().getControl(fieldEdit.getEntryControlKey());
            }
            if (entryGrid != null) {
                return entryGrid;
            }
            return (EntryGrid)fieldEdit.getView().getControl(entryKey);
        }
        return null;
    }

    private List<FieldEdit> getFieldEdits(String propertyName) {
        List<String> sf;
        if (this.isHasBinderMap() && this.binderMap == null) {
            this.binderMap = (BinderMap)FormMetadataCache.getControl(this.view.getFormShowParameter().getFormId(), "_bindermap_");
        }
        ArrayList<FieldEdit> fes = new ArrayList<FieldEdit>();
        Object ctl = this.view.getControl(propertyName);
        if (ctl instanceof FieldEdit && StringUtils.equalsIgnoreCase((CharSequence)((FieldEdit)ctl).getFieldKey(), (CharSequence)propertyName)) {
            fes.add((FieldEdit)ctl);
        }
        if (this.binderMap != null && (sf = this.binderMap.getMap().get(propertyName.toLowerCase())) != null) {
            for (String key : sf) {
                ctl = this.view.getControl(key);
                if (!(ctl instanceof FieldEdit)) continue;
                fes.add((FieldEdit)ctl);
            }
        }
        return fes;
    }
}

