/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.control;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.container.Container;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class FloatMenu
extends Container {
    private static final String SPAN_TYPE_PLUGIN = "plugin";
    protected List<ItemClickListener> itemClickListeners = new ArrayList<ItemClickListener>();

    @Override
    @KSMethod
    public void addItemClickListener(ItemClickListener listener) {
        this.itemClickListeners.add(listener);
    }

    @KSMethod
    public void itemClick(String itemKey, String operationKey) {
        if (StringUtils.isNotBlank((CharSequence)operationKey)) {
            this.getView().invokeOperation(operationKey);
        }
        ItemClickEvent e = new ItemClickEvent(this, itemKey, operationKey);
        if (this.itemClickListeners != null) {
            for (ItemClickListener l : this.itemClickListeners) {
                EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".itemClick"));
                Throwable throwable = null;
                try {
                    l.itemClick(e);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (span == null) continue;
                    if (throwable != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    span.close();
                }
            }
        }
    }
}

