/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.control;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.decode.DecodeHandlerFactory;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.AfterAddControlEvent;
import kd.bos.form.control.events.AfterAddControlListener;
import kd.bos.form.control.events.ClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.CreateUIByTypeEvent;
import kd.bos.form.control.events.CreateUIElemntByEntityItemEvent;
import kd.bos.form.control.events.CreateUIElemntListener;
import kd.bos.form.control.events.KeyPressArgs;
import kd.bos.form.control.events.PropertyEvent;
import kd.bos.form.control.events.PropertyListener;
import kd.bos.form.control.events.ShortCutKeyListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataService;

@KSObject
public class FormDesigner
extends Control
implements ICloseCallBack {
    protected List<PropertyListener> listeners = new ArrayList<PropertyListener>();
    protected List<CreateUIElemntListener> createUIElementlisteners = new ArrayList<CreateUIElemntListener>();
    protected List<ShortCutKeyListener> shortCutKeyListeners = new ArrayList<ShortCutKeyListener>();
    protected List<AfterAddControlListener> afterAddControlListeners = new ArrayList<AfterAddControlListener>();
    protected List<ClickListener> showGptDialogListeners = new ArrayList<ClickListener>();
    protected static final String CALLBACK_DELETE_CONFIRM = "deleteConfirm";
    protected static final String DELETE_FILED_LIST = "deleteFiledList";
    protected static final String DELETE_FILED_REFERENCED_LIST = "deleteReferencedList";
    protected static final String DO_DELETE = "doDelete";
    protected static final String FROM_ITEM = "fromitem";
    private Map<String, Object> content;

    @KSMethod
    public void addPropertyButtonClickListener(PropertyListener listener) {
        this.listeners.add(listener);
    }

    @KSMethod
    public void addCreateUIElemntListener(CreateUIElemntListener listener) {
        this.createUIElementlisteners.add(listener);
    }

    public void addShortCutKeyListener(ShortCutKeyListener listener) {
        this.shortCutKeyListeners.add(listener);
    }

    public void addAfterAddControlListener(AfterAddControlListener listener) {
        this.afterAddControlListeners.add(listener);
    }

    public void addShowGptDialogListeners(ClickListener listener) {
        this.showGptDialogListeners.add(listener);
    }

    @KSMethod
    public void click(String itemId, String metaType, String propertyName, Map<String, Object> param) {
        param = this.decodePropertyValue(propertyName, param);
        PropertyEvent e = new PropertyEvent(this, itemId, metaType, propertyName, param);
        this.fireClick(e);
    }

    private Map<String, Object> decodePropertyValue(String propertyName, Map<String, Object> param) {
        Map<Object, Object> result = new HashMap();
        Object value = param.get("kdEncodingKey");
        if (value == null) {
            return param;
        }
        if ("Rules".equals(propertyName) || "ClientRules".equals(propertyName) || "Operations".equals(propertyName) || "OperationKey".equals(propertyName) || "MustInputCondition".equals(propertyName) || "Filter".equals(propertyName)) {
            String type = this.getView().getFormShowParameter().getFormConfig().getKdEncoding();
            String decodeStr = DecodeHandlerFactory.getDecodeHandler(type).decode(value.toString());
            result = (Map)SerializationUtils.fromJsonString((String)decodeStr, Map.class);
        } else {
            result = param;
        }
        return result;
    }

    @KSMethod
    public void afterSetProperty(String itemId, String metaType, String propertyName, Object value) {
        if (this.listeners != null) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("value", value);
            PropertyEvent e = new PropertyEvent(this, itemId, metaType, propertyName, param);
            for (PropertyListener l : this.listeners) {
                l.afterSetProperty(e);
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        Map ret;
        if (CALLBACK_DELETE_CONFIRM.equals(e.getActionId()) && (ret = (Map)e.getReturnData()) != null && ret.size() > 0) {
            IClientViewProxy service = (IClientViewProxy)e.getView().getService(IClientViewProxy.class);
            List deleteFiledList = (List)ret.get(DELETE_FILED_LIST);
            ArrayList deleteFiledIds = new ArrayList();
            deleteFiledList.forEach(param -> deleteFiledIds.add((String)param.get("id")));
            String key = (String)ret.get(FROM_ITEM);
            service.invokeControlMethod(key, DO_DELETE, deleteFiledIds);
        }
        if (this.listeners != null) {
            for (PropertyListener l : this.listeners) {
                if (!(l instanceof ICloseCallBack)) continue;
                ((ICloseCallBack)((Object)l)).closedCallBack(e);
            }
        }
    }

    @KSMethod
    public void getPropertyAlias(String itemId, String metaType, String propertyName, Map<String, Object> param) {
        param = this.decodePropertyValue(propertyName, param);
        PropertyEvent e = new PropertyEvent(this, itemId, metaType, propertyName, param);
        this.fireGetPropertyAlias(e);
    }

    public void createUIElemntByEntityItem(Map<String, Object> item, Map<String, Object> container) {
        CreateUIElemntByEntityItemEvent e = new CreateUIElemntByEntityItemEvent(this, item, container);
        this.fireCreateUIElemntByEntityItem(e);
    }

    public void createUIElementByType(Map<String, Object> elementType, Map<String, Object> container) {
        CreateUIByTypeEvent e = new CreateUIByTypeEvent(this, elementType, container);
        this.fireCreateUIByType(e);
    }

    @KSMethod
    public void deleteConfirm(List<Map<String, Object>> params) {
        List<Map<String, Object>> referencedFileds = this.getReferencedFiledList(params);
        if (referencedFileds.size() > 0) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("bos_devp_deletefiled");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCustomParam(DELETE_FILED_LIST, params);
            parameter.setCustomParam(DELETE_FILED_REFERENCED_LIST, referencedFileds);
            parameter.setCustomParam(FROM_ITEM, this.getKey());
            CloseCallBack closeCallBack = new CloseCallBack(this.getClass().getName(), CALLBACK_DELETE_CONFIRM);
            parameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(parameter);
        } else {
            Object isEntity;
            Map<String, Object> firstParam = params.get(0);
            if (firstParam != null && firstParam.size() > 0 && (isEntity = firstParam.get("isEntity")) != null && !((Boolean)isEntity).booleanValue()) {
                String deleteFieldKey = this.getView().getPageCache().get("deletefiledkey");
                Set cacheDeletField = StringUtils.isBlank((CharSequence)deleteFieldKey) ? new HashSet() : (Set)SerializationUtils.fromJsonString((String)deleteFieldKey, Set.class);
                cacheDeletField.add(firstParam.get("key"));
                this.getView().getPageCache().put("deletefiledkey", SerializationUtils.toJsonString(cacheDeletField));
            }
            ArrayList deleteFiledIds = new ArrayList();
            params.forEach(param -> deleteFiledIds.add((String)param.get("id")));
            IClientViewProxy service = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            service.invokeControlMethod(this.getKey(), DO_DELETE, deleteFiledIds);
        }
    }

    @Override
    public void postBack(Object value) {
        this.content = (Map)value;
        String type = this.getView().getFormShowParameter().getFormConfig().getKdEncoding();
        DecodeHandlerFactory.getDecodeHandler(type).decode(this.content, this);
        this.getView().getPageCache().put("designer_content", SerializationUtils.toJsonString(this.content));
    }

    public void setContent(Map<String, Object> content) {
        this.content = content;
    }

    @KSMethod
    public Map<String, Object> getContent() {
        return this.content;
    }

    @KSMethod
    public void resetSideBar(String[] items) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "resetSideBar", new Object[]{items});
    }

    public void setProperty(Map<String, Object> param) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "setProperty", param);
    }

    public void keyUp(List<Integer> keys) {
        KeyPressArgs args = new KeyPressArgs(keys);
        for (ShortCutKeyListener listener : this.shortCutKeyListeners) {
            listener.keyDown(args);
        }
    }

    public void afterAddControlNotify(Map<String, Object> params) {
        AfterAddControlEvent event = new AfterAddControlEvent(this, params);
        for (AfterAddControlListener listener : this.afterAddControlListeners) {
            listener.afterAddControl(event);
        }
    }

    public void createUIElement(Map<String, Object> uiElement, Map<String, Object> container) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "createUIElement", uiElement, container);
    }

    public void createEntityElement(String parentId, Map<String, Object> element) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "createEntityElement", parentId, element);
    }

    public void createEntityElement(String parentId, Map<String, Object> element, Map<String, Object> container) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "createEntityElement", parentId, element);
    }

    @KSMethod
    public void removeUIElements(String containerId) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "removeUIElements", containerId);
    }

    public void setProperty(List<Map<String, Object>> params) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "setProperty", params);
    }

    public void showErrors(List<Map<String, Object>> erros) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "showErrorList", erros);
    }

    @KSMethod
    public void open(String modelType, Map<String, Object> doc) {
        boolean isPC;
        boolean bl = isPC = !modelType.startsWith("Mob");
        if (doc.containsKey("isPC")) {
            isPC = (Boolean)doc.get("isPC");
        }
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "open", modelType, isPC, doc);
        this.setDesignerConfig(doc);
        this.getView().getPageCache().put("designer_content", SerializationUtils.toJsonString(doc));
    }

    private void setDesignerConfig(Map<String, Object> doc) {
        DynamicObject dynamicObject;
        QFilter[] qFilters;
        Map masterBill;
        DynamicObject dynamicObject2;
        String billEntityId;
        QFilter[] qFilter;
        Map masterForm;
        String masterId;
        if (doc == null) {
            return;
        }
        Map formMeta = (Map)doc.get("formmeta");
        if (formMeta == null) {
            return;
        }
        String currentFormIsv = (String)formMeta.get("Isv");
        String rootIsv = "";
        HashMap<String, Boolean> configMap = new HashMap<String, Boolean>(16);
        boolean isLimits = false;
        if (formMeta.get("EnableGlobalExtLimits") instanceof Boolean) {
            isLimits = (Boolean)formMeta.get("EnableGlobalExtLimits");
        }
        if (StringUtils.isEmpty((CharSequence)(masterId = (String)formMeta.get("MasterId"))) && !(masterForm = BusinessDataReader.loadFromCache((String)"bos_formmeta", (QFilter[])(qFilter = new QFilter[]{new QFilter("id", "=", (Object)(billEntityId = (String)doc.get("billentityid")))}))).isEmpty() && (dynamicObject2 = (DynamicObject)masterForm.get(billEntityId)) != null) {
            masterId = dynamicObject2.getString("masterid");
        }
        if (!(masterBill = BusinessDataReader.loadFromCache((String)"bos_formmeta", (QFilter[])(qFilters = new QFilter[]{new QFilter("id", "=", (Object)masterId)}))).isEmpty() && (dynamicObject = (DynamicObject)masterBill.get(masterId)) != null) {
            rootIsv = dynamicObject.getString("isv");
        }
        if (isLimits && StringUtils.isNotEmpty((CharSequence)rootIsv) && !StringUtils.equals((CharSequence)rootIsv, (CharSequence)currentFormIsv)) {
            configMap.put("enableGlobalControl", true);
        } else {
            configMap.put("enableGlobalControl", false);
        }
        if (StringUtils.isNotEmpty((CharSequence)rootIsv) && !StringUtils.equals((CharSequence)rootIsv, (CharSequence)currentFormIsv)) {
            configMap.put("enableBillControl", true);
        } else {
            configMap.put("enableBillControl", false);
        }
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "setDesignerConfig", configMap);
    }

    public void sendFieldProsLock(Map<String, Object> fieldPropsLockList) {
        if (fieldPropsLockList == null || fieldPropsLockList.isEmpty()) {
            return;
        }
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "lockProperty", fieldPropsLockList);
    }

    public void sendMulLangProperty(Map<String, Map<String, Object>> data) {
        if (data == null) {
            return;
        }
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "setMulLangProperty", data);
    }

    private void fireGetPropertyAlias(PropertyEvent e) {
        if (this.listeners != null) {
            for (PropertyListener l : this.listeners) {
                l.getPropertyAlias(e);
            }
        }
    }

    private void fireClick(PropertyEvent e) {
        if (this.listeners != null) {
            for (PropertyListener l : this.listeners) {
                l.click(e);
            }
        }
    }

    private void fireCreateUIElemntByEntityItem(CreateUIElemntByEntityItemEvent e) {
        for (CreateUIElemntListener l : this.createUIElementlisteners) {
            l.createUIElemntByEntityItem(e);
        }
    }

    private void fireCreateUIByType(CreateUIByTypeEvent e) {
        for (CreateUIElemntListener l : this.createUIElementlisteners) {
            l.createUIByType(e);
        }
    }

    private List<Map<String, Object>> getReferencedFiledList(List<Map<String, Object>> params) {
        String metadata = this.getView().getPageCache().get("realtimemetadata");
        FormDesigner designer = (FormDesigner)this.getView().getControl("subformdesigner");
        if (StringUtils.isEmpty((CharSequence)metadata)) {
            metadata = this.getView().getPageCache().get("oldmetadata");
        }
        MetadataService metadataService = (MetadataService)ServiceFactory.getService(MetadataService.class);
        List filedReferencedList = metadataService.getFiledReferencedList((Map)SerializationUtils.fromJsonString((String)metadata, Map.class), params);
        return filedReferencedList;
    }

    public void showGptDialog(Map<String, Object> params) {
        ClickEvent clickEvent = new ClickEvent(this, params);
        for (ClickListener showGptDialogListener : this.showGptDialogListeners) {
            showGptDialogListener.click(clickEvent);
        }
    }
}

