/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.control;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.control.Control;
import kd.bos.form.control.DesignerBarListener;
import kd.bos.form.control.events.DesignerBarAction;
import kd.bos.form.control.events.DesignerBarEvent;
import kd.bos.form.control.events.MouseOutOfFocusEvent;
import kd.bos.form.control.events.MouseOutOfFocusListener;
import kd.bos.form.control.events.PropertyEvent;
import kd.bos.form.control.events.PropertyListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;

@KSObject
public class KFlowDesigner
extends Control
implements ICloseCallBack {
    private static final Log log = LogFactory.getLog(KFlowDesigner.class);
    private static final String BTN_SAVE = "save";
    private static final String CALLBACK_METHODNAME = "callBack";
    private static final String INVOKE_METHODNAME = "click";
    private static final String PAGE_ID = "pageId";
    private static final String KEY = "key";
    private Map<String, Object> content;
    private List<DesignerBarListener> barListeners = new ArrayList<DesignerBarListener>();
    protected List<PropertyListener> listeners = new ArrayList<PropertyListener>();
    List<MouseOutOfFocusListener> mouseOutOfFocusListeners = new ArrayList<MouseOutOfFocusListener>(10);

    public void addBarListener(DesignerBarListener barListener) {
        this.barListeners.add(barListener);
    }

    @KSMethod
    public void open(Map<String, Object> doc) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "open", "KFlowModel", doc);
    }

    @Override
    public void postBack(Object value) {
        this.content = (Map)value;
    }

    @KSMethod
    public Map<String, Object> getContent() {
        return this.content;
    }

    @KSMethod
    public void getKFlowData() {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "getKFlowData", new Object[0]);
    }

    public void showErrors(List<Map<String, Object>> errors) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "showErrorList", errors);
    }

    public void addMouseOutOfFocusListener(MouseOutOfFocusListener listener) {
        this.mouseOutOfFocusListeners.add(listener);
    }

    @KSMethod
    public void mouseOutOfFocus(Object value) {
        MouseOutOfFocusEvent event = new MouseOutOfFocusEvent(this);
        for (MouseOutOfFocusListener mouseOutOfFocusListener : this.mouseOutOfFocusListeners) {
            mouseOutOfFocusListener.mouseOutOfFocus(event);
        }
    }

    @KSMethod
    public void addPropertyButtonClickListener(PropertyListener listener) {
        this.listeners.add(listener);
    }

    @KSMethod
    public void click(String itemId, String metaType, String propertyName, Map<String, Object> param) {
        PropertyEvent e = new PropertyEvent(this, itemId, metaType, propertyName, param);
        this.fireClick(e);
    }

    private void fireClick(PropertyEvent e) {
        if (this.listeners != null) {
            for (PropertyListener l : this.listeners) {
                l.click(e);
            }
        }
    }

    public void setProperty(Map<String, Object> param) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "setProperty", param);
    }

    public void showGuide(boolean isShow) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "showGuide", isShow);
    }

    public void setProperty(List<Map<String, Object>> params) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "setProperty", params);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        if (this.listeners != null) {
            for (PropertyListener l : this.listeners) {
                if (!(l instanceof ICloseCallBack)) continue;
                ((ICloseCallBack)((Object)l)).closedCallBack(e);
            }
        }
    }

    public void designerBarClick(String key) {
        this.designerBarClick(key, "");
    }

    public void designerBarClick(String key, String pageId) {
        if (this.barListeners != null) {
            DesignerBarEvent e = new DesignerBarEvent();
            e.setActionId(DesignerBarAction.Click);
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put(KEY, key);
            param.put(PAGE_ID, pageId);
            e.setParam(param);
            for (DesignerBarListener l : this.barListeners) {
                l.designerBarClick(e);
            }
        }
    }

    @KSMethod
    public void getPropertyAlias(String itemId, String metaType, String propertyName, Map<String, Object> param) {
        PropertyEvent e = new PropertyEvent(this, itemId, metaType, propertyName, param);
        this.fireGetPropertyAlias(e);
    }

    private void fireGetPropertyAlias(PropertyEvent e) {
        if (this.listeners != null) {
            for (PropertyListener l : this.listeners) {
                l.getPropertyAlias(e);
            }
        }
    }
}

