/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.control;

import java.util.ArrayList;
import java.util.Map;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.OCREvent;
import kd.bos.form.control.events.OCRListener;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class OCR
extends Control {
    private static final String SPAN_TYPE_PLUGIN = "plugin";
    private ArrayList<OCRListener> ocrListeners = new ArrayList();

    public void scanAndOCR() {
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.invokeControlMethod(this.getKey(), "scanAndOCR", new Object[0]);
    }

    public void loadPicture(String localDirectory) {
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.invokeControlMethod(this.getKey(), "loadOCRPicture", localDirectory);
    }

    public void addOCRListener(OCRListener l) {
        this.ocrListeners.add(l);
    }

    public void processOCR(Map<String, Object> data) {
        Throwable throwable;
        EntityTraceSpan span;
        String msg;
        String sta = data.get("status").toString();
        int status = Integer.parseInt(sta);
        if (status == 1) {
            String imgName = (String)data.get("imgName");
            Map info = (Map)data.get("data");
            OCREvent evt = new OCREvent(info, imgName);
            for (OCRListener l : this.ocrListeners) {
                EntityTraceSpan span2 = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".processOCR"));
                Throwable throwable2 = null;
                try {
                    l.processOCR(evt);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (span2 == null) continue;
                    if (throwable2 != null) {
                        try {
                            span2.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    span2.close();
                }
            }
        }
        if (!StringUtils.isEmpty((String)(msg = (String)data.get("msg")))) {
            for (OCRListener l : this.ocrListeners) {
                span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".notifyMsg"));
                throwable = null;
                try {
                    l.notifyMsg(status, msg);
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (span == null) continue;
                    if (throwable != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    span.close();
                }
            }
        }
        if (status == -1 || status == 0) {
            for (OCRListener l : this.ocrListeners) {
                span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".finishOCR"));
                throwable = null;
                try {
                    l.finishOCR();
                }
                catch (Throwable throwable7) {
                    throwable = throwable7;
                    throw throwable7;
                }
                finally {
                    if (span == null) continue;
                    if (throwable != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable8) {
                            throwable.addSuppressed(throwable8);
                        }
                        continue;
                    }
                    span.close();
                }
            }
        }
    }
}

