/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.control;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.RateEvent;
import kd.bos.form.control.events.RateListener;
import kd.bos.script.annotations.KSMethod;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class Rate
extends Control {
    private static final String SPAN_TYPE_PLUGIN = "plugin";
    private List<RateListener> rateListeners;

    @KSMethod
    public void addRateListener(RateListener listener) {
        if (this.rateListeners == null) {
            this.rateListeners = new ArrayList<RateListener>();
        }
        this.rateListeners.add(listener);
    }

    @KSMethod
    public void setRateScore(Number rateScore) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "setRateScore", rateScore);
    }

    @KSMethod
    public void setRateTexts(List<String> texts) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "setRateTexts", texts);
    }

    @SdkInternal
    @KSMethod
    public void updateRateScore(Number rateScore) {
        RateEvent event = new RateEvent(this);
        event.setRateScore(rateScore);
        if (this.rateListeners != null) {
            for (RateListener l : this.rateListeners) {
                EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".update"));
                Throwable throwable = null;
                try {
                    l.update(event);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (span == null) continue;
                    if (throwable != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    span.close();
                }
            }
        }
    }
}

