/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.control;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.Control;
import kd.bos.form.control.TimelineClickArgs;
import kd.bos.form.control.TimelineOption;
import kd.bos.form.control.TimelineOptionClickArg;
import kd.bos.form.control.events.TimelineEvent;
import kd.bos.form.control.events.TimelineListener;
import kd.bos.script.annotations.KSMethod;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class Timeline
extends Control {
    private static final String SPAN_TYPE_PLUGIN = "plugin";
    private List<TimelineOption> timelineOptions = new ArrayList<TimelineOption>();
    private List<TimelineListener> timelineListeners;
    private boolean canClick = false;

    @KSMethod
    public void addTimelineListener(TimelineListener listener) {
        if (this.timelineListeners == null) {
            this.timelineListeners = new ArrayList<TimelineListener>();
        }
        this.timelineListeners.add(listener);
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=TimelineOption.class)
    public List<TimelineOption> getTimelineOptions() {
        return this.timelineOptions;
    }

    public void setTimelineOptions(List<TimelineOption> timelineOptions) {
        this.timelineOptions = timelineOptions;
    }

    @KSMethod
    public void setClientTimelineOptions(List<TimelineOption> timelineOptions) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "setTimelineOptions", timelineOptions.stream().map(TimelineOption::toMap).collect(Collectors.toList()));
    }

    @KSMethod
    public void setTimelineClick(boolean canClick) {
        this.canClick = canClick;
        HashMap<String, Boolean> map = new HashMap<String, Boolean>(1);
        map.put("click", canClick);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "setTimelineClick", map);
    }

    @KSMethod
    public boolean isCanClick() {
        return this.canClick;
    }

    public void updateTimelineArgs(Map<String, Object> map) {
        TimelineEvent event = new TimelineEvent(this);
        TimelineClickArgs args = new TimelineClickArgs();
        args.setIndex((Integer)map.get("index"));
        args.setTimeline((String)map.get("timeline"));
        args.setType((String)map.get("type"));
        event.setArgs(args);
        if (this.timelineListeners != null) {
            for (TimelineListener t : this.timelineListeners) {
                EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(t.getClass().getName() + ".update"));
                Throwable throwable = null;
                try {
                    t.update(event);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (span == null) continue;
                    if (throwable != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    span.close();
                }
            }
        }
    }

    public void timelineOpkClick(Map<String, Object> map) {
        TimelineOptionClickArg arg = new TimelineOptionClickArg((Integer)map.get("index"), (String)map.get("optionKey"));
        if (this.timelineListeners != null) {
            for (TimelineListener t : this.timelineListeners) {
                EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(t.getClass().getName() + ".optionClick"));
                Throwable throwable = null;
                try {
                    t.optionClick(arg);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (span == null) continue;
                    if (throwable != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    span.close();
                }
            }
        }
    }
}

