/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.control;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.trace.EntityTraceHint;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BadgeInfo;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ca.CertInfo;
import kd.bos.form.IMobileView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.UrlUtil;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.BeforeUploadEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.attachment.AttachmentInfo;
import kd.bos.mservice.attachment.AttachmentModel;
import kd.bos.mservice.attachment.AttachmentOpType;
import kd.bos.mservice.attachment.FieldType;
import kd.bos.mservice.attachment.IAttachmentManagerService;
import kd.bos.mservice.attachment.IAttachmentService;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.service.ServiceFactory;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class Toolbar
extends Container {
    private static final Log log = LogFactory.getLog(Toolbar.class);
    private static final String SPAN_TYPE_PLUGIN = "plugin";
    private static final String I_ATTACHMENT_MANAGER_SERVICE = "IAttachmentManagerService";
    protected List<ItemClickListener> barItemClickListeners = new ArrayList<ItemClickListener>();
    protected List<UploadListener> uploadListeners = new ArrayList<UploadListener>();

    @Override
    @KSMethod
    public void addItemClickListener(ItemClickListener listener) {
        if (!this.barItemClickListeners.contains(listener)) {
            this.barItemClickListeners.add(listener);
        }
    }

    @Override
    @SdkInternal
    public String getOpKey(String methodName, Object[] args) {
        if (args == null) {
            return super.getOpKey(methodName, args);
        }
        return this.key + Arrays.toString(args);
    }

    public void itemClick(String id, String operationKey) {
        BeforeItemClickEvent evt = new BeforeItemClickEvent(this, id, operationKey);
        this.fireBeforeItemClick(evt);
        if (!evt.isCancel()) {
            if (StringUtils.isNotBlank((CharSequence)operationKey)) {
                this.getView().invokeOperation(operationKey);
            }
            ItemClickEvent evt1 = new ItemClickEvent(this, id, operationKey);
            this.fireItemClick(evt1);
        }
    }

    private void fireBeforeItemClick(BeforeItemClickEvent e) {
        for (ItemClickListener l : this.barItemClickListeners) {
            if (!this.isNotOverride(l.getClass(), "beforeItemClick", e, BeforeItemClickEvent.class)) continue;
            EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".fireBeforeItemClick"), (EntityTraceHint)EntityTraceHint.getHintLinkAPM());
            Throwable throwable = null;
            try {
                l.beforeItemClick(e);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                span.close();
            }
        }
    }

    private void fireItemClick(ItemClickEvent e) {
        for (ItemClickListener l : this.barItemClickListeners) {
            if (!this.isNotOverride(l.getClass(), "itemClick", e, ItemClickEvent.class)) continue;
            EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".itemClick"), (EntityTraceHint)EntityTraceHint.getHintLinkAPM());
            Throwable throwable = null;
            try {
                l.itemClick(e);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                span.close();
            }
        }
    }

    @KSMethod
    public void addUploadListener(UploadListener listener) {
        this.uploadListeners.add(listener);
    }

    public void beforeUpload(String itemKey, List<Map<String, Object>> attachs) {
        BeforeUploadEvent evt = new BeforeUploadEvent((Object)this, itemKey, attachs);
        for (UploadListener l : this.uploadListeners) {
            EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".beforeUpload"));
            Throwable throwable = null;
            try {
                l.beforeUpload(evt);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                span.close();
            }
        }
    }

    public void upload(String itemKey, List<Map<String, Object>> attachs) {
        Throwable throwable;
        EntityTraceSpan span;
        IAttachmentService service = (IAttachmentService)ServiceFactory.getService(IAttachmentService.class);
        IAttachmentManagerService managerService = (IAttachmentManagerService)ServiceFactory.getService((String)I_ATTACHMENT_MANAGER_SERVICE);
        ArrayList<String> fileNameList = new ArrayList<String>(attachs.size());
        ArrayList<String> urlList = new ArrayList<String>(attachs.size());
        boolean newFormat = false;
        for (Map<String, Object> map : attachs) {
            if (!(map instanceof Map)) continue;
            Map<String, Object> attachMap = map;
            fileNameList.add(String.valueOf(attachMap.get("name")));
            urlList.add(String.valueOf(attachMap.get("url")));
            newFormat = Boolean.parseBoolean(String.valueOf(attachMap.get("newFormat")));
        }
        UploadEvent evt = newFormat ? new UploadEvent((Object)this, urlList.toArray(), fileNameList.toArray(), null, itemKey, service.isEncrptyPath()) : new UploadEvent((Object)this, attachs.toArray(), itemKey, service.isEncrptyPath());
        for (UploadListener l : this.uploadListeners) {
            span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".upload"));
            throwable = null;
            try {
                l.upload(evt);
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    continue;
                }
                span.close();
            }
        }
        if (evt.isCancel()) {
            return;
        }
        for (UploadListener l : this.uploadListeners) {
            span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".afterUpload"));
            throwable = null;
            try {
                l.afterUpload(evt);
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    continue;
                }
                span.close();
            }
        }
        boolean bl = !"mobile".equals(RequestContext.get().getClient()) && !(this.getView() instanceof IMobileView);
        MainEntityType dataEntityType = this.getModel().getDataEntityType();
        String billNo = "";
        if (dataEntityType instanceof BillEntityType && StringUtils.isNotBlank((CharSequence)((BillEntityType)dataEntityType).getBillNo())) {
            billNo = this.getModel().getDataEntity().getString(((BillEntityType)dataEntityType).getBillNo());
        }
        String name = this.getModel().getDataEntityType().getName();
        AttachmentModel attachmentModel = new AttachmentModel(bl, this.getKey(), billNo, name, FieldType.Button, this.view.getModel().getDataEntity().getPkValue() == null ? "" : String.valueOf(this.view.getModel().getDataEntity().getPkValue()));
        List infos = managerService.packageAttachmentInfo(attachs, attachmentModel);
        if (infos.isEmpty()) {
            return;
        }
        for (AttachmentInfo info : infos) {
            if (!StringUtils.isNotEmpty((CharSequence)info.getDownloadUrl())) continue;
            UrlUtil.cacheTempFilePermissionParam(info.getDownloadUrl(), this.view.getFormShowParameter().getFormId(), this.view.getFormShowParameter().getServiceAppId());
        }
        managerService.syncWriteFileBillMapping(infos);
        managerService.afterDoOperation(infos, AttachmentOpType.Upload);
    }

    @KSMethod
    public CertInfo getCertInfo() {
        CertInfo certInfo = new CertInfo();
        Map states = (Map)((Control)this.getView().getControl((String)this.key)).clientViewProxy.getViewState(this.key);
        Map info = (Map)states.get("certInfo");
        String serialNum = (String)info.get("serialNumber");
        serialNum = StringUtils.deleteWhitespace((String)serialNum);
        certInfo.setSerialNumber(serialNum);
        certInfo.setPublicKey((String)info.get("publicKey"));
        certInfo.setCertName((String)info.get("certName"));
        certInfo.setBegin(this.fromISODate((String)info.get("begin")));
        certInfo.setEnd(this.fromISODate((String)info.get("end")));
        certInfo.setIssuer(this.getIssuer((String)info.get("issuer")));
        certInfo.setCertIssuer((String)info.get("issuer"));
        return certInfo;
    }

    private LocaleString getIssuer(String issuer) {
        issuer = issuer.substring(issuer.indexOf("=") + 1, issuer.indexOf(","));
        LocaleString localeIssuer = new LocaleString(issuer);
        return localeIssuer;
    }

    private Date formatDate(String time) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            return sdf.parse(time);
        }
        catch (ParseException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    private Date fromISODate(String time) {
        if (time.matches("\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}.\\d{3}Z")) {
            time = time.replaceFirst("T", " ").replaceFirst(".\\d{3}Z", "");
            Date date = this.formatDate(time);
            return date;
        }
        if (time.matches("\\d{4}-\\d{2}-\\d{2}\\s+\\d{2}:\\d{2}:\\d{2}GMT")) {
            time = time.replace("GMT", "");
            Date date = this.formatDate(time);
            return date;
        }
        return null;
    }

    public void setBadgeInfo(String itemKey, BadgeInfo info) {
        if (info != null && kd.bos.util.StringUtils.isNotEmpty((String)itemKey)) {
            this.clientViewProxy.invokeControlMethod(itemKey, "setBadgeInfo", info);
        }
    }
}

