/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.control;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.entity.tree.TreeMenuNode;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.container.Container;
import kd.bos.form.control.events.ClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.TreeMenuAddNodesEvent;
import kd.bos.form.control.events.TreeMenuClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class TreeMenu
extends Container {
    private static final String SPAN_TYPE_PLUGIN = "plugin";
    private List<Consumer<TreeMenuAddNodesEvent>> treeMenuAddNodesListeners = new ArrayList<Consumer<TreeMenuAddNodesEvent>>();
    protected List<TreeMenuClickListener> treeMenuClickListener = new ArrayList<TreeMenuClickListener>();

    @KSMethod
    public void addTreeMenuAddNodesListener(Consumer<TreeMenuAddNodesEvent> treeMenuAddNodesListener) {
        this.treeMenuAddNodesListeners.add(treeMenuAddNodesListener);
    }

    @KSMethod
    public void fireTreeMenuAddNodesListener(TreeMenuAddNodesEvent event) {
        for (Consumer<TreeMenuAddNodesEvent> consumer : this.treeMenuAddNodesListeners) {
            EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(consumer.getClass().getName() + "accept"));
            Throwable throwable = null;
            try {
                consumer.accept(event);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                span.close();
            }
        }
    }

    @KSMethod
    public TreeMenu addNodes(List<TreeMenuNode> nodes) {
        if (nodes == null || nodes.isEmpty()) {
            return this;
        }
        TreeMenuAddNodesEvent treeMenuAddNodesEvent = new TreeMenuAddNodesEvent(this, nodes);
        this.fireTreeMenuAddNodesListener(treeMenuAddNodesEvent);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "createTreemenu", treeMenuAddNodesEvent.getNodes());
        return this;
    }

    @KSMethod
    public TreeMenu addNodes(List<TreeMenuNode> nodes, List<String> urls) {
        if (nodes == null || nodes.isEmpty()) {
            return this;
        }
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "createTreemenu", nodes, urls);
        return this;
    }

    @KSMethod
    public void addTreeMenuClickListener(TreeMenuClickListener listener) {
        this.treeMenuClickListener.add(listener);
    }

    @KSMethod
    public void treeMenuClick(String parentNodeId, String nodeId) {
        TreeNodeEvent evt = new TreeNodeEvent(this, parentNodeId, nodeId);
        for (TreeMenuClickListener l : this.treeMenuClickListener) {
            EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".treeMenuClick"));
            Throwable throwable = null;
            try {
                l.treeMenuClick(evt);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                span.close();
            }
        }
    }

    @KSMethod
    public void treeMenuDoubleClick(String parentNodeId, String nodeId) {
        TreeNodeEvent evt = new TreeNodeEvent(this, parentNodeId, nodeId);
        for (TreeMenuClickListener l : this.treeMenuClickListener) {
            EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".treeMenuDoubleClick"));
            Throwable throwable = null;
            try {
                l.treeMenuDoubleClick(evt);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                span.close();
            }
        }
    }

    public void clickMenuMark(Map<String, Object> map) {
        ClickEvent evt = new ClickEvent(this, map);
        for (ClickListener cl : this.clickListeners) {
            EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(cl.getClass().getName() + ".click"));
            Throwable throwable = null;
            try {
                cl.click(evt);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                span.close();
            }
        }
    }

    public void setTreeMenusMarked(List<String> MarkedMenuIds) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "setTreeMenusMarked", MarkedMenuIds);
    }
}

