/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.control;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.entity.tree.SuffixIconProps;
import kd.bos.entity.tree.TreeNode;
import kd.bos.entity.tree.TreeNodePartialVariables;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeDragEvent;
import kd.bos.form.control.events.TreeNodeDragListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.control.events.TreeSuffixIconClickEvent;
import kd.bos.form.control.events.TreeSuffixIconClickListener;
import kd.bos.form.control.events.TreeViewListener;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class TreeView
extends Control {
    private static final String FOCUS = "focus";
    private static final String SEL_NODES = "selNodes";
    private static final String SPAN_TYPE_PLUGIN = "plugin";
    protected List<TreeNodeClickListener> treeNodeClickListeners;
    protected List<TreeNodeQueryListener> treeNodeQueryListeners;
    protected List<TreeViewListener> treeViewListeners;
    protected List<TreeNodeCheckListener> treeNodeCheckListeners;
    protected List<TreeNodeDragListener> treeNodeDragListeners;
    private List<TreeSuffixIconClickListener> treeSuffixIconClickListeners = new ArrayList<TreeSuffixIconClickListener>(8);
    private boolean dragEnable;
    private boolean notifyFoldingStatus = false;

    @KSMethod
    public void expand(String nodeid) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "expand", nodeid);
    }

    @KSMethod
    public void showNode(String nodeid) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "showNode", nodeid);
    }

    @KSMethod
    public void collapse(String nodeid) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "collapse", nodeid);
    }

    @KSMethod
    public void deleteNode(String nodeid) {
        this.deleteNodes(Collections.singletonList(nodeid));
    }

    @KSMethod
    public void deleteNodes(List<String> nodes) {
        if (nodes == null || nodes.isEmpty()) {
            return;
        }
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "delNodes", nodes);
        this.getTreeState().delete(nodes);
    }

    @KSMethod
    public void deleteAllNodes() {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "delAllNodes", new Object[0]);
        this.getTreeState().clear();
    }

    @KSMethod
    public void updateNode(TreeNode node) {
        if (node == null) {
            return;
        }
        this.updateNodes(Collections.singletonList(node));
    }

    @KSMethod
    public void updateNodes(List<TreeNode> nodes) {
        if (nodes == null || nodes.isEmpty()) {
            return;
        }
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "updateNodes", nodes);
    }

    @KSMethod
    public void updateNodeProps(List<TreeNodePartialVariables> nodes) {
        if (CollectionUtils.isEmpty(nodes)) {
            return;
        }
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "updateNodeProps", nodes);
    }

    @KSMethod
    public void setRestrictCheckEffectiveArea(boolean restrictCheckEffectiveArea) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.setFieldProperty(this.getKey(), "restrictCheckEffectiveArea", restrictCheckEffectiveArea);
    }

    @KSMethod
    public void addNode(TreeNode node) {
        this.addNodes(Collections.singletonList(node));
    }

    @KSMethod
    public void addNodes(List<TreeNode> nodes) {
        if (nodes == null || nodes.isEmpty()) {
            return;
        }
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "addNodes", nodes);
    }

    @KSMethod
    public void checkNode(TreeNode node) {
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>(1);
        nodeList.add(node);
        this.checkNodes(nodeList);
    }

    @KSMethod
    public void checkNodes(List<TreeNode> nodes) {
        if (nodes == null || nodes.isEmpty()) {
            return;
        }
        nodes.removeIf(Objects::isNull);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.checkNodes(this.getKey(), nodes);
    }

    @KSMethod
    public void checkNodeWithoutChild(TreeNode node) {
        this.checkNodesWithoutChild(Collections.singletonList(node));
    }

    @KSMethod
    public void checkNodesWithoutChild(List<TreeNode> nodes) {
        if (nodes == null || nodes.isEmpty()) {
            return;
        }
        nodes.removeIf(Objects::isNull);
        ArrayList idList = new ArrayList(nodes.size());
        nodes.forEach(node -> idList.add(node.getId()));
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.key, "checkNodeWithoutChild", idList);
        proxy.checkNodesWithoutChild(this.key, nodes);
    }

    @KSMethod
    public void unCheckNodeWithoutChild(String nodeid) {
        this.unCheckNodesWithoutChild(Collections.singletonList(nodeid));
    }

    @KSMethod
    public void unCheckNodesWithoutChild(List<String> nodes) {
        if (nodes == null || nodes.isEmpty()) {
            return;
        }
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "unCheckNodeWithoutChild", nodes);
        this.getTreeState().uncheck(nodes);
    }

    @KSMethod
    public void uncheckNode(String nodeid) {
        this.uncheckNodes(Collections.singletonList(nodeid));
    }

    @KSMethod
    public void uncheckNodes(List<String> nodes) {
        if (nodes == null || nodes.isEmpty()) {
            return;
        }
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "uncheckNodes", nodes);
        this.getTreeState().uncheck(nodes);
    }

    @KSMethod
    public void focusNode(TreeNode node) {
        if (node == null) {
            return;
        }
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "focusNode", node.getId());
        this.getTreeState().focus((Map)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)node), Map.class));
    }

    @KSMethod
    public void setRootVisible(boolean visible) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "rootVisible", visible);
    }

    @KSMethod
    public void addTreeNodeClickListener(TreeNodeClickListener listener) {
        if (this.treeNodeClickListeners == null) {
            this.treeNodeClickListeners = new ArrayList<TreeNodeClickListener>();
        }
        this.treeNodeClickListeners.add(listener);
    }

    @KSMethod
    public void addTreeNodeQueryListener(TreeNodeQueryListener listener) {
        if (this.treeNodeQueryListeners == null) {
            this.treeNodeQueryListeners = new ArrayList<TreeNodeQueryListener>();
        }
        this.treeNodeQueryListeners.add(listener);
    }

    @KSMethod
    public void addTreeViewListener(TreeViewListener listener) {
        if (this.treeViewListeners == null) {
            this.treeViewListeners = new ArrayList<TreeViewListener>();
        }
        this.treeViewListeners.add(listener);
    }

    @KSMethod
    public void notifyFoldingStatus(List<String> expandNodes, List<String> collapseNodes) {
        if (this.treeViewListeners != null) {
            for (TreeViewListener l : this.treeViewListeners) {
                EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".notifyFoldingStatus"));
                Throwable throwable = null;
                try {
                    l.changeFoldingStatus(expandNodes, collapseNodes);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (span == null) continue;
                    if (throwable != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    span.close();
                }
            }
        }
    }

    @KSMethod
    public void addTreeNodeCheckListener(TreeNodeCheckListener listener) {
        if (this.treeNodeCheckListeners == null) {
            this.treeNodeCheckListeners = new ArrayList<TreeNodeCheckListener>();
        }
        this.treeNodeCheckListeners.add(listener);
    }

    @KSMethod
    public void addTreeNodeDragListener(TreeNodeDragListener listener) {
        if (this.treeNodeDragListeners == null) {
            this.treeNodeDragListeners = new ArrayList<TreeNodeDragListener>();
        }
        this.treeNodeDragListeners.add(listener);
    }

    @KSMethod
    public void treeNodeDrag(String nodeId, Object fromParentId, Object toParentId) {
        if (nodeId.equals(toParentId)) {
            return;
        }
        TreeNodeDragEvent evt = new TreeNodeDragEvent(this, nodeId, fromParentId, toParentId);
        if (this.treeNodeDragListeners != null) {
            for (TreeNodeDragListener l : this.treeNodeDragListeners) {
                EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".treeNodeDragged"));
                Throwable throwable = null;
                try {
                    l.treeNodeDragged(evt);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (span == null) continue;
                    if (throwable != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    span.close();
                }
            }
        }
    }

    @KSMethod
    public void treeNodeCheck(String parentNodeId, String nodeId, Boolean checked) {
        TreeNodeCheckEvent evt = new TreeNodeCheckEvent(this, parentNodeId, nodeId, checked);
        if (this.treeNodeCheckListeners != null) {
            for (TreeNodeCheckListener l : this.treeNodeCheckListeners) {
                EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".treeNodeCheck"));
                Throwable throwable = null;
                try {
                    l.treeNodeCheck(evt);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (span == null) continue;
                    if (throwable != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    span.close();
                }
            }
        }
    }

    @KSMethod
    public void treeNodeClick(String parentNodeId, String nodeId) {
        TreeNodeEvent evt = new TreeNodeEvent(this, parentNodeId, nodeId);
        if (this.treeNodeClickListeners != null) {
            for (TreeNodeClickListener l : this.treeNodeClickListeners) {
                EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".treeNodeClick"));
                Throwable throwable = null;
                try {
                    l.treeNodeClick(evt);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (span == null) continue;
                    if (throwable != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    span.close();
                }
            }
        }
    }

    @KSMethod
    public void treeNodeDoubleClick(String parentNodeId, String nodeId) {
        TreeNodeEvent evt = new TreeNodeEvent(this, parentNodeId, nodeId);
        if (this.treeNodeClickListeners != null) {
            for (TreeNodeClickListener l : this.treeNodeClickListeners) {
                EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".treeNodeDoubleClick"));
                Throwable throwable = null;
                try {
                    l.treeNodeDoubleClick(evt);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (span == null) continue;
                    if (throwable != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    span.close();
                }
            }
        }
    }

    public void queryTreeNodeChildren(String parentId, String nodeId) {
        TreeNodeEvent evt = new TreeNodeEvent(this, parentId, nodeId);
        if (this.treeNodeQueryListeners != null) {
            for (TreeNodeQueryListener l : this.treeNodeQueryListeners) {
                EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".queryTreeNodeChildren"));
                Throwable throwable = null;
                try {
                    l.queryTreeNodeChildren(evt);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (span == null) continue;
                    if (throwable != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    span.close();
                }
            }
        }
    }

    public void addTreeSuffixIconClickListeners(TreeSuffixIconClickListener treeSuffixIconClickListener) {
        this.treeSuffixIconClickListeners.add(treeSuffixIconClickListener);
    }

    public void treeSuffixIconClick(String nodeId, String iconId) {
        if (!this.treeSuffixIconClickListeners.isEmpty()) {
            for (TreeSuffixIconClickListener treeSuffixIconClickListener : this.treeSuffixIconClickListeners) {
                TreeSuffixIconClickEvent treeSuffixIconClickEvent = new TreeSuffixIconClickEvent(this, nodeId, iconId);
                treeSuffixIconClickListener.treeSuffixIconClick(treeSuffixIconClickEvent);
            }
        }
    }

    @KSMethod
    public TreeState getTreeState() {
        IClientViewProxy proxy = (IClientViewProxy)this.view.getService(IClientViewProxy.class);
        return proxy.getTreeState(this.getKey());
    }

    @KSMethod
    public void setMulti(boolean isMulti) {
        if (this.view != null) {
            HashMap<String, Object> ctl = new HashMap<String, Object>(1);
            ctl.put("im", isMulti);
            this.view.updateControlMetadata(this.getKey(), ctl);
        }
    }

    @SimplePropertyAttribute(name="DragEnable")
    public boolean isDragEnable() {
        return this.dragEnable;
    }

    public void setDragEnable(boolean dragEnable) {
        this.dragEnable = dragEnable;
    }

    @KSMethod
    public boolean isNotifyFoldingStatus() {
        return this.notifyFoldingStatus;
    }

    @KSMethod
    public void setNotifyFoldingStatus(boolean notifyFoldingStatus) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.setFieldProperty(this.getKey(), "notifyFoldingStatus", notifyFoldingStatus);
        this.notifyFoldingStatus = notifyFoldingStatus;
    }

    @KSMethod
    public void setSuffixIconProps(SuffixIconProps suffixIconProps) {
        HashMap<String, Object> suffixIcon = new HashMap<String, Object>(8);
        suffixIcon.put("suffixIconProps", suffixIconProps);
        this.getView().updateControlMetadata(this.getKey(), suffixIcon);
    }

    @Override
    public void postBack(Object value) {
        if (value instanceof Map) {
            if (EntityTracer.isRealtime()) {
                try (EntityTraceSpan span = EntityTracer.create((String)"TreeView", (String)"postBack");){
                    span.addTag("key", this.getKey());
                    span.addLocaleTag("value", value);
                }
            }
            Map states = (Map)value;
            TreeState treeState = this.getTreeState();
            for (Map.Entry state : states.entrySet()) {
                treeState.state.put(state.getKey(), state.getValue());
            }
        } else {
            super.postBack(value);
        }
    }

    @SdkPublic
    @KSObject
    public static class TreeState {
        private String key;
        private Map<String, Object> state = new HashMap<String, Object>();

        public TreeState(String key, Map<String, Object> state) {
            this.key = key;
            this.state = state;
        }

        void clear() {
            this.state.clear();
        }

        void delete(List<String> nodes) {
            this.uncheck(nodes);
            Map<String, Object> focusNode = this.getFocusNode();
            Object nodeId = null;
            if (focusNode != null) {
                nodeId = focusNode.get("id");
            }
            if (this.state.containsKey(TreeView.FOCUS) && nodes.contains(nodeId)) {
                this.state.remove(TreeView.FOCUS);
            }
        }

        void uncheck(List<String> nodes) {
            if (this.state.containsKey(TreeView.SEL_NODES)) {
                ((List)this.state.get(TreeView.SEL_NODES)).removeIf(node -> nodes.contains(node.get("id")));
            }
        }

        void focus(Map<String, Object> node) {
            this.state.put(TreeView.FOCUS, node);
        }

        public final void check(List<Map<String, Object>> nodes) {
            if (!this.state.containsKey(TreeView.SEL_NODES)) {
                this.state.put(TreeView.SEL_NODES, new ArrayList());
            }
            List selNodes = (List)this.state.get(TreeView.SEL_NODES);
            ArrayList idList = new ArrayList(selNodes.size());
            selNodes.forEach(node -> idList.add((String)node.get("id")));
            nodes.forEach(node -> {
                if (!idList.contains(node.get("id"))) {
                    selNodes.add(node);
                }
            });
        }

        @KSMethod
        public final List<Map<String, Object>> getCheckedNodes() {
            ArrayList selNodes = (ArrayList)this.state.get(TreeView.SEL_NODES);
            if (selNodes == null) {
                selNodes = new ArrayList();
                this.state.put(TreeView.SEL_NODES, selNodes);
            }
            return new ArrayList<Map<String, Object>>(selNodes);
        }

        @KSMethod
        public final List<String> getCheckedNodeIds() {
            if (!this.state.containsKey(TreeView.SEL_NODES)) {
                this.state.put(TreeView.SEL_NODES, new ArrayList());
            }
            List selNodes = (List)this.state.get(TreeView.SEL_NODES);
            ArrayList<String> idList = new ArrayList<String>(selNodes.size());
            selNodes.forEach(node -> idList.add((String)node.get("id")));
            return idList;
        }

        @KSMethod
        public final Map<String, Object> getFocusNode() {
            Map node = (Map)this.state.get(TreeView.FOCUS);
            return node == null ? node : new HashMap(node);
        }

        @KSMethod
        public final String getFocusNodeId() {
            Map<String, Object> node = this.getFocusNode();
            if (node != null && node.containsKey("id")) {
                return (String)node.get("id");
            }
            return null;
        }

        @KSMethod
        public final List<Map<String, Object>> getSelectedNodes() {
            ArrayList<Map<String, Object>> selNodes = new ArrayList<Map<String, Object>>();
            if (this.state.containsKey(TreeView.SEL_NODES)) {
                selNodes.addAll(this.getCheckedNodes());
            } else {
                Map<String, Object> focus = this.getFocusNode();
                if (focus != null) {
                    selNodes.add(focus);
                }
            }
            return selNodes;
        }

        @KSMethod
        public final List<String> getSelectedNodeId() {
            List<Map<String, Object>> selNodes = this.getSelectedNodes();
            ArrayList<String> idList = new ArrayList<String>(selNodes.size());
            selNodes.forEach(node -> idList.add((String)node.get("id")));
            return idList;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }
    }
}

