/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.control;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class UrlUtil {
    public static boolean checkUrl(String linkUrl) {
        if (StringUtils.isBlank((CharSequence)linkUrl)) {
            return true;
        }
        if (linkUrl.toLowerCase().contains("javascript")) {
            return false;
        }
        String pattern = "^([hH][tT]{2}[pP]:/{2}|[hH][tT]{2}[pP][sS]:/{2}|)([^(`]+)$";
        Pattern p = Pattern.compile(pattern);
        return p.matcher(linkUrl).matches();
    }

    public static String getParam(String url, String name) {
        return UrlUtil.urlSplit(url).get(name);
    }

    private static String truncateUrlPage(String url) {
        String strAllParam = null;
        String[] arrSplit = null;
        arrSplit = url.split("[?]");
        if (url.length() > 1 && arrSplit.length > 1) {
            for (int i = 1; i < arrSplit.length; ++i) {
                strAllParam = arrSplit[i];
            }
        }
        return strAllParam;
    }

    public static Map<String, String> urlSplit(String url) {
        HashMap<String, String> mapRequest = new HashMap<String, String>();
        String[] arrSplit = null;
        String strUrlParam = UrlUtil.truncateUrlPage(url);
        if (strUrlParam == null) {
            return mapRequest;
        }
        for (String strSplit : arrSplit = strUrlParam.split("[&]")) {
            String[] arrSplitEqual = null;
            arrSplitEqual = strSplit.split("[=]");
            if (arrSplitEqual.length > 1) {
                mapRequest.put(arrSplitEqual[0], arrSplitEqual[1]);
                continue;
            }
            if (arrSplitEqual[0].equals("")) continue;
            mapRequest.put(arrSplitEqual[0], "");
        }
        return mapRequest;
    }

    protected static void cacheTempFilePermissionParam(String tempFileUrl, String entityNum, String appId) {
        if (!tempFileUrl.contains("tempfile/download.do?configKey")) {
            return;
        }
        DistributeSessionlessCache redisCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("", new DistributeCacheHAPolicy(true, true));
        String tempFileId = UrlUtil.getParam(tempFileUrl, "id");
        Map<String, Object> refEntitiyMap = UrlUtil.createPermissionEntityMap(entityNum, appId);
        redisCache.put("TempFileCheckId:" + tempFileId, (Object)SerializationUtils.toJsonString(refEntitiyMap), 7200);
    }

    private static Map<String, Object> createPermissionEntityMap(String entityNum, String appId) {
        HashMap<String, Object> refEntitiyMap = new HashMap<String, Object>(16);
        refEntitiyMap.put("entityNum", entityNum);
        refEntitiyMap.put("appId", appId);
        refEntitiyMap.put("permItem", "2NJ5XVVCMBCL");
        return refEntitiyMap;
    }
}

