/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.control.events;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IFilterModel;
import kd.bos.entity.filter.CompareType;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.CompareTypeValue;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.filter.FilterRow;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class SearchClickEvent
extends EventObject {
    private static final long serialVersionUID = 1L;
    private static final String FASTFILTER = "fastfilter";
    private static final String SCHEMEFILTER = "schemefilter";
    private static final String FIELD_NAME = "FieldName";
    private static final String BOS_FORM_METADATA = "bos-form-metadata";
    transient Map<String, List<Map<String, List<Object>>>> filterValues;
    String entryEntity;
    transient IFilterModel filterModel;
    FilterParameter filterParameter;
    transient Map<String, List<Object>> currentCommonFilter;
    transient List<QFilter> fastQFilters;
    transient Map<String, List<CompareTypeValue>> innerFilterValuesMap = new HashMap<String, List<CompareTypeValue>>(16);
    transient Map<String, List<CompareTypeValue>> fieldCompareValuesMap = new HashMap<String, List<CompareTypeValue>>(16);
    transient Map<String, QFilter> innerQFilterMap = new HashMap<String, QFilter>();
    private static final Log log = LogFactory.getLog(SearchClickEvent.class);
    private Map<String, List<Object>> defaultCommonFilters;

    public Map<String, List<Object>> getDefaultCommonFilters() {
        return this.defaultCommonFilters;
    }

    public void setDefaultCommonFilters(Map<String, List<Object>> defaultCommonFilters) {
        this.defaultCommonFilters = defaultCommonFilters;
    }

    public List<QFilter> getFastQFilters() {
        return this.fastQFilters;
    }

    public Map<String, List<Object>> getCurrentCommonFilter() {
        return this.currentCommonFilter;
    }

    public void setCurrentCommonFilter(Map<String, List<Object>> currentCommonFilter) {
        this.currentCommonFilter = currentCommonFilter;
    }

    public Map<String, List<Map<String, List<Object>>>> getFilterValues() {
        return this.filterValues;
    }

    public void setFilterValues(Map<String, List<Map<String, List<Object>>>> filterValues) {
        this.filterValues = filterValues;
    }

    @KSMethod
    public String getEntryEntity() {
        return this.entryEntity;
    }

    @KSMethod
    public IFilterModel getFilterModel() {
        return this.filterModel;
    }

    @KSMethod
    public FilterParameter getFilterParameter() {
        return this.filterParameter;
    }

    public void setFilterParameter(FilterParameter filterParameter) {
        this.filterParameter = filterParameter;
    }

    public Object getFilterValue(String fieldName) {
        List<CompareTypeValue> compareTypeValues = this.innerFilterValuesMap.get(fieldName);
        if (compareTypeValues == null || compareTypeValues.isEmpty()) {
            return null;
        }
        return compareTypeValues.get(0).getValue();
    }

    public List<CompareTypeValue> getFieldCompareFilterValue(String fieldName) {
        return this.fieldCompareValuesMap.get(fieldName);
    }

    @Deprecated
    public QFilter getQFilter(String fieldName) {
        return this.innerQFilterMap.get(fieldName);
    }

    public List<Long> getSelectMainOrgIds() {
        return this.getFilterModel().getSelectedMainOrgIds();
    }

    public List<Map<String, List<Object>>> getFastFilterValues() {
        return this.filterValues.get(FASTFILTER);
    }

    private FilterRow getFilterRow(String fieldName) {
        for (FilterRow filterRow : this.filterModel.getFilterObject().getFilterRows()) {
            if (!fieldName.equals(filterRow.getFilterField().getFieldName())) continue;
            return filterRow;
        }
        return null;
    }

    private FilterRow getFilterRow(boolean isFilterValueContainId, String fieldName, String compareTypeId) {
        for (FilterRow filterRow : this.filterModel.getFilterObject().getFilterRows()) {
            FilterField idFilterField;
            FilterField filterField;
            CompareType compareType = filterRow.getCompareType();
            if (!(isFilterValueContainId && this.isConvertToIdMatch(compareType) ? !"1301".equals(compareTypeId) && (filterField = (FilterField)this.filterModel.getFilterObject().getAllFilterFields().get(fieldName)) != null && (idFilterField = filterField.convertToId()) != null && StringUtils.equals((CharSequence)filterRow.getFilterField().getFieldName(), (CharSequence)idFilterField.getFieldName()) && StringUtils.equals((CharSequence)compareTypeId, (CharSequence)compareType.getId()) : StringUtils.equals((CharSequence)fieldName, (CharSequence)filterRow.getFilterField().getFieldName()) && StringUtils.equals((CharSequence)compareTypeId, (CharSequence)compareType.getId()))) continue;
            return filterRow;
        }
        return null;
    }

    private boolean isConvertToIdMatch(CompareType compareType) {
        return "=".equals(compareType.getOperate()) || "<>".equals(compareType.getOperate()) || "IN".equals(compareType.getOperate()) || "Not IN".equals(compareType.getOperate());
    }

    private Object getFilterValueBySqlTypes(String operater, int fieldType, List<String> values) {
        boolean notInOperate;
        boolean bl = notInOperate = !"IN".equalsIgnoreCase(operater) && !"Not IN".equalsIgnoreCase(operater) && !"BETWEEN".equalsIgnoreCase(operater) && !values.isEmpty();
        if (fieldType == 5) {
            if (notInOperate) {
                return Short.parseShort(values.get(0));
            }
            ArrayList<Short> shorts = new ArrayList<Short>(10);
            for (String value : values) {
                shorts.add(Short.parseShort(value));
            }
            return shorts;
        }
        if (fieldType == -6) {
            if (notInOperate) {
                return Byte.parseByte(values.get(0));
            }
            ArrayList<Byte> bytes = new ArrayList<Byte>(10);
            for (String value : values) {
                bytes.add(Byte.parseByte(value));
            }
            return bytes;
        }
        if (fieldType == 4) {
            if (notInOperate) {
                return Integer.parseInt(values.get(0));
            }
            ArrayList<Integer> integers = new ArrayList<Integer>(10);
            for (String value : values) {
                integers.add(Integer.parseInt(value));
            }
            return integers;
        }
        if (fieldType == -5) {
            if (notInOperate) {
                return Long.parseLong(values.get(0));
            }
            ArrayList<Long> longs = new ArrayList<Long>(10);
            for (String value : values) {
                longs.add(Long.parseLong(value));
            }
            return longs;
        }
        if (fieldType == 7) {
            if (notInOperate) {
                return Float.valueOf(Float.parseFloat(values.get(0)));
            }
            ArrayList<Float> floats = new ArrayList<Float>(10);
            for (String value : values) {
                floats.add(Float.valueOf(Float.parseFloat(value)));
            }
            return floats;
        }
        if (fieldType == 6 || fieldType == 8) {
            if (notInOperate) {
                return Double.parseDouble(values.get(0));
            }
            ArrayList<Double> doubles = new ArrayList<Double>(10);
            for (String value : values) {
                doubles.add(Double.parseDouble(value));
            }
            return doubles;
        }
        if (fieldType == 3 || fieldType == 2) {
            if (notInOperate) {
                return Double.parseDouble(values.get(0));
            }
            ArrayList<BigDecimal> bigDecimals = new ArrayList<BigDecimal>(10);
            for (String value : values) {
                bigDecimals.add(BigDecimal.valueOf(Double.parseDouble(value)));
            }
            return bigDecimals;
        }
        if (fieldType == -7) {
            if (notInOperate) {
                return Boolean.parseBoolean(values.get(0));
            }
            ArrayList<Boolean> booleans = new ArrayList<Boolean>(10);
            for (String value : values) {
                booleans.add(Boolean.parseBoolean(value));
            }
            return booleans;
        }
        if (notInOperate) {
            return values.get(0);
        }
        return values;
    }

    private QFilter getParsedQFilter(String fieldName) {
        for (QFilter qFilter : this.fastQFilters) {
            if (!fieldName.equals(qFilter.getProperty())) continue;
            return qFilter;
        }
        for (QFilter qFilter : this.filterParameter.getQFilters()) {
            if (!fieldName.equals(qFilter.getProperty())) continue;
            return qFilter;
        }
        return null;
    }

    private void addInnerFilterValue(String filterMapKey, String fieldName, CompareTypeEnum compareTypeId, Object ... values) {
        this.addInnerFilterValue(filterMapKey, fieldName, compareTypeId.getId(), values);
    }

    private void addInnerFilterValue(String filterMapKey, String fieldName, String compareTypeId, Object ... values) {
        FilterField filterField = FilterField.create((MainEntityType)this.filterModel.getDataType(), (String)fieldName);
        CompareTypeEnum compareTypeEnum = CompareTypeEnum.createCompareTypeEnum((String)compareTypeId);
        if (compareTypeEnum != null && this.isFieldCompareType(compareTypeEnum)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u901a\u8fc7\u63d2\u4ef6\u8bbe\u7f6e\u65b9\u6848\u8fc7\u6ee4\u5b57\u6bb5\u6bd4\u8f83\u3002", (String)"SearchClickEvent_0", (String)BOS_FORM_METADATA, (Object[])new Object[0]), new Object[0]));
        }
        CompareType compareType = filterField.getCompareType(compareTypeId);
        if (compareType == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5%1$s\u6bd4\u8f83\u7b26%2$s\u4e0d\u5b58\u5728", (String)"SearchClickEvent_1", (String)BOS_FORM_METADATA, (Object[])new Object[0]), fieldName, compareTypeId));
        }
        List<Map<String, List<Object>>> filterValue = this.filterValues.get(filterMapKey);
        HashMap filterMap = new HashMap();
        ArrayList<String> fieldNames = new ArrayList<String>();
        fieldNames.add(fieldName);
        filterMap.put(FIELD_NAME, fieldNames);
        ArrayList<String> compareTypes = new ArrayList<String>();
        compareTypes.add(compareTypeId);
        filterMap.put("Compare", compareTypes);
        ArrayList<Object> valueList = new ArrayList<Object>();
        valueList.addAll(Arrays.asList(values));
        filterMap.put("Value", valueList);
        filterValue.add(filterMap);
        CompareTypeValue compareTypeValue = new CompareTypeValue(fieldName, compareTypeEnum, (Object)values);
        this.putInnerFilterValue(fieldName, compareTypeValue);
    }

    private boolean isFieldCompareType(CompareTypeEnum compareTypeEnum) {
        return compareTypeEnum == CompareTypeEnum.FIELDEQUAL || compareTypeEnum == CompareTypeEnum.FIELDNOTEQUAL || compareTypeEnum == CompareTypeEnum.FIELDGREATEROREQUAL || compareTypeEnum == CompareTypeEnum.FIELDGREATER || compareTypeEnum == CompareTypeEnum.FIELDSMALLEROREQUAL || compareTypeEnum == CompareTypeEnum.FIELDSMALLER;
    }

    private boolean isFieldCompareType(String compareTypeId) {
        return StringUtils.equals((CharSequence)compareTypeId, (CharSequence)"-1") || StringUtils.equals((CharSequence)compareTypeId, (CharSequence)"-2") || StringUtils.equals((CharSequence)compareTypeId, (CharSequence)"-3") || StringUtils.equals((CharSequence)compareTypeId, (CharSequence)"-4") || StringUtils.equals((CharSequence)compareTypeId, (CharSequence)"-5") || StringUtils.equals((CharSequence)compareTypeId, (CharSequence)"-6");
    }

    private void addInnerFastFilterValue(String value, String ... fieldNames) {
        List<Map<String, List<Object>>> filterValue = this.filterValues.get(FASTFILTER);
        HashMap filterMap = new HashMap();
        ArrayList<String> fieldNameList = new ArrayList<String>();
        fieldNameList.addAll(Arrays.asList(fieldNames));
        filterMap.put(FIELD_NAME, fieldNameList);
        ArrayList<String> valueList = new ArrayList<String>();
        valueList.add(value);
        filterMap.put("Value", valueList);
        filterValue.add(filterMap);
    }

    private String getFilterMapKey() {
        if (this.filterValues.containsKey("customfilter")) {
            return "customfilter";
        }
        return SCHEMEFILTER;
    }

    public void addConstFilter(String fieldName, CompareTypeEnum compareTypeId) {
        if (compareTypeId != null) {
            this.addInnerFilterValue(this.getFilterMapKey(), fieldName, compareTypeId, compareTypeId.getId());
        }
    }

    public void addFilter(String fieldName, CompareTypeEnum compareTypeId, Object ... values) {
        if (compareTypeId != null) {
            this.addInnerFilterValue(this.getFilterMapKey(), fieldName, compareTypeId, values);
        }
    }

    public void addFilter(String fieldName, String compareTypeId, Object ... values) {
        this.addInnerFilterValue(this.getFilterMapKey(), fieldName, compareTypeId, values);
    }

    public void addFastFilter(String fieldName, String value) {
        this.addInnerFastFilterValue(value, fieldName);
    }

    public SearchClickEvent(Object source, Map<String, List<Map<String, List<Object>>>> filterValues, String entryEntity, IFilterModel filterModel, FilterParameter filterParameter, Map<String, List<Object>> currentCommonFilter, List<QFilter> fastQFilters) {
        super(source);
        this.filterValues = filterValues;
        this.entryEntity = entryEntity;
        this.filterModel = filterModel;
        this.filterParameter = filterParameter;
        this.currentCommonFilter = currentCommonFilter;
        this.fastQFilters = fastQFilters;
        for (Map.Entry<String, List<Map<String, List<Object>>>> entry : filterValues.entrySet()) {
            if (entry.getValue() == null) continue;
            if (SCHEMEFILTER.equals(entry.getKey())) {
                for (Map<String, List<Object>> filterRowValueMap : entry.getValue()) {
                    this.schemeFilterValueParse(filterRowValueMap);
                }
                continue;
            }
            if (FASTFILTER.equals(entry.getKey()) || SCHEMEFILTER.equals(entry.getKey())) continue;
            for (Map<String, List<Object>> filterRowValueMap : entry.getValue()) {
                String fieldName = (String)filterRowValueMap.get(FIELD_NAME).get(0);
                FilterRow filterRow = this.getFilterRow(fieldName);
                if (filterRow == null) continue;
                Object filterValueBySqlTypes = this.getFilterValueBySqlTypes(filterRow.getCompareType().getOperate(), filterRow.getFilterField().getFieldType(), filterRow.getValue());
                CompareTypeEnum compareTypeEnum = CompareTypeEnum.createCompareTypeEnum((String)filterRow.getCompareType().getId());
                if (compareTypeEnum == null) {
                    log.warn("\u8fc7\u6ee4\u6bd4\u8f83\u7b26\u679a\u4e3e\u4e2d\u6ca1\u6709\u8be5\u7c7b\u578b\u7684\u6bd4\u8f83\u7b26:" + filterRow.getCompareType().getId());
                }
                CompareTypeValue compareTypeValue = new CompareTypeValue(fieldName, compareTypeEnum, filterValueBySqlTypes);
                this.putInnerFilterValue(fieldName, compareTypeValue);
                this.innerQFilterMap.put(fieldName, this.getParsedQFilter(filterRow.getORMFieldName()));
            }
        }
    }

    private void schemeFilterValueParse(Map<String, List<Object>> filterRowValueMap) {
        if (filterRowValueMap.get("Compare").size() != 0) {
            String compareTypeId = (String)filterRowValueMap.get("Compare").get(0);
            String fieldName = (String)filterRowValueMap.get(FIELD_NAME).get(0);
            if (this.isFieldCompareType(compareTypeId)) {
                FilterRow filterRow = this.getFilterRow(filterRowValueMap.containsKey("id") || filterRowValueMap.containsKey("Id"), fieldName, compareTypeId);
                if (filterRow != null) {
                    CompareTypeEnum compareTypeEnum = CompareTypeEnum.createCompareTypeEnum((String)compareTypeId);
                    if (compareTypeEnum == null) {
                        log.warn("\u8fc7\u6ee4\u6bd4\u8f83\u7b26\u679a\u4e3e\u4e2d\u6ca1\u6709\u8be5\u7c7b\u578b\u7684\u6bd4\u8f83\u7b26\uff1a" + compareTypeId);
                    }
                    CompareTypeValue compareTypeValue = new CompareTypeValue(fieldName, compareTypeEnum, (Object)filterRow.getValue());
                    this.putInnerFieldFilterValue(fieldName, compareTypeValue);
                    this.innerQFilterMap.put(fieldName, this.getParsedQFilter(filterRow.getORMFieldName()));
                }
            } else {
                FilterRow filterRow = this.getFilterRow(filterRowValueMap.containsKey("id") || filterRowValueMap.containsKey("Id"), fieldName, compareTypeId);
                if (filterRow != null) {
                    Object filterValueBySqlTypes = this.getFilterValueBySqlTypes(filterRow.getCompareType().getOperate(), filterRow.getFilterField().getFieldType(), filterRow.getValue());
                    CompareTypeEnum compareTypeEnum = CompareTypeEnum.createCompareTypeEnum((String)compareTypeId);
                    if (compareTypeEnum == null) {
                        log.warn("\u8fc7\u6ee4\u6bd4\u8f83\u7b26\u679a\u4e3e\u4e2d\u6ca1\u6709\u8be5\u7c7b\u578b\u7684\u6bd4\u8f83\u7b26\uff1a" + compareTypeId);
                    }
                    CompareTypeValue compareTypeValue = new CompareTypeValue(fieldName, compareTypeEnum, filterValueBySqlTypes);
                    this.putInnerFilterValue(fieldName, compareTypeValue);
                    this.innerQFilterMap.put(fieldName, this.getParsedQFilter(filterRow.getORMFieldName()));
                }
            }
        }
    }

    private void putInnerFieldFilterValue(String fieldName, CompareTypeValue compareTypeValue) {
        if (this.fieldCompareValuesMap.containsKey(fieldName)) {
            this.fieldCompareValuesMap.get(fieldName).add(compareTypeValue);
        } else {
            ArrayList<CompareTypeValue> compareTypeValues = new ArrayList<CompareTypeValue>();
            compareTypeValues.add(compareTypeValue);
            this.fieldCompareValuesMap.put(fieldName, compareTypeValues);
        }
    }

    private void putInnerFilterValue(String fieldName, CompareTypeValue compareTypeValue) {
        if (this.innerFilterValuesMap.containsKey(fieldName)) {
            this.innerFilterValuesMap.get(fieldName).add(compareTypeValue);
        } else {
            ArrayList<CompareTypeValue> compareTypeValues = new ArrayList<CompareTypeValue>();
            compareTypeValues.add(compareTypeValue);
            this.innerFilterValuesMap.put(fieldName, compareTypeValues);
        }
    }
}

