/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.control.grid;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.TreeEntryProp;
import kd.bos.entity.property.entryfilter.EntryQueryParam;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.TreeSubEntryGrid;

public class DragEntryRow {
    private static final String BOS_FORM_METADATA = "bos-form-metadata";
    private String entryKey;
    private String key;
    private IFormView view;
    private IDataModel model;
    private int[] formIndexs;
    int toIndex;

    public DragEntryRow() {
    }

    public DragEntryRow(String entryKey, String key, IFormView view, int[] formIndexs, int toIndex) {
        this.entryKey = entryKey;
        this.key = key;
        this.view = view;
        this.formIndexs = formIndexs;
        this.toIndex = toIndex;
        this.model = view.getModel();
    }

    public void invokeOperation() {
        boolean result;
        if (this.isAllowDragEntryRow(this.model, this.formIndexs, this.toIndex) && (result = this.model.togetherMoveEntryRow(this.entryKey, this.formIndexs, this.toIndex))) {
            EntryGrid entryGrid = (EntryGrid)this.view.getControl(this.key);
            int[] rowIndexs = entryGrid.getEntryState().getSelectedRows();
            entryGrid.bindData(null);
            this.resetSelectRows(entryGrid, rowIndexs);
        }
    }

    private boolean isAllowDragEntryRow(IDataModel model, int[] formIndexs, int toIndex) {
        try (EntityTraceSpan span = EntityTracer.create((String)"DragEntryRow", (String)"isAllowDragEntryRow");){
            EntryQueryParam queryParam;
            if (span.isRealtime()) {
                span.addLocaleTag("formIndexs", (Object)formIndexs);
                span.addLocaleTag("toIndex", (Object)toIndex);
            }
            if (formIndexs.length <= 0) {
                this.view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u62d6\u62fd\u7684\u5206\u5f55\u884c\u3002", (String)"DragEntryRow_0", (String)BOS_FORM_METADATA, (Object[])new Object[0]), 3000);
                boolean bl = false;
                return bl;
            }
            if (toIndex < -1) {
                this.view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u62d6\u62fd\u7684\u76ee\u6807\u5206\u5f55\u884c\u3002", (String)"DragEntryRow_1", (String)BOS_FORM_METADATA, (Object[])new Object[0]), 3000);
                boolean bl = false;
                return bl;
            }
            Object entry = this.view.getControl(this.key);
            if (entry instanceof TreeEntryGrid || entry instanceof TreeSubEntryGrid) {
                DynamicObjectCollection entryEntity = model.getEntryEntity(this.entryKey);
                if (span.isRealtime()) {
                    span.addLocaleTag("entryEntity.size", (Object)entryEntity.size());
                }
                if (entryEntity == null || entryEntity.size() <= 0 || entryEntity.size() <= toIndex || entryEntity.size() <= formIndexs[0] || entryEntity.size() <= formIndexs[formIndexs.length - 1]) {
                    this.view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u884c\u62d6\u62fd\u53c2\u6570\u662f\u5426\u6709\u8bef\u3002", (String)"DragEntryRow_2", (String)BOS_FORM_METADATA, (Object[])new Object[0]), 3000);
                    boolean bl = false;
                    return bl;
                }
                if (!TreeEntryProp.isHasSameParentNode((DynamicObjectCollection)entryEntity, (int[])formIndexs, (int)toIndex)) {
                    this.view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u540c\u4e00\u7236\u8282\u70b9\u7684\u884c\u8fdb\u884c\u62d6\u62fd\u3002", (String)"DragEntryRow_3", (String)BOS_FORM_METADATA, (Object[])new Object[0]), 3000);
                    boolean bl = false;
                    return bl;
                }
            }
            if ((queryParam = model.getEntryQueryParam(this.entryKey)) != null && queryParam.needFilterAndSort()) {
                if (span.isRealtime()) {
                    span.addLocaleTag("queryParam", (Object)SerializationUtils.toJsonString((Object)queryParam));
                }
                this.view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u53d6\u6d88\u5206\u5f55\u6392\u5e8f\u3001\u8fc7\u6ee4\u540e\u518d\u8fdb\u884c\u884c\u62d6\u62fd\u64cd\u4f5c\u3002", (String)"DragEntryRow_4", (String)BOS_FORM_METADATA, (Object[])new Object[0]), 3000);
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    public List<Integer> getMoveAfterRowKeysList(int[] formIndexs, int toIndex, int minIndex, int maxIndex) {
        int i;
        ArrayList<Integer> rows = new ArrayList<Integer>(maxIndex - minIndex + 1);
        for (i = minIndex; i <= maxIndex; ++i) {
            rows.add(i);
        }
        Arrays.sort(formIndexs);
        for (i = formIndexs.length - 1; i >= 0; --i) {
            rows.remove(formIndexs[i] - minIndex);
            if (formIndexs[i] > toIndex) continue;
            --toIndex;
        }
        for (i = formIndexs.length - 1; i >= 0; --i) {
            rows.add(toIndex - minIndex + 1, formIndexs[i]);
        }
        return rows;
    }

    private void resetSelectRows(EntryGrid entryGrid, int[] rowIndexs) {
        int minIndex = this.toIndex;
        int maxIndex = this.toIndex;
        for (int i = 0; i < this.formIndexs.length; ++i) {
            minIndex = Math.min(minIndex, this.formIndexs[i]);
            maxIndex = Math.max(maxIndex, this.formIndexs[i]);
        }
        List<Integer> moveAfterRowKeysList = this.getMoveAfterRowKeysList(this.formIndexs, this.toIndex, minIndex, maxIndex);
        int[] newSelectIndexs = new int[rowIndexs.length];
        for (int i = 0; i < rowIndexs.length; ++i) {
            int rowIndex = rowIndexs[i];
            newSelectIndexs[i] = rowIndex >= minIndex && rowIndex <= maxIndex ? minIndex + moveAfterRowKeysList.indexOf(rowIndexs[i]) : rowIndexs[i];
        }
        int focusRowIndex = minIndex + moveAfterRowKeysList.indexOf(this.formIndexs[0]);
        entryGrid.selectRows(newSelectIndexs, focusRowIndex);
    }
}

