/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.control.grid.column;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.control.Control;
import kd.bos.form.control.grid.column.IDataGridColumn;
import kd.bos.script.annotations.KSObject;

@KSObject
public class DataGridColumn
extends Control
implements IDataGridColumn {
    private static final String VISIBLE_DEFAULT_VALUE = "init,new,edit,view,submit,audit";
    private static final String DEFAULT = "default";
    private static final String LOOKUP = "lookup";
    private static final String INIT = "init";
    private static Map<String, Integer> mapVis = new HashMap<String, Integer>(11);
    private LocaleString caption;
    private LocaleString width;
    private String visible;
    private String textAlign;
    private String foreColor;
    private String backColor;
    private int fontsize = 12;

    @SimplePropertyAttribute
    public LocaleString getCaption() {
        return this.caption;
    }

    public void setCaption(LocaleString caption) {
        this.caption = caption;
    }

    @SimplePropertyAttribute
    public LocaleString getWidth() {
        return this.width;
    }

    public void setWidth(LocaleString width) {
        this.width = width;
    }

    @SimplePropertyAttribute
    public String getVisible() {
        return this.visible;
    }

    public void setVisible(String visible) {
        this.visible = visible == null ? VISIBLE_DEFAULT_VALUE : visible;
    }

    @SimplePropertyAttribute
    public String getTextAlign() {
        return this.textAlign;
    }

    public void setTextAlign(String textAlign) {
        this.textAlign = textAlign;
    }

    @SimplePropertyAttribute
    public String getForeColor() {
        return this.foreColor;
    }

    public void setForeColor(String foreColor) {
        this.foreColor = foreColor;
    }

    @SimplePropertyAttribute
    public String getBackColor() {
        return this.backColor;
    }

    public void setBackColor(String backColor) {
        this.backColor = backColor;
    }

    @SimplePropertyAttribute
    public int getFontSize() {
        return this.fontsize;
    }

    public void setFontSize(int fontSize) {
        this.fontsize = fontSize;
    }

    public int getVisibleValue() {
        String visible = this.getVisible();
        if (visible == null) {
            return 63;
        }
        if (visible.contains(DEFAULT) || visible.contains(LOOKUP)) {
            String string = visible = StringUtils.isNotBlank((CharSequence)visible) && !visible.contains(INIT) ? String.format("%s,%s", visible, INIT) : visible;
        }
        if (StringUtils.isEmpty((CharSequence)visible)) {
            return 0;
        }
        String[] vs = visible.split(",");
        int ret = 0;
        for (String v : vs) {
            ret |= mapVis.get(v).intValue();
        }
        return ret;
    }

    @Override
    public Map<String, Object> createColumn() {
        LinkedHashMap<String, Object> column = new LinkedHashMap<String, Object>();
        column.put("dataIndex", this.getKey().replace(".", "_"));
        column.put("header", this.getCaption());
        column.put("editor", this.createEditor());
        column.put("w", this.getWidth());
        if (this.isInvisible()) {
            column.put("vi", 0);
        } else {
            column.put("vi", this.getVisibleValue());
        }
        column.put("text-align", this.getTextAlign());
        column.put("fc", this.getForeColor());
        column.put("bc", this.getBackColor());
        column.put("fs", this.getFontSize());
        return column;
    }

    protected Map<String, Object> createEditor() {
        return new LinkedHashMap<String, Object>();
    }

    static {
        mapVis.put("new", 1);
        mapVis.put("edit", 2);
        mapVis.put("view", 4);
        mapVis.put(INIT, 8);
        mapVis.put("submit", 16);
        mapVis.put("audit", 32);
    }
}

