/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.dynplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dlock.DLock;
import kd.bos.entity.RuntimeMetaType;
import kd.bos.form.dynplugin.FormDynamicPluginDesignReader;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ServiceFactory;
import kd.bos.service.dynplugin.DynPlugin;
import kd.bos.service.dynplugin.DynamicPluginService;
import kd.bos.service.metadata.MetadataService;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class FormDynamicPluginReader {
    private static final Log log = LogFactory.getLog(FormDynamicPluginReader.class);
    private FormDynamicPluginDesignReader formDynamicPluginDesignReader = new FormDynamicPluginDesignReader();
    private DynamicPluginService dynamicPluginService = (DynamicPluginService)ServiceFactory.getService(DynamicPluginService.class);
    private MetadataService metadataService = (MetadataService)ServiceFactory.getService(MetadataService.class);
    private static final String TYPE_NAME = "FormDynamicPluginCache";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, List<DynPlugin>> getDynamicPluginMap(String formNumber, String interfacetype, String client) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"getDynamicPluginMap");){
            Map<String, List<DynPlugin>> firstReadDynamicPluginMap;
            if (span.isRealtime()) {
                span.addTag("formNumber", formNumber);
                span.addTag("interfacetype", interfacetype);
                span.addTag("client", client);
            }
            if ((firstReadDynamicPluginMap = this.getDynamicPluginMapByRuntimeMeta(formNumber, interfacetype, client)) != null) {
                if (span.isRealtime()) {
                    span.addLocaleTag("firstReadDynamicPluginMap", firstReadDynamicPluginMap);
                }
                Map<String, List<DynPlugin>> map = firstReadDynamicPluginMap;
                return map;
            }
            String key = FormDynamicPluginReader.getKey(formNumber, interfacetype, client);
            HashMap<String, List<DynPlugin>> dynamicPluginMap = new HashMap<String, List<DynPlugin>>(10);
            DLock lock = DLock.create((String)("FormDynamicPluginReader_getDynamicPlugin_" + RequestContext.get().getAccountId() + "_" + key)).fastMode();
            try {
                if (lock.tryLock()) {
                    Map<String, List<DynPlugin>> twoReadDynamicPluginMap = this.getDynamicPluginMapByRuntimeMeta(formNumber, interfacetype, client);
                    if (twoReadDynamicPluginMap != null) {
                        if (span.isRealtime()) {
                            span.addLocaleTag("twoReadDynamicPluginMap", twoReadDynamicPluginMap);
                        }
                        Map<String, List<DynPlugin>> map = twoReadDynamicPluginMap;
                        return map;
                    }
                    List<DynPlugin> dynamicPlugins = this.formDynamicPluginDesignReader.getDynamicPlugins(formNumber, interfacetype, "", client);
                    if (CollectionUtils.isEmpty(dynamicPlugins)) {
                        boolean b = this.dynamicPluginService.writeFormRuntimeMeta(formNumber, this.getKey(interfacetype, client), JSON.toJSONString((Object)new Object()));
                        if (span.isRealtime()) {
                            span.addTag("result", "{}");
                        }
                        HashMap<String, List<DynPlugin>> hashMap = new HashMap<String, List<DynPlugin>>(0);
                        return hashMap;
                    }
                    for (DynPlugin dynPlugin : dynamicPlugins) {
                        String eventmethod = dynPlugin.getEventmethod();
                        ArrayList<DynPlugin> dynPlugins = (ArrayList<DynPlugin>)dynamicPluginMap.get(eventmethod);
                        if (dynPlugins == null) {
                            dynPlugins = new ArrayList<DynPlugin>();
                            dynamicPluginMap.put(eventmethod, dynPlugins);
                        }
                        dynPlugins.add(dynPlugin);
                    }
                    if (span.isRealtime()) {
                        span.addLocaleTag("result", dynamicPluginMap);
                    }
                    boolean bl = this.dynamicPluginService.writeFormRuntimeMeta(formNumber, this.getKey(interfacetype, client), JSON.toJSONString(dynamicPluginMap));
                } else {
                    lock.lock();
                }
            }
            finally {
                lock.unlock();
            }
            HashMap<String, List<DynPlugin>> hashMap = dynamicPluginMap;
            return hashMap;
        }
    }

    private Map<String, List<DynPlugin>> getDynamicPluginMapByRuntimeMeta(String formNumber, String interfacetype, String client) {
        String dataJson = this.metadataService.loadFormRuntimeMeta(formNumber, RuntimeMetaType.DynPlugin.getValue(), this.getKey(interfacetype, client));
        if (StringUtils.isNotBlank((CharSequence)dataJson)) {
            if (dataJson.equals("{}")) {
                return new HashMap<String, List<DynPlugin>>(0);
            }
            return (Map)JSON.parseObject((String)dataJson, (TypeReference)new TypeReference<Map<String, List<DynPlugin>>>(){}, (Feature[])new Feature[0]);
        }
        return null;
    }

    public List<Map<String, String>> getClearCacheInfosByDynPluginIds(List<Object> dynPluginIds) {
        return this.dynamicPluginService.getClearCacheInfosByDynPluginIds(dynPluginIds);
    }

    public List<Map<String, String>> getClearCacheInfosByDynPluginBindIds(List<Object> dynPluginBindIds) {
        return this.dynamicPluginService.getClearCacheInfosByDynPluginBindIds(dynPluginBindIds);
    }

    public void clearCache(String formNumber, String interfacetype, String client) {
        this.dynamicPluginService.clearFormRuntimeMetaCache(formNumber, this.getKey(interfacetype, client));
    }

    private String getKey(String interfacetype, String client) {
        return interfacetype + "-" + client;
    }

    private static String getKey(String formNumber, String interfacetype, String client) {
        return formNumber + "-" + interfacetype + "-" + client;
    }
}

