/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.dynplugin;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.entity.plugin.Plugin;
import kd.bos.form.dynplugin.FormDynamicPluginCache;
import kd.bos.form.dynplugin.KingScriptFormDynamicProxyPluginFactory;
import kd.bos.service.dynplugin.DynPlugin;

public interface KingScriptFormDynamicProxyPlugin {
    public void register();

    public static class FormDynamicProxyPlugin
    implements KingScriptFormDynamicProxyPlugin {
        private List<Plugin> formPlugins;
        private String formId;
        private KingScriptFormDynamicProxyPluginFactory.PluginType pluginType;

        public FormDynamicProxyPlugin(List<Plugin> formPlugins, String formId, KingScriptFormDynamicProxyPluginFactory.PluginType pluginType) {
            this.formPlugins = formPlugins;
            this.formId = formId;
            this.pluginType = pluginType;
        }

        @Override
        public void register() {
            Map<Integer, String> classNames = this.loadTS();
            classNames.forEach(this::registerMixtureProxyPlugin);
        }

        private Map<Integer, String> loadTS() {
            String eventmethod;
            String interfacetype;
            List<DynPlugin> dynamicPlugins;
            String client = "1";
            if (this.pluginType.isMobile()) {
                client = "2";
                if (this.formId.endsWith("_mob")) {
                    this.formId = this.formId.substring(0, this.formId.lastIndexOf("_mob"));
                }
            }
            HashMap<Integer, String> result = new HashMap<Integer, String>((dynamicPlugins = FormDynamicPluginCache.getDynamicPlugins(this.formId, interfacetype = String.valueOf(this.pluginType.getType()), eventmethod = "ALL", client)) == null ? 0 : dynamicPlugins.size());
            if (dynamicPlugins != null && dynamicPlugins.size() > 0) {
                for (int i = 0; i < dynamicPlugins.size(); ++i) {
                    DynPlugin dynamicPlugin = dynamicPlugins.get(i);
                    result.put(i, dynamicPlugin.getClassName());
                }
            }
            return result;
        }

        private void registerMixtureProxyPlugin(int row, String className) {
            this.formPlugins.add(this.getFormProxyPlugin(row, className));
        }

        private Plugin getFormProxyPlugin(int row, String className) {
            Plugin plugin = new Plugin();
            plugin.setClassName(className);
            plugin.setEnabled(true);
            plugin.setType(4);
            plugin.setRowKey(row);
            return plugin;
        }
    }
}

