/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.field;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.BindingContext;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.inte.api.IInteService;
import kd.bos.inte.api.address.AddressCommitResult;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.util.HttpUtils;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class AddressEdit
extends BasedataEdit {
    private static final String ADDRESS_INFO_PAGE = "address_info_page";
    private static final String EDIT_ADDRESS_ID = "editAddressId";
    private static final String SOURCE_ENTITY_ID = "sourceEntityId";
    private static final String CTS_ADDRESS = "cts_address";
    private static final String COUNTRY_ID = "countryId";
    private static final String COUNTRY_ID_PRE = "countryId_";
    private static final String ADDR_CONFIG_ID = "addrConfigId";
    private static final String ADDR_CONFIG_ID_PRE = "addrConfigId_";
    private static final String EMPTY = " ";
    private static final Long COUNTRY_CN_ID = 1000001L;
    private static final Long PRESET_ADDR_CONFIG_ID = 1234851804710225920L;
    private static final String SET_ADDRESS = "setAddress";
    private static final String RESULT = "result";
    private static final String ID = "id";
    private static final String DETAIL = "detail";
    private static final String NAME = "name";
    private static final String CITY = "city";
    private static final String DISTRICT = "district";
    private static final String CONVERT_MAP_ADDRESS = "convertMapAddress";
    private static final String NUMBER = "number";
    private static final String SYSTEM_PRESET = "SYSTEM_PRESET";
    private static final String CTS_ADVANCE_ADDRESS = "cts_advance_address";
    private static final String MAP_CONFIG_ENTRY = "mapconfigentry";
    private static final String MAP_CONFIG_TYPE = "mapconfigtype";
    private static final String MAP_KEY = "mapkey";
    private static final String MAP_URL = "mapurl";
    private static final String UTF_8 = "UTF-8";
    private static final String ADMINDIVISION = "admindivision";
    private static final String FROM_FORM = "fromForm";
    private static final String ADDRESS_CONFIG_ID = "addressConfigId";
    private static final String COUNTRY = "country";
    private static final String ENABLE = "enable";
    private static final String EMPTY_CONFIG_ID = "0";
    private static final String MOB_ADDRESS_INFO_PAGE = "mob_address_info_page";
    private static final String BOS_FORM_METADATA = "bos-form-metadata";
    private String zoneField;

    @SimplePropertyAttribute
    public String getZoneField() {
        return this.zoneField;
    }

    public void setZoneField(String zoneField) {
        this.zoneField = zoneField;
    }

    @Override
    public void bindData(BindingContext bctx) {
        Object addressPkId = this.getPkId(this.getCurrentRowIndex());
        if (this.getZoneField() != null) {
            Map value = (Map)SerializationUtils.fromJsonString((String)this.getZoneField(), HashMap.class);
            value.forEach((k, v) -> {
                if (!"alias".equals(k)) {
                    IDataEntityProperty targetProperty1 = this.getModel().getProperty(k);
                    if (addressPkId != null) {
                        Set<Object> theZone = AddressEdit.getTheZone(Long.valueOf(v), Long.valueOf(addressPkId.toString()), new Date());
                        if (theZone != null && !theZone.isEmpty()) {
                            if (targetProperty1 instanceof BasedataProp) {
                                this.getModel().setValue(k, theZone.iterator().next());
                            }
                            if (targetProperty1 instanceof MulBasedataProp) {
                                this.getModel().setValue(k, (Object)theZone.toArray());
                            }
                        }
                    } else {
                        if (targetProperty1 instanceof BasedataProp) {
                            this.getModel().setValue(k, null);
                        }
                        if (targetProperty1 instanceof MulBasedataProp) {
                            this.getModel().setValue(k, null);
                        }
                    }
                }
            });
        }
        super.bindData(bctx);
    }

    private int getCurrentRowIndex() {
        int rowIndex = -1;
        if (this.isEntryProperty(this.getProperty())) {
            rowIndex = this.getModel().getEntryCurrentRowIndex(this.getProperty().getParent().getName());
        }
        return rowIndex;
    }

    @Override
    public void click() {
        String entityId;
        FormShowParameter showParameter = null;
        if (this.getView().getFormShowParameter() instanceof MobileBillShowParameter || this.getView().getFormShowParameter() instanceof MobileFormShowParameter) {
            showParameter = new MobileFormShowParameter();
            showParameter.setFormId(MOB_ADDRESS_INFO_PAGE);
            showParameter.getOpenStyle().setShowType(ShowType.Floating);
        } else {
            showParameter = new FormShowParameter();
            showParameter.setFormId(ADDRESS_INFO_PAGE);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
        }
        CloseCallBack closeCallBack = new CloseCallBack();
        String addrConfigId = this.getView().getPageCache().get(this.getAddrConfigIdCacheKey());
        String countryId = this.getView().getPageCache().get(this.getCountryIdCacheKey());
        if (!StringUtils.isBlank((CharSequence)addrConfigId) && !StringUtils.isBlank((CharSequence)countryId)) {
            showParameter.setCustomParam(COUNTRY_ID, countryId);
            showParameter.setCustomParam(ADDR_CONFIG_ID, addrConfigId);
        }
        if (!StringUtils.isBlank((CharSequence)(entityId = this.getView().getEntityId()))) {
            showParameter.setCustomParam(SOURCE_ENTITY_ID, entityId);
        } else {
            showParameter.setCustomParam(SOURCE_ENTITY_ID, EMPTY);
        }
        Object addressPkId = this.getPkId(this.getCurrentRowIndex());
        if (addressPkId != null) {
            showParameter.setCustomParam(EDIT_ADDRESS_ID, addressPkId);
        }
        closeCallBack.setControlKey(this.getKey());
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
        this.clearAddrConfigId();
    }

    public void setAddrConfigId(Long addrConfigId, Long countryId) {
        this.getView().getPageCache().put(this.getAddrConfigIdCacheKey(), Optional.ofNullable(addrConfigId).map(Objects::toString).orElse(EMPTY_CONFIG_ID));
        this.getView().getPageCache().put(this.getCountryIdCacheKey(), countryId.toString());
    }

    public void setAddrConfigId(Long countryId) {
        this.setAddrConfigId(null, countryId);
    }

    public void clearAddrConfigId() {
        this.getView().getPageCache().remove(this.getAddrConfigIdCacheKey());
        this.getView().getPageCache().remove(this.getCountryIdCacheKey());
    }

    private String getAddrConfigIdCacheKey() {
        return ADDR_CONFIG_ID_PRE + this.getFieldKey();
    }

    private String getCountryIdCacheKey() {
        return COUNTRY_ID_PRE + this.getFieldKey();
    }

    @Override
    public void setItemByNumber(String number, int rowKey) {
        super.setItemByNumber(null, rowKey);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        if (e.getReturnData() == null) {
            return;
        }
        IDataEntityProperty property = this.getProperty();
        IDataModel model = this.getModel();
        Long pkId = (Long)e.getReturnData();
        if (this.isEntryProperty(property)) {
            String entryKey = this.getEntryKey();
            if (entryKey != null) {
                int rowIndex = model.getEntryCurrentRowIndex(entryKey);
                DynamicObject rowDy = model.getEntryRowEntity(property.getParent().getName(), rowIndex);
                DynamicObjectType bdType = (DynamicObjectType)((BasedataProp)property).getComplexType((Object)rowDy);
                Map bdObjs = model.loadReferenceDataBatch(bdType, new Object[]{pkId});
                DynamicObject refDy = (DynamicObject)bdObjs.get(pkId);
                if (refDy != null) {
                    model.setValue(property.getName(), (Object)refDy, rowIndex);
                }
            }
        } else {
            String fieldKey = this.getFieldKey();
            model.setValue(fieldKey, (Object)pkId);
        }
    }

    public void getAddressSearchList(String keyword) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        list.addAll(this.getAddressBasedataSearchList(keyword));
        if (this.isEnabledMap()) {
            list.addAll(this.getMapSearchList(keyword));
        }
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        IDataEntityType parentType = this.getProperty().getParent();
        if (parentType instanceof EntryType) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("k", this.key);
            map.put("r", this.getModel().getEntryCurrentRowIndex(parentType.getName()));
            map.put("data", list);
            proxy.invokeControlMethod(this.getEntryGrid().getKey(), SET_ADDRESS, map);
        } else {
            proxy.invokeControlMethod(this.getKey(), SET_ADDRESS, list);
        }
    }

    private List<Map<String, Object>> getAddressBasedataSearchList(String keyword) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        DB.query((DBRoute)DBRoute.base, (String)"select top 5 fid,fname from t_cts_address where fenable = ? and fname like ? ", (Object[])new Object[]{"1", "%" + keyword + "%"}, rs -> {
            while (rs.next()) {
                HashMap<String, String> addressMap = new HashMap<String, String>();
                addressMap.put(ID, rs.getString("fid"));
                addressMap.put(DETAIL, rs.getString("fname"));
                result.add(addressMap);
            }
            return null;
        });
        return result;
    }

    private boolean isEnabledMap() {
        String selectProperties = "id,enablemap";
        QFilter advanceAddressQFilter = new QFilter(NUMBER, "=", (Object)SYSTEM_PRESET);
        DynamicObject advanceAddress = ORM.create().queryOne(CTS_ADVANCE_ADDRESS, selectProperties, advanceAddressQFilter.toArray());
        return advanceAddress != null && advanceAddress.getBoolean("enablemap") && AddressEdit.getDefaultChinaFormatId() != null;
    }

    private List<Map<String, Object>> getMapSearchList(String keyword) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        String url = this.getMapTipsUrl(keyword);
        if (StringUtils.isEmpty((CharSequence)url)) {
            return result;
        }
        try {
            List resultList;
            String queryResult = HttpUtils.request((String)url);
            ObjectMapper objectMapper = new ObjectMapper();
            Map queryResultMap = (Map)objectMapper.readValue(queryResult, Map.class);
            if (queryResultMap.containsKey(RESULT) && (resultList = (List)queryResultMap.get(RESULT)) != null && resultList.size() > 0) {
                Long formatId = (Long)AddressEdit.getDefaultChinaFormatId();
                for (Map item : resultList) {
                    Map<String, Object> address = AddressEdit.convertMapAddress(objectMapper.writeValueAsString((Object)item), formatId);
                    if (address == null || address.size() <= 0) continue;
                    address.put(ADDRESS_CONFIG_ID, formatId);
                    String id = objectMapper.writeValueAsString(address);
                    HashMap<String, String> addressMap = new HashMap<String, String>();
                    addressMap.put(ID, id);
                    addressMap.put(DETAIL, item.get(NAME) + EMPTY + item.get(CITY) + item.get(DISTRICT));
                    result.add(addressMap);
                }
            }
        }
        catch (IOException e) {
            result = new ArrayList();
        }
        return result;
    }

    private String getMapTipsUrl(String keyword) {
        String selectProperties = "id,mapconfigentry.id,mapconfigentry.mapkey,mapconfigentry.mapurl,mapconfigentry.mapconfigtype";
        QFilter advanceAddressQFilter = new QFilter(NUMBER, "=", (Object)SYSTEM_PRESET);
        ORM.create().queryOne(CTS_ADVANCE_ADDRESS, selectProperties, advanceAddressQFilter.toArray());
        DynamicObject advanceAddress = ORM.create().queryOne(CTS_ADVANCE_ADDRESS, selectProperties, advanceAddressQFilter.toArray());
        DynamicObject mapTipsConfig = null;
        for (DynamicObject dynamicObject : advanceAddress.getDynamicObjectCollection(MAP_CONFIG_ENTRY)) {
            if (!"2".equals(dynamicObject.getString(MAP_CONFIG_TYPE))) continue;
            mapTipsConfig = dynamicObject;
        }
        if (mapTipsConfig == null) {
            return null;
        }
        String mapTipsKey = mapTipsConfig.getString(MAP_KEY);
        String mapTipsUrl = mapTipsConfig.getString(MAP_URL);
        if (StringUtils.isBlank((CharSequence)mapTipsKey) || StringUtils.isBlank((CharSequence)mapTipsUrl)) {
            return null;
        }
        try {
            return String.format(mapTipsUrl + "?ak=" + mapTipsKey + "&query=%s&region=%s&city_limit=false&output=json", URLEncoder.encode(keyword, UTF_8), URLEncoder.encode(ResManager.loadKDString((String)"\u5168\u56fd", (String)"AddressEdit_1", (String)BOS_FORM_METADATA, (Object[])new Object[0]), UTF_8));
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static Map<String, Object> convertMapAddress(String map, Long formatId) {
        try {
            Class<?> clazz = Class.forName("kd.bos.address.util.AddressUtil");
            Method method = clazz.getDeclaredMethod(CONVERT_MAP_ADDRESS, String.class, Long.class, Long.class);
            AddressEdit.makeAccessible(method);
            return (Map)method.invoke(null, map, COUNTRY_CN_ID, formatId);
        }
        catch (Exception e) {
            return null;
        }
    }

    @SdkInternal
    public static void makeAccessible(Method method) {
        if (!(Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(method.getDeclaringClass().getModifiers()) || method.isAccessible())) {
            method.setAccessible(true);
        }
    }

    @Override
    public void setItemByIdFromClient(List<Object> args) {
        super.setItemByIdFromClient(args);
        String item = (String)args.get(0);
        if (item.startsWith("{")) {
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                Map map = (Map)objectMapper.readValue(item, Map.class);
                HashMap<String, Object> address = new HashMap<String, Object>();
                String fromForm = this.getView().getFormShowParameter().getFormId();
                address.put(FROM_FORM, fromForm);
                address.put(COUNTRY, COUNTRY_CN_ID);
                address.putAll(map);
                if (!address.containsKey(ADMINDIVISION) || !(address.get(ADMINDIVISION) instanceof String)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5730\u5740\u6570\u636e\u4e0e\u683c\u5f0f\u8981\u6c42\u4e0d\u7b26\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\u63a5\u53e3\u3001\u683c\u5f0f\u914d\u7f6e\uff0c\u6216\u5c1d\u8bd5\u9009\u62e9\u5176\u4ed6\u5730\u5740\u3002", (String)"AddressEdit_0", (String)BOS_FORM_METADATA, (Object[])new Object[0]));
                    this.getModel().setItemValueByID(this.getKey(), null);
                    return;
                }
                address.put(ADMINDIVISION, Long.valueOf((String)address.get(ADMINDIVISION)));
                AddressCommitResult result = ((IInteService)ServiceFactory.getService(IInteService.class)).commitAddressInfo(address);
                if (!result.getSuccess().booleanValue()) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5730\u5740\u6570\u636e\u4e0e\u683c\u5f0f\u8981\u6c42\u4e0d\u7b26\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\u63a5\u53e3\u3001\u683c\u5f0f\u914d\u7f6e\uff0c\u6216\u5c1d\u8bd5\u9009\u62e9\u5176\u4ed6\u5730\u5740\u3002", (String)"AddressEdit_0", (String)BOS_FORM_METADATA, (Object[])new Object[0]));
                }
                this.getModel().setItemValueByID(this.getKey(), (Object)result.getId());
            }
            catch (Exception e) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5730\u5740\u6570\u636e\u4e0e\u683c\u5f0f\u8981\u6c42\u4e0d\u7b26\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\u63a5\u53e3\u3001\u683c\u5f0f\u914d\u7f6e\uff0c\u6216\u5c1d\u8bd5\u9009\u62e9\u5176\u4ed6\u5730\u5740\u3002", (String)"AddressEdit_0", (String)BOS_FORM_METADATA, (Object[])new Object[0]));
                this.getModel().setItemValueByID(this.getKey(), null);
            }
        } else {
            super.setItemByIdFromClient(args);
        }
    }

    private static Object getDefaultChinaFormatId() {
        long countryId = 1000001L;
        String sql = "SELECT m.fid id FROM t_cts_addressconfig m LEFT JOIN t_cts_addrconfigcountry n ON m.fid = n.fid WHERE n.fbasedataid = ? and m.fisdefault = '1'";
        return DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[]{countryId}, rs -> {
            if (rs.next()) {
                return rs.getLong(ID);
            }
            return null;
        });
    }

    @SdkInternal
    public static Set<Object> getTheZone(Long zoneTypeId, Long addrId, Date date) {
        try {
            Class<?> clazz = Class.forName("kd.bos.i18n.mservice.I18nServiceHelper");
            Method method = clazz.getDeclaredMethod("getTheZone", Long.class, Long.class, Date.class);
            return (Set)method.invoke(null, zoneTypeId, addrId, date);
        }
        catch (Exception e) {
            return null;
        }
    }
}

