/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.field;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ORMUtil;
import kd.bos.form.BindingContext;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.field.FieldEdit;
import kd.bos.fulltext.common.util.PinYinUtil;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkPublic;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

@KSObject
@SdkPublic
public class AdminDivisionEdit
extends FieldEdit {
    private static final String BOS_FORM_METADATA = "bos-form-metadata";

    public void getCountrys() {
        List countrys = ORMUtil.getCountrys();
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "getCountrys", countrys);
    }

    @Override
    public Object getBindingValue(BindingContext bctx) {
        Object fieldValue = this.getFieldValue(bctx);
        if (fieldValue == null) {
            return null;
        }
        Map adminDivisionInfo = ORMUtil.getAdminDivisionInfo((String)String.valueOf(fieldValue));
        if (adminDivisionInfo == null || adminDivisionInfo.size() == 0) {
            return new Object[]{fieldValue};
        }
        Object[] value = new Object[]{fieldValue, adminDivisionInfo.get("countryName"), adminDivisionInfo.get("adminvisionAry")};
        return value;
    }

    public void getCountrysByFirstLetterForMobile() throws BadHanyuPinyinOutputFormatCombination {
        List allCountrys = ORMUtil.getCountrys();
        final Collator collator = Collator.getInstance(RequestContext.get().getLang().getLocale());
        allCountrys.sort(new Comparator<Map<String, String>>(){

            @Override
            public int compare(Map<String, String> o1, Map<String, String> o2) {
                return collator.compare(o1.get("name"), o2.get("name"));
            }
        });
        HashMap<String, List> countrys = new HashMap<String, List>();
        for (Map country : allCountrys) {
            String firstSpell = PinYinUtil.converterToFirstSpell((String)((String)country.get("name"))).toUpperCase();
            if (StringUtils.isBlank((CharSequence)firstSpell)) continue;
            char firstLetter = firstSpell.charAt(0);
            countrys.computeIfAbsent(String.valueOf(firstLetter), k -> new ArrayList()).add(country);
        }
        int firstLetter = 65;
        for (int i = 0; i < 26; ++i) {
            char curLetter = (char)(firstLetter + i);
            if (countrys.get(String.valueOf(curLetter)) != null) continue;
            countrys.put(String.valueOf(curLetter), null);
        }
        ArrayList countryList = new ArrayList(10);
        for (Map.Entry entry : countrys.entrySet()) {
            String FL = (String)entry.getKey();
            List CG = (List)entry.getValue();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("FL", FL);
            map.put("CG", CG);
            countryList.add(map);
        }
        ArrayList popularCountrys = new ArrayList();
        HashMap<String, String> popularCountry = new HashMap<String, String>();
        popularCountry.put("id", "1000001");
        popularCountry.put("name", ResManager.loadKDString((String)"\u4e2d\u56fd", (String)"AdminDivisionEdit_0", (String)BOS_FORM_METADATA, (Object[])new Object[0]));
        popularCountrys.add(popularCountry);
        HashMap<String, String> popularCountry1 = new HashMap<String, String>();
        popularCountry1.put("id", "1000002");
        popularCountry1.put("name", ResManager.loadKDString((String)"\u7f8e\u56fd", (String)"AdminDivisionEdit_1", (String)BOS_FORM_METADATA, (Object[])new Object[0]));
        popularCountrys.add(popularCountry1);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "getCountrysByFirstLetter", countryList, popularCountrys);
    }

    public void getAdmindivisionLevelsByCountryId(String countryId) {
        if (StringUtils.isBlank((CharSequence)countryId)) {
            return;
        }
        List admindivisionLevels = ORMUtil.getAdmindivisionLevelsByCountryId((String)countryId);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "getAdmindivisionLevels", admindivisionLevels);
    }

    public void getProvincesByCountryId(String countryId) {
        this.getProvincesByCountryId(countryId, null);
    }

    public void getProvincesByCountryId(String countryId, Integer rowNum) {
        if (StringUtils.isBlank((CharSequence)countryId)) {
            return;
        }
        List provinces = ORMUtil.getProvincesByCountryId((String)countryId);
        List admindivisionLevels = ORMUtil.getAdmindivisionLevelsByCountryId((String)countryId);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "getProvincesAndLevels", this.getWebParams(rowNum, provinces, admindivisionLevels));
    }

    public void getProincesByCountryIdForMobile(String countryId) {
        this.getProincesByCountryIdForMobile(countryId, null);
    }

    public void getProincesByCountryIdForMobile(String countryId, Integer rowNum) {
        if (StringUtils.isBlank((CharSequence)countryId)) {
            return;
        }
        List provinces = ORMUtil.getProvincesByCountryIdForMobile((String)countryId);
        List admindivisionLevels = ORMUtil.getAdmindivisionLevelsByCountryId((String)countryId);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "getProvincesAndLevelsForMobile", this.getWebParams(rowNum, provinces, admindivisionLevels));
    }

    public void getAdminDivisionsByParentId(String parentId) {
        this.getAdminDivisionsByParentId(parentId, null);
    }

    public void getAdminDivisionsByParentId(String parentId, Integer rowNum) {
        if (StringUtils.isBlank((CharSequence)parentId)) {
            return;
        }
        List adminDivisions = ORMUtil.getAdminDivisionsByParentId((String)parentId);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "getAdminDivisions", this.getWebParams(rowNum, adminDivisions));
    }

    @KSMethod
    public void setCountryId(String countryId) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "setCountryId", countryId);
    }

    public void getAdminDivisionInfo(List<String> admins) {
        this.getAdminDivisionInfo(admins, null);
    }

    public void getAdminDivisionInfo(List<String> admins, Integer rowNum) {
        if (admins == null || admins.size() == 0) {
            return;
        }
        this.getAdminDivisionInfo(String.valueOf(admins.get(0)), rowNum);
    }

    public void getAdminDivisionInfo(String adminId, Integer rowNum) {
        if (StringUtils.isBlank((CharSequence)adminId)) {
            return;
        }
        Map adminDivisionInfo = ORMUtil.getAdminDivisionInfo((String)adminId);
        if (rowNum != null) {
            adminDivisionInfo.put("r", rowNum);
        }
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "getAdminDivisionsFullName", adminDivisionInfo);
    }

    public void getAdminDivisionInfo(String adminId) {
        this.getAdminDivisionInfo(adminId, null);
    }

    private Object[] getWebParams(Integer rowNum, Object ... args) {
        ArrayList<Object> paramsList = new ArrayList<Object>(3);
        paramsList.addAll(Arrays.asList(args));
        if (rowNum != null) {
            paramsList.add(rowNum);
        }
        return paramsList.toArray();
    }
}

