/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.field;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.field.CityEditUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class CityCacheUtil {
    private static final Log logger = LogFactory.getLog(CityCacheUtil.class);
    private static final String ALL_CITY_LIST = "AllCityList";
    private static final int ONE_HOUR_SEC = 3600;
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final DistributeSessionlessCache redisCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("inte_region", new DistributeCacheHAPolicy());

    public static Map<String, Object> getCityGroupList(Integer type, char group, Integer count, Long lastCityId) {
        List<Object> curentPageCityList = new ArrayList();
        HashMap<String, Integer> extraMsgMap = new HashMap<String, Integer>();
        String key = type + "&" + group;
        List<Object> groupCityList = new ArrayList();
        String groupCityListStr = (String)redisCache.get(key);
        if (groupCityListStr == null) {
            groupCityList = CityEditUtil.getCityGroupList(type, group);
            try {
                redisCache.put("city", key, objectMapper.writeValueAsString(groupCityList), 3600);
            }
            catch (JsonProcessingException e) {
                logger.error((Throwable)e);
            }
        } else {
            try {
                groupCityList = (List)objectMapper.readValue(groupCityListStr, List.class);
            }
            catch (JsonProcessingException e) {
                logger.error((Throwable)e);
            }
        }
        if (lastCityId == -1L) {
            int remainCount = 0;
            if (groupCityList.size() > count) {
                curentPageCityList = groupCityList.subList(0, count);
                remainCount = groupCityList.size() - count;
            } else {
                curentPageCityList = groupCityList.subList(0, groupCityList.size());
            }
            extraMsgMap.put("remainCount", remainCount);
        } else {
            int lastCityIndex = -1;
            int hasLoadCount = -1;
            for (int i = 0; i < groupCityList.size(); ++i) {
                Map cityMap = (Map)groupCityList.get(i);
                if (!lastCityId.equals(Long.valueOf((String)cityMap.get("id")))) continue;
                hasLoadCount = i + 1;
                break;
            }
            if (hasLoadCount != -1) {
                int remainCount = 0;
                if (groupCityList.size() > hasLoadCount + count) {
                    curentPageCityList = groupCityList.subList(hasLoadCount, hasLoadCount + count);
                    remainCount = groupCityList.size() - hasLoadCount - count;
                } else {
                    curentPageCityList = groupCityList.subList(hasLoadCount, groupCityList.size());
                }
                extraMsgMap.put("remainCount", remainCount);
            } else {
                extraMsgMap.put("remainCount", 0);
            }
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("curentPageCityList", curentPageCityList);
        resultMap.put("extraMsgMap", extraMsgMap);
        return resultMap;
    }

    public static Map<String, Object> getAllCityListAndGroup() {
        HashMap<String, Object> result = new HashMap<String, DynamicObject[]>();
        String resultStr = (String)redisCache.get(ALL_CITY_LIST);
        if (resultStr == null) {
            DynamicObject[] allCityList = CityEditUtil.getAllCityList();
            result = new HashMap();
            result.put("allCityList", allCityList);
            try {
                redisCache.put("city", ALL_CITY_LIST, objectMapper.writeValueAsString(result), 3600);
            }
            catch (JsonProcessingException e) {
                logger.error((Throwable)e);
            }
        } else {
            try {
                result = (Map)objectMapper.readValue(resultStr, Map.class);
            }
            catch (JsonProcessingException e) {
                logger.error((Throwable)e);
            }
        }
        return result;
    }

    public static void clearCityCache() {
        redisCache.removeType("city");
    }
}

