/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.field;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.DBType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.field.CityORMUtil;
import kd.bos.form.field.CitySortUtil;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.WithEntityEntryDistinctable;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.session.SystemPropertyUtils;
import kd.sdk.annotation.SdkPublic;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

@SdkPublic
public class CityEditUtil {
    private static final Log logger = LogFactory.getLog(CityEditUtil.class);
    private static final String YES = "1";
    private static final String ENTITY_BD_ADMINDIVISION = "bd_admindivision";
    private static final String ENTITY_BD_COUNTRY = "bd_country";
    private static final String SELECT_FILED_ADMINDIVISION = "id,name,country,simplespell,fullspell,number,longnumber";
    private static final String ORDER_ASC_FILED = "id asc";
    private static final Long CHINA_COUNTRY_ID = 1000001L;
    private static final Long HONGKONG_ID = 1000003L;
    private static final Long MACAO_ID = 1000004L;
    private static final Long TAIWAN_ID = 1000005L;
    private static final String COUNTRY = "country";
    private static final String LONGNUMBER = "longnumber";
    private static final String PARENT = "parent";
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String ISCITY = "iscity";
    private static final String SIMPLESPELL = "simplespell";
    private static final String FULLSPELL = "fullspell";
    private static final String ENABLE = "enable";
    private static final String DOMESTIC = "domestic";
    private static final String FOREIGN = "foreign";
    private static final String ID = "id";
    private static HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
    private static ConcurrentHashMap<String, String> pinYinMapCache = new ConcurrentHashMap(16);

    public static List<Map<String, Object>> getAllCountrys() {
        ORM orm = ORM.create();
        DynamicObjectCollection dynamicObjects = orm.query(ENTITY_BD_COUNTRY, "id,name", null, ORDER_ASC_FILED);
        ArrayList<Map<String, Object>> countrys = new ArrayList<Map<String, Object>>();
        for (DynamicObject dynamicObject : dynamicObjects) {
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            map.put(ID, Long.parseLong(dynamicObject.get(ID).toString()));
            map.put(NAME, dynamicObject.get(NAME).toString());
            countrys.add(map);
        }
        return countrys;
    }

    public static List<Map<String, Object>> getCountrys(QFilter[] filters) {
        ORM orm = ORM.create();
        DynamicObjectCollection dynamicObjects = orm.query(ENTITY_BD_COUNTRY, "id,name", filters, ORDER_ASC_FILED);
        ArrayList<Map<String, Object>> countrys = new ArrayList<Map<String, Object>>();
        for (DynamicObject dynamicObject : dynamicObjects) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(ID, Long.parseLong(dynamicObject.get(ID).toString()));
            map.put(NAME, dynamicObject.get(NAME).toString());
            countrys.add(map);
        }
        return countrys;
    }

    public static DynamicObjectCollection getCityLists(QFilter[] filters) {
        ORM orm = ORM.create();
        DynamicObjectCollection dynamicObjects = orm.query(ENTITY_BD_ADMINDIVISION, "id,number,name,simplespell", filters, ORDER_ASC_FILED);
        return dynamicObjects;
    }

    public static void setCountryAndProvince(Object cityID, Object[] result) {
        QFilter countryFilter;
        DynamicObject[] countryArray;
        QFilter filter = new QFilter(ID, "=", cityID);
        DynamicObject[] entityArray = CityEditUtil.loadFromCache(ENTITY_BD_ADMINDIVISION, "id,country,longnumber,name", filter.toArray()).values().toArray(new DynamicObject[0]);
        if (entityArray == null || entityArray.length == 0) {
            result[3] = "";
            result[4] = "";
            return;
        }
        DynamicObject entity = entityArray[0];
        DynamicObject countryDy = (DynamicObject)entity.get(COUNTRY);
        String countryIdStr = "0";
        if (countryDy != null) {
            countryIdStr = countryDy.getPkValue().toString();
        }
        result[3] = !CityEditUtil.getDefaultCountryId().toString().equals(countryIdStr) ? ((countryArray = BusinessDataReader.loadFromCache((String)ENTITY_BD_COUNTRY, (QFilter[])(countryFilter = new QFilter(ID, "=", (Object)Long.valueOf(countryIdStr))).toArray()).values().toArray(new DynamicObject[0])) == null || countryArray.length == 0 ? "" : countryArray[0].getString(NAME)) : "";
        String longNumber = entity.getString(LONGNUMBER);
        String provinceNumber = null;
        if (longNumber.contains("!")) {
            provinceNumber = StringUtils.substringBefore((String)longNumber, (String)"!");
        } else if (longNumber.contains(".")) {
            provinceNumber = StringUtils.substringBefore((String)longNumber, (String)".");
        }
        if (StringUtils.isEmpty((CharSequence)provinceNumber)) {
            result[4] = "";
            return;
        }
        QFilter provinceFilter = new QFilter(NUMBER, "=", (Object)provinceNumber);
        DynamicObject[] provinceArray = CityEditUtil.loadFromCache(ENTITY_BD_ADMINDIVISION, "id,name", provinceFilter.toArray()).values().toArray(new DynamicObject[0]);
        String cityName = entity.getString(NAME);
        if (null == provinceArray || provinceArray.length == 0 || cityName.equals(provinceArray[0].getString(NAME))) {
            result[4] = "";
            return;
        }
        result[4] = provinceArray[0].getString(NAME);
    }

    public static Map<String, Object> requestCityList(Long countryId, boolean isIntl) {
        QFilter filter;
        ORM orm = ORM.create();
        DynamicObjectCollection dynamicObjects = orm.query(ENTITY_BD_ADMINDIVISION, SELECT_FILED_ADMINDIVISION, (filter = new QFilter(ISCITY, "=", (Object)YES)).toArray(), ORDER_ASC_FILED);
        if (dynamicObjects.size() == 0) {
            return Collections.emptyMap();
        }
        ArrayList<DynamicObject> currCityObjects = new ArrayList<DynamicObject>();
        ArrayList<Map<String, Object>> dCityArysCurHc = new ArrayList<Map<String, Object>>();
        ArrayList<DynamicObject> insCityObjects = new ArrayList<DynamicObject>();
        Map<String, String> provinceNumberMap = CityEditUtil.getProvinceAndCity(countryId, dynamicObjects, currCityObjects, insCityObjects);
        ArrayList<Map<String, Object>> otherCountryList = new ArrayList<Map<String, Object>>();
        Map<Long, Object> allCountryMap = CityEditUtil.getCountryMap(countryId, otherCountryList);
        List<Map<String, Object>> dataArysCur = CityEditUtil.buildCityGroupData(currCityObjects, allCountryMap, provinceNumberMap, Boolean.TRUE, dCityArysCurHc);
        HashMap<String, Object> mapCurCl = new HashMap<String, Object>();
        mapCurCl.put("cl", dataArysCur);
        mapCurCl.put("hc", dCityArysCurHc);
        List<Map<String, Object>> dataArysInsGroup = CityEditUtil.buildCityGroupData(insCityObjects, allCountryMap, provinceNumberMap, Boolean.FALSE, null);
        HashMap<String, List<Map<String, Object>>> mapInsCurr = new HashMap<String, List<Map<String, Object>>>();
        mapInsCurr.put("cl", dataArysInsGroup);
        mapInsCurr.put("hc", Collections.emptyList());
        HashMap<String, Object> mapIns = new HashMap<String, Object>();
        mapIns.put("il", otherCountryList);
        mapIns.put("curr", mapInsCurr);
        if (isIntl) {
            return mapIns;
        }
        return mapCurCl;
    }

    private static Map<String, String> getProvinceAndCity(Long countryId, DynamicObjectCollection dynamicObjects, List<DynamicObject> currCityObjects, List<DynamicObject> insCityObjects) {
        HashMap<String, String> provinceCityMap = new HashMap<String, String>();
        for (DynamicObject object : dynamicObjects) {
            Long country = object.getLong(COUNTRY);
            if (countryId.equals(country)) {
                currCityObjects.add(object);
            } else {
                insCityObjects.add(object);
            }
            String number = object.getString(NUMBER);
            String longNumber = object.getString(LONGNUMBER);
            if (StringUtils.isBlank((CharSequence)longNumber)) continue;
            String provinceNumber = "";
            if (longNumber.contains("!")) {
                provinceNumber = StringUtils.substringBefore((String)longNumber, (String)"!");
            } else if (longNumber.contains(".")) {
                provinceNumber = StringUtils.substringBefore((String)longNumber, (String)".");
            }
            if (!StringUtils.isNotEmpty((CharSequence)provinceNumber) || number.equals(provinceNumber)) continue;
            provinceCityMap.put(number, provinceNumber);
        }
        QFilter filter = new QFilter(NUMBER, "in", provinceCityMap.values());
        ORM orm = ORM.create();
        DynamicObjectCollection provinces = orm.query(ENTITY_BD_ADMINDIVISION, "id,number,name", filter.toArray());
        HashMap<String, String> map = new HashMap<String, String>();
        for (DynamicObject province : provinces) {
            String number = province.getString(NUMBER);
            String name = province.getString(NAME);
            map.put(number, name);
        }
        for (Map.Entry entry : provinceCityMap.entrySet()) {
            String provinceNumber = (String)entry.getValue();
            entry.setValue(map.get(provinceNumber));
        }
        return provinceCityMap;
    }

    private static Map<Long, Object> getCountryMap(Long countryId, List<Map<String, Object>> otherCountryList) {
        DynamicObject[] dynamicObjects = CityEditUtil.loadFromCache(ENTITY_BD_COUNTRY, String.join((CharSequence)",", ID, NAME), null).values().toArray(new DynamicObject[0]);
        HashMap<Long, Object> result = new HashMap<Long, Object>(16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            Long id = Long.parseLong(dynamicObject.get(ID).toString());
            String name = dynamicObject.get(NAME).toString();
            result.put(id, name);
            if (id.equals(countryId)) continue;
            HashMap<String, String> map = new HashMap<String, String>(16);
            map.put(ID, String.valueOf(id));
            map.put(NAME, name);
            otherCountryList.add(map);
        }
        return result;
    }

    private static List<Map<String, Object>> buildCityGroupData(List<DynamicObject> dynamicObjects, Map<Long, Object> allCountryMap, Map<String, String> provinceNumberMap, Boolean isCurrentCountry, List<Map<String, Object>> hotCities) {
        List<Long> hotCityIds = Arrays.asList(124L, 2676L, 383L, 407L, 2818L, 2216L, 2933L, 3534L);
        List<Long> noProvinceCityIds = Arrays.asList(124L, 2676L, 142L, 3135L);
        ArrayList<Map<String, Object>> cityGroups = new ArrayList<Map<String, Object>>(10);
        HashMap map = new HashMap();
        Long defaultCountryId = CityEditUtil.getDefaultCountryId();
        for (DynamicObject dynamicObject : dynamicObjects) {
            String province;
            String group;
            String simpleSpell = StringUtils.deleteWhitespace((String)dynamicObject.getString(SIMPLESPELL));
            if (StringUtils.isBlank((CharSequence)simpleSpell) || (group = CityEditUtil.getGroupStr(simpleSpell, dynamicObject.getString(NAME))) == null) continue;
            ArrayList cities = (ArrayList)map.get(group);
            if (CollectionUtils.isEmpty((Collection)cities)) {
                cities = new ArrayList();
                map.put(group, cities);
            }
            HashMap<String, String> cityDetail = new HashMap<String, String>();
            String cityId = dynamicObject.getString(ID);
            cityDetail.put(ID, cityId);
            cityDetail.put(NAME, dynamicObject.getString(NAME));
            cityDetail.put("jp", simpleSpell);
            cityDetail.put("qp", dynamicObject.getString(FULLSPELL));
            String number = dynamicObject.getString(NUMBER);
            String string = province = provinceNumberMap.get(number) == null ? "" : provinceNumberMap.get(number);
            if (noProvinceCityIds.contains(Long.valueOf(cityId))) {
                province = "";
            }
            cityDetail.put("p", province);
            String countryId = dynamicObject.getString(COUNTRY);
            cityDetail.put("ilid", countryId);
            Boolean needSetHotCity = isCurrentCountry != false && null != hotCities && defaultCountryId.toString().equals(countryId) && hotCityIds.contains(Long.valueOf(cityId));
            if (needSetHotCity.booleanValue()) {
                hotCities.add(cityDetail);
            }
            cities.add(cityDetail);
        }
        ArrayList groups = new ArrayList(map.keySet());
        Collections.sort(groups, String::compareTo);
        for (String group : groups) {
            List cities = (List)map.get(group);
            HashMap<String, Object> cityGroupMap = new HashMap<String, Object>();
            cityGroupMap.put("gr", group);
            Lang lang = RequestContext.get().getLang();
            if (lang.equals((Object)Lang.zh_CN) || lang.equals((Object)Lang.zh_TW)) {
                Collections.sort(cities, (o1, o2) -> {
                    String name1 = CityEditUtil.getPinYinStr((String)o1.get(NAME));
                    String name2 = CityEditUtil.getPinYinStr((String)o2.get(NAME));
                    return name1.compareTo(name2);
                });
            } else {
                Collections.sort(cities, (o1, o2) -> {
                    String name1 = (String)o1.get(NAME);
                    String name2 = (String)o2.get(NAME);
                    return name1.compareTo(name2);
                });
            }
            cityGroupMap.put("clg", cities);
            cityGroups.add(cityGroupMap);
        }
        return cityGroups;
    }

    private static String getPinYinStr(String input) {
        char[] arr;
        if (input == null || "".equals(input)) {
            return "";
        }
        String pinYin = pinYinMapCache.get(input);
        if (pinYin != null) {
            return pinYin;
        }
        StringBuilder sb = new StringBuilder();
        for (char c : arr = input.toCharArray()) {
            try {
                String[] temp = PinyinHelper.toHanyuPinyinStringArray((char)c, (HanyuPinyinOutputFormat)defaultFormat);
                if (temp.length > 0) {
                    sb.append(temp[0]);
                    continue;
                }
                sb.append(c);
            }
            catch (BadHanyuPinyinOutputFormatCombination badHanyuPinyinOutputFormatCombination) {
                logger.error("Catch BadHanyuPinyinOutputFormatCombination:", (Throwable)badHanyuPinyinOutputFormatCombination);
                sb.append(c);
            }
        }
        pinYinMapCache.put(input, sb.toString());
        return sb.toString();
    }

    private static String getGroupStr(String simpleSpell, String name) {
        Lang lang = RequestContext.get().getLang();
        if (lang.equals((Object)Lang.en_US) || lang.equals((Object)Lang.zh_CN) || lang.equals((Object)Lang.zh_TW)) {
            return CityEditUtil.getFirstAlphaFormStr(name, simpleSpell);
        }
        return Character.toString(simpleSpell.charAt(0)).toUpperCase();
    }

    private static String getFirstAlphaFormStr(String input, String simpleSpell) {
        if (input != null && input.toCharArray().length > 0) {
            char firstChar = input.charAt(0);
            if (CityEditUtil.isAlpha(firstChar)) {
                return Character.toString(firstChar).toUpperCase();
            }
            if (CityEditUtil.isHan(firstChar)) {
                HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
                defaultFormat.setVCharType(HanyuPinyinVCharType.WITH_V);
                defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
                defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
                try {
                    String[] temp = PinyinHelper.toHanyuPinyinStringArray((char)firstChar, (HanyuPinyinOutputFormat)defaultFormat);
                    if (temp.length > 1) {
                        return Character.toString(simpleSpell.charAt(0)).toUpperCase();
                    }
                    return temp[0].toUpperCase().substring(0, 1);
                }
                catch (Exception exception) {
                    return null;
                }
            }
            return String.valueOf(firstChar);
        }
        return null;
    }

    private static boolean isHan(char c) {
        return c >= '\u4e00' && c <= '\u9fa5';
    }

    private static boolean isAlpha(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private static List<Map<String, Object>> buildNativeHotCities() {
        ArrayList<Map<String, Object>> dCityArysCurHc = new ArrayList<Map<String, Object>>();
        Long[] ids = new Long[]{124L, 2676L, 383L, 407L, 2818L, 2216L, 2933L, 3534L};
        QFilter filter = new QFilter(ID, "in", Arrays.asList(ids));
        ORM orm = ORM.create();
        DynamicObjectCollection hotCities = orm.query(ENTITY_BD_ADMINDIVISION, SELECT_FILED_ADMINDIVISION, filter.toArray());
        for (DynamicObject city : hotCities) {
            HashMap<String, String> mapCurHc = new HashMap<String, String>();
            mapCurHc.put(ID, city.getString(ID));
            mapCurHc.put(NAME, city.getString(NAME));
            dCityArysCurHc.add(mapCurHc);
        }
        return dCityArysCurHc;
    }

    private static List<Map<String, Object>> buildInsHotCities(Long countryId) {
        QFilter filterIn = new QFilter(COUNTRY, "<>", (Object)countryId);
        filterIn.and(ISCITY, "=", (Object)YES);
        QFilter filterInHc = new QFilter(COUNTRY, "<>", (Object)countryId);
        filterInHc.and(filterIn);
        ArrayList<Long> inSpecial = new ArrayList<Long>();
        inSpecial.add(3958L);
        inSpecial.add(3975L);
        inSpecial.add(3633L);
        inSpecial.add(3783L);
        inSpecial.add(3980L);
        inSpecial.add(4310L);
        inSpecial.add(4150L);
        filterIn.and(ID, "in", inSpecial);
        filterInHc.and(ISCITY, "=", (Object)YES);
        ORM orm = ORM.create();
        DynamicObjectCollection dyInsHc = orm.query(ENTITY_BD_ADMINDIVISION, "id,name,country,simplespell", filterInHc.toArray(), ORDER_ASC_FILED);
        ArrayList<Map<String, Object>> dCityArysInsHc = new ArrayList<Map<String, Object>>();
        for (DynamicObject dyIn : dyInsHc) {
            HashMap<String, String> mapInsHc = new HashMap<String, String>();
            mapInsHc.put(ID, dyIn.get(ID).toString());
            mapInsHc.put(NAME, ((ILocaleString)dyIn.get(NAME)).getLocaleValue());
            mapInsHc.put("ilid", dyIn.get(COUNTRY).toString());
            dCityArysInsHc.add(mapInsHc);
        }
        return dCityArysInsHc;
    }

    public static List<List<String>> getCityGroup(DynamicObject[] dynamicObjects) {
        ArrayList chinaGroup = new ArrayList();
        ArrayList intlGroup = new ArrayList();
        ArrayList<List<String>> groupList = new ArrayList<List<String>>();
        groupList.add(chinaGroup);
        groupList.add(intlGroup);
        if (dynamicObjects.length == 0) {
            return groupList;
        }
        HashSet<String> chinaGroupSet = new HashSet<String>();
        HashSet<String> intlGroupSet = new HashSet<String>();
        Long defaultCountryId = CityEditUtil.getDefaultCountryId();
        for (DynamicObject dynamicObject : dynamicObjects) {
            DynamicObject countryDy;
            String group;
            String simpleSpell = StringUtils.deleteWhitespace((String)dynamicObject.getString(SIMPLESPELL));
            if (StringUtils.isBlank((CharSequence)simpleSpell) || (group = CityEditUtil.getGroupStr(simpleSpell, dynamicObject.getString(NAME))) == null || (countryDy = (DynamicObject)dynamicObject.get(COUNTRY)) == null) continue;
            Long countryId = (Long)countryDy.getPkValue();
            if (countryId.equals(defaultCountryId)) {
                chinaGroupSet.add(group);
                continue;
            }
            intlGroupSet.add(group);
        }
        chinaGroup.addAll(chinaGroupSet);
        intlGroup.addAll(intlGroupSet);
        Collections.sort(chinaGroup, String::compareTo);
        Collections.sort(intlGroup, String::compareTo);
        return groupList;
    }

    public static List<Map<String, Object>> getCityGroupList(Integer type, char group) {
        ArrayList<Map<String, Object>> cityList = new ArrayList<Map<String, Object>>();
        if (' ' == group) {
            return cityList;
        }
        QFilter filter = new QFilter(ISCITY, "=", (Object)YES);
        QFilter enableFilter = new QFilter(ENABLE, "=", (Object)YES);
        QFilter countryFilter = null;
        countryFilter = type == 0 ? new QFilter(COUNTRY, "=", (Object)CityEditUtil.getDefaultCountryId()) : new QFilter(COUNTRY, "!=", (Object)CityEditUtil.getDefaultCountryId());
        DynamicObject[] dynamicObjects = CityEditUtil.loadFromCache(ENTITY_BD_ADMINDIVISION, String.join((CharSequence)",", ID, NUMBER, NAME, SIMPLESPELL, FULLSPELL, COUNTRY, PARENT), new QFilter[]{filter, countryFilter, enableFilter}).values().toArray(new DynamicObject[0]);
        Map<String, String> chinaProvinceCityMap = CityEditUtil.getChinaProvinceAndCity();
        for (DynamicObject dynamicObject : dynamicObjects) {
            DynamicObject countryDy;
            String cityGroup;
            String simpleSpell = StringUtils.deleteWhitespace((String)dynamicObject.getString(SIMPLESPELL));
            if (StringUtils.isBlank((CharSequence)simpleSpell) || (cityGroup = CityEditUtil.getGroupStr(simpleSpell, dynamicObject.getString(NAME))) == null || (countryDy = (DynamicObject)dynamicObject.get(COUNTRY)) == null || !String.valueOf(group).equalsIgnoreCase(cityGroup)) continue;
            Long countryId = (Long)countryDy.getPkValue();
            HashMap<String, String> cityMap = new HashMap<String, String>();
            String cityId = dynamicObject.getString(ID);
            cityMap.put(ID, cityId);
            cityMap.put(NAME, dynamicObject.getString(NAME));
            cityMap.put("jp", simpleSpell);
            cityMap.put("qp", dynamicObject.getString(FULLSPELL));
            if (type == 0) {
                String province = chinaProvinceCityMap.get(dynamicObject.getString(NUMBER));
                cityMap.put("p", province != null ? province : "");
            } else {
                DynamicObject parent = (DynamicObject)dynamicObject.get(PARENT);
                cityMap.put("p", parent == null ? "" : parent.getString(NAME));
            }
            cityMap.put("c", countryDy.getString(NAME));
            cityMap.put("ilid", countryId.toString());
            cityList.add(cityMap);
        }
        Lang lang = RequestContext.get().getLang();
        if (lang.equals((Object)Lang.zh_CN) || lang.equals((Object)Lang.zh_TW)) {
            Collections.sort(cityList, (o1, o2) -> {
                String name1 = CityEditUtil.getPinYinStr((String)o1.get(NAME));
                String name2 = CityEditUtil.getPinYinStr((String)o2.get(NAME));
                return name1.compareTo(name2);
            });
        } else {
            Collections.sort(cityList, (o1, o2) -> {
                String name1 = (String)o1.get(NAME);
                String name2 = (String)o2.get(NAME);
                return name1.compareTo(name2);
            });
        }
        return cityList;
    }

    private static QFilter[] getSearchFilterListByType(Integer type, String keyWord) {
        QFilter filter = new QFilter(ISCITY, "=", (Object)YES);
        QFilter enableFilter = new QFilter(ENABLE, "=", (Object)YES);
        QFilter countryFilter = null;
        if (type == 0) {
            countryFilter = new QFilter(COUNTRY, "=", (Object)CityEditUtil.getDefaultCountryId());
        } else if (type == 1) {
            countryFilter = new QFilter(COUNTRY, "!=", (Object)CityEditUtil.getDefaultCountryId());
        }
        QFilter simpleSpellLikeFilter = new QFilter(SIMPLESPELL, CityEditUtil.getLike(), (Object)("%" + keyWord + "%"));
        QFilter fullSpellLikeFilter = new QFilter(FULLSPELL, CityEditUtil.getLike(), (Object)("%" + keyWord + "%"));
        QFilter nameLikeFilter = new QFilter(NAME, CityEditUtil.getLike(), (Object)("%" + keyWord + "%"));
        QFilter propLikeFilter = simpleSpellLikeFilter.or(fullSpellLikeFilter).or(nameLikeFilter);
        return new QFilter[]{filter, countryFilter, enableFilter, propLikeFilter};
    }

    private static String getLike() {
        String cp = "like";
        String tenantId = RequestContext.get().getTenantId();
        if (DB.getDBType((DBRoute)DBRoute.meta) == DBType.PostgreSQL && "TRUE".equalsIgnoreCase(SystemPropertyUtils.getProptyByTenant((String)"orm.opt.pg.ignorecase", (String)tenantId))) {
            cp = "ilike";
        }
        return cp;
    }

    public static List<Map<String, Object>> getCitySearchList(Integer type, String keyword) {
        List<Map<String, Object>> searchCityList = new ArrayList<Map<String, Object>>(10);
        QFilter[] qFilters = CityEditUtil.getSearchFilterListByType(type, keyword);
        DynamicObject[] dynamicObjects = CityEditUtil.loadFromCache(ENTITY_BD_ADMINDIVISION, String.join((CharSequence)",", COUNTRY, ID, NAME, SIMPLESPELL, FULLSPELL, NUMBER, PARENT), qFilters).values().toArray(new DynamicObject[0]);
        if (dynamicObjects.length == 0) {
            return searchCityList;
        }
        Map<Object, Object> chinaProvinceCityMap = new HashMap();
        if (type == 0 || type == 2) {
            chinaProvinceCityMap = CityEditUtil.getChinaProvinceAndCity();
        }
        for (DynamicObject dy : dynamicObjects) {
            DynamicObject countryDy = (DynamicObject)dy.get(COUNTRY);
            if (countryDy == null) continue;
            Long countryId = (Long)countryDy.getPkValue();
            HashMap<String, Object> cityMap = new HashMap<String, Object>(16);
            cityMap.put(ID, dy.getString(ID));
            String name = dy.getString(NAME);
            String simpleSpell = StringUtils.deleteWhitespace((String)dy.getString(SIMPLESPELL));
            cityMap.put(NAME, name);
            cityMap.put("jp", simpleSpell);
            cityMap.put("qp", dy.getString(FULLSPELL));
            if (Objects.equals(countryId, CityEditUtil.getDefaultCountryId())) {
                String province = (String)chinaProvinceCityMap.get(dy.getString(NUMBER));
                cityMap.put("p", province != null ? province : "");
                Map<String, Object> highLightMap = CityEditUtil.getHighLightText(name, keyword, simpleSpell);
                cityMap.put("highlightText", highLightMap.get("highlightText") != null ? highLightMap.get("highlightText") : "");
                cityMap.put("highlightIndex", highLightMap.get("highlightIndex") != null ? Integer.parseInt(String.valueOf(highLightMap.get("highlightIndex"))) : Integer.MAX_VALUE);
            } else {
                DynamicObject parent = (DynamicObject)dy.get(PARENT);
                cityMap.put("p", parent == null ? "" : parent.getString(NAME));
            }
            cityMap.put("c", countryDy.getString(NAME));
            cityMap.put("ilid", countryId.toString());
            searchCityList.add(cityMap);
        }
        searchCityList = CityEditUtil.sortSearchCityList(searchCityList, keyword);
        searchCityList.forEach(city -> city.remove("highlightIndex"));
        if (searchCityList.size() > 500) {
            return searchCityList.subList(0, 500);
        }
        return searchCityList;
    }

    private static List<Map<String, Object>> sortSearchCityList(List<Map<String, Object>> searchCityList, String keyword) {
        if (searchCityList == null || searchCityList.size() == 0) {
            return new ArrayList<Map<String, Object>>();
        }
        return CitySortUtil.sortCityList(searchCityList, keyword);
    }

    private static List<Map<String, Object>> getIntnList() {
        ArrayList<Map<String, Object>> otherCountryList = new ArrayList<Map<String, Object>>();
        CityEditUtil.getCountryMap(CityEditUtil.getDefaultCountryId(), otherCountryList);
        return otherCountryList;
    }

    public static Map<String, List<Map<String, Object>>> getCommonCity(DynamicObject[] dynamicObjects, Map<String, String> chinaProvinceCityMap) {
        List<Long> hotCityIds = Arrays.asList(124L, 2676L, 383L, 407L, 2818L, 2216L, 2933L, 3534L);
        List<Long> noProvinceCityIds = Arrays.asList(124L, 2676L, 142L, 3135L);
        ArrayList domesticCommonCityList = new ArrayList(10);
        ArrayList foreignCommonCityList = new ArrayList(10);
        HashMap<String, List<Map<String, Object>>> commonCityMap = new HashMap<String, List<Map<String, Object>>>();
        commonCityMap.put(DOMESTIC, domesticCommonCityList);
        commonCityMap.put(FOREIGN, foreignCommonCityList);
        Long defaultCountryId = CityEditUtil.getDefaultCountryId();
        for (DynamicObject dynamicObject : dynamicObjects) {
            String simpleSpell;
            if (dynamicObject.get(COUNTRY) == null) continue;
            Long countryId = (Long)((DynamicObject)dynamicObject.get(COUNTRY)).getPkValue();
            Long cityId = dynamicObject.getLong(ID);
            if (countryId == null || !countryId.equals(defaultCountryId) || !hotCityIds.contains(cityId) || StringUtils.isBlank((CharSequence)(simpleSpell = StringUtils.deleteWhitespace((String)dynamicObject.getString(SIMPLESPELL))))) continue;
            HashMap<String, Object> cityDetail = new HashMap<String, Object>();
            cityDetail.put(ID, cityId);
            cityDetail.put(NAME, dynamicObject.getString(NAME));
            cityDetail.put("jp", simpleSpell);
            cityDetail.put("qp", dynamicObject.getString(FULLSPELL));
            String province = chinaProvinceCityMap.get(dynamicObject.getString(NUMBER));
            if (noProvinceCityIds.contains(cityId)) {
                province = "";
            }
            cityDetail.put("p", province);
            cityDetail.put("ilid", countryId.toString());
            domesticCommonCityList.add(cityDetail);
        }
        return commonCityMap;
    }

    private static Map<String, String> getChinaProvinceAndCity() {
        QFilter filter = new QFilter(ISCITY, "=", (Object)YES).and(ENABLE, "=", (Object)YES);
        QFilter countryFilter = new QFilter(COUNTRY, "=", (Object)CityEditUtil.getDefaultCountryId());
        DynamicObject[] dynamicObjects = CityEditUtil.loadFromCache(ENTITY_BD_ADMINDIVISION, String.join((CharSequence)",", NUMBER, LONGNUMBER), new QFilter[]{filter, countryFilter}).values().toArray(new DynamicObject[0]);
        HashMap<String, String> provinceCityMap = new HashMap<String, String>();
        for (DynamicObject object : dynamicObjects) {
            String string = object.getString(NUMBER);
            String longNumber = object.getString(LONGNUMBER);
            if (StringUtils.isBlank((CharSequence)longNumber)) continue;
            String provinceNumber = "";
            if (longNumber.contains("!")) {
                provinceNumber = StringUtils.substringBefore((String)longNumber, (String)"!");
            } else if (longNumber.contains(".")) {
                provinceNumber = StringUtils.substringBefore((String)longNumber, (String)".");
            }
            if (!StringUtils.isNotEmpty((CharSequence)provinceNumber) || string.equals(provinceNumber)) continue;
            provinceCityMap.put(string, provinceNumber);
        }
        QFilter provincesFilter = new QFilter(NUMBER, "in", provinceCityMap.values());
        DynamicObject[] provinces = CityEditUtil.loadFromCache(ENTITY_BD_ADMINDIVISION, String.join((CharSequence)",", NUMBER, NAME), provincesFilter.toArray()).values().toArray(new DynamicObject[0]);
        HashMap<String, String> map = new HashMap<String, String>(16);
        for (DynamicObject province : provinces) {
            String number = province.getString(NUMBER);
            String name = province.getString(NAME);
            map.put(number, name);
        }
        for (Map.Entry entry : provinceCityMap.entrySet()) {
            String provinceNumber = (String)entry.getValue();
            entry.setValue(map.get(provinceNumber));
        }
        return provinceCityMap;
    }

    public static List<Map<String, Object>> getCityByIds(List<Long> idList, Map<String, String> chinaProvinceCityMap) {
        return CityEditUtil.getCityByIds(0, idList, chinaProvinceCityMap);
    }

    public static List<Map<String, Object>> getCityByIds(Integer type, List<Long> idList, Map<String, String> chinaProvinceCityMap) {
        DynamicObject[] dynamicObjects;
        ArrayList<Map<String, Object>> cityList = new ArrayList<Map<String, Object>>(10);
        QFilter filter = new QFilter(ISCITY, "=", (Object)YES).and(ENABLE, "=", (Object)YES);
        QFilter idsfilter = new QFilter(ID, "in", idList);
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataReader.loadFromCache((String)ENTITY_BD_ADMINDIVISION, (QFilter[])new QFilter[]{filter, idsfilter}).values().toArray(new DynamicObject[0])) {
            DynamicObject countryDy = (DynamicObject)dynamicObject.get(COUNTRY);
            if (countryDy == null) continue;
            String cityId = dynamicObject.getString(ID);
            String simpleSpell = StringUtils.deleteWhitespace((String)dynamicObject.getString(SIMPLESPELL));
            Long countryId = (Long)countryDy.getPkValue();
            HashMap<String, String> cityMap = new HashMap<String, String>(16);
            cityMap.put(ID, cityId);
            cityMap.put(NAME, dynamicObject.getString(NAME));
            cityMap.put("jp", simpleSpell);
            cityMap.put("qp", dynamicObject.getString(FULLSPELL));
            if (Objects.equals(countryId, CityEditUtil.getDefaultCountryId())) {
                String province = chinaProvinceCityMap.get(dynamicObject.getString(NUMBER));
                cityMap.put("p", province != null ? province : "");
            } else {
                DynamicObject parent = (DynamicObject)dynamicObject.get(PARENT);
                cityMap.put("p", parent == null ? "" : parent.getString(NAME));
            }
            cityMap.put("c", countryDy.getString(NAME));
            cityMap.put("ilid", countryId.toString());
            cityList.add(cityMap);
        }
        return cityList;
    }

    public static DynamicObject[] getAllCityList() {
        QFilter filter = new QFilter(ISCITY, "=", (Object)YES);
        QFilter enableFilter = new QFilter(ENABLE, "=", (Object)YES);
        return CityEditUtil.loadFromCache(ENTITY_BD_ADMINDIVISION, String.join((CharSequence)",", NAME, NUMBER, COUNTRY, ID, SIMPLESPELL, FULLSPELL), new QFilter[]{filter, enableFilter}).values().toArray(new DynamicObject[0]);
    }

    public static Map<String, Object> getCityInfo(List<Long> commonDomesticCityList) {
        return CityEditUtil.getCityInfo(commonDomesticCityList, new ArrayList<Long>(16));
    }

    public static Map<String, Object> getCityInfo(List<Long> commonDomesticCityList, List<Long> commonForeignCityList) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("type", CityEditUtil.isChineseEnvironment() ? 0 : 1);
        Map<String, Object> commonCityMap = CityEditUtil.getCommonCity(commonDomesticCityList, null);
        resultMap.put("common", commonCityMap.get(DOMESTIC) == null ? "" : commonCityMap.get(DOMESTIC));
        return resultMap;
    }

    private static Map<String, Object> getCommonCity(List<Long> commonDomesticCityList, DynamicObject[] dynamicObjects) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Map<String, String> provinceCityMap = CityEditUtil.getChinaProvinceAndCity();
        List<Map<String, Object>> domestic = CityEditUtil.getCityByIds(commonDomesticCityList, provinceCityMap);
        if (domestic != null && domestic.size() > 0) {
            resultMap.put(DOMESTIC, domestic);
        }
        return resultMap;
    }

    public static Map<Object, DynamicObject> loadFromCache(String entityName, String selectProperties, QFilter[] filters) {
        DynamicObjectType type = CityEditUtil.getSubEntityType(entityName, selectProperties);
        ArrayList idList = new ArrayList();
        DataEntityCacheManager cacheManager = new DataEntityCacheManager((IDataEntityType)type);
        Object[] pks = cacheManager.getCachePks(filters);
        if (pks == null) {
            try (DataSet ds = ORM.create().queryDataSet("BusinessDataServiceHelper.LoadFromCache", entityName, ID, filters, null, -1, (Distinctable)WithEntityEntryDistinctable.get());){
                ds.forEach(row -> idList.add(row.get(0)));
            }
            pks = idList.toArray();
            cacheManager.putCachePks(filters, pks);
        }
        return BusinessDataReader.loadFromCache((Object[])pks, (DynamicObjectType)type);
    }

    private static DynamicObjectType getSubEntityType(String entityName, String selectProperties) {
        String[] properties = selectProperties.split(",");
        HashSet<String> select = new HashSet<String>(properties.length);
        for (String prop : properties) {
            select.add(prop.trim());
        }
        return EntityMetadataCache.getSubDataEntityType((String)entityName, select);
    }

    private static Long getDefaultCountryId() {
        Object defaultcountry = CityEditUtil.callStaticMethod("kd.bos.servicehelper.parameter.SystemParamServiceHelper", "loadPublicParameterFromCache", new Object[]{"defaultcountry"}, String.class);
        if (defaultcountry != null) {
            Map defaultCountryMap = (Map)defaultcountry;
            return Long.valueOf(defaultCountryMap.get(ID).toString());
        }
        return CHINA_COUNTRY_ID;
    }

    public static Object callStaticMethod(String className, String methodName, Object[] param, Class<?> ... parameterTypes) {
        try {
            Class<?> clazz = Class.forName(className);
            Method method = clazz.getDeclaredMethod(methodName, parameterTypes);
            return method.invoke(null, param);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u9ed8\u8ba4\u56fd\u5bb6\u6216\u5730\u533a\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    private static boolean isChineseEnvironment() {
        Lang lang = RequestContext.get().getLang();
        long userId = RequestContext.get().getCurrUserId();
        DynamicObject dynamicObject = CityORMUtil.getUserCountry(userId);
        if (dynamicObject != null) {
            Long countryId = dynamicObject.getLong(COUNTRY);
            return !(!lang.equals((Object)Lang.zh_CN) && !lang.equals((Object)Lang.zh_TW) || countryId != 0L && !countryId.equals(CityEditUtil.getDefaultCountryId()) && !countryId.equals(HONGKONG_ID) && !countryId.equals(MACAO_ID) && !countryId.equals(TAIWAN_ID));
        }
        return true;
    }

    private static Map<String, Object> getHighLightText(String name, String keyword, String simpleSpell) {
        char[] chars;
        HashMap<String, Object> map = new HashMap<String, Object>();
        keyword = keyword.toLowerCase(Locale.ENGLISH);
        simpleSpell = simpleSpell.toLowerCase();
        if (keyword.trim().equals("") || name.contains(keyword)) {
            return map;
        }
        if (simpleSpell.contains(keyword)) {
            int index = simpleSpell.indexOf(keyword);
            if (name.length() >= keyword.length() + index) {
                map.put("highlightIndex", index);
                map.put("highlightText", name.substring(index, keyword.length() + index));
                return map;
            }
        }
        ArrayList<String> list = new ArrayList<String>(16);
        HashMap<String, Character> hashMap = new HashMap<String, Character>(16);
        for (char c : chars = name.toCharArray()) {
            try {
                String[] pinYinArr;
                for (String s : pinYinArr = PinyinHelper.toHanyuPinyinStringArray((char)c, (HanyuPinyinOutputFormat)defaultFormat)) {
                    if (!list.contains(s)) {
                        list.add(s);
                    }
                    if (hashMap.containsKey(s)) continue;
                    hashMap.put(s, Character.valueOf(c));
                }
            }
            catch (BadHanyuPinyinOutputFormatCombination e) {
                logger.error("getHighLightText failed:", (Throwable)e);
            }
        }
        List finalList = new ArrayList(16);
        block4: for (int i = 0; i < list.size(); ++i) {
            for (int j = i + 1; j <= list.size(); ++j) {
                List subList = list.subList(i, j);
                String subStr = String.join((CharSequence)"", subList);
                if (!subStr.startsWith(keyword)) continue;
                finalList = subList;
                map.put("highlightIndex", i);
                break block4;
            }
        }
        StringBuilder builder = new StringBuilder();
        finalList.forEach(str -> builder.append(hashMap.get(str)));
        map.put("highlightText", builder.toString());
        return map;
    }

    static {
        defaultFormat.setVCharType(HanyuPinyinVCharType.WITH_V);
        defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
    }
}

