/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.field;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

public class CityORMUtil {
    private static final Log logger = LogFactory.getLog(CityORMUtil.class);
    private static final String YES = "1";
    private static final String ENTITY_BD_ADMINDIVISION = "bd_admindivision";
    private static final String ENTITY_BD_COUNTRY = "bd_country";
    private static final String SELECT_FILED_ADMINDIVISION = "id,name,country,simplespell,fullspell,number,longnumber";
    private static final String ORDER_ASC_FILED = "id asc";
    private static final String ID_NAME = "id,name";
    private static final String NUMBER_1000001 = "1000001";
    private static final String COUNTRY = "country";
    private static final String NUMBER = "number";
    private static final String IS_CITY = "iscity";
    private static HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();

    public static List<Map<String, Object>> getAllCountrys() {
        ORM orm = ORM.create();
        DynamicObjectCollection dynamicObjects = orm.query(ENTITY_BD_COUNTRY, ID_NAME, null, ORDER_ASC_FILED);
        ArrayList<Map<String, Object>> countrys = new ArrayList<Map<String, Object>>();
        for (DynamicObject dynamicObject : dynamicObjects) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", Long.parseLong(dynamicObject.get("id").toString()));
            map.put("name", dynamicObject.get("name").toString());
            countrys.add(map);
        }
        return countrys;
    }

    public static List<Map<String, Object>> getCountrys(QFilter[] filters) {
        ORM orm = ORM.create();
        DynamicObjectCollection dynamicObjects = orm.query(ENTITY_BD_COUNTRY, ID_NAME, filters, ORDER_ASC_FILED);
        ArrayList<Map<String, Object>> countrys = new ArrayList<Map<String, Object>>();
        for (DynamicObject dynamicObject : dynamicObjects) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", Long.parseLong(dynamicObject.get("id").toString()));
            map.put("name", dynamicObject.get("name").toString());
            countrys.add(map);
        }
        return countrys;
    }

    public static DynamicObjectCollection getCityLists(QFilter[] filters) {
        ORM orm = ORM.create();
        DynamicObjectCollection dynamicObjects = orm.query(ENTITY_BD_ADMINDIVISION, "id,number,name,simplespell", filters, ORDER_ASC_FILED);
        return dynamicObjects;
    }

    public static DynamicObject getUserCountry(Long userId) {
        ORM orm = ORM.create();
        QFilter[] qFilters = new QFilter("id", "=", (Object)userId).toArray();
        return orm.queryOne("bos_user", "id,country", qFilters);
    }

    public static void setCountryAndProvince(Object cityID, Object[] result) {
        QFilter countryFilter;
        DynamicObject country;
        QFilter filter;
        ORM orm = ORM.create();
        DynamicObject entity = orm.queryOne(ENTITY_BD_ADMINDIVISION, SELECT_FILED_ADMINDIVISION, (filter = new QFilter("id", "=", cityID)).toArray());
        if (entity == null) {
            result[3] = "";
            result[4] = "";
            return;
        }
        result[3] = !NUMBER_1000001.equals(entity.getString(COUNTRY)) ? ((country = orm.queryOne(ENTITY_BD_COUNTRY, "id, name", (countryFilter = new QFilter("id", "=", entity.get(COUNTRY))).toArray())) == null ? "" : country.getString("name")) : "";
        String longNumber = entity.getString("longnumber");
        String provinceNumber = null;
        if (longNumber.contains("!")) {
            provinceNumber = StringUtils.substringBefore((String)longNumber, (String)"!");
        } else if (longNumber.contains(".")) {
            provinceNumber = StringUtils.substringBefore((String)longNumber, (String)".");
        }
        if (StringUtils.isEmpty((CharSequence)provinceNumber)) {
            result[4] = "";
            return;
        }
        QFilter provinceFilter = new QFilter(NUMBER, "=", (Object)provinceNumber);
        DynamicObject province = orm.queryOne(ENTITY_BD_ADMINDIVISION, SELECT_FILED_ADMINDIVISION, provinceFilter.toArray());
        String cityName = entity.getString("name");
        if (null == province || cityName.equals(province.getString("name"))) {
            result[4] = "";
            return;
        }
        result[4] = province.getString("name");
    }

    public static Map<String, Object> requestCityList(Long countryId) {
        ORM orm = ORM.create();
        QFilter filter = new QFilter(IS_CITY, "=", (Object)YES);
        QFilter enableFilter = new QFilter("enable", "=", (Object)YES);
        DynamicObjectCollection dynamicObjects = orm.query(ENTITY_BD_ADMINDIVISION, SELECT_FILED_ADMINDIVISION, new QFilter[]{filter, enableFilter}, ORDER_ASC_FILED);
        if (dynamicObjects.size() == 0) {
            return Collections.emptyMap();
        }
        ArrayList<DynamicObject> currCityObjects = new ArrayList<DynamicObject>();
        ArrayList<Map<String, Object>> dCityArysCurHc = new ArrayList<Map<String, Object>>();
        ArrayList<DynamicObject> insCityObjects = new ArrayList<DynamicObject>();
        Map<String, String> provinceNumberMap = CityORMUtil.getProvinceAndCity(countryId, dynamicObjects, currCityObjects, insCityObjects);
        ArrayList<Map<String, Object>> otherCountryList = new ArrayList<Map<String, Object>>();
        Map<Long, Object> allCountryMap = CityORMUtil.getCountryMap(countryId, otherCountryList);
        List<Map<String, Object>> dataArysCur = CityORMUtil.buildCityGroupData(currCityObjects, allCountryMap, provinceNumberMap, true, dCityArysCurHc);
        HashMap<String, List<Map<String, Object>>> mapCurCl = new HashMap<String, List<Map<String, Object>>>();
        mapCurCl.put("cl", dataArysCur);
        mapCurCl.put("hc", dCityArysCurHc);
        List<Map<String, Object>> dataArysInsGroup = CityORMUtil.buildCityGroupData(insCityObjects, allCountryMap, provinceNumberMap, false, null);
        HashMap<String, List<Map<String, Object>>> mapInsCurr = new HashMap<String, List<Map<String, Object>>>();
        mapInsCurr.put("cl", dataArysInsGroup);
        mapInsCurr.put("hc", Collections.emptyList());
        HashMap<String, Cloneable> mapIns = new HashMap<String, Cloneable>();
        mapIns.put("il", otherCountryList);
        mapIns.put("curr", mapInsCurr);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("curr", mapCurCl);
        result.put("intn", mapIns);
        return result;
    }

    private static Map<String, String> getProvinceAndCity(Long countryId, DynamicObjectCollection dynamicObjects, List<DynamicObject> currCityObjects, List<DynamicObject> insCityObjects) {
        HashMap<String, String> provinceCityMap = new HashMap<String, String>();
        for (DynamicObject object : dynamicObjects) {
            Long country = object.getLong(COUNTRY);
            if (countryId.equals(country)) {
                currCityObjects.add(object);
            } else {
                insCityObjects.add(object);
            }
            String number = object.getString(NUMBER);
            String longNumber = object.getString("longnumber");
            if (StringUtils.isBlank((CharSequence)longNumber)) continue;
            String provinceNumber = "";
            if (longNumber.contains("!")) {
                provinceNumber = StringUtils.substringBefore((String)longNumber, (String)"!");
            } else if (longNumber.contains(".")) {
                provinceNumber = StringUtils.substringBefore((String)longNumber, (String)".");
            }
            if (!StringUtils.isNotEmpty((CharSequence)provinceNumber) || number.equals(provinceNumber)) continue;
            provinceCityMap.put(number, provinceNumber);
        }
        QFilter filter = new QFilter(NUMBER, "in", provinceCityMap.values());
        ORM orm = ORM.create();
        DynamicObjectCollection provinces = orm.query(ENTITY_BD_ADMINDIVISION, "id,number,name", filter.toArray());
        HashMap<String, String> map = new HashMap<String, String>();
        for (DynamicObject province : provinces) {
            String number = province.getString(NUMBER);
            String name = province.getString("name");
            map.put(number, name);
        }
        for (Map.Entry entry : provinceCityMap.entrySet()) {
            String provinceNumber = (String)entry.getValue();
            entry.setValue(map.get(provinceNumber));
        }
        return provinceCityMap;
    }

    private static Map<Long, Object> getCountryMap(Long countryId, List<Map<String, Object>> otherCountryList) {
        ORM orm = ORM.create();
        DynamicObjectCollection dynamicObjects = orm.query(ENTITY_BD_COUNTRY, ID_NAME, null, ORDER_ASC_FILED);
        HashMap<Long, Object> result = new HashMap<Long, Object>();
        for (DynamicObject dynamicObject : dynamicObjects) {
            Long id = Long.parseLong(dynamicObject.get("id").toString());
            String name = dynamicObject.get("name").toString();
            result.put(id, name);
            if (id.equals(countryId)) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", String.valueOf(id));
            map.put("name", name);
            otherCountryList.add(map);
        }
        return result;
    }

    private static List<Map<String, Object>> buildCityGroupData(List<DynamicObject> dynamicObjects, Map<Long, Object> allCountryMap, Map<String, String> provinceNumberMap, Boolean isCurrentCountry, List<Map<String, Object>> hotCities) {
        List<Long> hotCityIds = Arrays.asList(124L, 2676L, 383L, 407L, 2818L, 2216L, 2933L, 3534L);
        List<Long> noProvinceCityIds = Arrays.asList(124L, 2676L, 142L, 3135L);
        ArrayList<Map<String, Object>> cityGroups = new ArrayList<Map<String, Object>>(10);
        HashMap map = new HashMap();
        for (DynamicObject dynamicObject : dynamicObjects) {
            String province;
            String group;
            String simpleSpell = StringUtils.deleteWhitespace((String)dynamicObject.getString("simplespell"));
            if (StringUtils.isBlank((CharSequence)simpleSpell) || (group = CityORMUtil.getGroupStr(simpleSpell, dynamicObject.getString("name"))) == null) continue;
            ArrayList cities = (ArrayList)map.get(group);
            if (CollectionUtils.isEmpty((Collection)cities)) {
                cities = new ArrayList();
                map.put(group, cities);
            }
            HashMap<String, Object> cityDetail = new HashMap<String, Object>();
            String cityId = dynamicObject.getString("id");
            cityDetail.put("id", cityId);
            cityDetail.put("name", dynamicObject.getString("name"));
            cityDetail.put("jp", simpleSpell);
            cityDetail.put("qp", dynamicObject.getString("fullspell"));
            String number = dynamicObject.getString(NUMBER);
            String string = province = provinceNumberMap.get(number) == null ? "" : provinceNumberMap.get(number);
            if (noProvinceCityIds.contains(Long.valueOf(cityId))) {
                province = "";
            }
            cityDetail.put("province", province);
            String countryId = dynamicObject.getString(COUNTRY);
            cityDetail.put("ilid", countryId);
            if (isCurrentCountry.booleanValue() && NUMBER_1000001.equals(countryId)) {
                cityDetail.put("countryName", "");
            } else {
                cityDetail.put("countryName", allCountryMap.get(dynamicObject.getLong(COUNTRY)));
            }
            Boolean needSetHotCity = isCurrentCountry != false && null != hotCities && NUMBER_1000001.equals(countryId) && hotCityIds.contains(Long.valueOf(cityId));
            if (needSetHotCity.booleanValue()) {
                hotCities.add(cityDetail);
            }
            cities.add(cityDetail);
        }
        ArrayList groups = new ArrayList(map.keySet());
        Collections.sort(groups, String::compareTo);
        for (String group : groups) {
            List cities = (List)map.get(group);
            HashMap<String, Object> cityGroupMap = new HashMap<String, Object>();
            cityGroupMap.put("gr", group);
            Lang lang = RequestContext.get().getLang();
            if (lang.equals((Object)Lang.zh_CN) || lang.equals((Object)Lang.zh_TW)) {
                Collections.sort(cities, (o1, o2) -> {
                    String name1 = CityORMUtil.getPinYinStr((String)o1.get("name"));
                    String name2 = CityORMUtil.getPinYinStr((String)o2.get("name"));
                    return name1.compareTo(name2);
                });
            } else {
                Collections.sort(cities, (o1, o2) -> {
                    String name1 = (String)o1.get("name");
                    String name2 = (String)o2.get("name");
                    return name1.compareTo(name2);
                });
            }
            cityGroupMap.put("clg", cities);
            cityGroups.add(cityGroupMap);
        }
        return cityGroups;
    }

    private static String getPinYinStr(String input) {
        char[] arr;
        if (input == null || "".equals(input)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (char c : arr = input.toCharArray()) {
            try {
                String[] temp = PinyinHelper.toHanyuPinyinStringArray((char)c, (HanyuPinyinOutputFormat)defaultFormat);
                if (temp.length > 0) {
                    sb.append(temp[0]);
                    continue;
                }
                sb.append(c);
            }
            catch (BadHanyuPinyinOutputFormatCombination badHanyuPinyinOutputFormatCombination) {
                logger.error("Catch BadHanyuPinyinOutputFormatCombination:", (Throwable)badHanyuPinyinOutputFormatCombination);
                sb.append(c);
            }
        }
        return sb.toString();
    }

    private static String getGroupStr(String simpleSpell, String name) {
        Lang lang = RequestContext.get().getLang();
        if (lang.equals((Object)Lang.en_US) || lang.equals((Object)Lang.zh_CN) || lang.equals((Object)Lang.zh_TW)) {
            return CityORMUtil.getFirstAlphaFormStr(name);
        }
        return Character.toString(simpleSpell.charAt(0)).toUpperCase();
    }

    private static String getFirstAlphaFormStr(String input) {
        if (input != null && input.toCharArray().length > 0) {
            char firstChar = input.charAt(0);
            if (CityORMUtil.isAlpha(firstChar)) {
                return Character.toString(firstChar).toUpperCase();
            }
            if (CityORMUtil.isHan(firstChar)) {
                HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
                defaultFormat.setVCharType(HanyuPinyinVCharType.WITH_V);
                defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
                defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
                try {
                    String[] temp = PinyinHelper.toHanyuPinyinStringArray((char)firstChar, (HanyuPinyinOutputFormat)defaultFormat);
                    return temp[0].toUpperCase().substring(0, 1);
                }
                catch (Exception exception) {
                    return null;
                }
            }
            return String.valueOf(firstChar);
        }
        return null;
    }

    private static boolean isHan(char c) {
        return c >= '\u4e00' && c <= '\u9fa5';
    }

    private static boolean isAlpha(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private static List<Map<String, Object>> buildNativeHotCities() {
        ArrayList<Map<String, Object>> dCityArysCurHc = new ArrayList<Map<String, Object>>();
        Long[] ids = new Long[]{124L, 2676L, 383L, 407L, 2818L, 2216L, 2933L, 3534L};
        QFilter filter = new QFilter("id", "in", Arrays.asList(ids));
        ORM orm = ORM.create();
        DynamicObjectCollection hotCities = orm.query(ENTITY_BD_ADMINDIVISION, SELECT_FILED_ADMINDIVISION, filter.toArray());
        for (DynamicObject city : hotCities) {
            HashMap<String, String> mapCurHc = new HashMap<String, String>();
            mapCurHc.put("id", city.getString("id"));
            mapCurHc.put("name", city.getString("name"));
            dCityArysCurHc.add(mapCurHc);
        }
        return dCityArysCurHc;
    }

    private static List<Map<String, Object>> buildInsHotCities(Long countryId) {
        QFilter filterIn = new QFilter(COUNTRY, "<>", (Object)countryId);
        filterIn.and(IS_CITY, "=", (Object)YES);
        QFilter filterInHc = new QFilter(COUNTRY, "<>", (Object)countryId);
        filterInHc.and(filterIn);
        ArrayList<Long> inSpecial = new ArrayList<Long>();
        inSpecial.add(3958L);
        inSpecial.add(3975L);
        inSpecial.add(3633L);
        inSpecial.add(3783L);
        inSpecial.add(3980L);
        inSpecial.add(4310L);
        inSpecial.add(4150L);
        filterIn.and("id", "in", inSpecial);
        filterInHc.and(IS_CITY, "=", (Object)YES);
        ORM orm = ORM.create();
        DynamicObjectCollection dyInsHc = orm.query(ENTITY_BD_ADMINDIVISION, "id,name,country,simplespell", filterInHc.toArray(), ORDER_ASC_FILED);
        ArrayList<Map<String, Object>> dCityArysInsHc = new ArrayList<Map<String, Object>>();
        for (DynamicObject dyIn : dyInsHc) {
            HashMap<String, String> mapInsHc = new HashMap<String, String>();
            mapInsHc.put("id", dyIn.get("id").toString());
            mapInsHc.put("name", ((ILocaleString)dyIn.get("name")).getLocaleValue());
            mapInsHc.put("ilid", dyIn.get(COUNTRY).toString());
            dCityArysInsHc.add(mapInsHc);
        }
        return dCityArysInsHc;
    }

    static {
        defaultFormat.setVCharType(HanyuPinyinVCharType.WITH_V);
        defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
    }
}

