/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.field;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.field.CityEditUtil;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

public class CitySortUtil {
    private static final Log logger = LogFactory.getLog(CitySortUtil.class);
    private static HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
    private static final String CHINA_LANGUAGE = "zh_CN";
    static final Comparator<Map<String, Object>> langComparator;
    static final Comparator<Map<String, Object>> countryComparator;
    static final Comparator<Map<String, Object>> parentListComparator;
    static final Comparator<Map<String, Object>> lengthComparator;
    static final Comparator<Map<String, Object>> lengthThenParentListComparator;
    static final Comparator<Map<String, Object>> highLightThenLengthComparator;

    private static List<String> getParentNameList(Long id) {
        DynamicObject adminDivisionParent;
        ArrayList<String> nameList = new ArrayList<String>();
        Map dynamicObjects = BusinessDataReader.loadFromCache((String)"bd_admindivision", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
        DynamicObject adminDivision = (DynamicObject)dynamicObjects.get(id);
        Long parentId = 0L;
        if (adminDivision != null) {
            parentId = adminDivision.getLong("parent_id");
        }
        while (parentId != null && parentId != 0L && (dynamicObjects = BusinessDataReader.loadFromCache((String)"bd_admindivision", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)parentId)})).size() > 0 && (adminDivisionParent = (DynamicObject)dynamicObjects.get(parentId)) != null) {
            parentId = adminDivisionParent.getLong("parent_id");
            nameList.add(adminDivisionParent.getString("name"));
        }
        Collections.reverse(nameList);
        return nameList;
    }

    public static List<Map<String, Object>> sortCityList(List<Map<String, Object>> cityList, String keyword) {
        Map<Integer, List<Map>> cityGroupMap = cityList.stream().collect(Collectors.groupingBy(a -> {
            String name = (String)a.get("name");
            if (keyword.equals(name)) {
                return 0;
            }
            String fullSpell = (String)a.get("qp");
            if (keyword.equals(fullSpell)) {
                return 1;
            }
            String simpleSpell = (String)a.get("jp");
            if (keyword.equals(simpleSpell)) {
                return 2;
            }
            if (name.startsWith(keyword)) {
                return 3;
            }
            if (name.contains(keyword)) {
                return 4;
            }
            return 5;
        }));
        ArrayList<Map<String, Object>> sortCityList = new ArrayList<Map<String, Object>>();
        List<Map> nameMatchCityList = cityGroupMap.get(0);
        List<Map> fullSpellMatchCityList = cityGroupMap.get(1);
        List<Map> simpleSpellMatchCityList = cityGroupMap.get(2);
        List<Map> nameStartsCityList = cityGroupMap.get(3);
        List<Map> nameContainsCityList = cityGroupMap.get(4);
        List<Map> fullOrSimpleLikeCityList = cityGroupMap.get(5);
        if (nameMatchCityList != null && nameMatchCityList.size() > 0) {
            Collections.sort(nameMatchCityList, countryComparator);
            sortCityList.addAll(nameMatchCityList);
        }
        if (fullSpellMatchCityList != null && fullSpellMatchCityList.size() > 0) {
            Collections.sort(fullSpellMatchCityList, lengthComparator);
            sortCityList.addAll(fullSpellMatchCityList);
        }
        if (simpleSpellMatchCityList != null && simpleSpellMatchCityList.size() > 0) {
            Collections.sort(simpleSpellMatchCityList, lengthComparator);
            sortCityList.addAll(simpleSpellMatchCityList);
        }
        if (nameStartsCityList != null && nameStartsCityList.size() > 0) {
            Collections.sort(nameStartsCityList, lengthComparator);
            sortCityList.addAll(nameStartsCityList);
        }
        if (nameContainsCityList != null && nameContainsCityList.size() > 0) {
            Collections.sort(nameContainsCityList, lengthComparator);
            sortCityList.addAll(nameContainsCityList);
        }
        if (fullOrSimpleLikeCityList != null && fullOrSimpleLikeCityList.size() > 0) {
            Collections.sort(fullOrSimpleLikeCityList, highLightThenLengthComparator);
            sortCityList.addAll(fullOrSimpleLikeCityList);
        }
        return sortCityList;
    }

    private static String getPinYinStr(String input) {
        char[] arr;
        if (input == null || "".equals(input)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (char c : arr = input.toCharArray()) {
            try {
                String[] temp = PinyinHelper.toHanyuPinyinStringArray((char)c, (HanyuPinyinOutputFormat)defaultFormat);
                if (temp.length > 0) {
                    sb.append(temp[0]);
                    continue;
                }
                sb.append(c);
            }
            catch (BadHanyuPinyinOutputFormatCombination badHanyuPinyinOutputFormatCombination) {
                logger.error("Catch BadHanyuPinyinOutputFormatCombination:", (Throwable)badHanyuPinyinOutputFormatCombination);
                sb.append(c);
            }
        }
        return sb.toString();
    }

    private static String getDefaultCountryName() {
        Object defaultCountry = CityEditUtil.callStaticMethod("kd.bos.servicehelper.parameter.SystemParamServiceHelper", "loadPublicParameterFromCache", new Object[]{"defaultcountry"}, String.class);
        if (defaultCountry != null) {
            Map defaultCountryMap = (Map)defaultCountry;
            return (String)((Map)defaultCountryMap.get("name")).get(CHINA_LANGUAGE);
        }
        return ResManager.loadKDString((String)"\u4e2d\u56fd", (String)"CitySortUtil_0", (String)"bos-form-metadata", (Object[])new Object[0]);
    }

    static {
        defaultFormat.setVCharType(HanyuPinyinVCharType.WITH_V);
        defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        langComparator = (map1, map2) -> {
            Lang lang = RequestContext.get().getLang();
            if (lang.equals((Object)Lang.zh_CN) || lang.equals((Object)Lang.zh_TW)) {
                String name1 = CitySortUtil.getPinYinStr((String)map1.get("name"));
                String name2 = CitySortUtil.getPinYinStr((String)map2.get("name"));
                return name1.compareTo(name2);
            }
            String name1 = (String)map1.get("name");
            String name2 = (String)map2.get("name");
            return name1.compareTo(name2);
        };
        countryComparator = (map1, map2) -> {
            String defaultCountryName = CitySortUtil.getDefaultCountryName();
            String country1 = (String)map1.get("c");
            String country2 = (String)map2.get("c");
            if (defaultCountryName.equals(country1) && !defaultCountryName.equals(country2)) {
                return -1;
            }
            if (defaultCountryName.equals(country2) && !defaultCountryName.equals(country1)) {
                return 1;
            }
            return 0;
        };
        parentListComparator = countryComparator.thenComparing((map1, map2) -> {
            Long id1 = Long.parseLong((String)map1.get("id"));
            Long id2 = Long.parseLong((String)map2.get("id"));
            List<String> nameList1 = CitySortUtil.getParentNameList(id1);
            List<String> nameList2 = CitySortUtil.getParentNameList(id2);
            int size1 = nameList1.size();
            int size2 = nameList2.size();
            if (size1 == 0 && size2 == 0) {
                return 0;
            }
            if (size1 == 0) {
                return -1;
            }
            if (size2 == 0) {
                return 1;
            }
            int minSize = Math.min(size1, size2);
            for (int i = 0; i < minSize; ++i) {
                String name1 = nameList1.get(i);
                String name2 = nameList2.get(i);
                int comarator = CitySortUtil.getPinYinStr(name1).compareTo(CitySortUtil.getPinYinStr(name2));
                if (comarator == 0) {
                    ++i;
                    continue;
                }
                return comarator;
            }
            return size1 - size2;
        });
        lengthComparator = (map1, map2) -> {
            int size2;
            String name1 = (String)map1.get("name");
            String name2 = (String)map2.get("name");
            int size1 = name1.length();
            if (size1 != (size2 = name2.length())) {
                return size1 - size2;
            }
            return langComparator.compare((Map<String, Object>)map1, (Map<String, Object>)map2);
        };
        lengthThenParentListComparator = lengthComparator.thenComparing(parentListComparator);
        highLightThenLengthComparator = (map1, map2) -> {
            Integer index2;
            Object highlightIndex1 = map1.get("highlightIndex");
            Object highlightIndex2 = map2.get("highlightIndex");
            Integer index1 = Integer.parseInt(String.valueOf(highlightIndex1 == null ? Integer.valueOf(Integer.MAX_VALUE) : highlightIndex1));
            if (!index1.equals(index2 = Integer.valueOf(Integer.parseInt(String.valueOf(highlightIndex2 == null ? Integer.valueOf(Integer.MAX_VALUE) : highlightIndex2))))) {
                return index1 - index2;
            }
            return lengthComparator.compare((Map<String, Object>)map1, (Map<String, Object>)map2);
        };
    }
}

