/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.field;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.AbstractFormView;
import kd.bos.form.BindingContext;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ISuportClick;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class ComboEdit
extends FieldEdit
implements ISuportClick {
    private static Log log = LogFactory.getLog(ComboEdit.class);
    private List<ClickListener> clickListeners = new ArrayList<ClickListener>();

    @KSMethod
    public void setComboItems(List<ComboItem> items) {
        ArrayList<List<Object>> listitems = new ArrayList<List<Object>>();
        if (items != null && !items.isEmpty()) {
            for (ComboItem item : items) {
                listitems.add(this.createEnumItem(item));
            }
        }
        IClientViewProxy viewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        if (this.getProperty().getParent() instanceof EntryType) {
            String entryKey = this.getEntryKey() != null ? this.getEntryKey() : this.getProperty().getParent().getName();
            viewProxy.setEntryFieldProperty(entryKey, this.getKey(), "st", listitems);
        } else {
            viewProxy.setFieldProperty(this.getKey(), "st", listitems);
        }
    }

    private List<Object> createEnumItem(ComboItem item) {
        ArrayList<Object> data = new ArrayList<Object>(4);
        data.add(item.getValue());
        data.add(item.getCaption());
        data.add(item.getImageKey());
        data.add(item.isItemVisible());
        data.add(item.isDisable());
        return data;
    }

    @KSMethod
    public void selectedStore(ComboItem item) {
        ArrayList<List<Object>> listitems = new ArrayList<List<Object>>();
        listitems.add(this.createEnumItem(item));
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).setFieldProperty(this.getKey(), "selectedStore", listitems);
    }

    @KSMethod
    public void selectedStore(List<ComboItem> items) {
        ArrayList<List<Object>> listitems = new ArrayList<List<Object>>(10);
        for (ComboItem item : items) {
            listitems.add(this.createEnumItem(item));
        }
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).setFieldProperty(this.getKey(), "selectedStore", listitems);
    }

    @Override
    public Object getBindingValue(BindingContext bctx) {
        Object v = super.getBindingValue(bctx);
        if (StringUtils.isBlank((Object)v)) {
            return "";
        }
        return v;
    }

    public void setComboInputable(boolean inputable) {
        IClientViewProxy viewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        viewProxy.invokeControlMethod(this.key, "inputable", inputable);
    }

    @Override
    public void postBack(Object value, int rowIndex, int parentRowIndex) {
        if (!this.checkEditFieldStatus()) {
            throw new KDBizException(BosErrorCode.variableNotValid, new Object[]{String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u4fee\u6539\u9501\u5b9a\u5b57\u6bb5%s\u7684\u503c\u3002", (String)"ComboEdit_0", (String)"bos-form-metadata", (Object[])new Object[0]), this.getDisplayName())});
        }
        DynamicObject dataEntity = null;
        if (!this.postDataCheck(value)) {
            String errMsg = String.format(ResManager.loadKDString((String)"%s\u8f6c\u6362\u5931\u8d25\u3002", (String)"ComboEdit_1", (String)"bos-form-metadata", (Object[])new Object[0]), this.getProperty().getDisplayName());
            try {
                if (this.prop != null && this.prop.getParent() instanceof EntryType) {
                    DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(this.getEntryKey());
                    dataEntity = (DynamicObject)entryEntity.get(rowIndex);
                } else {
                    dataEntity = this.getModel().getDataEntity(true);
                }
                BindingContext bc = new BindingContext(dataEntity, rowIndex);
                this.bindData(bc);
                if (this.getView() instanceof AbstractFormView) {
                    ((AbstractFormView)this.getView()).showMessage(errMsg);
                }
                this.getView().showMessage(errMsg);
            }
            catch (Exception e) {
                throw new KDBizException(BosErrorCode.variableNotValid, new Object[]{errMsg});
            }
        } else {
            this.view.getModel().setValue(this.getFieldKey(), value, rowIndex, parentRowIndex);
            this.addNewLineIfKeyField(1, rowIndex);
        }
    }

    @Override
    protected boolean postDataCheck(Object value) {
        boolean checkFlag = true;
        try {
            if (!((ComboProp)this.getProperty()).isComboValueCheck() || ObjectUtils.isEmpty((Object)value)) {
                return checkFlag;
            }
            Set<String> comboValueSet = this.getComboItemValues();
            String v = (String)value;
            checkFlag = this.checkComboValueLegal(v, comboValueSet);
        }
        catch (Exception ignore) {
            log.error((Throwable)ignore);
        }
        return checkFlag;
    }

    private Set<String> getComboItemValues() {
        Map<String, Object> controlMetaState = this.clientViewProxy.getControlMetaState(this.getKey());
        HashSet<String> valueSet = new HashSet<String>();
        if (!ObjectUtils.isEmpty(controlMetaState) && controlMetaState instanceof Map && controlMetaState.containsKey("st")) {
            boolean equalsFlag = false;
            Object metaState = controlMetaState.get("st");
            ArrayList viewStateList = (ArrayList)metaState;
            for (int i = 0; i < viewStateList.size() && !equalsFlag; ++i) {
                Object comboItem = viewStateList.get(i);
                if (!(comboItem instanceof List)) continue;
                for (Object comboContent : (List)comboItem) {
                    if (!(comboContent instanceof String)) continue;
                    valueSet.add((String)comboContent);
                }
            }
        } else {
            ComboProp comboProp = (ComboProp)this.getProperty();
            List comboItems = comboProp.getComboItems();
            for (ValueMapItem item : comboItems) {
                LocaleString itemName = item.getName();
                String itemValue = item.getValue();
                valueSet.add(itemName.getLocaleValue());
                valueSet.add(itemValue);
            }
        }
        return valueSet;
    }

    protected boolean checkComboValueLegal(String value, Set<String> comboItems) {
        if (comboItems == null || comboItems.isEmpty()) {
            return false;
        }
        return comboItems.contains(value);
    }

    @Override
    public void addClickListener(ClickListener listener) {
        this.clickListeners.add(listener);
    }

    @KSMethod
    public void setDefaultValue(Map<String, Object> paramsMap) {
        BeforeClickEvent e = new BeforeClickEvent(this, paramsMap);
        this.fireBeforeClick(e);
        if (!e.isCancel()) {
            ClickEvent e1 = new ClickEvent(this, paramsMap);
            this.fireClick(e1);
        }
    }

    private void fireBeforeClick(BeforeClickEvent e) {
        for (ClickListener l : this.clickListeners) {
            l.beforeClick(e);
        }
    }

    private void fireClick(ClickEvent e) {
        if (this.clickListeners != null) {
            for (ClickListener l : this.clickListeners) {
                l.click(e);
            }
        }
    }

    @Override
    public void addItemClickListener(ItemClickListener listener) {
    }
}

