/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.field;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.BindingContext;
import kd.bos.form.CoreShowFormHelper;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.service.InteTimeZone;
import kd.bos.service.TimeService;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class DateRangeEdit
extends FieldEdit
implements ICloseCallBack {
    private static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    private static final String YYYY_MM_DD = "yyyy-MM-dd";
    private String startDateFieldKey;
    private String endDateFieldKey;
    private String aboveEqual = "39";
    private String belowEqual = "16";
    private boolean allowBindData = true;
    private Log log = LogFactory.getLog(DateRangeEdit.class);

    @Override
    public Set<String> getFilterKeys() {
        HashSet<String> set = new HashSet<String>();
        set.add(this.getStartDateFieldKey());
        set.add(this.getEndDateFieldKey());
        return set;
    }

    @KSMethod
    @SimplePropertyAttribute
    public String getStartDateFieldKey() {
        return this.startDateFieldKey;
    }

    public void setStartDateFieldKey(String startDateFieldKey) {
        this.startDateFieldKey = startDateFieldKey.trim();
    }

    @KSMethod
    @SimplePropertyAttribute
    public String getEndDateFieldKey() {
        return this.endDateFieldKey;
    }

    public void setEndDateFieldKey(String endDateFieldKey) {
        this.endDateFieldKey = endDateFieldKey.trim();
    }

    @Override
    public void postBack(Object value, int rowIndex, int parentRowIndex) {
        IDataModel model = (IDataModel)this.view.getService(IDataModel.class);
        IDataEntityProperty prop = model.getProperty(this.startDateFieldKey);
        SimpleDateFormat simpleDateFormat = ((DateTimeProp)prop).getRegionType() == 2 ? new SimpleDateFormat(YYYY_MM_DD_HH_MM_SS) : new SimpleDateFormat(YYYY_MM_DD);
        try {
            boolean isOnlyStartDateChanged;
            Object oldEndDateValue;
            Object oldStartDateValue;
            Date startDate = null;
            Date endDate = null;
            if (value != null && value.toString().split(",").length == 2) {
                startDate = simpleDateFormat.parse(value.toString().split(",")[0]);
                endDate = simpleDateFormat.parse(value.toString().split(",")[1]);
            }
            IDataModel dataModel = this.view.getModel();
            IDataEntityProperty startDateProp = dataModel.getProperty(this.startDateFieldKey);
            IDataEntityProperty endDateProp = dataModel.getProperty(this.endDateFieldKey);
            if (StringUtils.isNotBlank((CharSequence)this.getEntryKey())) {
                DynamicObject rowDynamicObject = dataModel.getEntryRowEntity(this.getEntryKey(), rowIndex);
                if (rowDynamicObject == null) {
                    return;
                }
                oldStartDateValue = rowDynamicObject.getDataStorage().getLocalValue(startDateProp);
                oldEndDateValue = rowDynamicObject.getDataStorage().getLocalValue(endDateProp);
            } else {
                oldStartDateValue = dataModel.getDataEntity().getDataStorage().getLocalValue(startDateProp);
                oldEndDateValue = dataModel.getDataEntity().getDataStorage().getLocalValue(endDateProp);
            }
            boolean bl = isOnlyStartDateChanged = !this.isValueEquals(oldStartDateValue, startDate) && this.isValueEquals(oldEndDateValue, endDate);
            if (!isOnlyStartDateChanged) {
                this.setAllowBindData(false);
            }
            dataModel.setValue(this.startDateFieldKey, (Object)startDate, rowIndex, parentRowIndex);
            this.setAllowBindData(true);
            dataModel.setValue(this.endDateFieldKey, (Object)endDate, rowIndex, parentRowIndex);
        }
        catch (ParseException e) {
            throw new KDBizException((Throwable)e, BosErrorCode.parse, new Object[]{e.toString()});
        }
    }

    private boolean isValueEquals(Object v1, Object v2) {
        if (v1 == null && v2 == null) {
            return true;
        }
        if (v1 == null) {
            return false;
        }
        return v1.equals(v2);
    }

    protected void setAllowBindData(boolean allowBindData) {
        this.allowBindData = allowBindData;
    }

    protected boolean isAllowBindData() {
        return this.allowBindData;
    }

    @Override
    public Object getBindingValue(BindingContext bctx) {
        Object startDate = this.getBindingValue(this.startDateFieldKey, bctx);
        Object endDate = this.getBindingValue(this.endDateFieldKey, bctx);
        return this.getValue(startDate, endDate);
    }

    @Override
    public void bindData(BindingContext bctx) {
        if (!this.isAllowBindData()) {
            return;
        }
        Object startDate = this.getBindingValue(this.startDateFieldKey, bctx);
        Object endDate = this.getBindingValue(this.endDateFieldKey, bctx);
        this.setValue(this.getValue(startDate, endDate), bctx.getRowIndex());
        HashMap<String, String> meta = new HashMap<String, String>();
        meta.put("k", this.getFieldKey());
        TimeService svc = new TimeService();
        meta.put("today", InteTimeZone.getSysTimeZone().format(svc.today()));
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.addAction("u", meta);
    }

    @SdkInternal
    protected Object getValue(Object startDate, Object endDate) {
        IDataModel dataModel = (IDataModel)this.view.getService(IDataModel.class);
        IDataEntityProperty prop = dataModel.getProperty(this.startDateFieldKey);
        if (prop instanceof DateTimeProp) {
            StringBuilder sb = new StringBuilder();
            if (startDate != null) {
                sb.append(startDate instanceof Date ? ((DateTimeProp)prop).getDateFormat().format(startDate) : startDate.toString());
            }
            sb.append(", ");
            if (endDate != null) {
                sb.append(endDate instanceof Date ? ((DateTimeProp)prop).getDateFormat().format(endDate) : endDate.toString());
            } else {
                sb.append("");
            }
            return sb.toString();
        }
        return (startDate == null ? "" : startDate.toString()) + "," + (endDate == null ? "" : endDate.toString());
    }

    private void setValue(Object v, int row) {
        IDataModel dataModel = (IDataModel)this.view.getService(IDataModel.class);
        IDataEntityProperty prop = dataModel.getProperty(this.startDateFieldKey);
        if (prop.getParent() instanceof EntryType) {
            EntryGrid grid = this.getEntryGrid();
            this.clientViewProxy.setEntryFieldValue(grid, this.getFieldKey(), row, v);
        } else {
            this.clientViewProxy.setFieldProperty(this.getKey(), "v", v);
        }
    }

    public Object getBindingValue(String fieldkey, BindingContext bctx) {
        IDataModel dataModel = (IDataModel)this.view.getService(IDataModel.class);
        IDataEntityProperty prop = dataModel.getProperty(fieldkey);
        return prop.getValue(bctx.getDataEntity());
    }

    public void focus() {
        IDataModel model = (IDataModel)this.view.getService(IDataModel.class);
        IDataEntityProperty prop = model.getProperty(this.startDateFieldKey);
        int regionType = ((DateTimeProp)prop).getRegionType();
        Object startDate = this.getModel().getValue(this.startDateFieldKey);
        Object endDate = this.getModel().getValue(this.endDateFieldKey);
        String dateString = (startDate == null ? "" : startDate.toString()) + "," + (endDate == null ? "" : endDate.toString());
        FormShowParameter formShowParameter = CoreShowFormHelper.createDateSelectShowForm(this.getKey(), dateString, "daterange", true, null, null);
        formShowParameter.setCustomParam("mustInput", ((DateTimeProp)this.getProperty()).isMustInput());
        formShowParameter.setCustomParam("regionType", regionType);
        this.getView().showForm(formShowParameter);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        int rowIndex = 0;
        IDataModel dataModel = (IDataModel)this.view.getService(IDataModel.class);
        IDataEntityProperty prop = dataModel.getProperty(this.startDateFieldKey);
        if (prop.getParent() instanceof EntryType) {
            rowIndex = dataModel.getEntryCurrentRowIndex(prop.getParent().getName());
        }
        this.postBack(e.getReturnData(), rowIndex, -1);
        Object value = e.getReturnData();
        if (",".equals(value.toString())) {
            this.setValue(value, rowIndex);
            return;
        }
        String startDate = value.toString().split(",")[0];
        String endDate = value.toString().split(",")[1];
        this.setValue(this.getValue(startDate, endDate), rowIndex);
    }

    @Override
    public List<Map<String, List<Object>>> getDefaultFilters() {
        ArrayList<Map<String, List<Object>>> defaultFilterList = new ArrayList<Map<String, List<Object>>>();
        IDataEntityProperty prop = this.getModel().getProperty(this.startDateFieldKey);
        if (prop.getParent() instanceof EntryType) {
            return defaultFilterList;
        }
        HashMap startCommonFilter = new HashMap();
        ArrayList<String> compareList = new ArrayList<String>();
        compareList.add(this.aboveEqual);
        ArrayList<String> nameList = new ArrayList<String>();
        nameList.add(this.startDateFieldKey);
        ArrayList<Object> valueList = new ArrayList<Object>();
        valueList.add(this.getModel().getValue(this.startDateFieldKey));
        startCommonFilter.put("FieldName", nameList);
        startCommonFilter.put("Value", valueList);
        startCommonFilter.put("Compare", compareList);
        defaultFilterList.add(startCommonFilter);
        HashMap<String, ArrayList<Object>> endCommonFilter = new HashMap<String, ArrayList<Object>>();
        compareList = new ArrayList();
        compareList.add(this.belowEqual);
        nameList = new ArrayList();
        nameList.add(this.endDateFieldKey);
        valueList = new ArrayList();
        valueList.add(this.getModel().getValue(this.endDateFieldKey));
        endCommonFilter.put("FieldName", nameList);
        endCommonFilter.put("Value", valueList);
        endCommonFilter.put("Compare", compareList);
        defaultFilterList.add(endCommonFilter);
        return defaultFilterList;
    }

    @Override
    public IDataEntityProperty getProperty() {
        if (this.view == null) {
            return null;
        }
        if (this.prop == null) {
            if (StringUtils.isNotBlank((CharSequence)this.getStartDateFieldKey())) {
                this.prop = ((IDataModel)this.view.getService(IDataModel.class)).getProperty(this.getStartDateFieldKey());
            } else if (StringUtils.isNotBlank((CharSequence)this.getEndDateFieldKey())) {
                this.prop = ((IDataModel)this.view.getService(IDataModel.class)).getProperty(this.getEndDateFieldKey());
            }
        }
        return this.prop;
    }

    public void setMinDate(Date date) {
        if (date == null) {
            return;
        }
        this.setDate(date, "min");
    }

    public void setMaxDate(Date date) {
        if (date == null) {
            return;
        }
        this.setDate(date, "max");
    }

    private void setDate(Date date, String minValue) {
        if (StringUtils.isNotBlank((CharSequence)this.getEntryKey())) {
            EntryGrid entryGrid = this.getEntryGrid();
            if (entryGrid instanceof CardEntry) {
                this.updatecontrolMetadata(date, minValue);
            } else {
                IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                proxy.invokeControlMethod(this.getEntryKey(), "setColEditorProp", this.key, minValue, date);
            }
        } else {
            this.updatecontrolMetadata(date, minValue);
        }
    }

    private void updatecontrolMetadata(Date date, String maxValue) {
        HashMap<String, String> editor = new HashMap<String, String>();
        HashMap<String, Object> item = new HashMap<String, Object>();
        IDataModel model = (IDataModel)this.view.getService(IDataModel.class);
        IDataEntityProperty prop = model.getProperty(this.startDateFieldKey);
        SimpleDateFormat sdf = ((DateTimeProp)prop).getRegionType() == 2 ? new SimpleDateFormat(YYYY_MM_DD_HH_MM_SS) : new SimpleDateFormat(YYYY_MM_DD);
        editor.put(maxValue, sdf.format(date));
        item.put("item", editor);
        this.getView().updateControlMetadata(this.getKey(), item);
    }
}

