/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.field;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.formula.OutValue;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.BindingContext;
import kd.bos.form.CoreShowFormHelper;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.DateTimeFormula;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.DateClickListener;
import kd.bos.form.field.events.ResetDateFilterEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.service.InteTimeZone;
import kd.bos.service.KDDateFormatUtils;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class DateTimeEdit
extends FieldEdit
implements ICloseCallBack {
    private static final Log LOG = LogFactory.getLog(DateTimeEdit.class);
    private static final String BOS_FORM_METADATA = "bos-form-metadata";
    private static final String SPAN_TYPE_PLUGIN = "plugin";
    protected List<DateClickListener> dateClickListeners = new ArrayList<DateClickListener>();
    String fmtString = "yyyy-MM-dd HH:mm:ss";
    String relateddate;
    private String minDate;
    private String maxDate;
    private Boolean is_Start;
    private int timeZoneTransType;
    private String displayFormatString;
    private String mask;

    public DateTimeEdit() {
        this("yyyy-MM-dd HH:mm:ss");
    }

    public DateTimeEdit(String fmtString) {
        this.fmtString = fmtString;
    }

    @KSMethod
    public void addDateClickListener(DateClickListener listener) {
        this.dateClickListeners.add(listener);
    }

    @SimplePropertyAttribute
    public Boolean getIsStartDate() {
        return this.is_Start;
    }

    public void setIsStartDate(Boolean value) {
        this.is_Start = value;
    }

    @SimplePropertyAttribute
    public String getRelatedDate() {
        return this.relateddate;
    }

    public void setRelatedDate(String value) {
        this.relateddate = value;
    }

    @SimplePropertyAttribute
    public String getMinDate() {
        return this.minDate;
    }

    public void setMinDate(String min) {
        this.minDate = min;
    }

    public void setMinDate(Date date) {
        if (date == null) {
            return;
        }
        this.setDate(date, "min");
    }

    @SimplePropertyAttribute
    public String getMaxDate() {
        return this.maxDate;
    }

    public void setMaxDate(String max) {
        this.maxDate = max;
    }

    public void setMaxDate(Date date) {
        if (date == null) {
            return;
        }
        this.setDate(date, "max");
    }

    @KSMethod
    @SimplePropertyAttribute
    public String getFormatString() {
        return this.fmtString;
    }

    public void setFormatString(String format) {
        this.fmtString = format;
    }

    @SimplePropertyAttribute
    public int getTimeZoneTransType() {
        return this.timeZoneTransType;
    }

    public void setTimeZoneTransType(int timeZoneTransType) {
        this.timeZoneTransType = timeZoneTransType;
    }

    @SimplePropertyAttribute
    public String getDisplayFormatString() {
        return this.displayFormatString;
    }

    public void setDisplayFormatString(String displayFormatString) {
        this.displayFormatString = displayFormatString;
    }

    @SimplePropertyAttribute
    public String getMask() {
        return this.mask;
    }

    public void setMask(String mask) {
        this.mask = mask;
    }

    @KSMethod
    public InteTimeZone getTimeZone() {
        String relateOrg;
        IDataModel model = this.getModel();
        Long orgId = 0L;
        DateTimeProp prop = (DateTimeProp)this.getProperty();
        String string = relateOrg = StringUtils.isBlank((CharSequence)prop.getRelateOrg()) ? model.getDataEntityType().getMainOrg() : prop.getRelateOrg();
        if (StringUtils.isNotBlank((CharSequence)relateOrg)) {
            DynamicObject org;
            MainEntityType parentType = model.getDataEntityType();
            IDataEntityProperty orgProp = (IDataEntityProperty)parentType.getProperties().get((Object)relateOrg);
            if (orgProp != null && (org = model.getDataEntity().getDynamicObject(orgProp)) != null) {
                orgId = (Long)org.getPkValue();
            }
            if (orgProp == null && (parentType = parentType.getParent()) != null && (orgProp = (IDataEntityProperty)parentType.getProperties().get((Object)relateOrg)) != null && (org = model.getDataEntity().getDynamicObject(orgProp)) != null) {
                orgId = (Long)org.getPkValue();
            }
            if (orgProp == null && parentType != null && (parentType = parentType.getParent()) != null && (orgProp = (IDataEntityProperty)parentType.getProperties().get((Object)relateOrg)) != null && (org = model.getDataEntity().getDynamicObject(orgProp)) != null) {
                orgId = (Long)org.getPkValue();
            }
        }
        return ((DateTimeProp)this.getProperty()).getTimeZone(orgId);
    }

    private InteTimeZone getTimeZone(int rowIndex) {
        String relateOrg;
        IDataModel model = this.getModel();
        if (InteTimeZone.TransType.get((int)this.getTimeZoneTransType()) != InteTimeZone.TransType.OrgTimeZone) {
            return ((DateTimeProp)this.getProperty()).getTimeZone(Long.valueOf(0L));
        }
        Long orgId = 0L;
        DateTimeProp prop = (DateTimeProp)this.getProperty();
        DynamicObject org = null;
        String string = relateOrg = StringUtils.isBlank((CharSequence)prop.getRelateOrg()) ? model.getDataEntityType().getMainOrg() : prop.getRelateOrg();
        if (StringUtils.isNotBlank((CharSequence)relateOrg)) {
            IDataEntityType parentType = this.getProperty().getParent();
            DynamicObject activeRow = null;
            activeRow = parentType instanceof EntryType ? model.getEntryRowEntity(parentType.getName(), rowIndex) : model.getDataEntity(true);
            if (activeRow != null) {
                RowDataModel rowDataModel = new RowDataModel(parentType.getName(), model.getDataEntityType());
                rowDataModel.setRowContext(activeRow);
                OutValue outValue = new OutValue();
                rowDataModel.tryGetValue(relateOrg, outValue);
                org = (DynamicObject)outValue.get();
            }
        }
        if (org != null) {
            orgId = (Long)org.getPkValue();
        }
        return ((DateTimeProp)this.getProperty()).getTimeZone(orgId);
    }

    public void changeYear(Object year) {
        ResetDateFilterEvent e = new ResetDateFilterEvent(this, this.getKey());
        e.setFocusedYear(Integer.parseInt(String.valueOf(year)));
        for (DateClickListener listener : this.dateClickListeners) {
            EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(listener.getClass().getName() + ".resetDateFilter"));
            Throwable throwable = null;
            try {
                listener.resetDateFilter(e);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                span.close();
            }
        }
        HashMap<String, List<String>> data = new HashMap<String, List<String>>(2);
        List<String> includeDates = e.getFmtIncludeDates();
        List<String> excludeDates = e.getFmtExcludeDates();
        if (includeDates != null) {
            data.put("includeDates", includeDates);
        } else if (excludeDates != null) {
            data.put("excludeDates", excludeDates);
        }
        if (StringUtils.isNotBlank((CharSequence)this.getEntryKey())) {
            HashMap<String, Object> map = new HashMap<String, Object>(2);
            map.put("k", this.getKey());
            map.put("data", data);
            this.clientViewProxy.invokeControlMethod(this.getEntryKey(), "setDateFilter", map);
        } else {
            this.clientViewProxy.invokeControlMethod(this.getKey(), "setDateFilter", data);
        }
    }

    @Override
    protected Object getFieldValue(BindingContext bctx) {
        IDataEntityProperty property = this.getProperty();
        if (property == null) {
            return null;
        }
        Object val = property.getValue(bctx.getDataEntity());
        if (val != null && property instanceof DateTimeProp) {
            val = ((DateTimeProp)this.prop).format(bctx.getDataEntity(), (Date)val);
        }
        return val;
    }

    @Override
    public void bindData(BindingContext bctx) {
        super.bindData(bctx);
        HashMap<String, String> meta = new HashMap<String, String>();
        meta.put("k", this.getFieldKey());
        if (InteTimeZone.TransType.get((int)this.timeZoneTransType) == InteTimeZone.TransType.OrgTimeZone) {
            meta.put("timezone", this.getTimeZone().getTimeZoneDesc());
        }
        DateFormat dateFormat = this instanceof DateEdit ? KDDateFormatUtils.getUserZoneDateFormat() : KDDateFormatUtils.getDateTimeFormat((TimeZone)this.getTimeZone().getTimeZone());
        meta.put("today", dateFormat.format(new Date()));
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.addAction("u", meta);
        this.updateDateTimeRangeMeta();
    }

    @SdkInternal
    public void updateDateTimeRangeMeta() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.getFormatString());
        this.setMinDate(this.toDate(simpleDateFormat, this.getMinDate()));
        this.setMaxDate(this.toDate(simpleDateFormat, this.getMaxDate()));
    }

    @Override
    public void postBack(Object value, int rowIndex, int parentRowIndex) {
        super.postBack(this.toDateTime(value, rowIndex), rowIndex, parentRowIndex);
    }

    public void postBack(String key, Object value, int rowIndex, int parentRowIndex) {
        this.view.getModel().setValue(key, value, rowIndex, parentRowIndex);
    }

    public void postBack(String key, Object value) {
        this.view.getModel().setValue(key, value);
    }

    Date toDateTime(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            try {
                return this.getTimeZone().parse((String)value);
            }
            catch (ParseException e) {
                throw new KDBizException((Throwable)e, BosErrorCode.conversionNotSupported, new Object[]{ResManager.loadKDString((String)"\u65e5\u671f\u8f6c\u6362\u5931\u8d25", (String)"DateTimeEdit_0", (String)BOS_FORM_METADATA, (Object[])new Object[0])});
            }
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        throw new KDBizException(BosErrorCode.conversionNotSupported, new Object[]{String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u65e5\u671f\u7c7b\u578b %s ", (String)"DateTimeEdit_1", (String)BOS_FORM_METADATA, (Object[])new Object[0]), "")});
    }

    Date toDateTime(Object value, int rowIndex) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            try {
                return this.getTimeZone(rowIndex).parse((String)value);
            }
            catch (ParseException e) {
                throw new KDBizException((Throwable)e, BosErrorCode.conversionNotSupported, new Object[]{ResManager.loadKDString((String)"\u65e5\u671f\u8f6c\u6362\u5931\u8d25", (String)"DateTimeEdit_0", (String)BOS_FORM_METADATA, (Object[])new Object[0])});
            }
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        throw new KDBizException(BosErrorCode.conversionNotSupported, new Object[]{String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u65e5\u671f\u7c7b\u578b %s ", (String)"DateTimeEdit_1", (String)BOS_FORM_METADATA, (Object[])new Object[0]), "")});
    }

    public void focus() {
        String dateString;
        String myStartDate = null;
        String myEndDate = null;
        if (this.getModel().getValue(this.getKey()) != null) {
            myStartDate = this.getModel().getValue(this.getKey()).toString();
        }
        String string = dateString = myStartDate == null ? "" : myStartDate;
        if (!"".equals(dateString)) {
            SimpleDateFormat sdf = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US);
            try {
                Date date = sdf.parse(dateString);
                dateString = new SimpleDateFormat(this.fmtString).format(date);
            }
            catch (ParseException e) {
                throw new KDException((Throwable)e, BosErrorCode.parse, new Object[0]);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.getRelatedDate())) {
            if (this.getModel().getValue(this.getRelatedDate()) != null) {
                myEndDate = this.getModel().getValue(this.getRelatedDate()).toString();
            }
            dateString = this.isStart() ? dateString + "," + (myEndDate == null ? "" : myEndDate) : (myEndDate == null ? "" : myEndDate) + "," + dateString;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(this.fmtString);
        Date convertedMinDate = this.toDate(dateFormat, this.minDate);
        Date convertedMaxDate = this.toDate(dateFormat, this.maxDate);
        String convertedMinDateString = convertedMinDate == null ? null : dateFormat.format(convertedMinDate);
        String convertedMaxDateString = convertedMaxDate == null ? null : dateFormat.format(convertedMaxDate);
        FormShowParameter formShowParameter = CoreShowFormHelper.createDateSelectShowForm(this.getKey(), dateString, "datetime", this.isStart(), convertedMinDateString, convertedMaxDateString);
        this.getView().showForm(formShowParameter);
    }

    protected Date toDate(DateFormat format, String expr) {
        if (StringUtils.isBlank((CharSequence)expr)) {
            return null;
        }
        Object result = null;
        try {
            return format.parse(expr);
        }
        catch (ParseException e) {
            LOG.info(e.getMessage());
            try {
                result = DateTimeFormula.getDateTimeFormula().runFormula(expr, new HashMap());
            }
            catch (Exception exp) {
                throw new KDBizException(ResManager.loadKDString((String)"\u516c\u5f0f\u6267\u884c\u51fa\u9519", (String)"DateTimeEdit_2", (String)BOS_FORM_METADATA, (Object[])new Object[0]));
            }
            if (result == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u516c\u5f0f\u65e0\u6548\uff1a%s", (String)"DateTimeEdit_3", (String)BOS_FORM_METADATA, (Object[])new Object[0]), expr));
            }
            if (result instanceof Date) {
                return (Date)result;
            }
            if (result instanceof String) {
                try {
                    return format.parse((String)result);
                }
                catch (ParseException e2) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65e5\u671f\u6700\u5927\u503c\u6700\u5c0f\u503c\u5c5e\u6027\u683c\u5f0f\u5316\u5931\u8d25%s", (String)"DateTimeEdit_4", (String)BOS_FORM_METADATA, (Object[])new Object[0]), expr));
                }
            }
            return (Date)result;
        }
    }

    private void setValue(String key, Object v) {
        IDataModel dataModel = (IDataModel)this.view.getService(IDataModel.class);
        IDataEntityProperty prop = dataModel.getProperty(key);
        if (prop.getParent() instanceof EntryType) {
            int rowIndex = dataModel.getEntryCurrentRowIndex(prop.getParent().getName());
            int parentRowIndex = 0;
            if (prop.getParent().getParent() instanceof EntryType) {
                parentRowIndex = dataModel.getEntryCurrentRowIndex(prop.getParent().getParent().getName());
            }
            this.postBack(key, v, rowIndex, parentRowIndex);
        } else {
            this.postBack(key, v);
        }
    }

    private boolean isStart() {
        return this.getIsStartDate() == null ? false : this.getIsStartDate();
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        Object value = e.getReturnData();
        if (StringUtils.isNotBlank((CharSequence)this.getRelatedDate())) {
            String startDate = value.toString().split(",")[0];
            String endDate = value.toString().split(",")[1];
            if (this.isStart()) {
                this.setValue(this.getKey(), startDate);
                this.setValue(this.getRelatedDate(), endDate);
            } else {
                this.setValue(this.getKey(), endDate);
                this.setValue(this.getRelatedDate(), startDate);
            }
        } else {
            this.setValue(this.getKey(), value);
        }
    }

    protected void setDate(Date date, String minDate) {
        if (date == null) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)this.getEntryKey())) {
            EntryGrid entryGrid = this.getEntryGrid();
            if (entryGrid instanceof CardEntry) {
                this.updateControlMetadata(date, minDate);
            } else {
                IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                proxy.invokeControlMethod(this.getEntryKey(), "setColEditorProp", this.key, minDate, date);
            }
        } else {
            this.updateControlMetadata(date, minDate);
        }
    }

    private void updateControlMetadata(Date date, String minDate) {
        HashMap<String, String> editor = new HashMap<String, String>();
        HashMap<String, Object> item = new HashMap<String, Object>();
        SimpleDateFormat sdf = new SimpleDateFormat(this.getFormatString());
        editor.put(minDate, sdf.format(date));
        item.put("item", editor);
        this.getView().updateControlMetadata(this.getKey(), item);
    }

    @Override
    public List<Map<String, List<Object>>> getDefaultFilters() {
        List<Map<String, List<Object>>> defaultFilters = super.getDefaultFilters();
        if (!this.isStart()) {
            ArrayList<Date> valueList = new ArrayList<Date>();
            Map<String, List<Object>> commonFilter = defaultFilters.get(0);
            Date date = this.toDateTime(this.getModel().getValue(this.getFieldKey()));
            if (date != null) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                valueList.add(calendar.getTime());
            } else {
                valueList.add(null);
            }
            commonFilter.put("Value", valueList);
        }
        return defaultFilters;
    }
}

