/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.field;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.ExchangeRateProp;
import kd.bos.form.BindingContext;
import kd.bos.form.IFormDataBinder;
import kd.bos.form.IFormView;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.field.ExRateConfigUtil;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class ExchangeRateEdit
extends DecimalEdit {
    private String originalCurrencyFieldKey;
    private String targetCurrencyFieldKey;
    private String exRateTypeFieldKey;
    private String exRateDateFieldKey;
    private String exRateQuotationKey;

    @SimplePropertyAttribute
    public String getOriginalCurrencyFieldKey() {
        return this.originalCurrencyFieldKey;
    }

    public void setOriginalCurrencyFieldKey(String originalCurrencyFieldKey) {
        this.originalCurrencyFieldKey = originalCurrencyFieldKey;
    }

    @SimplePropertyAttribute
    public String getTargetCurrencyFieldKey() {
        return this.targetCurrencyFieldKey;
    }

    public void setTargetCurrencyFieldKey(String targetCurrencyFieldKey) {
        this.targetCurrencyFieldKey = targetCurrencyFieldKey;
    }

    @SimplePropertyAttribute
    public String getExRateTypeFieldKey() {
        return this.exRateTypeFieldKey;
    }

    public void setExRateTypeFieldKey(String exRateTypeFieldKey) {
        this.exRateTypeFieldKey = exRateTypeFieldKey;
    }

    @SimplePropertyAttribute
    public String getExRateDateFieldKey() {
        return this.exRateDateFieldKey;
    }

    public void setExRateDateFieldKey(String exRateDateFieldKey) {
        this.exRateDateFieldKey = exRateDateFieldKey;
    }

    @SimplePropertyAttribute
    public String getExRateQuotationKey() {
        return this.exRateQuotationKey;
    }

    public void setExRateQuotationKey(String exRateQuotationKey) {
        this.exRateQuotationKey = exRateQuotationKey;
    }

    @Override
    public void bindData(BindingContext bctx) {
        super.bindData(bctx);
        ExchangeRateEdit.autoRegisterExchangeRatePlugin(this.getModel(), this.getView());
        if (ExRateConfigUtil.isEnableExRatePrecisionControl()) {
            if (this.prop == null) {
                return;
            }
            int scale = ((ExchangeRateProp)this.prop).getEnsureScale(this.getModel(), bctx.getDataEntity());
            if (this.prop.getParent() instanceof EntryType) {
                HashMap<String, Map<String, Integer>> cpropMap = new HashMap<String, Map<String, Integer>>();
                cpropMap.put(this.getKey(), Collections.singletonMap("ssc", scale));
                this.clientViewProxy.invokeControlMethod(this.prop.getParent().getName(), "setCustomProperties", bctx.getRowIndex(), cpropMap);
            } else {
                HashMap<String, Object> itemMap = new HashMap<String, Object>();
                itemMap.put("item", Collections.singletonMap("ssc", scale));
                this.getView().updateControlMetadata(this.getKey(), itemMap);
            }
        }
    }

    public int getCurrentRowIndex() {
        int rowIndex = -1;
        if (this.isEntryProperty(this.getProperty())) {
            rowIndex = this.getModel().getEntryCurrentRowIndex(this.getProperty().getParent().getName());
        }
        return rowIndex;
    }

    protected boolean isEntryProperty(IDataEntityProperty property) {
        IDataEntityType propParentType = property.getParent();
        return propParentType instanceof EntryType;
    }

    public static void autoRegisterExchangeRatePlugin(IDataModel model, IFormView view) {
        FormViewPluginProxy formViewPluginProxy = (FormViewPluginProxy)model.getService(FormViewPluginProxy.class);
        if (formViewPluginProxy != null && formViewPluginProxy.getPlugin("kd.bos.exrate.plugin.ExchangeRateHandlePlugin") == null) {
            if (view == null) {
                view = ExchangeRateEdit.getFormDataBinderView(model);
            }
            Object billSummaryId = view.getFormShowParameter().getCustomParam("billsummaryid");
            Object billSummaryNumber = view.getFormShowParameter().getCustomParam("billsummarynumber");
            Object scene = view.getFormShowParameter().getCustomParam("scene");
            if (!(billSummaryId != null && billSummaryNumber != null || "wf_mbillsummary_cfg".equals(scene))) {
                view.getFormShowParameter().addCustPlugin("kd.bos.exrate.plugin.ExchangeRateHandlePlugin");
                view.cacheFormShowParameter();
                IFormPlugin plugin = ExchangeRateEdit.getExchangeRateHandlePlugin();
                plugin.setView(view);
                formViewPluginProxy.registerPlugin(plugin);
            }
        }
    }

    private static IFormPlugin getExchangeRateHandlePlugin() {
        try {
            Class<?> clazz = Class.forName("kd.bos.exrate.plugin.ExchangeRateHandlePlugin");
            Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
            return (IFormPlugin)constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static IFormView getFormDataBinderView(IDataModel model) {
        try {
            Object binder = model.getService(IFormDataBinder.class);
            Class<?> clazz = Class.forName("kd.bos.mvc.form.FormDataBinder");
            Method method = clazz.getDeclaredMethod("getView", new Class[0]);
            return (IFormView)method.invoke(binder, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

