/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.field;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleValue;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.LocaleValue;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.privacy.PrivacyCenterUtils;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.trace.EntityTraceHint;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.privacy.PrivacyDataConstant;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.PermissionControlType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BillStatusProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.BindingContext;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IMobileView;
import kd.bos.form.IPrivacyService;
import kd.bos.form.TipsSupport;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.EmbedSubEntryGrid;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.BasedataPropEdit;
import kd.bos.lang.Lang;
import kd.bos.permission.api.FieldControlRule;
import kd.bos.permission.api.FieldControlRules;
import kd.bos.permission.api.PermissionService;
import kd.bos.permission.model.PermRes;
import kd.bos.permission.model.perm.req.field.FieldControlRules2RuleReq;
import kd.bos.privacy.DesensitizeField;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.service.ServiceFactory;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class FieldEdit
extends TipsSupport {
    private static final String BOS_FORM_METADATA = "bos-form-metadata";
    private static final String SPAN_TYPE_FIELDEDIT = "FieldEdit";
    private static final String SPAN_TAG_FIELDKEY = "fieldKey";
    private static final String SPAN_TAG_VALUE = "value";
    private static final String DESENSITIZE_FIELD = "desensitizeField";
    private static final String CONTROLMETASTATE = "controlMetaState";
    private static final String POLICY = "policy";
    private static final String VISIBLE = "visible";
    private String fieldKey;
    private String entryKey;
    private String entryControlKey;
    private int gridMustInputIndex = -1;
    private boolean isGridMustInput = false;
    @SdkInternal
    protected IDataEntityProperty prop;
    private boolean is_FlatField;
    @SdkInternal
    protected String postErrorMessage;
    private LocaleString displayName;
    private IDataEntityProperty desenProp = null;
    private static final String POLICY_MUST_INPUT = "policy_FieldEdit";

    public Set<String> getFilterKeys() {
        HashSet<String> set = new HashSet<String>();
        set.add(this.getKey());
        return set;
    }

    public void postBack(Object value, int rowIndex, int parentRowIndex) {
        if (!this.postDataCheck(value)) {
            KDBizException e = new KDBizException(BosErrorCode.variableNotValid, new Object[]{this.postErrorMessage});
            HashMap<String, Object> tags = new HashMap<String, Object>(2);
            tags.put(SPAN_TAG_FIELDKEY, this.getFieldKey());
            tags.put(SPAN_TAG_VALUE, value);
            EntityTracer.throwException((String)SPAN_TYPE_FIELDEDIT, (String)"postBack", null, (Throwable)e, tags);
            throw e;
        }
        if (!this.checkEditFieldStatus()) {
            KDBizException e = new KDBizException(BosErrorCode.variableNotValid, new Object[]{String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u4fee\u6539\u9501\u5b9a\u5b57\u6bb5%s\u7684\u503c\u3002", (String)"FieldEdit_0", (String)BOS_FORM_METADATA, (Object[])new Object[0]), this.getDisplayName())});
            HashMap<String, Object> tags = new HashMap<String, Object>(2);
            tags.put(SPAN_TAG_FIELDKEY, this.getFieldKey());
            tags.put(SPAN_TAG_VALUE, value);
            EntityTracer.throwException((String)SPAN_TYPE_FIELDEDIT, (String)"postBack", null, (Throwable)e, tags);
            throw e;
        }
        this.view.getModel().setValue(this.getFieldKey(), value, rowIndex, parentRowIndex);
    }

    @KSMethod
    @SimplePropertyAttribute
    public String getFieldKey() {
        if (this.fieldKey == null) {
            this.fieldKey = this.key;
        }
        return this.fieldKey;
    }

    public boolean shouldSerializeFieldKey() {
        return !this.key.equals(this.fieldKey);
    }

    public void setFieldKey(String key) {
        this.fieldKey = key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bindData(BindingContext bctx) {
        Object v = this.getBindingValue(bctx);
        try (EntityTraceSpan span = null;){
            if (EntityTracer.isRealtime()) {
                span = EntityTracer.create((String)SPAN_TYPE_FIELDEDIT, (String)"getDesensitizeValue", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());
            }
            v = this.getDesensitizeValue(bctx, v);
        }
        boolean canRead = true;
        try (EntityTraceSpan spanCanRead = null;){
            if (EntityTracer.isRealtime()) {
                spanCanRead = EntityTracer.create((String)SPAN_TYPE_FIELDEDIT, (String)"canRead", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());
            }
            canRead = this.canRead();
        }
        if (!canRead) {
            v = v instanceof ILocaleValue ? new LocaleValue((Object)"******") : "******";
        }
        if (this.prop == null) {
            return;
        }
        this.sendUpdateAction(bctx, v);
    }

    protected void sendUpdateAction(BindingContext bctx, Object v) {
        if (this.prop.getParent() instanceof EntryType) {
            EntryGrid grid = this.getEntryGrid();
            if (grid instanceof EmbedSubEntryGrid) {
                ((EmbedSubEntryGrid)grid).getControlViewProxy().setEntryFieldValue(grid, this.getKey(), bctx.getRowIndex(), bctx.getParentRowIndex(), v);
            } else {
                this.clientViewProxy.setEntryFieldValue(grid, this.getKey(), bctx.getRowIndex(), v);
            }
        } else {
            this.clientViewProxy.setFieldProperty(this.getKey(), "v", v);
        }
    }

    protected Object getDesensitizeValue(BindingContext bctx, Object v) {
        IDataEntityProperty property = this.getDesensitizeProperty();
        if (property == null) {
            return v;
        }
        if (this.isDesensitizeField()) {
            String strategy;
            boolean isDesensitizedState = false;
            boolean canShowDetail = false;
            if (this.isDesensitized(bctx) && !"PLAINTEXT".equals(strategy = PrivacyCenterUtils.getDesensitizeStrategy((IDataEntityProperty)property, (String)"FORM", (DynamicObject)this.getModel().getDataEntity()))) {
                v = this.getDesensitizeValue(v);
                if (!(property.getParent() instanceof EntryType)) {
                    isDesensitizedState = true;
                }
                if ("CLICKVIEW".equals(strategy)) {
                    canShowDetail = true;
                }
            }
            if (StringUtils.isEmpty((CharSequence)this.getEntryKey())) {
                this.setDesensitizedState(bctx, isDesensitizedState, canShowDetail);
            } else {
                this.setEntryDesensitizedState(bctx, isDesensitizedState, canShowDetail);
            }
        }
        return v;
    }

    public Object getBindingValue(BindingContext bctx) {
        return this.getFieldValue(bctx);
    }

    protected Object getFieldValue(BindingContext bctx) {
        IDataEntityProperty property = this.getProperty();
        if (property == null) {
            return null;
        }
        return property.getValue(bctx.getDataEntity());
    }

    @KSMethod
    public IDataEntityProperty getProperty() {
        if (this.view == null) {
            return null;
        }
        if (this.prop == null && StringUtils.isNotBlank((CharSequence)this.getFieldKey())) {
            this.prop = ((IDataModel)this.view.getService(IDataModel.class)).getProperty(this.getFieldKey());
        }
        return this.prop;
    }

    @KSMethod
    public String getEntryKey() {
        return this.entryKey;
    }

    public void setEntryKey(String entryKey) {
        this.entryKey = entryKey;
    }

    @KSMethod
    public String getEntryControlKey() {
        return this.entryControlKey;
    }

    public void setEntryControlKey(String entryControlKey) {
        this.entryControlKey = entryControlKey;
    }

    private int getGridMustInputIndex() {
        if (this.gridMustInputIndex > -1) {
            return this.gridMustInputIndex;
        }
        return -1;
    }

    public void setGridMustInputIndex(int gridMustInputIndex) {
        this.gridMustInputIndex = gridMustInputIndex;
    }

    public boolean isGridMustInput() {
        return this.isGridMustInput;
    }

    public void setGridMustInput(boolean gridMustInput) {
        this.isGridMustInput = gridMustInput;
    }

    protected EntryGrid getEntryGrid() {
        EntryGrid grid = null;
        if (this.entryKey != null) {
            if (StringUtils.isNotBlank((CharSequence)this.entryControlKey)) {
                grid = (EntryGrid)this.view.getControl(this.getEntryControlKey());
            }
            if (grid == null) {
                grid = (EntryGrid)this.view.getControl(this.entryKey);
            }
        } else {
            grid = (EntryGrid)this.view.getControl(this.prop.getParent().getName());
        }
        return grid;
    }

    public void setVisible(String policy, boolean enable) {
        if (StringUtils.isBlank((CharSequence)policy)) {
            policy = "s";
        }
        if (this.getProperty().getParent() instanceof EntryType) {
            HashMap<String, Object> fieldMap = new HashMap<String, Object>();
            ArrayList<String> keys = new ArrayList<String>(1);
            keys.add(this.key);
            fieldMap.put("o", policy);
            fieldMap.put("k", keys);
            fieldMap.put("vi", enable);
            this.clientViewProxy.setVisibleState(this.entryKey, fieldMap);
        } else {
            HashMap<String, Object> visableMap = new HashMap<String, Object>();
            visableMap.put(POLICY, policy);
            visableMap.put(VISIBLE, enable);
            String[] keys = new String[]{this.getKey()};
            visableMap.put("keys", keys);
            this.clientViewProxy.addAction("setVisible", visableMap);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void oldsetVisible(String policy, boolean enable) {
        if (StringUtils.isBlank((CharSequence)policy)) {
            policy = "s";
        }
        if (this.getProperty().getParent() instanceof EntryType) {
            void var6_11;
            ArrayList visibleState = (ArrayList)this.clientViewProxy.getVisibleState(VISIBLE);
            Map<String, Object> policyMap = null;
            if (visibleState == null) {
                visibleState = new ArrayList();
                policyMap = new HashMap<String, Object>();
                policyMap.put("o", policy);
                policyMap.put("v", new ArrayList());
                visibleState.add(policyMap);
            }
            for (Map map : visibleState) {
                String oString = (String)map.get("o");
                if (!StringUtils.equals((CharSequence)oString, (CharSequence)policy)) continue;
                policyMap = map;
                break;
            }
            if (policyMap == null) {
                policyMap = new HashMap();
                policyMap.put("o", policy);
                policyMap.put("v", new ArrayList());
                visibleState.add(policyMap);
            }
            ArrayList keys = (ArrayList)policyMap.get("v");
            Object var6_9 = null;
            if (keys == null) {
                keys = new ArrayList();
            }
            for (Map map : keys) {
                String kString = (String)map.get("k");
                if (!StringUtils.equals((CharSequence)kString, (CharSequence)this.key)) continue;
                Map map2 = map;
                break;
            }
            if (var6_11 == null) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("k", this.key);
                hashMap.put("vi", enable);
                keys.add(hashMap);
            }
            this.clientViewProxy.invokeControlMethod(this.entryKey, VISIBLE, visibleState);
        } else {
            HashMap<String, Object> visableMap = new HashMap<String, Object>();
            visableMap.put(POLICY, StringUtils.isNotBlank((CharSequence)policy) ? policy : "");
            visableMap.put(VISIBLE, enable);
            String[] keys = new String[]{this.getKey()};
            visableMap.put("keys", keys);
            this.clientViewProxy.addAction("setVisible", visableMap);
        }
    }

    @KSMethod
    public void setEnable(String policy, boolean enable, int row) {
        if (StringUtils.isBlank((CharSequence)policy)) {
            policy = "s";
        }
        if (this.getProperty().getParent() instanceof EntryType) {
            HashMap<String, Object> fieldMap = new HashMap<String, Object>();
            fieldMap.put("o", policy);
            fieldMap.put("k", this.key);
            fieldMap.put("r", row);
            fieldMap.put("l", enable);
            this.clientViewProxy.setLockState(this.entryKey, fieldMap);
        } else {
            HashMap<String, Object> enableMap = new HashMap<String, Object>();
            enableMap.put(POLICY, policy);
            enableMap.put("enable", enable);
            String[] keys = new String[]{this.getKey()};
            enableMap.put("keys", keys);
            this.clientViewProxy.addAction("setEnable", enableMap);
        }
    }

    /*
     * WARNING - void declaration
     */
    @KSMethod
    public void oldsetEnable(String policy, boolean enable, int row) {
        if (StringUtils.isBlank((CharSequence)policy)) {
            policy = "s";
        }
        if (this.getProperty().getParent() instanceof EntryType) {
            void var9_19;
            void var7_14;
            List list;
            void var7_12;
            ArrayList lockState = (ArrayList)this.clientViewProxy.getLockState("lock");
            Map<String, Object> policyMap = null;
            if (lockState == null) {
                lockState = new ArrayList();
                policyMap = new HashMap<String, Object>();
                policyMap.put("o", policy);
                policyMap.put("v", new ArrayList());
                lockState.add(policyMap);
            }
            for (Map map : lockState) {
                String oString = (String)map.get("o");
                if (!StringUtils.equals((CharSequence)oString, (CharSequence)policy)) continue;
                policyMap = map;
                break;
            }
            if (policyMap == null) {
                policyMap = new HashMap();
                policyMap.put("o", policy);
                policyMap.put("v", new ArrayList());
                lockState.add(policyMap);
            }
            ArrayList keys = (ArrayList)policyMap.get("v");
            Object var7_10 = null;
            if (keys == null) {
                keys = new ArrayList();
            }
            for (Map map : keys) {
                String kString = (String)map.get("k");
                if (!StringUtils.equals((CharSequence)kString, (CharSequence)this.key)) continue;
                Map map2 = map;
                break;
            }
            String lock = String.valueOf(enable);
            if (var7_12 == null) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("k", this.key);
                hashMap.put("l", !enable);
                hashMap.put("r", new ArrayList());
                keys.add(hashMap);
            }
            if ((list = (List)var7_14.get("r")) == null) {
                ArrayList arrayList = new ArrayList();
                var7_14.put("r", arrayList);
            }
            var9_19.add(row);
            this.clientViewProxy.invokeControlMethod(this.entryKey, "lock", lockState);
        } else {
            HashMap<String, Object> enableMap = new HashMap<String, Object>();
            enableMap.put(POLICY, StringUtils.isNotBlank((CharSequence)policy) ? policy : "");
            enableMap.put("enable", enable);
            String[] keys = new String[]{this.getKey()};
            enableMap.put("keys", keys);
            this.clientViewProxy.addAction("setEnable", enableMap);
        }
    }

    @KSMethod
    public void setText(String text) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.setFieldProperty(this.getKey(), "text", text);
    }

    @KSMethod
    public void setMustInput(boolean value) {
        if (this.entryKey != null) {
            EntryGrid entryGrid = this.getEntryGrid();
            if (entryGrid instanceof CardEntry) {
                if (this.isGridMustInput() && this.getGridMustInputIndex() > -1) {
                    entryGrid.setChildMustInput(POLICY_MUST_INPUT, value, this.getGridMustInputIndex(), this.getKey());
                } else {
                    this.setMustInputClient(value);
                }
            } else if (StringUtils.isNotBlank((CharSequence)this.entryControlKey)) {
                if (this.isGridMustInput() && this.getGridMustInputIndex() > -1) {
                    entryGrid.setChildMustInput(POLICY_MUST_INPUT, value, this.getGridMustInputIndex(), this.getKey());
                } else {
                    this.clientViewProxy.invokeControlMethod(this.entryControlKey, "setColEditorProp", this.getKey(), "mi", value);
                }
            } else if (this.isGridMustInput() && this.getGridMustInputIndex() > -1) {
                entryGrid.setChildMustInput(POLICY_MUST_INPUT, value, this.getGridMustInputIndex(), this.getKey());
            } else {
                this.clientViewProxy.invokeControlMethod(this.entryKey, "setColEditorProp", this.getKey(), "mi", value);
            }
        } else {
            this.setMustInputClient(value);
        }
    }

    private void setMustInputClient(boolean value) {
        HashMap<String, Object> prop = new HashMap<String, Object>(1);
        prop.put("mi", value);
        HashMap<String, Boolean> editor = new HashMap<String, Boolean>(1);
        editor.put("mi", value);
        prop.put("item", editor);
        this.view.updateControlMetadata(this.getKey(), prop);
    }

    public void setFireEvtUp(boolean value) {
        HashMap<String, Object> prop = new HashMap<String, Object>(1);
        prop.put("fu", value);
        HashMap<String, Boolean> editor = new HashMap<String, Boolean>(1);
        editor.put("fu", value);
        prop.put("item", editor);
        this.view.updateControlMetadata(this.getKey(), prop);
    }

    @KSMethod
    public void setCaption(LocaleString caption) {
        if (this.entryKey != null) {
            this.clientViewProxy.invokeControlMethod(this.entryKey, "setColProp", this.getKey(), "header", caption);
        } else {
            HashMap<String, Object> prop = new HashMap<String, Object>(1);
            prop.put("caption", caption);
            this.view.updateControlMetadata(this.getKey(), prop);
        }
        this.clientViewProxy.setControlMetaState(this.getCaptionCacheKey(), "disn", caption);
    }

    private String getCaptionCacheKey() {
        return this.key + "." + "disn";
    }

    @KSMethod
    public void setFocus(boolean focus) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.setFieldProperty(this.getKey(), "focus", focus);
    }

    public List<Map<String, List<Object>>> getDefaultFilters() {
        ArrayList<Map<String, List<Object>>> defaultFilterList = new ArrayList<Map<String, List<Object>>>();
        if (this.getProperty().getParent() instanceof EntryType) {
            return defaultFilterList;
        }
        HashMap commonFilter = new HashMap();
        ArrayList<String> compareList = new ArrayList<String>();
        compareList.add(((IFieldHandle)this.getProperty()).getDefaultCompareTypeId());
        ArrayList<String> nameList = new ArrayList<String>();
        nameList.add(this.getFieldKey());
        ArrayList<Object> valueList = new ArrayList<Object>();
        valueList.add(this.getModel().getValue(this.getFieldKey()));
        commonFilter.put("FieldName", nameList);
        commonFilter.put("Value", valueList);
        commonFilter.put("Compare", compareList);
        defaultFilterList.add(commonFilter);
        return defaultFilterList;
    }

    @SimplePropertyAttribute
    public boolean isFlatField() {
        return this.is_FlatField;
    }

    public void setFlatField(boolean isFlatField) {
        this.is_FlatField = isFlatField;
    }

    protected boolean postDataCheck(Object value) {
        return true;
    }

    protected void addNewLineIfKeyField(int size, int rowIndex) {
        IDataEntityProperty property = this.getProperty();
        IDataEntityType propParentType = property.getParent();
        if (propParentType instanceof EntryType) {
            EntryType parent = (EntryType)propParentType;
            if (!parent.isQuickAdd()) {
                return;
            }
            EntryGrid grid = this.getEntryGrid();
            IDataModel model = (IDataModel)this.view.getService(IDataModel.class);
            int rowCount = model.getEntryRowCount(parent.getName());
            String keyField = parent.getKeyField();
            if (rowIndex + size >= rowCount && StringUtils.isNotBlank((CharSequence)keyField) && keyField.equals(property.getName())) {
                model.createNewEntryRow(parent.getName());
            }
        }
    }

    public boolean checkEditFieldStatus() {
        boolean checkCanEdit = true;
        Integer lock = this.getLockIntegerVal();
        if (!"true".equals(System.getProperty("checkfieldlock", "true"))) {
            return checkCanEdit;
        }
        try {
            int status = this.getView().getFormShowParameter().getStatusValue();
            BillStatusProp statusProp = null;
            Map<String, Object> metaStatusMap = this.clientViewProxy.getControlMetaState("status");
            if (metaStatusMap != null && metaStatusMap.containsKey("status")) {
                Object staObj = metaStatusMap.get("status");
                if (staObj instanceof Integer) {
                    status = (Integer)staObj;
                }
            } else {
                String billStatusKey;
                MainEntityType mainEntityType = this.getModel().getDataEntityType();
                if (mainEntityType instanceof BillEntityType && StringUtils.isNotBlank((CharSequence)(billStatusKey = ((BillEntityType)mainEntityType).getBillStatus()))) {
                    statusProp = (BillStatusProp)mainEntityType.getProperty(billStatusKey);
                }
                if (statusProp != null) {
                    String dbStatus = (String)statusProp.getValue((Object)this.getModel().getDataEntity());
                    status = this.convertStatus(dbStatus);
                }
            }
            Map<String, Object> controlMetaState = this.clientViewProxy.getControlMetaState(this.getFieldKey());
            if (status != -1) {
                if (this.getProperty() != null && this.getProperty().getParent() instanceof EntryType) {
                    if (controlMetaState == null) {
                        checkCanEdit = (lock & 2 << status - 1) <= 0;
                    }
                } else if (controlMetaState != null && controlMetaState.containsKey("lockControl")) {
                    checkCanEdit = (Boolean)controlMetaState.get("lockControl");
                } else if (controlMetaState != null && controlMetaState.containsKey("l")) {
                    Integer lockVal = (Integer)controlMetaState.get("l");
                    checkCanEdit = (lockVal & 2 << status - 1) <= 0;
                } else if (status == BillOperationStatus.VIEW.getValue()) {
                    checkCanEdit = false;
                } else if (!ObjectUtils.isEmpty((Object)lock)) {
                    checkCanEdit = (lock & (status == 0 ? 1 : 2 << status - 1)) <= 0;
                }
            } else if (controlMetaState != null && controlMetaState.containsKey("lockControl")) {
                checkCanEdit = (Boolean)controlMetaState.get("lockControl");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return checkCanEdit;
    }

    private int convertStatus(String status) {
        int result = 0;
        switch (status) {
            case "A": 
            case "new": {
                result = BillOperationStatus.ADDNEW.getValue();
                break;
            }
            case "edit": {
                result = BillOperationStatus.EDIT.getValue();
                break;
            }
            case "view": {
                result = BillOperationStatus.VIEW.getValue();
                break;
            }
            case "B": 
            case "submit": {
                result = BillOperationStatus.SUBMIT.getValue();
                break;
            }
            case "C": 
            case "audit": {
                result = BillOperationStatus.AUDIT.getValue();
                break;
            }
        }
        return result;
    }

    protected boolean canRead() {
        boolean b = true;
        Boolean skipCheck = (Boolean)this.getView().getFormShowParameter().getCustomParam("skipCheckFieldRule");
        if (skipCheck != null && skipCheck.booleanValue()) {
            return b;
        }
        FieldControlRule frule = (FieldControlRule)this.getView().getModel().getContextVariable("fieldControlRule");
        if (frule == null) {
            long userId = RequestContext.get().getCurrUserId();
            String mainOrg = this.getModel().getDataEntityType().getMainOrg();
            PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
            MainEntityType entityType = this.getModel().getDataEntityType();
            FieldControlRules fieldControlRules = permissionService.getFieldControlRules(userId, this.getView().getFormShowParameter().getCheckRightAppId(), entityType.getName());
            if (fieldControlRules != null) {
                MainEntityType dataEntityType = this.getModel().getDataEntityType();
                PermissionControlType permissionControlType = null == dataEntityType ? null : dataEntityType.getPermissionControlType();
                String dimension = null == permissionControlType ? "" : permissionControlType.getDimension();
                String dataDimensionField = null == permissionControlType ? "" : permissionControlType.getDataDimensionField();
                DynamicObject dyn = this.getModel().getDataEntity();
                DynamicObjectCollection doc = new DynamicObjectCollection();
                doc.add((Object)dyn);
                FieldControlRules2RuleReq req = new FieldControlRules2RuleReq(doc, fieldControlRules, mainOrg, dimension, dataDimensionField);
                PermRes fieldControlRuleMapPermRes = permissionService.fieldControlRules2RuleMap(req);
                Map fieldControlRuleMap = (Map)fieldControlRuleMapPermRes.getData();
                frule = (FieldControlRule)fieldControlRuleMap.get(String.valueOf(dyn.getPkValue()));
                if (null == frule || null == frule.getCanNotReadFields() || frule.getCanNotReadFields().isEmpty()) {
                    this.getView().getFormShowParameter().getCustomParams().put("skipCheckFieldRule", true);
                    return b;
                }
                this.getView().getModel().putContextVariable("fieldControlRule", (Object)frule);
            } else {
                this.getView().getFormShowParameter().getCustomParams().put("skipCheckFieldRule", true);
                return b;
            }
        }
        if (frule.getCanNotReadFields().contains(this.getFieldKey())) {
            b = false;
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDesensitizeField() {
        try (EntityTraceSpan span = null;){
            boolean isDesensitizeField;
            if (EntityTracer.isRealtime()) {
                span = EntityTracer.create((String)SPAN_TYPE_FIELDEDIT, (String)"isDesensitizeField", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());
            }
            IDataModel dataModel = this.getModel();
            IDataEntityProperty property = this.getDesensitizeProperty();
            if (dataModel == null || property == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = isDesensitizeField = PrivacyCenterUtils.isDesensitizeField((IDataEntityProperty)property, (String)Lang.get().toString(), (String)"FORM", (DynamicObject)dataModel.getDataEntity());
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDesensitized(BindingContext bctx) {
        try (EntityTraceSpan span = null;){
            String modelType;
            IDataEntityProperty property;
            if (EntityTracer.isRealtime()) {
                span = EntityTracer.create((String)SPAN_TYPE_FIELDEDIT, (String)"isDesensitized", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());
            }
            if ((property = this.getDesensitizeProperty()) == null || bctx == null || !this.isDesensitizeField()) {
                boolean bl = false;
                return bl;
            }
            boolean isCopy = false;
            if (!(this instanceof BasedataPropEdit || (modelType = this.getModelType()) == null || "form".equals(modelType) || "mobileform".equals(modelType) || OperationStatus.ADDNEW != this.getView().getFormShowParameter().getStatus())) {
                boolean bl = false;
                return bl;
            }
            Map<String, Object> viewState = null;
            IDataEntityType entity = property.getParent();
            if (entity instanceof EntryType && bctx.getDataEntity() instanceof DynamicObject) {
                if (bctx.getRowIndex() != -1) {
                    DynamicObject dObj = (DynamicObject)bctx.getDataEntity();
                    Object pkValue = this.getPkValue(dObj);
                    String modelType2 = this.getModelType();
                    if (bctx.getRowIndex() != -1 && pkValue == null && "form".equals(modelType2)) {
                        pkValue = bctx.getRowIndex();
                    }
                    if (pkValue != null) {
                        String key = this.getEntryKey() + "." + pkValue + "." + this.getKey();
                        if (entity instanceof SubEntryType && ((DynamicObject)bctx.getDataEntity()).getParent() instanceof DynamicObject && ((DynamicObject)bctx.getDataEntity()).getParent() instanceof DynamicObject) {
                            Object entryPK = this.getPkValue((DynamicObject)((DynamicObject)bctx.getDataEntity()).getParent());
                            if (bctx.getRowIndex() != -1 && entryPK == null && "form".equals(modelType2)) {
                                entryPK = ((DynamicObject)((DynamicObject)bctx.getDataEntity()).getParent()).get("seq");
                            }
                            key = key + "." + entryPK;
                        }
                        viewState = this.clientViewProxy.getControlMetaState(key);
                    }
                    if (viewState == null && modelType2 != null && !"form".equals(modelType2)) {
                        boolean isFromDataBase = ((DynamicObject)bctx.getDataEntity()).getDataEntityState().getFromDatabase();
                        if (!isCopy && !isFromDataBase && StringUtils.isNotEmpty((CharSequence)dObj.getDataEntityType().getAlias())) {
                            this.setEntryDesensitizedState(bctx, false, false);
                            boolean bl = false;
                            return bl;
                        }
                    }
                }
            } else {
                this.key = this.getKey();
                viewState = this.clientViewProxy.getControlMetaState(this.key);
            }
            boolean isDesensitize = true;
            if (viewState != null && Boolean.FALSE.equals(viewState.get("isprivacy"))) {
                isDesensitize = Boolean.FALSE;
            }
            boolean bl = isDesensitize;
            return bl;
        }
    }

    public Object getDesensitizeValue(Object clearText) {
        IDataEntityProperty property = this.getDesensitizeProperty();
        if (this.getModel() == null || property == null) {
            return clearText;
        }
        if (clearText instanceof Object[]) {
            for (int i = 0; i < ((Object[])clearText).length; ++i) {
                ((Object[])clearText)[i] = PrivacyCenterUtils.getDesensitizeValue((IDataEntityProperty)property, (String)Lang.get().toString(), (String)"FORM", (DynamicObject)this.getModel().getDataEntity(), (Object)((Object[])clearText)[i]);
            }
        } else {
            if (clearText != null && property instanceof ComboProp) {
                clearText = ((ComboProp)property).getItemByName((String)clearText);
            }
            clearText = PrivacyCenterUtils.getDesensitizeValue((IDataEntityProperty)property, (String)Lang.get().toString(), (String)"FORM", (DynamicObject)this.getModel().getDataEntity(), (Object)clearText);
        }
        return clearText;
    }

    public IDataEntityProperty getDesenPropByEntry() {
        return this.getDesensitizeProperty();
    }

    protected IDataEntityProperty getDesensitizeProperty() {
        IDataEntityProperty desenProperty;
        if (this.desenProp != null) {
            return this.desenProp;
        }
        IPrivacyService proxy = (IPrivacyService)this.getView().getService(IPrivacyService.class);
        if (proxy != null && (desenProperty = proxy.getDesenProp(this.getFieldKey())) != null) {
            this.desenProp = desenProperty;
            return this.desenProp;
        }
        return this.getProperty();
    }

    public void setDesensitizeField(DesensitizeField desensitizeField) {
        IPrivacyService proxy = (IPrivacyService)this.getView().getService(IPrivacyService.class);
        proxy.setDesensitizeField(this.getFieldKey(), desensitizeField);
    }

    public void getPlainText(Integer rowIndex) {
        BindingContext bctx = null;
        if (this.getEntryKey() != null) {
            IDataModel model = this.getModel();
            String entryKey = this.getEntryKey();
            if (model.useTableCache()) {
                DynamicObject[] filterEntryRows;
                ArrayList<Integer> rowIndexList = new ArrayList<Integer>(1);
                rowIndexList.add(rowIndex);
                List filterRows = model.getFilterIndexByRowKeys(entryKey, rowIndexList);
                if (filterRows != null && filterRows.size() > 0 && (filterEntryRows = model.getFilterEntryRows(this.getEntryKey(), ((Integer)filterRows.get(0)).intValue(), (Integer)filterRows.get(0) + 1)) != null && filterEntryRows.length > 0) {
                    DynamicObject dynamicObject = filterEntryRows[0];
                    bctx = new BindingContext(dynamicObject.getDataEntityType(), dynamicObject, (int)rowIndex);
                }
            } else {
                DynamicObjectCollection coll = model.getEntryEntity(entryKey);
                if (coll != null && !coll.isEmpty()) {
                    DynamicObject dynamicObject = (DynamicObject)coll.get(rowIndex - coll.getStartRowIndex());
                    bctx = new BindingContext(dynamicObject.getDataEntityType(), dynamicObject, (int)rowIndex);
                }
            }
        } else {
            bctx = new BindingContext(this.getModel().getDataEntity(), rowIndex);
        }
        boolean checkPermission = true;
        String checkPermissionStr = this.getView().getPageCache().get("privacy.checkpermission");
        if (StringUtils.isNotEmpty((CharSequence)checkPermissionStr)) {
            checkPermission = Boolean.parseBoolean(checkPermissionStr);
        }
        this.getPlainText(bctx, checkPermission);
        boolean setdesenstate = true;
        String setdesenstateStr = this.getView().getPageCache().get("privacy.setdesenstate");
        if (StringUtils.isNotEmpty((CharSequence)setdesenstateStr)) {
            setdesenstate = Boolean.parseBoolean(setdesenstateStr);
        }
        if (setdesenstate) {
            if (this.getEntryKey() != null) {
                this.setEntryDesensitizedState(bctx, false, false, false);
            } else {
                this.setDesensitizedState(bctx, false, false);
            }
        }
    }

    private void getPlainText(BindingContext bctx, boolean checkPermission) {
        IDataEntityProperty property = this.getDesensitizeProperty();
        if (bctx == null || property == null) {
            return;
        }
        if (checkPermission) {
            try {
                String operateTerminal = this.getView() instanceof IMobileView ? "MOBILE" : "PC";
                if (this.getModel() != null) {
                    PrivacyCenterUtils.checkDecryptPermission((IDataEntityProperty)property, (String)"FORM", (String)operateTerminal, (DynamicObject)this.getModel().getDataEntity());
                }
            }
            catch (KDException e) {
                if (PrivacyDataConstant.ERRORCODE.equals((Object)e.getErrorCode())) {
                    this.getView().showErrorNotification(e.getMessage());
                    return;
                }
                throw e;
            }
        }
        Object clearVal = this.getBindingValue(bctx);
        int rowIndex = bctx.getRowIndex();
        this.sendSetPlainText(clearVal, rowIndex);
    }

    private void setEntryDesensitizedState(BindingContext bctx, boolean isDesensitize, boolean canShowDetail) {
        this.setEntryDesensitizedState(bctx, isDesensitize, canShowDetail, true);
    }

    private void setEntryDesensitizedState(BindingContext bctx, boolean isDesensitize, boolean canShowDetail, boolean isAutoGetPlant) {
        int rowIndex = bctx.getRowIndex();
        String entryKey = this.getEntryKey();
        String fldKey = this.getKey();
        if (rowIndex == -1) {
            HashMap<String, Boolean> map = new HashMap<String, Boolean>(3);
            map.put("isprivacy", isDesensitize);
            map.put("canshowdetail", canShowDetail);
            if (this.getEntryGrid() instanceof CardEntry) {
                HashMap<String, HashMap<String, Boolean>> editor = new HashMap<String, HashMap<String, Boolean>>(1);
                editor.put("privacy", map);
                HashMap<String, Object> prop = new HashMap<String, Object>(1);
                prop.put("item", editor);
                this.view.updateControlMetadata(this.getKey(), prop);
            } else {
                this.clientViewProxy.invokeControlMethod(entryKey, "setColEditorProp", fldKey, "privacy", map);
            }
            return;
        }
        DynamicObject dObj = (DynamicObject)bctx.getDataEntity();
        Map<Object, Object> entryField = null;
        Object pkValue = this.getPkValue(dObj);
        String modelType = this.getModelType();
        if (bctx.getRowIndex() != -1 && pkValue == null && "form".equals(modelType)) {
            pkValue = bctx.getRowIndex();
        }
        String desenKey = null;
        if (pkValue != null) {
            desenKey = this.getEntryKey() + "." + pkValue + "." + this.getKey();
            if (bctx.getEntityEntityType() instanceof SubEntryType && ((DynamicObject)bctx.getDataEntity()).getParent() instanceof DynamicObject && ((DynamicObject)bctx.getDataEntity()).getParent() instanceof DynamicObject) {
                Object entryPkValue = this.getPkValue((DynamicObject)((DynamicObject)bctx.getDataEntity()).getParent());
                if (bctx.getRowIndex() != -1 && entryPkValue == null && "form".equals(modelType)) {
                    entryPkValue = ((DynamicObject)((DynamicObject)bctx.getDataEntity()).getParent()).get("seq");
                }
                desenKey = desenKey + "." + entryPkValue;
            }
            entryField = this.clientViewProxy.getControlMetaState(desenKey);
        }
        if (entryField == null) {
            entryField = new HashMap(3);
        }
        Boolean oriIsDesen = entryField.get("isprivacy") instanceof Boolean ? (Boolean)entryField.get("isprivacy") : Boolean.valueOf(true);
        if (isAutoGetPlant && !isDesensitize && rowIndex != -1) {
            this.getPlainText(bctx, false);
        }
        if (oriIsDesen.equals(isDesensitize)) {
            return;
        }
        if (pkValue != null) {
            this.clientViewProxy.setControlMetaState(desenKey, "isprivacy", isDesensitize);
        }
    }

    public void setDesensitizedState(BindingContext bctx, boolean isDesensitize, boolean canShowDetail) {
        if (StringUtils.isEmpty((CharSequence)this.getEntryKey())) {
            String fldKey = this.getKey();
            Map<String, Object> viewState = this.clientViewProxy.getControlMetaState(fldKey);
            if ("form".equals(this.getModelType()) || viewState == null || !Boolean.valueOf(isDesensitize).equals(viewState.get("isprivacy"))) {
                HashMap<String, Boolean> map = new HashMap<String, Boolean>(3);
                map.put("isprivacy", isDesensitize);
                map.put("canshowdetail", canShowDetail);
                HashMap<String, HashMap<String, Boolean>> privacyMap = new HashMap<String, HashMap<String, Boolean>>(3);
                privacyMap.put("privacy", map);
                HashMap<String, HashMap<String, HashMap<String, Boolean>>> ctl = new HashMap<String, HashMap<String, HashMap<String, Boolean>>>(3);
                ctl.put("item", privacyMap);
                ArrayList<Object> paras = new ArrayList<Object>(6);
                paras.add(fldKey);
                paras.add(ctl);
                this.clientViewProxy.addAction("updateControlMetadata", paras);
                this.clientViewProxy.setControlMetaState(fldKey, "isprivacy", isDesensitize);
            }
        } else {
            this.setEntryDesensitizedState(bctx, isDesensitize, canShowDetail);
        }
    }

    private void sendSetPlainText(Object clearVal, int rowIndex) {
        HashMap<String, Object> data = new HashMap<String, Object>(6);
        String key = null;
        if (this.getEntryKey() != null) {
            key = this.getEntryKey();
            ArrayList fieldstates = new ArrayList(3);
            HashMap<String, Object> tmp = new HashMap<String, Object>(6);
            tmp.put("v", clearVal);
            tmp.put("r", rowIndex);
            tmp.put("k", this.getKey());
            fieldstates.add(tmp);
            data.put("fieldstates", fieldstates);
        } else {
            key = this.key;
            data.put("v", clearVal);
        }
        this.clientViewProxy.invokeControlMethod(key, "setPlainText", data);
    }

    private Object getPkValue(DynamicObject dObj) {
        Object ret = null;
        Object pk = dObj.getPkValue();
        if (pk instanceof Long && (Long)pk != 0L) {
            ret = pk;
        }
        if (pk instanceof String && StringUtils.isNotEmpty((CharSequence)((String)pk))) {
            ret = pk;
        }
        return ret;
    }

    private String getModelType() {
        String modelType = null;
        if (this.getView() != null && this.getView().getFormShowParameter() != null && this.getView().getFormShowParameter().getFormConfig() != null) {
            modelType = this.getView().getFormShowParameter().getFormConfig().getModelType();
        }
        return modelType;
    }

    @SimplePropertyAttribute
    public LocaleString getDisplayName() {
        LocaleString displayName = this.displayName;
        if (this.clientViewProxy != null) {
            Map<String, Object> controlMetaState = this.clientViewProxy.getControlMetaState(this.getCaptionCacheKey());
            if (controlMetaState != null && controlMetaState.get("disn") instanceof Map) {
                displayName = LocaleString.fromMap((Map)((Map)controlMetaState.get("disn")));
            } else if ((displayName == null || StringUtils.isEmpty((CharSequence)displayName.toString())) && this.getProperty() != null) {
                displayName = this.getProperty().getDisplayName();
            }
        }
        return displayName;
    }

    public void setDisplayName(LocaleString displayName) {
        this.displayName = displayName;
    }
}

