/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.field;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceHint;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.FlexEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.flex.CreateFlexMetaArgs;
import kd.bos.entity.flex.FlexEntireData;
import kd.bos.entity.flex.FlexEntityMetaUtils;
import kd.bos.entity.flex.FlexProperty;
import kd.bos.entity.flex.FlexType;
import kd.bos.entity.nameversion.NameVersionService;
import kd.bos.entity.operate.GridConfigurationRow;
import kd.bos.entity.property.AssistantProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.flex.FlexService;
import kd.bos.form.BindingContext;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ControlTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.IMobileView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.EntryViewType;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FlexBeforeClosedEvent;
import kd.bos.form.field.AssistantFlexEdit;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.BasedataFlexEdit;
import kd.bos.form.field.OrgFlexEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.AfterBindingDataEvent;
import kd.bos.form.field.events.BasedataEditListener;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.FlexControlMetaPreRenderListener;
import kd.bos.form.field.events.ShowFlexEditEvent;
import kd.bos.form.field.events.ShowFlexEditListener;
import kd.bos.form.field.format.FlexValueFormatter;
import kd.bos.form.flex.AbstractFlexBasedataService;
import kd.bos.form.flex.FlexFormMetaUtils;
import kd.bos.form.flex.FlexSplitColsCache;
import kd.bos.form.flex.FlexSplitColumn;
import kd.bos.form.flex.FlexSplitStatus;
import kd.bos.form.flex.IFlexBasedataService;
import kd.bos.form.flex.IFlexEdit;
import kd.bos.form.flex.event.FlexControlMetaEvent;
import kd.bos.form.flex.event.FlexControlMetaPreRenderEvent;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.list.ListFilterParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.WithEntityEntryDistinctable;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.userconfig.GridConfigDAO;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.JSONUtils;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class FlexEdit
extends TextEdit
implements IFlexEdit,
ICloseCallBack {
    private static Log log = LogFactory.getLog(FlexEdit.class);
    private static final String SPAN_TYPE_PLUGIN = "plugin";
    int flexTypeId;
    private BasedataProp refBaseProp;
    private IDataModel flexModel;
    private boolean is_BasedataShowFrequent;
    private boolean batchInput;
    private boolean isNeedSplit;
    private FlexSplitColsCache flexSplitColsCache = null;
    private Map<ParentBDValue, MainEntityType> flexTypes = new HashMap<ParentBDValue, MainEntityType>();
    protected List<ShowFlexEditListener> showFlexEditListeners;
    protected List<FlexControlMetaPreRenderListener> flexControlMetaPreRenderListeners;
    protected List<BasedataEditListener> baseDataEditListeners;
    private static final String FLEX_EDIT = "FlexEdit";
    private static final String SUF_INITFLEXMODEL = "__initflexmodel";
    private static final String BOS_FORM_METADATA = "bos-form-metadata";
    private static final String SAVEFLEXDATA = "saveFlexData";
    private static final String CURRENTINDEX = "FlexEdit_CurrentIndex";
    private static final String SUFFIX_SPLIT_COLS = ".splitCols";
    private static final String SUFFIX_SPLIT_STATUS = ".splitStatus";
    private boolean defaultSplit = true;

    public IFlexBasedataService getFlexBasedataService() {
        FlexType flexType = FlexEntityMetaUtils.getFlexType((int)this.getFlexTypeId());
        if (StringUtils.isBlank((CharSequence)flexType.getBasedataService())) {
            return new AbstractFlexBasedataService();
        }
        Class cls = TypesContainer.getOrRegister((String)flexType.getBasedataService());
        IFlexBasedataService service = (IFlexBasedataService)TypesContainer.createInstance((Class)cls);
        return service;
    }

    @KSMethod
    public void addShowFlexEditListener(ShowFlexEditListener listener) {
        if (this.showFlexEditListeners == null) {
            this.showFlexEditListeners = new ArrayList<ShowFlexEditListener>();
        }
        this.showFlexEditListeners.add(listener);
    }

    @KSMethod
    public void addFlexControlMetaPreRenderListener(FlexControlMetaPreRenderListener listener) {
        if (this.flexControlMetaPreRenderListeners == null) {
            this.flexControlMetaPreRenderListeners = new ArrayList<FlexControlMetaPreRenderListener>();
        }
        this.flexControlMetaPreRenderListeners.add(listener);
    }

    @KSMethod
    public void registerBeforeF7SelectListener(BeforeF7SelectListener listener) {
        List<Control> list = this.getFlexControls();
        for (Control control : list) {
            BasedataEdit ctl;
            if (control instanceof BasedataFlexEdit) {
                ctl = (BasedataFlexEdit)this.getView().getControl(control.getKey());
                ctl.addBeforeF7SelectListener(listener);
                continue;
            }
            if (control instanceof AssistantFlexEdit) {
                ctl = (AssistantFlexEdit)this.getView().getControl(control.getKey());
                ctl.addBeforeF7SelectListener(listener);
                continue;
            }
            if (!(control instanceof OrgFlexEdit)) continue;
            ctl = (OrgFlexEdit)this.getView().getControl(control.getKey());
            ctl.addBeforeF7SelectListener(listener);
        }
    }

    @KSMethod
    public void addBaseDataEditListener(BasedataEditListener listener) {
        if (this.baseDataEditListeners == null) {
            this.baseDataEditListeners = new ArrayList<BasedataEditListener>();
        }
        this.baseDataEditListeners.add(listener);
    }

    @KSMethod
    public void registerBaseDataEditListeners(BasedataEditListener listener) {
        List<Control> controls = this.getFlexControls();
        for (Control control : controls) {
            BasedataEdit ctl;
            if (control instanceof BasedataFlexEdit) {
                ctl = (BasedataFlexEdit)this.getView().getControl(control.getKey());
                ctl.addBasedataEditListener(listener);
                continue;
            }
            if (control instanceof AssistantFlexEdit) {
                ctl = (AssistantFlexEdit)this.getView().getControl(control.getKey());
                ctl.addBasedataEditListener(listener);
                continue;
            }
            if (!(control instanceof OrgFlexEdit)) continue;
            ctl = (OrgFlexEdit)this.getView().getControl(control.getKey());
            ctl.addBasedataEditListener(listener);
        }
    }

    @KSMethod
    @SimplePropertyAttribute
    public int getFlexTypeId() {
        return this.flexTypeId;
    }

    public void setFlexTypeId(int flexTypeId) {
        this.flexTypeId = flexTypeId;
    }

    public void setBatchInput(boolean batchInput) {
        this.batchInput = batchInput;
    }

    @KSMethod
    @SimplePropertyAttribute(name="FlexBatchInput")
    public boolean getBatchInput() {
        return this.batchInput;
    }

    @SimplePropertyAttribute(name="ShowFrequent")
    public boolean isBasedataShowFrequent() {
        return this.is_BasedataShowFrequent;
    }

    public void setBasedataShowFrequent(boolean isBasedataShowFrequent) {
        this.is_BasedataShowFrequent = isBasedataShowFrequent;
    }

    @SimplePropertyAttribute(name="NeedSplit")
    @DefaultValueAttribute(value="false")
    public boolean isNeedSplit() {
        return this.isNeedSplit;
    }

    public void setNeedSplit(boolean isNeedSplit) {
        this.isNeedSplit = isNeedSplit;
    }

    @SimplePropertyAttribute(name="DefaultSplit")
    @DefaultValueAttribute(value="true")
    public boolean isDefaultSplit() {
        return this.defaultSplit;
    }

    public void setDefaultSplit(boolean defaultSplit) {
        this.defaultSplit = defaultSplit;
    }

    @Override
    public void postBack(Object value, int rowIndex, int parentRowIndex) {
    }

    @Override
    public void click() {
        BeforeClickEvent e = new BeforeClickEvent(this);
        this.fireBeforeClick(e);
        if (!e.isCancel() && this.isServerSideOpen()) {
            this.showFlexEdit();
        }
        ClickEvent ev = new ClickEvent(this);
        this.fireClick(ev);
    }

    public void viewDetail(Map<String, Object> param) {
        if (this.isServerSideOpen()) {
            if (this.isEntryProperty(this.getProperty())) {
                int rowIndex = (Integer)param.get("rowKey");
                this.getModel().setEntryCurrentRowIndex(this.getProperty().getParent().getName(), rowIndex);
            }
            this.showFlexEdit(true);
        }
    }

    public void batchInput() {
        int height;
        int width;
        int rowIndex = this.getCurrentRowIndex();
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        pageCache.put(CURRENTINDEX, String.valueOf(rowIndex));
        String baseKey = this.getRelateBasedataProp().getName();
        DynamicObject baseData = (DynamicObject)this.getModel().getValue(baseKey, rowIndex);
        if (baseData == null) {
            return;
        }
        List<Long> flexPropertyIds = this.getBasedataUsedFlexProperties(baseData);
        this.createShowFormFlexModel(baseData, rowIndex, flexPropertyIds);
        DynamicObject flexFieldData = (DynamicObject)this.getModel().getValue(this.getFieldKey(), rowIndex);
        String value = flexFieldData == null ? "" : flexFieldData.get("value");
        FormShowParameter para = new FormShowParameter();
        para.setShowTitle(false);
        para.setFormId("bos_flex_batchinput");
        int size = flexPropertyIds.size();
        if (size <= 4) {
            width = 290;
            height = size * 66 + 20 + 100;
        } else if (size <= 8) {
            width = 550;
            height = (int)Math.ceil((double)size / 2.0) * 66 + 20 + 100;
        } else {
            width = 560;
            height = 384;
        }
        StyleCss css = new StyleCss();
        css.setWidth(width + "px");
        css.setHeight(height + "px");
        para.getOpenStyle().setInlineStyleCss(css);
        para.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("flexTypeId", this.getFlexTypeId());
        map.put("flexEditKey", this.getKey());
        map.put("appId", this.getModel().getDataEntityType().getAppId());
        map.put("pageId", this.getView().getPageId());
        map.put("flexEditValue", value);
        map.put("flexEditDisplayName", this.getProperty().getDisplayName().getLocaleValue());
        map.put("flexPropertyIds", flexPropertyIds);
        Map<String, Object> metaMap = this.createFlexControlMeta(baseData, flexPropertyIds);
        List items = (List)((Map)((List)metaMap.get("items")).get(0)).get("items");
        map.put("flexPropertyMapList", items);
        para.setCustomParams(map);
        CloseCallBack closeCallBack = new CloseCallBack();
        closeCallBack.setActionId("batchInput");
        closeCallBack.setControlKey(this.getKey());
        para.setCloseCallBack(closeCallBack);
        this.getView().showForm(para);
    }

    public void getFlexItemFilter(String controlKey, String actionKey) throws IOException {
        try (EntityTraceSpan span = EntityTracer.create((String)FLEX_EDIT, (String)"getFlexItemFilter", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());){
            if (span.isRealtime()) {
                span.addTag("controlKey", controlKey);
                span.addTag("actionKey", actionKey);
            }
            Object ctl = this.getFlexControl(controlKey);
            ListFilterParameter listFilterParameter = ((BasedataEdit)ctl).createAndSetListShowParameter("click").getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            ArrayList listStr = new ArrayList();
            qFilters.forEach(x -> listStr.add(x.toSerializedString()));
            String actionResult = JSONUtils.toString(listStr);
            this.clientViewProxy.addAction(actionKey, actionResult);
            if (span.isRealtime()) {
                span.addTag("actionResult", actionResult);
            }
        }
    }

    private void batchInputCallBack(IDataModel model, List<Long> dataIds, FlexProp property, int rowIndex) {
        DynamicObject baseData = (DynamicObject)model.getValue(property.getBasePropertyKey(), rowIndex);
        BasedataEntityType baseDataType = (BasedataEntityType)baseData.getDataEntityType();
        Long baseDataId = (Long)baseData.get("id");
        model.loadReferenceDataBatch((DynamicObjectType)baseDataType, new Object[]{baseDataId});
        model.loadReferenceDataBatch(property.getFlexDataType(), dataIds.toArray());
        boolean updateView = "true".equals(this.getView().getPageCache().get("BOS.flexBatchInputUpdateView"));
        if (updateView) {
            model.beginInit();
        }
        int currentRow = rowIndex;
        for (Long dataId : dataIds) {
            if (currentRow != rowIndex) {
                currentRow = model.insertEntryRow(this.getEntryKey(), currentRow);
                model.setValue(property.getBasePropertyKey(), (Object)baseDataId, currentRow);
            }
            model.setValue(property.getName(), (Object)dataId, currentRow);
            ++currentRow;
        }
        int focusRow = currentRow != rowIndex ? currentRow - 1 : rowIndex;
        ((EntryGrid)this.getView().getControl(this.getEntryKey())).selectRows(focusRow);
        if (updateView) {
            model.endInit();
            this.getView().updateView(this.getEntryKey());
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        IDataModel model = (IDataModel)this.view.getService(IDataModel.class);
        FlexProp property = (FlexProp)this.getProperty();
        IDataEntityType propParentType = property.getParent();
        int rowIndex = model.getEntryCurrentRowIndex(property.getParent().getName());
        String actionId = e.getActionId();
        if ("batchInput".equals(actionId)) {
            List dataIds = (List)e.getReturnData();
            if (dataIds == null) {
                return;
            }
            this.batchInputCallBack(model, dataIds, property, rowIndex);
        } else {
            Integer flexDataId = (Integer)e.getReturnData();
            if (propParentType instanceof EntryType) {
                model.setValue(property.getName(), (Object)flexDataId, rowIndex);
            } else {
                model.setValue(property.getName(), (Object)flexDataId);
            }
        }
    }

    @Override
    public void bindData(BindingContext bctx) {
        super.bindData(bctx);
        this.bindFlexData(bctx);
    }

    @Override
    public Object getBindingValue(BindingContext bctx) {
        FlexProp flexProp = (FlexProp)this.getProperty();
        MainEntityType flexEntityType = this.getFlexEntityType((DynamicObject)bctx.getDataEntity());
        this.splitUnlock(bctx);
        return flexProp.getValue(flexEntityType, (DynamicObject)bctx.getDataEntity(), (type, value) -> this.getBaseData((DynamicObjectType)type, value, bctx), (v, bindValue) -> this.getBindingBaseDataByListener(v, (Object[])bindValue));
    }

    private void getBindingBaseDataByListener(Object v, Object[] bindValue) {
        if (this.baseDataEditListeners != null) {
            AfterBindingDataEvent evt = new AfterBindingDataEvent(this, v);
            for (BasedataEditListener l : this.baseDataEditListeners) {
                EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".afterBindingData"));
                Throwable throwable = null;
                try {
                    l.afterBindingData(evt);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (span == null) continue;
                    if (throwable != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    span.close();
                }
            }
            if (StringUtils.isNotBlank((Object)evt.getDisplayProp())) {
                bindValue[1] = evt.getDisplayProp();
            }
            if (StringUtils.isNotBlank((CharSequence)evt.getEditSearchProp())) {
                bindValue[2] = evt.getEditSearchProp();
            }
        }
    }

    protected DynamicObject getBaseData(DynamicObjectType basedataEntityType, Object masterId, BindingContext ctx) {
        FlexValueFormatter flexValueFormatter;
        Object[] pks;
        Object currentOrg;
        if (!(basedataEntityType instanceof BasedataEntityType)) {
            return null;
        }
        if (Boolean.getBoolean("flex.personal.enable") && (currentOrg = this.getMainOrg(ctx)) != null && (pks = this.getMasterIdToPK((BasedataEntityType)basedataEntityType, masterId)) != null && pks.length > 0) {
            for (Object pk : pks) {
                Map map = (Map)pk;
                Object currentPk = map.get(((DynamicObject)currentOrg).get("id"));
                if (currentPk == null) continue;
                masterId = currentPk;
                break;
            }
        }
        if ((flexValueFormatter = ctx.getFlexValueFormatter()) == null) {
            return this.loadReferenceData(basedataEntityType, masterId);
        }
        Object flexValue = this.getFieldValue(ctx);
        String flexId = null;
        String flexField = null;
        if (flexValue instanceof DynamicObject) {
            flexId = ((DynamicObject)flexValue).get("id").toString();
            Map flexMaps = (Map)SerializationUtils.fromJsonString((String)((DynamicObject)flexValue).get("value").toString(), Map.class);
            for (Map.Entry flexMap : flexMaps.entrySet()) {
                if (!masterId.equals(flexMap.getValue())) continue;
                flexField = (String)flexMap.getKey();
            }
        }
        DynamicObject data = flexValueFormatter.getFlexData(flexId, flexField, masterId, (BasedataEntityType)basedataEntityType);
        return this.loadReferenceData(basedataEntityType, data);
    }

    private DynamicObject loadReferenceData(DynamicObjectType dt, DynamicObject data) {
        Object date;
        String versionControl;
        if (data != null && NameVersionService.getInstance().enableNameVersionControl(dt.getName()) && StringUtils.isNotBlank((CharSequence)(versionControl = this.getModel().getDataEntityType().getVersionControl())) && (date = this.getModel().getValue(versionControl)) instanceof Date) {
            return NameVersionService.getInstance().getNameVersionData(data, (Date)date);
        }
        return data;
    }

    @SdkInternal
    protected DynamicObject loadReferenceData(DynamicObjectType dt, Object pkValue) {
        Object date;
        String versionControl;
        DynamicObject data = this.getModel().loadReferenceData(dt, pkValue);
        if (data != null && NameVersionService.getInstance().enableNameVersionControl(dt.getName()) && StringUtils.isNotBlank((CharSequence)(versionControl = this.getModel().getDataEntityType().getVersionControl())) && (date = this.getModel().getValue(versionControl)) instanceof Date) {
            return NameVersionService.getInstance().getNameVersionData(data, (Date)date);
        }
        return data;
    }

    private Object getMainOrg(BindingContext ctx) {
        if (ctx != null && ctx.getDataEntity() instanceof DynamicObject) {
            for (DynamicObject dataEntity = (DynamicObject)ctx.getDataEntity(); dataEntity != null; dataEntity = (DynamicObject)dataEntity.getParent()) {
                BillEntityType dataEntityType;
                MainOrgProp mainOrgProperty;
                if (dataEntity.getDataEntityType() instanceof BillEntityType && (mainOrgProperty = (dataEntityType = (BillEntityType)dataEntity.getDataEntityType()).getMainOrgProperty()) != null) {
                    return mainOrgProperty.getValue((Object)dataEntity);
                }
                if (dataEntity.getParent() == null || !(dataEntity.getParent() instanceof DynamicObject)) break;
            }
        }
        return null;
    }

    private Object[] getMasterIdToPK(BasedataEntityType basedataEntityType, Object masterId) {
        String entityName = basedataEntityType.getName();
        MainOrgProp orgProp = basedataEntityType.getMainOrgProperty();
        if (orgProp == null) {
            return null;
        }
        ArrayList idList = new ArrayList();
        QFilter[] filters = new QFilter[]{new QFilter(basedataEntityType.getMasteridPropName(), "=", masterId)};
        try (DataSet ds = this.getOrm().queryDataSet("FlexEdit.getMasterIdToPK", entityName, "id," + orgProp.getName(), filters, null, -1, (Distinctable)WithEntityEntryDistinctable.get());){
            ds.forEach(row -> {
                HashMap<Object, Object> map = new HashMap<Object, Object>();
                map.put(row.get(1), row.get(0));
                idList.add(map);
            });
        }
        return idList.toArray();
    }

    @SdkInternal
    protected ORM getOrm() {
        return ORM.create();
    }

    @SdkInternal
    protected DynamicObjectType getSubEntityType(String entityName, String selectProperties) {
        String[] properties = selectProperties.split(",");
        HashSet<String> select = new HashSet<String>(properties.length);
        for (String prop : properties) {
            select.add(prop.trim());
        }
        return EntityMetadataCache.getSubDataEntityType((String)entityName, select);
    }

    @Override
    public <T extends Control> T getFlexControl(String key) {
        int rowIndex = this.getCurrentRowIndex();
        return this.getFlexControl(key, rowIndex);
    }

    @Override
    public List<Control> getFlexControls() {
        int rowIndex = this.getCurrentRowIndex();
        return this.getFlexControls(rowIndex);
    }

    @Override
    public <T extends Control> T getFlexControl(String key, int row) {
        List<Control> list = this.getFlexControls(row);
        String fullKey = String.format("$$%s__%s", this.getKey(), key);
        for (Control control : list) {
            if (!fullKey.equals(control.getKey())) continue;
            control.setView(this.getView());
            control.setModel(this.getModel());
            return (T)control;
        }
        return null;
    }

    private List<Control> getFlexControls(int rowIndex) {
        List<Long> flexPropertyIds = this.baseUsedFlexPropertyIds(rowIndex);
        if (flexPropertyIds.isEmpty()) {
            return new ArrayList<Control>();
        }
        String formId = this.getView().getFormShowParameter().getFormId();
        CreateFlexMetaArgs args = this.getFlexMetaArgs(formId, flexPropertyIds);
        return FlexFormMetaUtils.getFlexControl(args);
    }

    @Override
    public IDataModel getFlexModel() {
        int rowIndex;
        if (this.flexModel != null && this.flexModel.getDataEntityType() != MainEntityType.Empty) {
            return this.flexModel;
        }
        if (this.isServerSideOpen()) {
            IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
            String cacheValue = pageCache.get(CURRENTINDEX);
            if (cacheValue == null) {
                rowIndex = this.getCurrentRowIndex();
            } else {
                boolean isMerge;
                rowIndex = this.splitEnable() ? ((isMerge = String.valueOf(FlexSplitStatus.Merge.getStatus()).equals(this.getView().getPageCache().get(this.getKey() + SUFFIX_SPLIT_STATUS))) ? Integer.parseInt(cacheValue) : this.getCurrentRowIndex()) : Integer.parseInt(cacheValue);
                if (rowIndex != this.getCurrentRowIndex()) {
                    log.warn(String.format("flex debug: FlexEdit getFlexModel()  CurrentRowIndex are not equal. currentrow: %s,  getCurrentRowIndex(): %s", cacheValue, this.getCurrentRowIndex()));
                    FlexEntityMetaUtils.outLog((String)FLEX_EDIT, (String)"getFlexModel", (String)"flex debug: FlexEdit getFlexModel()  CurrentRowIndex are not equal. ");
                }
            }
        } else {
            rowIndex = this.getCurrentRowIndex();
        }
        return this.getFlexModel(rowIndex);
    }

    public void tryCloseFlexible(Map<String, Object> map) {
        String accountId;
        String type;
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(null, new DistributeCacheHAPolicy(true, true));
        String isFlexEdit = (String)cache.get(type = String.format("%s_%s_isFlexEdit", accountId = CacheKeyUtil.getAcctId(), this.view.getPageId()), this.getKey() + "_isFlexEdit");
        if (isFlexEdit == null) {
            int row = -1;
            if (map != null && map.get("r") != null) {
                row = (Integer)map.get("r");
            }
            this.saveFlexData(row);
            this.closeFlexPanel(map);
            if (this.isServerSideOpen()) {
                this.release();
            }
        } else {
            FlexEntityMetaUtils.outLog((String)FLEX_EDIT, (String)"tryCloseFlexible", (String)"flex debug: FlexEdit tryCloseFlexible()  pop-up form is not closed. ");
        }
    }

    @Override
    public void release() {
        try {
            IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
            if (this.isEntryProperty(this.getProperty())) {
                if (FlexEntityMetaUtils.isFlexCacheRelease()) {
                    this.releaseFlexModelNew();
                } else {
                    int rowCount = this.getModel().getEntryRowCount(this.getProperty().getParent().getName());
                    HashMap<String, String> map = new HashMap<String, String>(16);
                    for (int i = 0; i < rowCount; ++i) {
                        this.releaseFlexModel(i);
                    }
                    if (map.size() > 0) {
                        pageCache.put(map);
                    }
                }
            } else {
                this.releaseFlexModel(-1);
            }
            pageCache.remove(this.getKey() + SUF_INITFLEXMODEL);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void releaseFlexModelNew() {
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        String initRows = pageCache.get(this.getKey() + SUF_INITFLEXMODEL);
        if (StringUtils.isNotBlank((CharSequence)initRows)) {
            String[] rowindexes = initRows.split(",");
            this.releaseFlex(rowindexes);
        }
    }

    private void releaseFlex(String[] rowindexes) {
        ArrayList<String> keys = new ArrayList<String>(10);
        for (String row : rowindexes) {
            String entityTypeName = this.key + "__" + row;
            String cacheKey = String.format("%s.%s.%s", CacheKeyUtil.getAcctId(), entityTypeName, this.getView().getPageId());
            keys.add(cacheKey);
        }
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("formmodel", new DistributeCacheHAPolicy(true, true));
        cache.remove(keys.toArray(new String[keys.size()]));
        if (FlexEntityMetaUtils.isOutLog()) {
            String formId = this.getView().getFormShowParameter().getFormId();
            try {
                DynamicObjectCollection coll = this.getModel().getEntryEntity(this.getEntryKey());
                if (coll != null) {
                    StringBuilder sb = new StringBuilder();
                    int count = 0;
                    for (int i = 0; i < coll.size(); ++i) {
                        String entityTypeName = this.key + "__" + i;
                        String cacheKey = String.format("%s.%s.%s", CacheKeyUtil.getAcctId(), entityTypeName, this.getView().getPageId());
                        Object o = cache.get(cacheKey);
                        if (o == null) continue;
                        sb.append(i).append(",");
                        ++count;
                    }
                    Object pk = this.getModel().getDataEntity().getPkValue();
                    FlexEntityMetaUtils.outLog((String)FLEX_EDIT, (String)"releaseFlex", (String)String.format("%s release failed, count:%s, pk:%s", formId, count, pk));
                }
            }
            catch (Exception e) {
                FlexEntityMetaUtils.outLog((String)FLEX_EDIT, (String)"releaseFlex", (String)String.format("%s release outlog error:%s", formId, e.getMessage()));
            }
        }
    }

    private void releaseFlexModel(int rowIndex) {
        List<Long> flexPropertyIds = this.baseUsedFlexPropertyIds(rowIndex);
        String formId = this.getView().getFormShowParameter().getFormId();
        MainEntityType met = MainEntityType.Empty;
        if (!flexPropertyIds.isEmpty()) {
            met = FlexEntityMetaUtils.getBasedataPropFlexEntityType((String)formId, (String)this.getKey(), (int)this.getFlexTypeId(), flexPropertyIds);
            met.setName(this.key + "__" + rowIndex);
        }
        IDataModel model = this.view.createFlexModel(null, met);
        model.release();
        this.flexModel = null;
    }

    public IDataModel getFlexModel(int rowIndex) {
        IPageCache pageCache;
        String initRows;
        boolean isInit;
        List<Long> flexPropertyIds = this.baseUsedFlexPropertyIds(rowIndex);
        String formId = this.getView().getFormShowParameter().getFormId();
        if (flexPropertyIds.isEmpty()) {
            this.flexModel = this.view.createFlexModel(this.flexModel, MainEntityType.Empty);
            return this.flexModel;
        }
        FlexEntityType met = FlexEntityMetaUtils.getBasedataPropFlexEntityType((String)formId, (String)this.getKey(), (int)this.getFlexTypeId(), flexPropertyIds);
        if (!this.isServerSideOpen()) {
            met.setName(this.key + "__" + rowIndex);
        }
        this.flexModel = this.view.createFlexModel(this.flexModel, (MainEntityType)met);
        if (FlexEntityMetaUtils.isOutLog()) {
            DataEntityPropertyCollection properties = met.getProperties();
            StringBuilder debugStr = new StringBuilder();
            try {
                for (IDataEntityProperty prop1 : properties) {
                    debugStr.append(prop1.getName()).append(":{");
                    if (prop1 instanceof OrgProp) {
                        String func = ((OrgProp)prop1).getOrgFunc();
                        debugStr.append("func:").append(func);
                    }
                    debugStr.append("}");
                }
                debugStr.append(System.lineSeparator());
            }
            catch (Exception e) {
                debugStr.append("getFlexModel debug error:").append(e.getMessage());
            }
            log.info(String.format("FlexEdit - getFlexModel createFlexModel: met:%s, index:%d", debugStr.toString(), rowIndex));
        }
        if (!(isInit = this.flexModelIsInit(rowIndex, initRows = (pageCache = (IPageCache)this.getView().getService(IPageCache.class)).get(this.getKey() + SUF_INITFLEXMODEL)))) {
            this.flexModel.beginInit();
            Object flexValue = this.getModel().getValue(this.getFieldKey(), rowIndex);
            if (flexValue != null) {
                DynamicObject flexData = this.createFlexDataDynamicObject((DynamicObject)flexValue, (MainEntityType)met);
                this.flexModel.createNewData((Object)flexData);
            } else {
                this.flexModel.createNewData();
            }
            this.flexModel.endInit();
            this.flexModel.updateCache();
            if (FlexEntityMetaUtils.isOutLog()) {
                StringBuilder errData = new StringBuilder(200);
                errData.append("pageid=").append(this.getView().getPageId()).append("--");
                errData.append("thiskey=").append(this.getKey()).append("--");
                errData.append("rowindex=").append(rowIndex).append("--");
                IDataModel model = (IDataModel)this.view.getService(IDataModel.class);
                String baseKey = this.getRelateBasedataProp().getName();
                DynamicObject baseData = this.isEntryProperty(this.prop) ? (DynamicObject)model.getValue(baseKey, rowIndex) : (DynamicObject)model.getValue(baseKey);
                if (baseData != null) {
                    errData.append("baseDataid=").append(baseData.getPkValue()).append("--");
                }
                errData.append("flexPropertyIds=");
                for (Long long1 : flexPropertyIds) {
                    errData.append(long1).append(",");
                }
                errData.append("--");
                if (flexValue != null) {
                    errData.append("flexValue=").append(DataEntitySerializer.serializerToString((Object)flexValue, (DataEntitySerializerOption)FlexEdit.debugSerializerOption())).append("--");
                    errData.append("flexdata=").append(DataEntitySerializer.serializerToString((Object)flexValue, (DataEntitySerializerOption)FlexEdit.debugSerializerOption())).append("--");
                }
                errData.append("type=").append(ControlTypes.toJsonString(met)).append("--");
                errData.append("model.getDataEntityType=").append(ControlTypes.toJsonString(this.flexModel.getDataEntityType()));
                FlexEntityMetaUtils.outLog((String)FLEX_EDIT, (String)"createFlexEdit", (String)errData.toString());
            }
            if (StringUtils.isBlank((CharSequence)initRows)) {
                pageCache.put(this.getKey() + SUF_INITFLEXMODEL, String.valueOf(rowIndex));
            } else {
                pageCache.put(this.getKey() + SUF_INITFLEXMODEL, initRows + "," + rowIndex);
            }
        }
        return this.flexModel;
    }

    private boolean flexModelIsInit(int rowIndex, String initRows) {
        boolean isInit = false;
        if (StringUtils.isNotBlank((CharSequence)initRows)) {
            String[] rowindexes;
            for (String idx : rowindexes = initRows.split(",")) {
                if (Integer.parseInt(idx) != rowIndex) continue;
                isInit = true;
                break;
            }
        }
        return isInit;
    }

    public void createFlexEdit(DynamicObject baseData, int rowIndex) {
        if (this.isServerSideOpen()) {
            return;
        }
        if (baseData == null) {
            this.flexModel = this.view.createFlexModel(this.flexModel, MainEntityType.Empty);
            this.sendFlexMeta(null, null, rowIndex);
            return;
        }
        DynamicObject flexData = (DynamicObject)this.getModel().getValue(this.getFieldKey(), rowIndex);
        List<Long> flexPropertyIds = this.getBasedataUsedFlexProperties(baseData);
        if (flexPropertyIds.isEmpty()) {
            this.flexModel = this.view.createFlexModel(this.flexModel, MainEntityType.Empty);
            this.sendFlexMeta(null, null, rowIndex);
            return;
        }
        String formId = this.getView().getFormShowParameter().getFormId();
        FlexEntityType met = FlexEntityMetaUtils.getBasedataPropFlexEntityType((String)formId, (String)this.getKey(), (int)this.getFlexTypeId(), flexPropertyIds);
        met.setName(this.key + "__" + rowIndex);
        this.flexModel = this.view.createFlexModel(this.flexModel, (MainEntityType)met);
        DynamicObject flexValueObject = this.createFlexDataDynamicObject(flexData, (MainEntityType)met);
        this.flexModel.beginInit();
        if (flexValueObject == null) {
            this.flexModel.createNewData();
        } else {
            this.flexModel.createNewData((Object)flexValueObject);
        }
        this.flexModel.endInit();
        this.flexModel.updateCache();
        if (FlexEntityMetaUtils.isOutLog()) {
            StringBuilder errData = new StringBuilder(200);
            errData.append("pageid=").append(this.getView().getPageId()).append("--");
            errData.append("thiskey=").append(this.getKey()).append("--");
            errData.append("rowindex=").append(rowIndex).append("--");
            errData.append("baseDataid=").append(baseData.getPkValue()).append("--");
            errData.append("flexPropertyIds=");
            for (Long long1 : flexPropertyIds) {
                errData.append(long1).append(",");
            }
            errData.append("--");
            if (flexValueObject != null) {
                errData.append("flexValue=").append(DataEntitySerializer.serializerToString((Object)flexData, (DataEntitySerializerOption)FlexEdit.debugSerializerOption())).append("--");
                errData.append("data=").append(DataEntitySerializer.serializerToString((Object)flexValueObject, (DataEntitySerializerOption)FlexEdit.debugSerializerOption())).append("--");
            }
            errData.append("type=").append(ControlTypes.toJsonString(met)).append("--");
            errData.append("model.getDataEntityType=").append(ControlTypes.toJsonString(this.flexModel.getDataEntityType()));
            FlexEntityMetaUtils.outLog((String)FLEX_EDIT, (String)"createFlexEdit", (String)errData.toString());
        }
        Map<String, Object> dataMap = FlexEdit.createBaseEditFlexClientData(met, flexValueObject);
        Map<String, Object> clientFormMeta = this.getFlexMeta(baseData, flexPropertyIds);
        this.sendFlexMeta(clientFormMeta, dataMap, rowIndex);
    }

    private void saveFlexData(int row) {
        DynamicObject data;
        IDataModel fModel = this.getFlexModel(row);
        MainEntityType modelEntityType = fModel.getDataEntityType();
        try {
            data = fModel.getDataEntity();
        }
        catch (Exception e) {
            Object data2 = null;
            fModel.createNewData();
            fModel.updateCache();
            String err = e.getMessage();
            if (StringUtils.isBlank((CharSequence)err)) {
                err = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            }
            this.view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f39\u6027\u57df\u6570\u636e\u4fdd\u5b58\u9519\u8bef\uff0crow=%1$s\u3002\u9519\u8bef\u4fe1\u606f\uff1a%2$s", (String)"FlexEdit_0", (String)BOS_FORM_METADATA, (Object[])new Object[0]), row + 1, err));
            return;
        }
        MainEntityType entityType = (MainEntityType)data.getDataEntityType();
        StringBuilder debugStr = new StringBuilder();
        debugStr.append("row:").append(row);
        if (entityType == null) {
            debugStr.append("entityType is null");
        }
        if (entityType != null && entityType.equals((Object)MainEntityType.Empty)) {
            debugStr.append("entityType is Empty");
        }
        if (entityType == null || entityType.equals((Object)MainEntityType.Empty)) {
            this.getModel().setValue(this.prop.getName(), null, row);
            return;
        }
        int modelPropSize = modelEntityType.getProperties().size();
        int propSize = entityType.getProperties().size();
        debugStr.append("propSize:").append(entityType.getProperties().size());
        if (modelPropSize != propSize) {
            FlexEntityMetaUtils.outLog((String)FLEX_EDIT, (String)SAVEFLEXDATA, (String)ResManager.loadKDString((String)"flex Error: \u6a21\u578b\u7c7b\u578b\u4e0e\u6570\u636e\u7c7b\u578b\u4e0d\u4e00\u81f4\uff01", (String)"FlexEdit_1", (String)BOS_FORM_METADATA, (Object[])new Object[0]));
        }
        FlexEntireData fet = new FlexEntireData();
        try {
            fet.setFlexData(entityType, data);
            debugStr.append("------save before:     ");
            if (entityType == null || entityType.equals((Object)MainEntityType.Empty)) {
                debugStr.append("entityType == null");
            } else {
                debugStr.append(ControlTypes.toJsonString(entityType));
                if (entityType.getPrimaryKey() == null) {
                    debugStr.append("   ;   entityType.getPrimaryKey() == null");
                }
            }
            Long id = FlexService.saveFlexData((MainEntityType)entityType, (FlexEntireData)fet);
            debugStr.append("------save after:     ");
            if (entityType == null || entityType.equals((Object)MainEntityType.Empty)) {
                debugStr.append("entityType == null");
            } else {
                debugStr.append(ControlTypes.toJsonString(entityType));
                if (entityType.getPrimaryKey() == null) {
                    debugStr.append("   ;   entityType.getPrimaryKey() == null");
                }
            }
            if (entityType instanceof FlexEntityType) {
                FlexService.addRefrenceCount((FlexEntityType)((FlexEntityType)entityType), (DynamicObject[])new DynamicObject[]{data});
                DataEntityCacheManager cacheManager = new DataEntityCacheManager((IDataEntityType)entityType);
                cacheManager.removeByPrimaryKey(new Object[]{id});
            }
            entityType.getPrimaryKey().setValue((Object)data, (Object)id);
            Map map = fet.getFlexValue();
            this.setFlexFieldValue(id, row, map);
        }
        catch (Exception e) {
            String errData = fet.concatFlexData();
            if (StringUtils.isBlank((CharSequence)errData) && data != null) {
                errData = DataEntitySerializer.serializerToString((Object)data, (DataEntitySerializerOption)FlexEdit.debugSerializerOption());
            }
            fModel.createNewData();
            data = null;
            fModel.updateCache();
            log.error("\u5f39\u6027\u57df\u6570\u636e\u4fdd\u5b58\u9519\u8bef", (Throwable)e);
            FlexEntityMetaUtils.outLog((String)FLEX_EDIT, (String)SAVEFLEXDATA, (String)String.format(ResManager.loadKDString((String)"save error, \u4fdd\u5b58\u524d debugstr\uff1a%s", (String)"FlexEdit_2", (String)BOS_FORM_METADATA, (Object[])new Object[0]), debugStr.toString()));
            String entityTypeStr = "";
            if (entityType == null || entityType.equals((Object)MainEntityType.Empty)) {
                FlexEntityMetaUtils.outLog((String)FLEX_EDIT, (String)SAVEFLEXDATA, (String)String.format("save error, row(start 0):%s, errData:%s, entityType is null", row, errData));
            } else {
                entityTypeStr = ControlTypes.toJsonString(entityType);
                if (entityType.getPrimaryKey() == null) {
                    entityTypeStr = entityTypeStr + " ;  entityType.getPrimaryKey() == null  ";
                }
                FlexEntityMetaUtils.outLog((String)FLEX_EDIT, (String)SAVEFLEXDATA, (String)String.format("save error, row(start 0):%s, errData:%s, entityType:%s", row, errData, entityTypeStr));
            }
            String err = e.getMessage();
            if (StringUtils.isBlank((CharSequence)err)) {
                err = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            }
            this.view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f39\u6027\u57df\u6570\u636e\u4fdd\u5b58\u9519\u8bef\uff0crow=%1$s\u3002\u9519\u8bef\u4fe1\u606f\uff1a%2$s", (String)"FlexEdit_0", (String)BOS_FORM_METADATA, (Object[])new Object[0]), row + 1, err));
        }
    }

    public void setFlexModelValue(Object value, int rowIndex) {
        if (value != null) {
            DynamicObject dynamicObject = null;
            if (!(value instanceof DynamicObject)) {
                DynamicObjectType dt = ((FlexProp)this.getProperty()).getFlexDataType();
                Map mapObjects = this.getModel().loadReferenceDataBatch(dt, new Object[]{value});
                dynamicObject = (DynamicObject)mapObjects.get(value);
            } else {
                dynamicObject = (DynamicObject)value;
            }
            IDataModel dm = this.getFlexModel(rowIndex);
            FlexEntityType fet = (FlexEntityType)dm.getDataEntityType();
            DynamicObject d = this.createFlexDataDynamicObject(dynamicObject, (MainEntityType)fet);
            dm.createNewData((Object)d);
            dm.updateCache();
        }
    }

    private void setFlexFieldValue(long id, int row, Map<String, Object> map) {
        DynamicObject flexObj = (DynamicObject)((FlexProp)this.prop).getComplexType().createInstance();
        flexObj.set("id", (Object)id);
        String val = SerializationUtils.toJsonString(map);
        flexObj.set("value", (Object)val);
        this.getModel().setValue(this.prop.getName(), (Object)flexObj, row);
    }

    private void bindFlexData(BindingContext bctx) {
        if (this.prop == null) {
            return;
        }
        DynamicObject row = (DynamicObject)bctx.getDataEntity();
        DynamicObject baseData = (DynamicObject)this.getRelateBasedataProp().getValue((Object)row);
        if (baseData == null) {
            this.flexModel = this.view.createFlexModel(this.flexModel, MainEntityType.Empty);
            this.sendFlexMeta(null, null, bctx.getRowIndex());
            return;
        }
    }

    private DynamicObject createFlexDataDynamicObject(DynamicObject flexData, MainEntityType flexEntityType) {
        if (flexData == null) {
            return null;
        }
        DynamicObject flexValueObject = (DynamicObject)flexEntityType.createInstance();
        String val = (String)flexData.get("value");
        Map map = (Map)SerializationUtils.fromJsonString((String)val, HashMap.class);
        for (Map.Entry keyVal : map.entrySet()) {
            DynamicObject flexBaseObj;
            Long pk;
            DynamicObjectType dt;
            Object value = keyVal.getValue();
            String flexFieldKey = this.getFlexKey((String)keyVal.getKey());
            DynamicProperty flexFieldProp = flexEntityType.getProperty(flexFieldKey);
            if (flexFieldProp == null) {
                return flexValueObject;
            }
            if (flexFieldProp instanceof BasedataProp) {
                dt = (DynamicObjectType)((BasedataProp)flexFieldProp).getComplexType();
                pk = null;
                pk = value instanceof Integer ? Long.valueOf(((Integer)value).longValue()) : (Long)value;
                flexBaseObj = this.getModel().loadReferenceData(dt, (Object)pk);
                flexValueObject.set(flexFieldKey, (Object)flexBaseObj);
                continue;
            }
            if (flexFieldProp instanceof AssistantProp) {
                dt = (DynamicObjectType)((AssistantProp)flexFieldProp).getComplexType();
                pk = null;
                pk = value instanceof Integer ? Long.valueOf(((Integer)value).longValue()) : value;
                flexBaseObj = this.getModel().loadReferenceData(dt, (Object)pk);
                flexValueObject.set(flexFieldKey, (Object)flexBaseObj);
                continue;
            }
            flexValueObject.set(flexFieldKey, value);
        }
        return flexValueObject;
    }

    private void sendFlexMeta(Map<String, Object> clientFormMeta, Object data, int row) {
        if (this.isEntryProperty(this.getProperty())) {
            if (data == null) {
                return;
            }
            HashMap<String, Object> updateFlexMeta = new HashMap<String, Object>();
            updateFlexMeta.put("k", this.prop.getName());
            updateFlexMeta.put("r", row);
            updateFlexMeta.put("flexMeta", clientFormMeta);
            this.clientViewProxy.invokeControlMethod(this.getEntryControlKey(), "updateFlexMeta", updateFlexMeta);
        } else {
            this.clientViewProxy.setFieldProperty(this.key, "flexMeta", clientFormMeta);
            this.clientViewProxy.setFieldProperty(this.key, "hasFlex", true);
        }
    }

    private List<Long> baseUsedFlexPropertyIds(int rowIndex) {
        IDataModel model = (IDataModel)this.view.getService(IDataModel.class);
        String baseKey = this.getRelateBasedataProp().getName();
        DynamicObject obj = this.isEntryProperty(this.prop) ? (DynamicObject)model.getValue(baseKey, rowIndex) : (DynamicObject)model.getValue(baseKey);
        if (obj != null) {
            return this.getBasedataUsedFlexProperties(obj);
        }
        return new ArrayList<Long>();
    }

    private String getFlexKey(String key) {
        return String.format("$$%s__%s", this.getKey(), key);
    }

    private static Map<String, Object> createBaseEditFlexClientData(FlexEntityType entityType, DynamicObject data) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (IDataEntityProperty prop : entityType.getProperties()) {
            Object arr;
            if (data == null && (prop instanceof BasedataProp || prop instanceof AssistantProp || prop instanceof TextProp)) {
                map.put(prop.getName(), "");
                continue;
            }
            if (prop instanceof BasedataProp) {
                arr = FlexEdit.getBasedataDisplayVal((BasedataProp)prop, (DynamicObject)prop.getValue((Object)data));
                map.put(prop.getName(), arr);
                continue;
            }
            if (prop instanceof AssistantProp) {
                arr = FlexEdit.getBasedataDisplayVal((BasedataProp)((AssistantProp)prop), (DynamicObject)prop.getValue((Object)data));
                map.put(prop.getName(), arr);
                continue;
            }
            if (!(prop instanceof TextProp)) continue;
            Object text = prop.getValue((Object)data);
            map.put(prop.getName(), text);
        }
        return map;
    }

    private static Object getBasedataDisplayVal(BasedataProp prop, DynamicObject data) {
        IDataEntityProperty p3;
        IDataEntityProperty p2;
        Object[] arr = new Object[3];
        BasedataEntityType dt = (BasedataEntityType)prop.getComplexType();
        String nameKey = dt.getNameProperty();
        String numberKey = dt.getNumberProperty();
        IDataEntityProperty p1 = dt.findProperty(numberKey);
        if (p1 != null && data != null) {
            arr[0] = p1.getValueFast((Object)data);
        }
        if ((p2 = dt.findProperty(nameKey)) != null && data != null) {
            arr[1] = p2.getValueFast((Object)data);
            if (arr[1] instanceof ILocaleString) {
                arr[1] = arr[1].toString();
            }
        }
        if (StringUtils.isBlank((CharSequence)nameKey)) {
            arr[0] = arr[1];
        }
        if ((p3 = dt.findProperty("name".equals(prop.getEditSearchProp()) ? nameKey : numberKey)) != null && data != null) {
            arr[2] = p3.getValueFast((Object)data);
            if (arr[2] instanceof ILocaleString) {
                arr[2] = arr[2].toString();
            }
        }
        return arr;
    }

    private void closeFlexPanel(Map<String, Object> map) {
        FormViewPluginProxy pluginProxy = (FormViewPluginProxy)this.getView().getService(FormViewPluginProxy.class);
        FlexBeforeClosedEvent event = new FlexBeforeClosedEvent(this.getView());
        String baseKey = this.getRelateBasedataProp().getName();
        event.setBasedataKey(baseKey);
        event.setFlexKey(this.prop.getName());
        pluginProxy.fireFlexBeforeClosed(event);
        if (event.isCancel()) {
            return;
        }
        if (this.isEntryProperty(this.prop)) {
            String entryKey = this.prop.getParent().getName();
            this.clientViewProxy.invokeControlMethod(entryKey, "closeFlexible", map);
        } else {
            this.clientViewProxy.invokeControlMethod(this.getKey(), "closeFlexible", map);
        }
    }

    private MainEntityType getFlexEntityType(DynamicObject dataEntity) {
        BasedataProp refBDProp = this.getRelateBasedataProp();
        DynamicObject baseData = (DynamicObject)refBDProp.getValue((Object)dataEntity);
        if (baseData == null) {
            return MainEntityType.Empty;
        }
        Object bdPKValue = baseData.getPkValue();
        ParentBDValue parentBDValue = new ParentBDValue(baseData.getDataEntityType().getName(), bdPKValue);
        MainEntityType flexType = this.flexTypes.get(parentBDValue);
        if (flexType != null) {
            return flexType;
        }
        List<Long> flexPropertyIds = this.getBasedataUsedFlexProperties(baseData);
        if (flexPropertyIds.isEmpty()) {
            flexType = MainEntityType.Empty;
        } else {
            String entityKey = this.getModel().getDataEntityType().getName();
            flexType = FlexEntityMetaUtils.getBasedataPropFlexEntityType((String)entityKey, (String)this.getKey(), (int)this.getFlexTypeId(), flexPropertyIds);
        }
        this.flexTypes.put(parentBDValue, flexType);
        return flexType;
    }

    private void showFlexEdit() {
        this.showFlexEdit(false);
    }

    private void showFlexEdit(boolean isAllLock) {
        int rowIndex = this.getCurrentRowIndex();
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        pageCache.put(CURRENTINDEX, String.valueOf(rowIndex));
        String baseKey = this.getRelateBasedataProp().getName();
        DynamicObject baseData = (DynamicObject)this.getModel().getValue(baseKey, rowIndex);
        List<Long> flexPropertyIds = this.getBasedataUsedFlexProperties(baseData);
        this.createShowFormFlexModel(baseData, rowIndex, flexPropertyIds);
        ShowFlexEditEvent evt = new ShowFlexEditEvent(this, rowIndex, baseKey);
        if (this.showFlexEditListeners != null) {
            for (ShowFlexEditListener l : this.showFlexEditListeners) {
                EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".showFlexEdit"));
                Throwable throwable = null;
                try {
                    l.showFlexEdit(evt);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (span == null) continue;
                    if (throwable != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    span.close();
                }
            }
            if (evt.isCancel()) {
                return;
            }
        }
        Map<String, Object> clientFormMeta = this.getFlexMeta(baseData, flexPropertyIds);
        if (isAllLock) {
            clientFormMeta.put("l", 55);
        }
        if (this.isEntryProperty(this.getProperty())) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("r", rowIndex);
            map.put("k", this.key);
            map.put("flexMeta", clientFormMeta);
            this.clientViewProxy.invokeControlMethod(this.getEntryControlKey(), "showFlexible", map);
        } else {
            this.clientViewProxy.invokeControlMethod(this.key, "showFlexible", clientFormMeta);
        }
    }

    private IDataModel createShowFormFlexModel(DynamicObject baseData, int rowIndex, List<Long> flexPropertyIds) {
        if (baseData == null || flexPropertyIds.isEmpty()) {
            this.flexModel = this.view.createFlexModel(null, MainEntityType.Empty);
            return this.flexModel;
        }
        DynamicObject flexData = (DynamicObject)this.getModel().getValue(this.getFieldKey(), rowIndex);
        String formId = this.getView().getFormShowParameter().getFormId();
        if (FlexEntityMetaUtils.isOutLog()) {
            StringBuilder debugStr = new StringBuilder();
            Object relateBDPKValue = baseData.getPkValue();
            debugStr.append(relateBDPKValue.toString()).append(":");
            try {
                for (Long id : flexPropertyIds) {
                    debugStr.append(id).append(",");
                }
                debugStr.append(System.lineSeparator());
            }
            catch (Exception e) {
                debugStr.append("getFlexModel debug error:").append(e.getMessage());
            }
            log.info(String.format("FlexEdit - createShowFormFlexModel getFieldKey:%s, getFlexTypeId:%d, flexPropertyIds: %s", this.getFieldKey(), this.getFlexTypeId(), debugStr.toString()));
        }
        FlexEntityType met = FlexEntityMetaUtils.getBasedataPropFlexEntityType((String)formId, (String)this.getKey(), (int)this.getFlexTypeId(), flexPropertyIds);
        this.flexModel = this.view.createFlexModel(null, (MainEntityType)met);
        this.flexModel.beginInit();
        if (flexData == null) {
            this.flexModel.createNewData();
        } else {
            DynamicObject flexValueObject = this.createFlexDataDynamicObject(flexData, (MainEntityType)met);
            this.flexModel.createNewData((Object)flexValueObject);
        }
        this.flexModel.endInit();
        this.flexModel.updateCache();
        return this.flexModel;
    }

    private boolean isEntryProperty(IDataEntityProperty property) {
        IDataEntityType propParentType = property.getParent();
        return propParentType instanceof EntryType;
    }

    private int getCurrentRowIndex() {
        int rowIndex = -1;
        if (this.isEntryProperty(this.getProperty())) {
            rowIndex = this.getModel().getEntryCurrentRowIndex(this.getProperty().getParent().getName());
        }
        return rowIndex;
    }

    private BasedataProp getRelateBasedataProp() {
        if (this.refBaseProp == null) {
            String baseKey = ((FlexProp)this.getProperty()).getBasePropertyKey();
            if (StringUtils.isEmpty((CharSequence)baseKey)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\uff1a\u5173\u8054\u7684\u57fa\u7840\u8d44\u6599\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FlexEdit_3", (String)BOS_FORM_METADATA, (Object[])new Object[0]), this.getDisplayName().getDefaultItem()));
            }
            this.refBaseProp = (BasedataProp)this.getModel().getProperty(baseKey);
        }
        return this.refBaseProp;
    }

    private Map<String, Object> createFlexControlMeta(DynamicObject baseData, List<Long> flexPropertyIds) {
        String formId = this.getView().getFormShowParameter().getFormId();
        CreateFlexMetaArgs flexMetaArgs = this.getFlexMetaArgs(formId, flexPropertyIds);
        Map<String, Object> map = FlexFormMetaUtils.getClientFormMeta(flexMetaArgs);
        List items = (List)((Map)((List)map.get("items")).get(0)).get("items");
        FlexControlMetaEvent args = new FlexControlMetaEvent(this, formId, this.getKey(), baseData, flexPropertyIds);
        args.setItems(items);
        this.getFlexBasedataService().createFlexControlMetas(args);
        if (this.flexControlMetaPreRenderListeners != null) {
            FlexControlMetaPreRenderEvent flexControlMetaPreRenderEvent = new FlexControlMetaPreRenderEvent(this, formId, this.getKey(), baseData, flexPropertyIds);
            flexControlMetaPreRenderEvent.setItems(items);
            for (FlexControlMetaPreRenderListener l : this.flexControlMetaPreRenderListeners) {
                EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".flexMetaListener"));
                Throwable throwable = null;
                try {
                    l.flexControlMetaPreRender(flexControlMetaPreRenderEvent);
                    log.info(String.format("FlexEdit - flexControlMetaPreRenderEvent getFieldKey:%s, getFlexTypeId:%d, flexControlMeta: %s", this.getFieldKey(), this.getFlexTypeId(), SerializationUtils.toJsonString((Object)items)));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (span == null) continue;
                    if (throwable != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    span.close();
                }
            }
        }
        return map;
    }

    private Map<String, Object> getFlexMeta(DynamicObject baseData, List<Long> flexPropertyIds) {
        Map<String, Object> map = this.createFlexControlMeta(baseData, flexPropertyIds);
        List items = (List)((Map)((List)map.get("items")).get(0)).get("items");
        if (this.getView() instanceof IMobileView && this.isEntryProperty(this.getProperty())) {
            for (Map map2 : items) {
                map2.put("type", "cardfield");
                map2.put("header", map2.get("caption"));
                map2.put("dataIndex", map2.get("id"));
            }
        }
        return map;
    }

    private List<Long> getBasedataUsedFlexProperties(DynamicObject baseData) {
        if (baseData == null) {
            return new ArrayList<Long>();
        }
        BasedataProp relateBDProp = this.getRelateBasedataProp();
        BasedataEntityType relateBDType = (BasedataEntityType)relateBDProp.getComplexType();
        String relateBDEntityNumber = relateBDProp.getBaseEntityId();
        Object relateBDPKValue = baseData.getPkValue();
        String relateBDFlexPropertyKey = relateBDType.getFlexProperty();
        if (StringUtils.isBlank((CharSequence)relateBDType.getFlexProperty()) && relateBDType.getMasteridType() == 2) {
            BasedataProp masterProp = (BasedataProp)relateBDType.getProperty(relateBDType.getMasteridPropName());
            relateBDFlexPropertyKey = ((BasedataEntityType)masterProp.getComplexType()).getFlexProperty();
            relateBDEntityNumber = masterProp.getBaseEntityId();
            DynamicObject masterObj = (DynamicObject)masterProp.getValue((Object)baseData);
            if (masterObj == null) {
                return new ArrayList<Long>();
            }
            relateBDPKValue = masterObj.getPkValue();
        }
        return FlexService.getBaseUseFlexProperties((String)relateBDEntityNumber, (Object)relateBDPKValue, (String)relateBDFlexPropertyKey);
    }

    private static DataEntitySerializerOption debugSerializerOption() {
        DataEntitySerializerOption option = new DataEntitySerializerOption();
        option.setIncludeComplexProperty(false);
        option.setIncludeCollectionProperty(false);
        option.setIncludeDataEntityState(false);
        return option;
    }

    private CreateFlexMetaArgs getFlexMetaArgs(String formId, List<Long> flexPropertyIds) {
        CreateFlexMetaArgs args = new CreateFlexMetaArgs(formId, this.getKey(), this.getFlexTypeId(), flexPropertyIds);
        if (this.isBasedataShowFrequent()) {
            args.setShowFrequentIds(flexPropertyIds);
        }
        return args;
    }

    private boolean isServerSideOpen() {
        return !(this.getView() instanceof IMobileView);
    }

    public void splitShow() {
        EntryGrid entryGrid;
        block12: {
            if (!this.splitEnable()) {
                return;
            }
            entryGrid = (EntryGrid)this.getView().getControl(this.getEntryControlKey());
            BasedataProp relateBDProp = this.getRelateBasedataProp();
            try {
                relateBDProp.getFlexPropertyKey();
            }
            catch (KDException e) {
                if (e.getErrorCode() != BosErrorCode.findPropertyFailed) break block12;
                return;
            }
        }
        List flexProperties = FlexEntityMetaUtils.getFlexProperties((int)this.getFlexTypeId());
        ArrayList<Long> flexPropertyIds = new ArrayList<Long>(10);
        LinkedHashMap<String, Long> flexPropKeyIdMap = new LinkedHashMap<String, Long>(16);
        for (FlexProperty property : flexProperties) {
            Long flexPropertyId = property.getId();
            flexPropertyIds.add(flexPropertyId);
            flexPropKeyIdMap.put(String.format("$$%s__%s", this.getKey(), property.getFlexField()), flexPropertyId);
        }
        String formId = this.getView().getFormShowParameter().getFormId();
        CreateFlexMetaArgs flexMetaArgs = this.getFlexMetaArgs(formId, flexPropertyIds);
        Map<Object, Object> clientFormMeta = new HashMap(16);
        try {
            clientFormMeta = FlexFormMetaUtils.getClientFormMeta(flexMetaArgs);
        }
        catch (Exception e) {
            log.error("\u5f39\u6027\u57df\u62c6\u5206\u663e\u793a\u83b7\u53d6\u62c6\u5206\u5c5e\u6027\u9519\u8bef", (Throwable)e);
        }
        if (clientFormMeta == null || clientFormMeta.isEmpty()) {
            return;
        }
        LinkedHashMap<Object, Map<String, Object>> newItemMap = new LinkedHashMap<Object, Map<String, Object>>(16);
        ArrayList<FlexSplitColumn> splitColumns = new ArrayList<FlexSplitColumn>(10);
        List items = (List)((Map)((List)clientFormMeta.get("items")).get(0)).get("items");
        for (Map item : items) {
            Object id = item.get("id");
            Object caption = item.get("caption");
            if (StringUtils.isNotBlank(id) && flexPropKeyIdMap.containsKey(id)) {
                FlexSplitColumn splitColumn = new FlexSplitColumn(id, (LocaleString)caption, (Long)flexPropKeyIdMap.get(id));
                splitColumns.add(splitColumn);
            }
            HashMap<String, Serializable> newItem = new HashMap<String, Serializable>(item);
            newItem.put("editor", new HashMap((Map)item.get("item")));
            newItem.put("dataIndex", (Serializable)id);
            newItem.put("l", Integer.valueOf(55));
            newItem.put("header", (Serializable)caption);
            newItem.remove("item");
            newItem.remove("id");
            newItem.remove("caption");
            if (entryGrid != null && entryGrid.isServerFilterModle()) {
                newItem.put("sort", Boolean.valueOf(false));
                newItem.put("filter", Boolean.valueOf(false));
            }
            newItemMap.putIfAbsent(id, newItem);
        }
        String pageCacheKey = this.getKey() + SUFFIX_SPLIT_COLS;
        FlexSplitColsCache splitColsCache = new FlexSplitColsCache();
        if (!splitColumns.isEmpty()) {
            splitColsCache.setSplitColumns(splitColumns);
        }
        List<Map<String, Object>> newItems = this.getFlexSplitItems(newItemMap);
        this.getView().getPageCache().put(pageCacheKey, SerializationUtils.toJsonString((Object)splitColsCache));
        if (newItems == null) {
            this.getView().getPageCache().put(this.getKey() + SUFFIX_SPLIT_STATUS, String.valueOf(FlexSplitStatus.Merge.getStatus()));
        }
        this.clientViewProxy.removeInvokeControlMethod(parameter -> this.getEntryControlKey().equals(parameter.getkey()) && "setColProp".equals(parameter.getmethodname()) && this.getKey().equals(parameter.getkey()));
        this.clientViewProxy.invokeControlMethod(this.getEntryControlKey(), "setColProp", this.getKey(), "children", newItems);
    }

    private List<Map<String, Object>> getFlexSplitItems(Map<Object, Map<String, Object>> newItemMap) {
        GridConfigDAO gridConfigDAO = new GridConfigDAO();
        List configurationRows = gridConfigDAO.getGridConfig(this.view.getFormShowParameter().getFormId(), this.getEntryControlKey());
        GridConfigurationRow flexConfigRow = this.findFlexConfigRow(configurationRows);
        ArrayList<Map<String, Object>> newItems = new ArrayList<Map<String, Object>>(newItemMap.values());
        if (flexConfigRow == null) {
            if (!this.isDefaultSplit()) {
                return null;
            }
            return newItems;
        }
        FlexSplitStatus status = FlexSplitStatus.valueOf(flexConfigRow.getFlexSplit());
        if (status == FlexSplitStatus.NoSet && !this.isDefaultSplit() || status == FlexSplitStatus.Merge) {
            return null;
        }
        List childSplitColumns = flexConfigRow.getChildren();
        int hideItemCount = 0;
        for (Map map : newItems) {
            for (GridConfigurationRow gridChildRow : childSplitColumns) {
                if (!StringUtils.equals((CharSequence)gridChildRow.getFieldKey(), (CharSequence)String.valueOf(map.get("dataIndex")))) continue;
                if (gridChildRow.isHide()) {
                    map.put("vi", 0);
                    ++hideItemCount;
                }
                if (!StringUtils.isNotBlank((CharSequence)gridChildRow.getTextAlign())) continue;
                map.put("text-align", gridChildRow.getTextAlign());
            }
        }
        if (hideItemCount == newItems.size()) {
            new ArrayList(0);
        }
        ArrayList<Map<String, Object>> newItems2 = new ArrayList<Map<String, Object>>();
        for (GridConfigurationRow gridChildRow : childSplitColumns) {
            for (Map map : newItems) {
                if (!StringUtils.equals((CharSequence)gridChildRow.getFieldKey(), (CharSequence)String.valueOf(map.get("dataIndex")))) continue;
                newItems2.add(map);
            }
        }
        if (childSplitColumns.size() == newItems.size()) {
            return newItems2;
        }
        return newItems;
    }

    private GridConfigurationRow findFlexConfigRow(List<GridConfigurationRow> configurationRows) {
        for (GridConfigurationRow configurationRow : configurationRows) {
            GridConfigurationRow subCtl;
            if (StringUtils.equals((CharSequence)this.getKey(), (CharSequence)configurationRow.getFieldKey())) {
                return configurationRow;
            }
            if (configurationRow.getChildren() == null || configurationRow.getChildren().isEmpty() || (subCtl = this.findFlexConfigRow(configurationRow.getChildren())) == null || !StringUtils.equals((CharSequence)this.getKey(), (CharSequence)subCtl.getFieldKey())) continue;
            return subCtl;
        }
        return null;
    }

    public void splitUnlock(BindingContext bctx) {
        if (!this.splitEnable()) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)this.getEntryControlKey())) {
            String cacheKey = String.format("%s_%s", this.getEntryControlKey(), "FlexSplitChange");
            if ("true".equals(this.getView().getPageCache().get(cacheKey))) {
                return;
            }
        }
        int rowIndex = bctx.getRowIndex();
        String flexSplitCols = this.getView().getPageCache().get(this.getKey() + SUFFIX_SPLIT_COLS);
        if (StringUtils.isNotBlank((CharSequence)flexSplitCols) && this.flexSplitColsCache == null) {
            this.flexSplitColsCache = (FlexSplitColsCache)SerializationUtils.fromJsonString((String)flexSplitCols, FlexSplitColsCache.class);
        }
        if (this.flexSplitColsCache == null || this.flexSplitColsCache.getSplitColumns().isEmpty()) {
            return;
        }
        List<FlexSplitColumn> cachedSplitColumns = this.flexSplitColsCache.getSplitColumns();
        Map<Object, Object> basePkFlexSplitCols = new LinkedHashMap();
        if (bctx.getFlexValueFormatter() != null) {
            basePkFlexSplitCols = bctx.getFlexValueFormatter().getBasePkFlexSplitCols(this.getRelateBasedataProp().getBaseEntityId());
        }
        LinkedHashMap<String, Serializable> map = new LinkedHashMap<String, Serializable>(16);
        if (rowIndex == -1) {
            map.put("r", Integer.valueOf(-1));
            this.clientViewProxy.setFlexSplitLockState(this.getEntryControlKey(), map);
            int rowCount = this.getModel().getEntryRowCount(this.getProperty().getParent().getName());
            if (this.isFlexEditLock(rowIndex)) {
                map.put("k", new HashSet(0));
                for (int i = 0; i < rowCount; ++i) {
                    map.put("r", Integer.valueOf(i));
                    this.clientViewProxy.setFlexSplitLockState(this.getEntryControlKey(), map);
                }
                return;
            }
            for (int i = 0; i < rowCount; ++i) {
                LinkedHashSet<String> dataIndex = new LinkedHashSet<String>(16);
                DynamicObject baseData = (DynamicObject)this.getModel().getValue(this.getRelateBasedataProp().getName(), i);
                if (baseData == null || baseData.getPkValue() == null) continue;
                List splitFlexPropertyIds = basePkFlexSplitCols != null && basePkFlexSplitCols.get(baseData) != null ? (List)basePkFlexSplitCols.get(baseData) : this.getBasedataUsedFlexProperties(baseData);
                ArrayList<FlexSplitColumn> splitColumns = new ArrayList<FlexSplitColumn>();
                for (FlexSplitColumn cachedSplitColumn : cachedSplitColumns) {
                    if (!splitFlexPropertyIds.contains(cachedSplitColumn.getFlexPropId())) continue;
                    splitColumns.add(cachedSplitColumn);
                }
                for (FlexSplitColumn splitColumn : splitColumns) {
                    dataIndex.add((String)splitColumn.getDataIndex());
                }
                map.put("k", dataIndex);
                map.put("r", Integer.valueOf(i));
                this.clientViewProxy.setFlexSplitLockState(this.getEntryControlKey(), map);
            }
            return;
        }
        if (this.isFlexEditLock(rowIndex)) {
            map.put("r", Integer.valueOf(-1));
            this.clientViewProxy.setFlexSplitLockState(this.getEntryControlKey(), map);
            int rowCount = this.getModel().getEntryRowCount(this.getProperty().getParent().getName());
            map.put("k", new HashSet(0));
            for (int i = 0; i < rowCount; ++i) {
                map.put("r", Integer.valueOf(i));
                this.clientViewProxy.setFlexSplitLockState(this.getEntryControlKey(), map);
            }
            return;
        }
        LinkedHashSet<String> dataIndex = new LinkedHashSet<String>(16);
        DynamicObject baseData = (DynamicObject)this.getModel().getValue(this.getRelateBasedataProp().getName(), rowIndex);
        if (baseData != null && baseData.getPkValue() != null) {
            List splitFlexPropertyIds = basePkFlexSplitCols != null && basePkFlexSplitCols.get(baseData) != null ? (List)basePkFlexSplitCols.get(baseData) : this.getBasedataUsedFlexProperties(baseData);
            ArrayList<FlexSplitColumn> splitColumns = new ArrayList<FlexSplitColumn>();
            for (FlexSplitColumn cachedSplitColumn : cachedSplitColumns) {
                if (!splitFlexPropertyIds.contains(cachedSplitColumn.getFlexPropId())) continue;
                splitColumns.add(cachedSplitColumn);
            }
            for (FlexSplitColumn splitColumn : splitColumns) {
                dataIndex.add((String)splitColumn.getDataIndex());
            }
        }
        map.put("k", dataIndex);
        map.put("r", Integer.valueOf(rowIndex));
        this.clientViewProxy.setFlexSplitLockState(this.getEntryControlKey(), map);
    }

    private boolean isFlexEditLock(int rowIndex) {
        IDataEntityProperty property;
        int statusVal;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        int n = statusVal = this.getView() instanceof IBillView ? ((BillShowParameter)formShowParameter).getBillStatus().getValue() : formShowParameter.getStatus().getValue();
        if (rowIndex == -1 && (property = this.getModel().getProperty("billstatus")) != null && this.getView() instanceof IBillView) {
            if (this.getView().getFormShowParameter().getStatus() == OperationStatus.VIEW) {
                statusVal = 2;
            } else {
                String value = (String)this.getModel().getValue("billstatus");
                if ("A".equals(value)) {
                    boolean bFromDb = this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
                    statusVal = bFromDb ? 1 : 0;
                } else if ("B".equals(value)) {
                    statusVal = 4;
                } else if ("C".equals(value)) {
                    statusVal = 5;
                }
            }
        }
        int lockValue = this.getLockIntegerVal();
        return statusVal == 0 && (lockValue & 1) == 1 || statusVal == 1 && (lockValue & 2) == 2 || statusVal == 2 && (lockValue & 4) == 4 || statusVal == 4 && (lockValue & 0x10) == 16 || statusVal == 5 && (lockValue & 0x20) == 32;
    }

    public void splitSaveFlexData(int row) {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(null, new DistributeCacheHAPolicy(true, true));
        String accountId = CacheKeyUtil.getAcctId();
        String type = String.format("%s_%s_isFlexEdit", accountId, this.view.getPageId());
        String isFlexEdit = (String)cache.get(type, this.getKey() + "_isFlexEdit");
        if (isFlexEdit == null) {
            this.saveFlexData(row);
            if (this.isServerSideOpen()) {
                this.release();
            }
        } else {
            FlexEntityMetaUtils.outLog((String)FLEX_EDIT, (String)"splitSaveFlexData", (String)"flex debug: FlexEdit splitSaveFlexData() is not saved. ");
        }
    }

    public boolean splitEnable() {
        if (this.getView() instanceof IMobileView) {
            return false;
        }
        if (!this.isNeedSplit()) {
            return false;
        }
        if (this.getProperty() != null && !this.isEntryProperty(this.getProperty())) {
            return false;
        }
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(this.getEntryControlKey());
        if (entryGrid == null) {
            return false;
        }
        if (entryGrid.isServerFilterModle()) {
            return false;
        }
        return entryGrid.getEntryState().getEntryViewType() == EntryViewType.GridView;
    }

    static class ParentBDValue {
        private String bdType;
        private Object bdPKValue;

        public ParentBDValue(String bdType, Object bdPKValue) {
            this.bdType = bdType;
            this.bdPKValue = bdPKValue;
        }

        public String getBDType() {
            return this.bdType;
        }

        public Object getBDPKValue() {
            return this.bdPKValue;
        }

        public String toString() {
            return String.format("{bdType=%s, bdPKValue=%s}", this.bdType, this.bdPKValue);
        }

        public int hashCode() {
            int hashcode = 1;
            hashcode = 31 * hashcode + (this.bdType == null ? 0 : this.bdType.hashCode());
            hashcode = 31 * hashcode + (this.bdPKValue == null ? 0 : this.bdPKValue.hashCode());
            return hashcode;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ParentBDValue)) {
                return false;
            }
            ParentBDValue other = (ParentBDValue)obj;
            if (!this.equalsValue(this.bdType, other.getBDType())) {
                return false;
            }
            return this.equalsValue(this.bdPKValue, other.getBDPKValue());
        }

        private boolean equalsValue(Object v1, Object v2) {
            if (v1 == null) {
                return v2 == null;
            }
            return v1.equals(v2);
        }
    }
}

