/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.field;

import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.GroupProp;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class GroupEdit
extends BasedataEdit {
    @Override
    protected ListShowParameter createShowListForm(BasedataProp prop) {
        GroupProp grop = (GroupProp)prop;
        String tableName = grop.getGroupTableName();
        if ("bos_group".equals(prop.getBaseEntityId())) {
            ListShowParameter para = new ListShowParameter();
            para.getOpenStyle().setShowType(ShowType.Modal);
            para.setFormId("bos_groupselect");
            para.setCustomParam("groupTableName", tableName);
            return para;
        }
        ListShowParameter para = new ListShowParameter();
        para.setShowTitle(false);
        para.setLookUp(true);
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setBillFormId(prop.getBaseEntityId());
        StyleCss css = this.setStyleCss("960px", "580px");
        para.getOpenStyle().setInlineStyleCss(css);
        para.setMultiSelect(false);
        para.setFormId(GroupEdit.getListFormId(prop.getBaseEntityId()));
        return para;
    }

    private static String getListFormId(String formId) {
        FormConfig formConfig = FormMetadataCache.getListFormConfig(formId);
        return formConfig.getF7ListFormId();
    }

    private StyleCss setStyleCss(String width, String hight) {
        StyleCss css = new StyleCss();
        css.setWidth(width);
        css.setHeight(hight);
        return css;
    }
}

