/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.field;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.form.BindingContext;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class ItemClassEdit
extends BasedataEdit {
    @Override
    protected ListShowParameter createShowListForm(BasedataProp prop) {
        if (StringUtils.isBlank((CharSequence)this.getBaseEntityId())) {
            this.getView().showMessage(this.getItemTypeName());
            return null;
        }
        ListShowParameter showParameter = super.createShowListForm(prop);
        showParameter.setMultiSelect(false);
        return showParameter;
    }

    @Override
    protected ListShowParameter createShowMobileListForm(BasedataProp prop) {
        if (StringUtils.isBlank((CharSequence)this.getBaseEntityId())) {
            this.getView().showErrorNotification(this.getItemTypeName());
            return null;
        }
        ListShowParameter showParameter = super.createShowMobileListForm(prop);
        showParameter.setMultiSelect(false);
        return showParameter;
    }

    @Override
    protected String getItemTypeName() {
        MainEntityType dataEntityType = this.getModel().getDataEntityType();
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        ArrayList<IDataEntityProperty> allProperties = new ArrayList<IDataEntityProperty>();
        for (IDataEntityProperty dtProp : properties) {
            this.addProperty(dtProp, allProperties);
        }
        String typeName = ((ItemClassProp)this.getProperty()).getTypePropName();
        Optional<IDataEntityProperty> property = allProperties.stream().filter(p -> typeName.equals(p.getName())).findFirst();
        if (property.isPresent()) {
            return String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9%s\u3002", (String)"ItemClassEdit_0", (String)"bos-form-metadata", (Object[])new Object[0]), property.get().getDisplayName().toString());
        }
        return ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u591a\u7c7b\u522b\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u3002", (String)"ItemClassEdit_1", (String)"bos-form-metadata", (Object[])new Object[0]);
    }

    private void addProperty(IDataEntityProperty dtProp, List<IDataEntityProperty> allProperties) {
        if (dtProp instanceof EntryProp) {
            EntryProp prop = (EntryProp)dtProp;
            DynamicObjectType entryType = prop.getDynamicCollectionItemPropertyType();
            DataEntityPropertyCollection entryProperties = entryType.getProperties();
            for (IDataEntityProperty entryProp : entryProperties) {
                this.addProperty(entryProp, allProperties);
            }
        } else {
            allProperties.add(dtProp);
        }
    }

    @Override
    protected String getBaseEntityId() {
        return (String)this.getModel().getValue(((ItemClassProp)this.getProperty()).getTypePropName());
    }

    @SdkInternal
    protected String getBaseEntityId(int rowKey) {
        return (String)this.getModel().getValue(((ItemClassProp)this.getProperty()).getTypePropName(), rowKey);
    }

    @Override
    public void bindData(BindingContext bctx) {
        super.bindData(bctx);
        String baseEntityId = this.getBaseEntityId();
        if (StringUtils.isNotBlank((CharSequence)baseEntityId)) {
            String entryKey = this.getEntryKey();
            if (entryKey != null) {
                if (this.getEntryGrid() instanceof CardEntry) {
                    this.setBaseEntityIdClient(baseEntityId);
                } else {
                    if (StringUtils.isNotBlank((CharSequence)this.getEntryControlKey())) {
                        entryKey = this.getEntryControlKey();
                    }
                    this.clientViewProxy.invokeControlMethod(entryKey, "setColEditorProp", this.getKey(), "ei", baseEntityId);
                }
            } else {
                this.setBaseEntityIdClient(baseEntityId);
            }
        }
    }

    private void setBaseEntityIdClient(String baseEntityId) {
        HashMap<String, Object> item = new HashMap<String, Object>(1);
        HashMap<String, String> ctl = new HashMap<String, String>(1);
        ctl.put("ei", baseEntityId);
        item.put("item", ctl);
        this.getView().updateControlMetadata(this.getKey(), item);
    }
}

