/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.field;

import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.LargeTextProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class LargeTextEdit
extends TextEdit
implements ICloseCallBack {
    private String tagFieldKey = "_tag";

    public String getTagFieldKey() {
        return this.getFieldKey() + this.tagFieldKey;
    }

    @Override
    public void click() {
        this.detailClick(null);
    }

    public void detailClick(Map<String, Object> args) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ide_largertextedit");
        if (this.getProperty() instanceof LargeTextProp) {
            showParameter.setCaption(((LargeTextProp)this.getProperty()).getDisplayName().toString());
        }
        boolean lock = args == null || args.get("lock") == null ? false : Boolean.parseBoolean(args.get("lock").toString());
        showParameter.setCustomParam("lock", lock);
        showParameter.setCustomParam("largeTextValue", this.getLargeTextValue());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack callBack = new CloseCallBack();
        callBack.setControlKey(this.getKey());
        callBack.setActionId("ide_largertextedit_callBack");
        showParameter.setCloseCallBack(callBack);
        this.getView().showForm(showParameter);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        if (e.getReturnData() == null) {
            return;
        }
        if ("ide_largertextedit_callBack".equals(e.getActionId())) {
            if (StringUtils.isBlank((CharSequence)this.getEntryKey())) {
                this.getModel().setValue(this.getTagFieldKey(), e.getReturnData(), 0);
            } else {
                int index = this.getModel().getEntryCurrentRowIndex(this.getEntryKey());
                this.getModel().setValue(this.getTagFieldKey(), e.getReturnData(), index);
            }
        }
    }

    private String getLargeTextValue() {
        String largeTextValue;
        if (StringUtils.isBlank((CharSequence)this.getEntryKey())) {
            largeTextValue = (String)this.getModel().getValue(this.getTagFieldKey(), 0);
        } else {
            int index = this.getModel().getEntryCurrentRowIndex(this.getEntryKey());
            largeTextValue = (String)this.getModel().getValue(this.getTagFieldKey(), index);
        }
        return largeTextValue;
    }
}

