/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.field;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.base.BillLayoutScheme;
import kd.bos.bill.BillShowParameter;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.LayoutControlInfo;
import kd.bos.entity.bill.BillLayoutParameter;
import kd.bos.entity.bill.BillLayoutSchemeAssignEntity;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BillTypeProp;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.entity.property.org.MainOrgExchanger;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.IMobileView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ORMUtil;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.events.AfterChangeMainOrgEventArgs;
import kd.bos.form.field.events.BeforeChangeMainOrgEventArgs;
import kd.bos.form.field.events.MainOrgChangeListener;
import kd.bos.orm.ORM;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.WithEntityEntryDistinctable;
import kd.bos.param.ParameterReader;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class MainOrgEdit
extends OrgEdit
implements IConfirmCallBack {
    private static final String EXCHANGE_ORG_CLEAR = "exchange_org_clear";
    private static final String EXCHANGE_ORG_AUTO_SWITCH = "exchange_org_auto_switch";
    private static final String EXCHANGE_LAYOUT = "exchange_layout";
    private static final String BOS_FORM_METADATA = "bos-form-metadata";
    private static final String NEW_ORG_VALUE = "newOrgValue";
    private static final String IS_CHANGING_MAIN_ORG = "isChangingMainOrg";
    private static final String MAIN_ORG_PRO_NAME = "mainOrgProName";
    private static final String SPAN_TYPE_PLUGIN = "plugin";
    private static final String TAMP_ATT_CACHE = "TampAttCache";
    List<MainOrgChangeListener> orgChangeListeners = new ArrayList<MainOrgChangeListener>(1);

    public MainOrgProp getMainOrgProp() {
        return (MainOrgProp)this.getProperty();
    }

    @Override
    public void setItemByIdFromClient(List<Object> args) {
        if (args == null || args.isEmpty()) {
            return;
        }
        Object newValue = args.get(0);
        if (StringUtils.isBlank((Object)newValue)) {
            return;
        }
        newValue = this.getMainOrgProp().convertPKValueType((DynamicObjectType)this.getMainOrgProp().getComplexType(), newValue);
        String mainOrgProName = this.getProperty().getName();
        Object oldValue = this.getView().getModel().getValue(mainOrgProName);
        boolean isChange = this.isChange(newValue, oldValue);
        if (!isChange) {
            return;
        }
        if (!(this.getView() instanceof IMobileView)) {
            this.prompt(String.valueOf(newValue));
        } else if (this.isExchangeOrgClearBill()) {
            this.clearBill(this.getView(), mainOrgProName, newValue.toString());
        } else {
            this.exchangeMainOrg(this.getView(), mainOrgProName, newValue.toString());
        }
    }

    @Override
    public void setItemByNumber(String number) {
        this.setItemByNumber(number, -1);
    }

    @Override
    public void setItemByNumber(String number, int rowkey) {
        boolean changed;
        IDataModel model = this.getView().getModel();
        MainOrgProp mainOrgProperty = (MainOrgProp)model.getProperty(this.getFieldKey());
        if (StringUtils.isBlank((CharSequence)number)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u4e0d\u5141\u8bb8\u6e05\u7a7a\u3002", (String)"MainOrgEdit_0", (String)BOS_FORM_METADATA, (Object[])new Object[0]), mainOrgProperty.getDisplayName().toString()));
            this.getView().updateView(this.getFieldKey());
            return;
        }
        String numPropName = mainOrgProperty.getNumbProp().getName();
        DynamicObject oldValue = (DynamicObject)model.getValue(this.getFieldKey());
        String oldNumber = oldValue != null ? oldValue.getString(numPropName) : null;
        boolean bl = changed = !number.equalsIgnoreCase(oldNumber);
        if (!changed) {
            this.getView().updateView(this.getFieldKey());
            return;
        }
        DynamicObject org = this.loadOrgFromCacheByNumber(number);
        if (org == null) {
            LocaleString displayName = mainOrgProperty.getDisplayName();
            String tipMsg = "";
            tipMsg = StringUtils.isBlank((Object)displayName) ? ResManager.loadKDString((String)"\u4e3b\u4e1a\u52a1\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002", (String)"MainOrgEdit_1", (String)BOS_FORM_METADATA, (Object[])new Object[0]) : MessageFormat.format(ResManager.loadKDString((String)"{0}\u4e0d\u5b58\u5728\u3002", (String)"MainOrgEdit_2", (String)BOS_FORM_METADATA, (Object[])new Object[0]), "\"" + displayName + "\"");
            this.getView().showTipNotification(tipMsg, 2000);
            this.getView().updateView(this.getFieldKey());
        } else if (!(this.getView() instanceof IMobileView)) {
            this.prompt(String.valueOf(org.getPkValue()));
        } else if (this.isExchangeOrgClearBill()) {
            this.clearBill(this.getView(), this.getProperty().getName(), String.valueOf(org.getPkValue()));
        } else {
            this.exchangeMainOrg(this.getView(), this.getProperty().getName(), String.valueOf(org.getPkValue()));
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        if (!(e.getReturnData() instanceof ListSelectedRowCollection)) {
            return;
        }
        ListSelectedRowCollection rows = (ListSelectedRowCollection)e.getReturnData();
        if (rows == null || rows.isEmpty()) {
            return;
        }
        Object newValue = rows.get(0).getPrimaryKeyValue();
        if (newValue == null) {
            return;
        }
        String mainOrgProName = this.getProperty().getName();
        Object oldValue = this.getView().getModel().getValue(mainOrgProName);
        boolean isChange = this.isChange(newValue, oldValue);
        if (!isChange) {
            return;
        }
        if (!(this.getView() instanceof IMobileView)) {
            this.prompt(String.valueOf(newValue));
        } else if (this.isExchangeOrgClearBill()) {
            this.clearBill(this.getView(), mainOrgProName, newValue.toString());
        } else {
            this.exchangeMainOrg(this.getView(), mainOrgProName, newValue.toString());
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent e) {
        if (e.getResult() == MessageBoxResult.Yes) {
            IFormView formView = (IFormView)e.getSource();
            IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
            if (StringUtils.equalsIgnoreCase((CharSequence)e.getCallBackId(), (CharSequence)EXCHANGE_LAYOUT)) {
                this.showExchangeLayout(pageCache.get(NEW_ORG_VALUE));
            } else {
                if (StringUtils.equalsIgnoreCase((CharSequence)e.getCallBackId(), (CharSequence)EXCHANGE_ORG_CLEAR)) {
                    this.clearBill(formView, pageCache.get(MAIN_ORG_PRO_NAME), pageCache.get(NEW_ORG_VALUE));
                } else {
                    this.exchangeMainOrg(formView, pageCache.get(MAIN_ORG_PRO_NAME), pageCache.get(NEW_ORG_VALUE));
                }
                this.updateBillLayout(pageCache.get(NEW_ORG_VALUE));
            }
        } else {
            this.getView().updateView(this.getKey());
        }
    }

    @Override
    public void endSelect(Object params) {
        boolean isChange;
        super.endSelect(params);
        IDataModel model = this.getView().getModel();
        Object orgId = null;
        String id = null;
        String mainOrgProName = this.getProperty().getName();
        Object oldValue = this.getView().getModel().getValue(mainOrgProName);
        if (params instanceof ArrayList) {
            String yzjOrgId = ((ArrayList)params).get(0).toString();
            Map orgMap = model.getOrgbyYzjorgId(yzjOrgId);
            orgId = orgMap.get("id");
            if (orgId == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff01", (String)"MainOrgEdit_3", (String)BOS_FORM_METADATA, (Object[])new Object[0]));
                return;
            }
            model.setValue(this.getFieldKey().toLowerCase(), orgId);
        }
        if (!(isChange = this.isChange(orgId, oldValue))) {
            return;
        }
        if (orgId != null && this.showExchangeLayout(id = orgId.toString())) {
            return;
        }
        if (this.isExchangeOrgClearBill()) {
            this.clearBill(this.getView(), mainOrgProName, id);
        } else {
            this.exchangeMainOrg(this.getView(), mainOrgProName, id);
        }
    }

    public void addMainOrgChangeListener(MainOrgChangeListener listener) {
        if (!this.orgChangeListeners.contains(listener)) {
            this.orgChangeListeners.add(listener);
        }
    }

    private void prompt(String newOrgId) {
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        pageCache.put(MAIN_ORG_PRO_NAME, this.getProperty().getName());
        pageCache.put(NEW_ORG_VALUE, newOrgId);
        if (this.isExchangeLayout(newOrgId)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5e03\u5c40\u5207\u6362\uff0c\u5c06\u6e05\u9664\u5355\u636e\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"MainOrgEdit_4", (String)BOS_FORM_METADATA, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(EXCHANGE_LAYOUT, this));
        } else if (this.isExchangeOrgClearBill()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u7ec4\u7ec7\u5207\u6362\uff0c\u5c06\u6e05\u9664\u5355\u636e\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"MainOrgEdit_5", (String)BOS_FORM_METADATA, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(EXCHANGE_ORG_CLEAR, this));
        } else {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u7ec4\u7ec7\u5207\u6362\uff0c\u5c06\u68c0\u67e5\u5355\u636e\u4fe1\u606f\uff0c\u6e05\u9664\u65b0\u7ec4\u7ec7\u65e0\u6743\u4f7f\u7528\u7684\u6570\u636e\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"MainOrgEdit_6", (String)BOS_FORM_METADATA, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(EXCHANGE_ORG_AUTO_SWITCH, this));
        }
    }

    private boolean isExchangeLayout(String newOrgId) {
        if (LayoutControlInfo.isBillTypeLayout()) {
            return false;
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (!(formShowParameter instanceof BillShowParameter)) {
            return false;
        }
        BillLayoutScheme bls = this.getLayoutScheme(newOrgId, formShowParameter);
        BillLayoutSchemeAssignEntity blsa = bls.getLayoutScheme();
        Long originaScheme = ((BillShowParameter)formShowParameter).getLayoutSchemeId();
        return (originaScheme != null || blsa != null) && (originaScheme == null || blsa == null || !originaScheme.equals(blsa.getId()));
    }

    private boolean showExchangeLayout(String newOrgId) {
        BillShowParameter billShowParameter;
        if (LayoutControlInfo.isBillTypeLayout()) {
            return false;
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (!(formShowParameter instanceof BillShowParameter)) {
            return false;
        }
        BillLayoutScheme bls = this.getLayoutScheme(newOrgId, formShowParameter);
        String billTypeKey = ((BillEntityType)this.getModel().getDataEntityType()).getBillType();
        boolean hidden = false;
        if (StringUtils.isBlank((CharSequence)billTypeKey) || this.getView().getControl(billTypeKey) == null) {
            hidden = true;
        }
        if ((billShowParameter = bls.convertLayoutShowParameter((BillShowParameter)formShowParameter, hidden)) != null) {
            this.getView().showForm(billShowParameter);
            return true;
        }
        return false;
    }

    private void updateBillLayout(String newOrgId) {
        if (LayoutControlInfo.isBillTypeLayout()) {
            return;
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (!(formShowParameter instanceof BillShowParameter)) {
            return;
        }
        BillLayoutScheme bls = this.getLayoutScheme(newOrgId, formShowParameter);
        BillLayoutSchemeAssignEntity blsa = bls.getLayoutScheme();
        if (blsa != null) {
            bls.updateBillLayout(this.getView());
        }
    }

    private BillLayoutScheme getLayoutScheme(String newOrgId, FormShowParameter formShowParameter) {
        BillLayoutParameter blp = new BillLayoutParameter();
        long orgId = StringUtils.isBlank((CharSequence)newOrgId) ? 0L : Long.parseLong(newOrgId);
        blp.setOrgId(orgId);
        String billType = ((BillShowParameter)formShowParameter).getBillTypeId();
        long billTypeId = this.getSafeBillTypeId(billType);
        blp.setBillTypeId(billTypeId);
        return new BillLayoutScheme((IBillModel)this.getModel(), (BillShowParameter)formShowParameter, blp);
    }

    private long getSafeBillTypeId(String billType) {
        if (StringUtils.isBlank((CharSequence)billType)) {
            return 0L;
        }
        long billTypeId = 0L;
        try {
            billTypeId = Long.parseLong(billType);
        }
        catch (Exception e) {
            billTypeId = 0L;
        }
        return billTypeId;
    }

    private long getLayoutBillTypeId(FormShowParameter formShowParameter) {
        long billTypeId = 0L;
        String billType = ((BillShowParameter)formShowParameter).getBillTypeId();
        if (StringUtils.isNotBlank((CharSequence)billType)) {
            billTypeId = this.getSafeBillTypeId(billType);
        } else {
            DynamicObject billTypeObj;
            BillEntityType dt = (BillEntityType)this.getModel().getDataEntityType();
            String billTypeKey = dt.getBillType();
            if (StringUtils.isNotBlank((CharSequence)billTypeKey) && (billTypeObj = (DynamicObject)this.getModel().getValue(billTypeKey)) != null && billTypeObj.getPkValue() != null) {
                billTypeId = (Long)billTypeObj.getPkValue();
            }
        }
        return billTypeId;
    }

    private void clearBill(IFormView formView, String mainOrgProName, String newOrgValue) {
        IDataModel model = (IDataModel)formView.getService(IDataModel.class);
        FormShowParameter formShowParameter = formView.getFormShowParameter();
        if (!Boolean.TRUE.equals(model.getContextVariable("IGNORE_RELOADDATAMODEL")) && formShowParameter instanceof BillShowParameter) {
            ((BillShowParameter)formShowParameter).setCachePageId(null);
            if (LayoutControlInfo.isBillTypeLayout()) {
                this.billTypeClearBill(formView, mainOrgProName, newOrgValue, model, formShowParameter);
            } else {
                this.billLayoutClearBill(formView, mainOrgProName, newOrgValue, model, formShowParameter);
            }
        }
    }

    private void billLayoutClearBill(IFormView formView, String mainOrgProName, String newOrgValue, IDataModel model, FormShowParameter formShowParameter) {
        model.putContextVariable(IS_CHANGING_MAIN_ORG, (Object)"true");
        model.putContextVariable(MAIN_ORG_PRO_NAME, (Object)mainOrgProName);
        model.putContextVariable(NEW_ORG_VALUE, (Object)newOrgValue);
        long billTypeId = this.getLayoutBillTypeId(formShowParameter);
        if (billTypeId != 0L) {
            model.putContextVariable("DEFAULT_BILLTYPE_ID", (Object)billTypeId);
        }
        model.beginInit();
        model.createNewData();
        model.endInit();
        model.removeContextVariable(IS_CHANGING_MAIN_ORG);
        model.removeContextVariable(MAIN_ORG_PRO_NAME);
        model.removeContextVariable(NEW_ORG_VALUE);
        IPageCache cache = (IPageCache)this.getView().getService(IPageCache.class);
        if (StringUtils.isNotBlank((CharSequence)cache.get(TAMP_ATT_CACHE + this.getView().getPageId()))) {
            cache.remove(TAMP_ATT_CACHE + this.getView().getPageId());
        }
        IClientViewProxy clientViewProxy = (IClientViewProxy)formView.getService(IClientViewProxy.class);
        clientViewProxy.addAction("setBillStatus", formShowParameter.getStatus().getValue());
        clientViewProxy.addAction("reset", null);
        formView.updateView();
    }

    private void billTypeClearBill(IFormView formView, String mainOrgProName, String newOrgValue, IDataModel model, FormShowParameter formShowParameter) {
        BillTypeProp billTypeProp;
        Long billTypeId;
        BillShowParameter billShowParameter = (BillShowParameter)formShowParameter;
        String layoutFormId = billShowParameter.getFormId();
        BillEntityType type = (BillEntityType)model.getDataEntityType();
        String billType = type.getBillType();
        if (billType != null && (billTypeId = (billTypeProp = (BillTypeProp)type.getProperty(billType)).queryDefaultBillType(type.getName())) != null) {
            layoutFormId = ORMUtil.getFormIdByBillTypeId(billTypeId);
        }
        if (billShowParameter.getFormId().equals(layoutFormId)) {
            model.putContextVariable(IS_CHANGING_MAIN_ORG, (Object)"true");
            model.putContextVariable(MAIN_ORG_PRO_NAME, (Object)mainOrgProName);
            model.putContextVariable(NEW_ORG_VALUE, (Object)newOrgValue);
            model.beginInit();
            model.createNewData();
            model.endInit();
            model.removeContextVariable(IS_CHANGING_MAIN_ORG);
            model.removeContextVariable(MAIN_ORG_PRO_NAME);
            model.removeContextVariable(NEW_ORG_VALUE);
            IPageCache cache = (IPageCache)this.getView().getService(IPageCache.class);
            if (StringUtils.isNotBlank((CharSequence)cache.get(TAMP_ATT_CACHE + this.getView().getPageId()))) {
                cache.remove(TAMP_ATT_CACHE + this.getView().getPageId());
            }
            IClientViewProxy clientViewProxy = (IClientViewProxy)formView.getService(IClientViewProxy.class);
            clientViewProxy.addAction("setBillStatus", billShowParameter.getStatus().getValue());
            clientViewProxy.addAction("reset", null);
            formView.updateView();
        } else {
            billShowParameter.setFormId(layoutFormId);
            billShowParameter.setCustomParam("mainOrgId", newOrgValue);
            billShowParameter.getOpenStyle().setShowType(ShowType.InCurrentForm);
            this.getView().showForm(billShowParameter);
        }
    }

    private void exchangeMainOrg(IFormView formView, String mainOrgProName, String newOrgValue) {
        BeforeChangeMainOrgEventArgs beforeEventArgs = new BeforeChangeMainOrgEventArgs();
        for (MainOrgChangeListener listener : this.orgChangeListeners) {
            EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(listener.getClass().getName() + ".beforeChangeMainOrg"));
            Throwable throwable = null;
            try {
                listener.beforeChangeMainOrg(beforeEventArgs);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                span.close();
            }
        }
        if (beforeEventArgs.isCancel()) {
            String msg = ResManager.loadKDString((String)"\u4e1a\u52a1\u63d2\u4ef6\u53d6\u6d88\u4e86\u7ec4\u7ec7\u5207\u6362", (String)"MainOrgEdit_7", (String)BOS_FORM_METADATA, (Object[])new Object[0]);
            if (StringUtils.isNotBlank((CharSequence)beforeEventArgs.getMessage())) {
                msg = beforeEventArgs.getMessage();
            }
            this.getView().showErrorNotification(msg);
            this.getView().updateView(this.getFieldKey());
            return;
        }
        MainOrgExchanger mainOrgExchanger = new MainOrgExchanger(this.getModel(), this.getMainOrgProp());
        mainOrgExchanger.exchangeMainOrg(Long.parseLong(newOrgValue));
        AfterChangeMainOrgEventArgs afterEventArgs = new AfterChangeMainOrgEventArgs();
        for (MainOrgChangeListener listener : this.orgChangeListeners) {
            EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(listener.getClass().getName() + ".afterChangeMainOrg"));
            Throwable throwable = null;
            try {
                listener.afterChangeMainOrg(afterEventArgs);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    continue;
                }
                span.close();
            }
        }
        if (mainOrgExchanger.getExchangeResult() != null && !mainOrgExchanger.getExchangeResult().isSuccess()) {
            this.showExchangeResult(mainOrgExchanger.getExchangeResult());
        }
        this.getView().updateView();
    }

    private DynamicObject loadOrgFromCacheByNumber(String number) {
        MainOrgProp mainOrgProperty = this.getMainOrgProp();
        List qFilters = mainOrgProperty.buildCoreFilterByString(this.getModel());
        qFilters.add(new QFilter(mainOrgProperty.getNumbProp().getName(), "=", (Object)number));
        ArrayList idList = new ArrayList(1);
        try (DataSet ds = ORM.create().queryDataSet("MainOrgEdit.loadOrgByNumber", mainOrgProperty.getBaseEntityId(), "id", qFilters.toArray(new QFilter[0]), null, -1, (Distinctable)WithEntityEntryDistinctable.get());){
            ds.forEach(row -> idList.add(row.get(0)));
        }
        if (idList.isEmpty()) {
            return null;
        }
        Map orgs = BusinessDataReader.loadFromCache((Object[])idList.toArray(), (DynamicObjectType)mainOrgProperty.getDynamicComplexPropertyType());
        if (orgs.isEmpty()) {
            return null;
        }
        return (DynamicObject)orgs.entrySet().iterator().next().getValue();
    }

    private boolean isExchangeOrgClearBill() {
        DynamicObject billParamObj = ParameterReader.getBillParameter((String)this.getModel().getDataEntityType().getName());
        if (billParamObj != null && billParamObj.getDataEntityType().getProperties().containsKey((Object)"exchangemainorg_clearbill")) {
            return billParamObj.getBoolean("exchangemainorg_clearbill");
        }
        return true;
    }

    private boolean isChange(Object newValue, Object oldValue) {
        boolean changed = false;
        if (newValue == null && oldValue == null) {
            return false;
        }
        if (oldValue == null) {
            changed = true;
        } else {
            if (oldValue instanceof DynamicObject) {
                oldValue = ((DynamicObject)oldValue).getPkValue();
            }
            changed = !oldValue.equals(newValue);
        }
        return changed;
    }

    private void showExchangeResult(OperationResult exchangeResult) {
        List errorInfos = exchangeResult.getAllErrorOrValidateInfo();
        if (errorInfos.isEmpty()) {
            return;
        }
        if (errorInfos.size() > 1) {
            this.showExchangeResultMulti(exchangeResult);
        } else {
            String msg;
            OperateErrorInfo errorInfo = (OperateErrorInfo)errorInfos.get(0);
            String string = msg = errorInfo.getMessage() == null ? "" : errorInfo.getMessage();
            if (msg.length() > 40 && this.getView().getFormShowParameter().getOpenStyle().getShowType() == ShowType.Modal) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u7ec4\u7ec7\u5207\u6362\u51fa\u9519", (String)"MainOrgEdit_8", (String)BOS_FORM_METADATA, (Object[])new Object[0]), errorInfo.getMessage(), MessageTypes.Default);
            } else if (errorInfo.getLevel() == ErrorLevel.Warning || errorInfo.getLevel() == ErrorLevel.Error) {
                this.getView().showTipNotification(errorInfo.getMessage(), 5000);
            } else {
                this.getView().showErrorNotification(errorInfo.getMessage());
            }
        }
    }

    private void showExchangeResultMulti(OperationResult exchangeResult) {
        List errorInfos = exchangeResult.getAllErrorOrValidateInfo();
        FormShowParameter parameters = new FormShowParameter();
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setFormId("bos_operationresult");
        parameters.setShowTitle(false);
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        DataEntitySerializerOption option = new DataEntitySerializerOption();
        option.setIncludeComplexProperty(true);
        String serialResult = DataEntitySerializer.serializerToString((Object)exchangeResult, (DataEntitySerializerOption)option);
        pageCache.put("operationresult", serialResult);
        String title = ResManager.loadKDString((String)"\u7ec4\u7ec7\u5207\u6362\u51fa\u9519", (String)"MainOrgEdit_8", (String)BOS_FORM_METADATA, (Object[])new Object[0]);
        parameters.setCustomParam("title", title);
        ArrayList<String> list = new ArrayList<String>();
        int len = errorInfos.size();
        for (int i = 0; i < 5 && i < len; ++i) {
            list.add(((IOperateInfo)errorInfos.get(i)).getMessage());
        }
        parameters.setCustomParam("hasMore", errorInfos.size() > 5);
        parameters.setCustomParam("errorMsg", list);
        this.getView().showForm(parameters);
    }
}

