/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.field;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import kd.bos.base.BasedataHelper;
import kd.bos.base.IBasedataController;
import kd.bos.bill.MobileFormPosition;
import kd.bos.data.ParameterHelper;
import kd.bos.dataentity.entity.ComplexPropertyAttribute;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.RefEntityType;
import kd.bos.entity.SelectedDisplayField;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.TypeChange;
import kd.bos.entity.param.BillParam;
import kd.bos.entity.param.FuzzySearch;
import kd.bos.entity.param.ShowColumn;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.MasterBasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.rule.FieldRuleHelper;
import kd.bos.form.BindingContext;
import kd.bos.form.CloseCallBack;
import kd.bos.form.CoreShowFormHelper;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.IMobileView;
import kd.bos.form.IPageCache;
import kd.bos.form.OrgFullNameService;
import kd.bos.form.ShowType;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterBindingDataEvent;
import kd.bos.form.field.events.BaseDataCustomControllerEvent;
import kd.bos.form.field.events.BasedataControllerSourceEnum;
import kd.bos.form.field.events.BasedataEditListener;
import kd.bos.list.ListShowParameter;
import kd.bos.list.MobileListShowParameter;
import kd.bos.list.query.impl.BaseData;
import kd.bos.list.query.impl.BaseDataQuery;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class MulBasedataEdit
extends BasedataEdit {
    private static final Log log = LogFactory.getLog(MulBasedataEdit.class);
    private String orgFuncId;
    boolean isOrgBaseAdmin = false;
    private BasedataProp bdProp;
    private SelectedDisplayField selectedDisplayField;
    private List<Object[]> frequentData;
    private static final String BOS_FORM_METADATA = "bos-form-metadata";
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String LONG_NUMBER = "longNumber";
    private static final String FULL_NAME = "fullName";
    private static final String BASE_TREE_TPL = "b0d31cea000001ac";
    private String layoutId = "";
    private static final String SKIP_CHECK_SELECT_ROWS = "skipCheckSelectRows";

    @Override
    @SimplePropertyAttribute
    public String getLayoutId() {
        return this.layoutId;
    }

    @Override
    public void setLayoutId(String layoutId) {
        this.layoutId = layoutId;
    }

    @Override
    @SimplePropertyAttribute
    public String getEditSearchProp() {
        return super.getDisplayProp();
    }

    public String getOrgFuncId() {
        return this.orgFuncId;
    }

    public void setOrgFuncId(String orgFuncId) {
        this.orgFuncId = orgFuncId;
    }

    @SimplePropertyAttribute
    public boolean getIsOrgBaseAdmin() {
        return this.isOrgBaseAdmin;
    }

    public void setIsOrgBaseAdmin(boolean isOrgBaseAdmin) {
        this.isOrgBaseAdmin = isOrgBaseAdmin;
    }

    @ComplexPropertyAttribute
    public SelectedDisplayField getSelectedDisplayField() {
        return this.selectedDisplayField;
    }

    public void setSelectedDisplayField(SelectedDisplayField selectedDisplayField) {
        this.selectedDisplayField = selectedDisplayField;
    }

    @Override
    protected BasedataEntityType getMainEntityType() {
        MulBasedataProp prop = (MulBasedataProp)this.getProperty();
        BasedataEntityType dataType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)prop.getBaseEntityId());
        return dataType;
    }

    private BasedataProp getBasedataProp() {
        if (this.bdProp == null) {
            MulBasedataProp prop = (MulBasedataProp)this.getProperty();
            DynamicObjectType dType = prop.getDynamicCollectionItemPropertyType();
            this.bdProp = (BasedataProp)dType.getProperties().get((Object)"fbasedataid");
        }
        return this.bdProp;
    }

    @Override
    protected String getBaseEntityId() {
        return ((MulBasedataProp)this.getProperty()).getBaseEntityId();
    }

    @Override
    public Object getBindingValue(BindingContext bctx) {
        Object v = super.getFieldValue(bctx);
        if (v == null || ((DynamicObjectCollection)v).isEmpty()) {
            return null;
        }
        ArrayList<Object[]> returnValues = new ArrayList<Object[]>();
        DynamicObjectCollection mulObjs = (DynamicObjectCollection)v;
        BasedataProp basedataProp = this.getBasedataProp();
        if (basedataProp != null) {
            this.frequentData = new ArrayList<Object[]>(mulObjs.size());
            for (DynamicObject obj : mulObjs) {
                DynamicObject basedataObj = (DynamicObject)basedataProp.getValueFast((Object)obj);
                if (basedataObj == null) continue;
                Object[] arr = (Object[])this.getBindingBasedataValue(basedataObj);
                returnValues.add(arr);
                this.addFrequentData(basedataObj, arr);
            }
        }
        return returnValues;
    }

    @Override
    protected Object getBindingBasedataValue(Object v) {
        OrgFullNameService orgFullNameService;
        DynamicObject bdObj = (DynamicObject)v;
        Object bindValue = null;
        BasedataEntityType bdType = null;
        bdType = bdObj.getDataEntityType() instanceof BasedataEntityType ? (BasedataEntityType)((DynamicObject)v).getDataEntityType() : (BasedataEntityType)((MulBasedataProp)this.getProperty()).getComplexType();
        if (StringUtils.isBlank((CharSequence)bdType.getMasteridPropName()) || !bdType.getProperties().containsKey((Object)bdType.getMasteridPropName()) || bdType.getMasteridType() != 2) {
            this.getBasedataProp().setOrgFunc(((MulBasedataProp)this.getProperty()).getOrgFunc());
            orgFullNameService = new OrgFullNameService(this.getBasedataProp());
            if (!this.fromEntryGrid) {
                orgFullNameService.preLoadOrgData(v, this.getBasedataProp().getDisplayProp());
            }
            bindValue = this.getBasedataProp().getBindingBasedataValue((Object)bdObj, this.getDisplayProp());
            if (!this.fromEntryGrid) {
                orgFullNameService.resetOrgDatas();
            }
        } else {
            MasterBasedataProp masterProp = null;
            Object masterObj = null;
            masterProp = (MasterBasedataProp)bdType.findProperty(bdType.getMasteridPropName());
            masterObj = (DynamicObject)bdObj.get(bdType.getMasteridPropName());
            if (masterProp != null && masterObj != null) {
                masterProp.setOrgFunc(((MulBasedataProp)this.getProperty()).getOrgFunc());
                OrgFullNameService orgFullNameService2 = new OrgFullNameService((BasedataProp)masterProp);
                if (!this.fromEntryGrid) {
                    orgFullNameService2.preLoadOrgData(v, this.getBasedataProp().getDisplayProp());
                }
                bindValue = masterProp.getBindingBasedataValue(masterObj, this.getDisplayProp());
                if (!this.fromEntryGrid) {
                    orgFullNameService2.resetOrgDatas();
                }
            }
        }
        if (bindValue == null) {
            orgFullNameService = new OrgFullNameService(this.getBasedataProp());
            if (!this.fromEntryGrid) {
                orgFullNameService.preLoadOrgData(v, this.getBasedataProp().getDisplayProp());
            }
            bindValue = this.getBasedataProp().getBindingBasedataValue((Object)bdObj, this.getDisplayProp());
            if (!this.fromEntryGrid) {
                orgFullNameService.resetOrgDatas();
            }
        }
        if (bindValue instanceof Object[] && this.basedataEditListeners != null) {
            AfterBindingDataEvent evt = new AfterBindingDataEvent(this, v);
            for (BasedataEditListener l : this.basedataEditListeners) {
                l.afterBindingData(evt);
            }
            Object[] bindValueArr = (Object[])bindValue;
            if (StringUtils.isNotBlank((Object)evt.getDisplayProp())) {
                bindValueArr[1] = evt.getDisplayProp();
            }
            if (StringUtils.isNotBlank((CharSequence)evt.getEditSearchProp())) {
                bindValueArr[2] = evt.getEditSearchProp();
            }
        }
        return bindValue;
    }

    @Override
    protected FuzzySearch loadLookUpSetting(BasedataEntityType refBDType) {
        String cachedKey;
        if (StringUtils.isBlank((CharSequence)refBDType.getMasteridPropName()) || refBDType.getMasteridType() != 2) {
            return super.loadLookUpSetting(refBDType);
        }
        FuzzySearch setting = null;
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        String search = pageCache.get(cachedKey = "searchSetting" + refBDType.getName());
        if (search == null) {
            BillParam billParam = ParameterHelper.getBillParam((String)refBDType.getName());
            if (billParam.getFuzzySearch() != null) {
                IDataEntityProperty masteridProp = refBDType.findProperty(refBDType.getMasteridPropName());
                if (masteridProp instanceof MasterBasedataProp) {
                    setting = this.buildDefLookUpSetting(refBDType);
                    for (ShowColumn column : billParam.getFuzzySearch().getComboListFields()) {
                        if (NAME.equals(column.getId()) || NUMBER.equals(column.getId())) continue;
                        if ("id".equals(column.getId())) {
                            ParameterHelper.addItem((FuzzySearch)setting, (String)refBDType.getPrimaryKey().getName(), (String)"ID", (float)0.0f, (int)-1, (int)0, (boolean)column.isVisible());
                            continue;
                        }
                        ParameterHelper.addItem((FuzzySearch)setting, (String)column.getId(), (String)column.getCaption(), (float)156.0f, (boolean)column.isVisible());
                    }
                }
            } else {
                setting = this.buildDefLookUpSetting(refBDType);
            }
            ParameterHelper.addItem((FuzzySearch)setting, (String)refBDType.getPrimaryKey().getName(), (String)"ID", (float)0.0f, (int)-1, (int)0, (boolean)false);
            pageCache.put(cachedKey, SerializationUtils.toJsonString((Object)setting));
        } else {
            setting = (FuzzySearch)SerializationUtils.fromJsonString((String)search, FuzzySearch.class);
        }
        this.setComboFieldCaption(refBDType, setting);
        return setting;
    }

    @Override
    protected FuzzySearch buildDefLookUpSetting(BasedataEntityType refBDType) {
        if (StringUtils.isBlank((CharSequence)refBDType.getMasteridPropName()) || refBDType.getMasteridType() != 2) {
            return super.buildDefLookUpSetting(refBDType);
        }
        FuzzySearch setting = new FuzzySearch();
        String number = "";
        String name = "";
        IDataEntityProperty masteridProp = refBDType.findProperty(refBDType.getMasteridPropName());
        if (masteridProp instanceof MasterBasedataProp) {
            RefEntityType refDBType2 = (RefEntityType)((MasterBasedataProp)masteridProp).getComplexType();
            if (StringUtils.isNotBlank((CharSequence)refDBType2.getNumberProperty())) {
                number = String.format("%s.%s", refBDType.getMasteridPropName(), refDBType2.getNumberProperty());
            }
            if (StringUtils.isNotBlank((CharSequence)refDBType2.getNameProperty())) {
                name = String.format("%s.%s", refBDType.getMasteridPropName(), refDBType2.getNameProperty());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)number)) {
            ParameterHelper.addItem((FuzzySearch)setting, (String)number, (String)ResManager.loadKDString((String)"\u7f16\u7801", (String)"MulBasedataEdit_0", (String)BOS_FORM_METADATA, (Object[])new Object[0]), (float)156.0f, (boolean)true);
        }
        if (StringUtils.isNotBlank((CharSequence)name) && !StringUtils.equals((CharSequence)number, (CharSequence)name)) {
            ParameterHelper.addItem((FuzzySearch)setting, (String)name, (String)ResManager.loadKDString((String)"\u540d\u79f0", (String)"MulBasedataEdit_1", (String)BOS_FORM_METADATA, (Object[])new Object[0]), (float)156.0f, (boolean)true);
        }
        return setting;
    }

    @Override
    protected ListShowParameter createAndSetListShowParameter(String sourceMethod) {
        ListShowParameter para = null;
        String baseEntityId = null;
        String orgFunc = null;
        MulBasedataProp prop = (MulBasedataProp)this.getProperty();
        if (prop != null) {
            if (this.getView() instanceof IMobileView) {
                para = this.createShowMobileListForm(prop);
            } else {
                para = !StringUtils.isEmpty((CharSequence)this.getLayoutId()) ? CoreShowFormHelper.createShowListForm(this.getLayoutId(), this.isEntryProperty((IDataEntityProperty)prop) && this.isF7MultipleSelect()) : CoreShowFormHelper.createShowListForm(prop.getBaseEntityId(), true);
                para.setShowTitle(false);
            }
            baseEntityId = prop.getBaseEntityId();
            orgFunc = prop.getOrgFunc();
        }
        if (para != null) {
            if ("bos_org".equalsIgnoreCase(baseEntityId)) {
                if (this.isOrgBaseAdmin) {
                    para.setCustomParam("isOrgBaseAdmin", this.isOrgBaseAdmin);
                } else {
                    para.setCustomParam("isOrgBaseAdmin", false);
                }
            }
            if ("bos_org".equalsIgnoreCase(baseEntityId) && StringUtils.isNotBlank(orgFunc)) {
                para.setCustomParam("orgFuncId", prop.getOrgFunc());
            } else if (StringUtils.isNotBlank((CharSequence)this.orgFuncId)) {
                para.setCustomParam("orgFuncId", this.orgFuncId);
            }
            para.setSelectedRows(this.getPkIds());
            para.setMultiSelect(true);
            para.setShowFrequent(this.isShowFrequent());
            para.setShowApproved(true);
            para.setShowUsed(this.isShowUsed());
            para.setMustInput(prop.isMustInput());
            super.setParamUseOrgId(para, (IBasedataField)prop);
            this.addFilter(para);
            CloseCallBack closeCallBack = new CloseCallBack();
            closeCallBack.setControlKey(this.getKey());
            para.setCloseCallBack(closeCallBack);
            this.setVersionControlDate(para);
            if (!this.isShowUsed()) {
                para.setF7ClickByFilter(true);
            }
            if (!this.triggerBeforeF7(para, sourceMethod)) {
                return null;
            }
            if (this.getSearchFilter() != null) {
                para.getListFilterParameter().getQFilters().add(this.getSearchFilter());
            }
            if (!super.isF7Click()) {
                BaseDataCustomControllerEvent event = new BaseDataCustomControllerEvent(this, para, BasedataControllerSourceEnum.FUZZY);
                BasedataEntityType dt = this.getMainEntityType();
                List<IBasedataController> controllers = BasedataHelper.createPlugin(dt.getBasedataControllersProp());
                for (IBasedataController controller : controllers) {
                    controller.buildBaseDataCoreFilter(event);
                }
                if (!event.getQfilters().isEmpty()) {
                    para.getListFilterParameter().getQFilters().addAll(event.getQfilters());
                }
            }
            para.setHasRight(true);
            if (!para.isMustInput()) {
                para.setCustomParam(SKIP_CHECK_SELECT_ROWS, true);
            } else if (!FieldRuleHelper.isMustInput((MainEntityType)this.getModel().getDataEntityType(), (DynamicObject)this.getModel().getDataEntity(), (String)this.getKey())) {
                para.setCustomParam(SKIP_CHECK_SELECT_ROWS, true);
            }
        }
        return para;
    }

    protected ListShowParameter createShowMobileListForm(MulBasedataProp prop) {
        ShowType showType;
        MobileListShowParameter para = new MobileListShowParameter();
        FormConfig formConfig = FormMetadataCache.getMobListFormConfig(this.getBaseEntityId());
        para.setLookUp(true);
        para.setBillFormId(this.getBaseEntityId());
        if (formConfig.getShowType() == ShowType.MainNewTabPage) {
            showType = ShowType.Floating;
        } else {
            showType = ShowType.Modal;
            para.setPosition(MobileFormPosition.Bottom);
        }
        para.getOpenStyle().setShowType(showType);
        para.setMultiSelect(true);
        para.setMustInput(prop.isMustInput());
        para.setSelectedDisplayField(this.getSelectedDisplayField());
        String formId = formConfig.getF7ListFormId();
        if (StringUtils.isNotBlank((CharSequence)formId)) {
            para.setFormId(formId);
        }
        return para;
    }

    @Override
    protected Object[] getPkIds() {
        IDataModel model = (IDataModel)this.view.getService(IDataModel.class);
        IDataEntityProperty property = this.getProperty();
        ArrayList<Object> pkIds = new ArrayList<Object>();
        DynamicObjectCollection dynamicObjectCollection = (DynamicObjectCollection)model.getValue(property.getName());
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            Object objectValue = dynamicObject.get("fbasedataid_id");
            if (objectValue == null) continue;
            pkIds.add(objectValue);
        }
        return pkIds.toArray(new Object[0]);
    }

    @Override
    protected void showFrequent(ListSelectedRowCollection rows) {
        if (this.frequentData == null || !this.isShowFrequent() || this.getView() instanceof IMobileView) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        map.put("type", this.getMainEntityType().getName());
        map.put("fieldType", "mulbasedata");
        map.put("data", this.frequentData);
        this.clientViewProxy.setFieldProperty(this.getKey(), "frequent", map);
    }

    @Override
    @SdkInternal
    public void getFeqData(List<List<?>> myFrequent) {
        ArrayList list;
        if (myFrequent.isEmpty()) {
            return;
        }
        try {
            ArrayList pkIds = new ArrayList(myFrequent.size());
            HashMap<String, Integer> pkSeq = new HashMap<String, Integer>(myFrequent.size());
            HashMap<String, Integer> pkFeqCount = new HashMap<String, Integer>(myFrequent.size());
            for (int i = 0; i < myFrequent.size(); ++i) {
                List<?> frequent = myFrequent.get(i);
                if (frequent.size() <= 6) continue;
                Object pkId = frequent.get(5);
                pkIds.add(pkId);
                pkSeq.put(pkId.toString(), i);
                if (frequent.size() <= 6 || frequent.get(6) == null) continue;
                pkFeqCount.put(pkId.toString(), Integer.parseInt(frequent.get(6).toString()));
            }
            if (!CollectionUtils.isEmpty(pkIds)) {
                BasedataEntityType basedataEntityType = this.getMainEntityType();
                List realPkList = TypeChange.getRealPkList((DynamicObjectType)basedataEntityType, pkIds);
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
                ListShowParameter para = this.createAndSetListShowParameter("getLookUpList");
                if (para != null) {
                    qFilters.addAll(para.getListFilterParameter().getQFilters());
                }
                qFilters.add(new QFilter("id", "in", (Object)realPkList));
                List baseDatas = BaseDataQuery.queryBaseDataOrBizBaseData((BasedataEntityType)basedataEntityType, (QFilter[])qFilters.toArray(new QFilter[0]), (boolean)this.isBaseTreeTpl(basedataEntityType.getInheritPath()));
                Collections.sort(baseDatas, (o1, o2) -> Integer.compare((Integer)pkSeq.get(o1.getId().toString()), (Integer)pkSeq.get(o2.getId().toString())));
                list = new ArrayList(baseDatas.size());
                ArrayList<String> addIds = new ArrayList<String>(10);
                for (BaseData baseData : baseDatas) {
                    String id = baseData.getId().toString();
                    if (addIds.contains(id)) continue;
                    ArrayList<String> vals = new ArrayList<String>();
                    vals.add(baseData.getNumber());
                    vals.add(baseData.getName());
                    vals.add(StringUtils.replaceEach((String)this.getEditSearchProp(), (String[])new String[]{LONG_NUMBER, FULL_NAME, NUMBER, NAME}, (String[])new String[]{baseData.getLongNumber(), baseData.getFullName(), baseData.getNumber(), baseData.getName()}));
                    vals.add(baseData.getLongNumber());
                    vals.add(baseData.getFullName());
                    vals.add(id);
                    vals.add((String)pkFeqCount.get(id));
                    list.add(vals);
                    addIds.add(id);
                }
            } else {
                list = new ArrayList(0);
            }
        }
        catch (Exception e) {
            list = new ArrayList(0);
            log.warn("getFeqData error", (Throwable)e);
        }
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        map.put("type", this.getMainEntityType().getName());
        map.put("fieldType", "mulbasedata");
        map.put("data", list);
        this.clientViewProxy.invokeControlMethod(this.getKey(), "setFrequentData", map);
    }

    private void addFrequentData(DynamicObject mulData, Object[] returnValue) {
        Object[] data = Arrays.copyOf(returnValue, returnValue.length + 1);
        data[returnValue.length] = mulData.getPkValue().toString();
        this.frequentData.add(data);
    }

    private boolean isBaseTreeTpl(String inheritPath) {
        if (StringUtils.isNotBlank((CharSequence)inheritPath)) {
            String[] split;
            for (String path : split = inheritPath.split(",")) {
                if (!StringUtils.equals((CharSequence)BASE_TREE_TPL, (CharSequence)path)) continue;
                return true;
            }
        }
        return false;
    }
}

