/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.field;

import java.util.ArrayList;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.GroupProp;
import kd.bos.entity.property.ParentBasedataProp;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.GroupEdit;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class ParentBasedataEdit
extends GroupEdit {
    private static final String NUMBER = "number";
    private static final String LONGNUMBER = "longnumber";

    @Override
    protected ListShowParameter createShowListForm(BasedataProp prop) {
        GroupProp grop = (GroupProp)prop;
        String tableName = grop.getGroupTableName();
        String longNumberDLM = ".";
        if (grop instanceof ParentBasedataProp) {
            longNumberDLM = ((ParentBasedataProp)grop).getLongNumberDLM();
        }
        if ("bos_group".equals(prop.getBaseEntityId()) && StringUtils.isNotBlank((CharSequence)tableName)) {
            ListShowParameter para = new ListShowParameter();
            para.getOpenStyle().setShowType(ShowType.Modal);
            para.setFormId("bos_groupedit");
            para.setCustomParam("groupTableName", tableName);
            return para;
        }
        ListShowParameter para = new ListShowParameter();
        para.setLookUp(true);
        para.setMultiSelect(false);
        para.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss css = this.setStyleCss("960px", "580px");
        para.getOpenStyle().setInlineStyleCss(css);
        FormConfig formConfig = FormMetadataCache.getListFormConfig(prop.getBaseEntityId());
        para.setFormId(formConfig.getF7ListFormId());
        para.setBillFormId(prop.getBaseEntityId());
        para.setShowTitle(false);
        para.setCustomParam("groupTableName", tableName);
        if (this.getView().getFormShowParameter().getStatus() == OperationStatus.EDIT) {
            QFilter f;
            String number = (String)this.getView().getModel().getValue(NUMBER);
            Object longnumber = this.getView().getModel().getValue(LONGNUMBER);
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            if (longnumber != null) {
                f = new QFilter(LONGNUMBER, "not like", (Object)(longnumber.toString() + longNumberDLM + "%"));
                qFilters.add(f);
                QFilter f2 = new QFilter(NUMBER, "!=", (Object)number);
                qFilters.add(f2);
            } else {
                f = new QFilter(NUMBER, "!=", (Object)number);
                qFilters.add(f);
                QFilter f2 = new QFilter(LONGNUMBER, "not like", (Object)("%" + longNumberDLM + number + longNumberDLM + "%"));
                qFilters.add(f2);
                QFilter f3 = new QFilter(LONGNUMBER, "not like", (Object)(number + longNumberDLM + "%"));
                qFilters.add(f3);
            }
            ListFilterParameter filter = new ListFilterParameter(qFilters, null);
            para.setListFilterParameter(filter);
        }
        if (prop instanceof ParentBasedataProp) {
            para.setMultiSelect(false);
        }
        return para;
    }

    private StyleCss setStyleCss(String width, String hight) {
        StyleCss css = new StyleCss();
        css.setWidth(width);
        css.setHeight(hight);
        return css;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        if ("bos_group".equals(this.getView().getEntityId())) {
            Map para;
            if (e.getReturnData() != null && StringUtils.isNotBlank((para = (Map)e.getReturnData()).get("fparentid"))) {
                this.getModel().setValue("parentid", (Object)Integer.parseInt((String)para.get("fparentid")));
            }
        } else {
            super.closedCallBack(e);
        }
    }
}

