/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.field;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.config.VerityConfiguration;
import kd.bos.dataentity.entity.ILocaleValue;
import kd.bos.dataentity.entity.LocaleValue;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.decode.DecodeHandlerFactory;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.BindingContext;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.EnterKeyEvent;
import kd.bos.form.control.events.EnterKeyListener;
import kd.bos.form.control.events.FireFocusEvent;
import kd.bos.form.control.events.ISuportClick;
import kd.bos.form.control.events.InputFocusListener;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.rule.DecodeRulesHandle;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkPublic;
import org.slf4j.LoggerFactory;

@KSObject
@SdkPublic
public class TextEdit
extends FieldEdit
implements ISuportClick {
    private static final String SPAN_TYPE_PLUGIN = "plugin";
    private boolean sensitiveInfo;
    private static final String TEXT_POST_VALUE = "textPostValue";
    private static final String TEXT_POST_MODEL_VALUE = "_textPostModelValue";
    protected List<ClickListener> buttonClickListeners = new ArrayList<ClickListener>();
    protected List<HyperLinkClickListener> hyperLinkClickListeners;
    private boolean fireFocus = false;
    private List<InputFocusListener> inputFocusListeners = new ArrayList<InputFocusListener>();
    private List<EnterKeyListener> enterKeyListeners = new ArrayList<EnterKeyListener>(10);

    public void addButtonClickListener(ClickListener listener) {
        this.buttonClickListeners.add(listener);
    }

    @KSMethod
    public void addHyperClickListener(HyperLinkClickListener listener) {
        if (this.hyperLinkClickListeners == null) {
            this.hyperLinkClickListeners = new ArrayList<HyperLinkClickListener>();
        }
        this.hyperLinkClickListeners.add(listener);
    }

    @KSMethod
    public boolean isFireFocus() {
        return this.fireFocus;
    }

    public void setFireFocus(boolean isFireFocus) {
        this.fireFocus = isFireFocus;
    }

    @KSMethod
    public void addInputFocusListener(InputFocusListener listener) {
        IClientViewProxy proxy = (IClientViewProxy)this.view.getService(IClientViewProxy.class);
        ArrayList<Object> paras = new ArrayList<Object>(2);
        HashMap<String, Boolean> ctl = new HashMap<String, Boolean>();
        ctl.put("fireFocusEvent", true);
        paras.add(this.getKey());
        paras.add(ctl);
        proxy.addAction("updateControlMetadata", paras);
        this.inputFocusListeners.add(listener);
    }

    @KSMethod
    public void inputFocus(boolean isFocus) {
        this.setFireFocus(isFocus);
        FireFocusEvent event = new FireFocusEvent(this);
        for (InputFocusListener inputFocusListener : this.inputFocusListeners) {
            inputFocusListener.inputFocus(event);
        }
    }

    @KSMethod
    public void setFireEnter(boolean fireEnter) {
        IClientViewProxy proxy = (IClientViewProxy)this.view.getService(IClientViewProxy.class);
        ArrayList<Object> paras = new ArrayList<Object>(2);
        HashMap<String, Boolean> ctl = new HashMap<String, Boolean>();
        ctl.put("setFireEnter", fireEnter);
        paras.add(this.getKey());
        paras.add(ctl);
        proxy.addAction("updateControlMetadata", paras);
    }

    @KSMethod
    public void addEnterKeyListener(EnterKeyListener listener) {
        this.enterKeyListeners.add(listener);
    }

    @KSMethod
    public void enterKeyEvent(String content) {
        EnterKeyEvent event = new EnterKeyEvent(this, content);
        for (EnterKeyListener enterKeyListener : this.enterKeyListeners) {
            enterKeyListener.enterKeyEvent(event);
        }
    }

    @SimplePropertyAttribute(name="SensitiveInfo")
    public boolean isSensitiveInfo() {
        return this.sensitiveInfo;
    }

    public void setSensitiveInfo(boolean sensitiveInfo) {
        this.sensitiveInfo = sensitiveInfo;
    }

    public void click() {
        BeforeClickEvent e = new BeforeClickEvent(this);
        this.fireBeforeClick(e);
        if (!e.isCancel()) {
            ClickEvent e1 = new ClickEvent(this);
            this.fireClick(e1);
        }
    }

    protected void fireBeforeClick(BeforeClickEvent e) {
        for (ClickListener l : this.buttonClickListeners) {
            EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".beforeClick"));
            Throwable throwable = null;
            try {
                l.beforeClick(e);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                span.close();
            }
        }
    }

    protected void fireClick(ClickEvent e) {
        if (this.buttonClickListeners != null) {
            for (ClickListener l : this.buttonClickListeners) {
                EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".click"));
                Throwable throwable = null;
                try {
                    l.click(e);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (span == null) continue;
                    if (throwable != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    span.close();
                }
            }
        }
    }

    @Override
    public Object getBindingValue(BindingContext bctx) {
        Object v;
        IDataEntityProperty prop = this.getProperty();
        boolean isPassword = false;
        if (prop instanceof TextProp) {
            isPassword = ((TextProp)prop).isPassword();
        }
        if ((v = super.getBindingValue(bctx)) instanceof ILocaleValue) {
            if (isPassword) {
                v = new LocaleValue((Object)"******");
            }
        } else if (StringUtils.isBlank((Object)v)) {
            v = "";
        } else if (isPassword) {
            v = "******";
        }
        return v;
    }

    @Override
    public void addClickListener(ClickListener listener) {
        this.buttonClickListeners.add(listener);
    }

    @Override
    public void addItemClickListener(ItemClickListener listener) {
    }

    @Override
    protected boolean postDataCheck(Object value) {
        if (!VerityConfiguration.needCheckTextLength()) {
            return true;
        }
        IDataEntityProperty prop = this.getProperty();
        if (null == value) {
            return true;
        }
        boolean legal = true;
        if (prop instanceof TextProp) {
            legal = this.checkTextBounds(value);
        }
        return legal;
    }

    private boolean checkTextBounds(Object value) {
        TextProp textProp = (TextProp)this.prop;
        boolean legal = true;
        if (this.prop instanceof MuliLangTextProp) {
            if (value instanceof Map) {
                Map multiLang = (Map)value;
                for (Map.Entry item : multiLang.entrySet()) {
                    String itemValue = (String)item.getValue();
                    if (this.isLegalBound(itemValue, textProp.getMaxLenth())) continue;
                    legal = false;
                    break;
                }
            }
        } else {
            legal = this.isLegalBound(value, textProp.getMaxLenth());
        }
        if (!legal) {
            String msg = ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%1$s\u201d\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4[%2$s,%3$s]\u3002", (String)"TextEdit_0", (String)"bos-form-metadata", (Object[])new Object[0]);
            this.postErrorMessage = String.format(msg, this.prop.getDisplayName(), textProp.getMinLenth(), textProp.getMaxLenth());
        }
        return legal;
    }

    private boolean isLegalBound(Object value, int maxLength) {
        if (StringUtils.isBlank((Object)value)) {
            return true;
        }
        if (0 == maxLength) {
            return true;
        }
        int len = value.toString().trim().length();
        return len <= maxLength;
    }

    @Override
    public void postBack(Object value, int rowIndex, int parentRowIndex) {
        if (value instanceof String) {
            String type = this.getView().getFormShowParameter().getFormConfig().getKdEncoding();
            value = DecodeHandlerFactory.getDecodeHandler(type).decode(value.toString());
        }
        value = this.decryptRsaContent(value);
        if (StringUtils.isBlank((CharSequence)this.getEntryKey())) {
            this.getModel().putContextVariable(this.getKey() + TEXT_POST_MODEL_VALUE, value);
        }
        super.postBack(value, rowIndex, parentRowIndex);
        if (StringUtils.isNotBlank((Object)value)) {
            this.addNewLineIfKeyField(1, rowIndex);
        }
    }

    @Override
    protected void sendUpdateAction(BindingContext bctx, Object v) {
        if (StringUtils.isNotBlank((CharSequence)this.getEntryKey())) {
            super.sendUpdateAction(bctx, v);
            return;
        }
        IDataEntityProperty prop = this.getProperty();
        boolean isPassword = false;
        if (prop instanceof TextProp) {
            isPassword = ((TextProp)prop).isPassword();
        }
        if (isPassword) {
            Object postModelValue;
            Object originalValue = super.getBindingValue(bctx);
            if (StringUtils.isBlank((Object)originalValue)) {
                originalValue = "";
            }
            if ((postModelValue = this.getModel().getContextVariable(this.getKey() + TEXT_POST_MODEL_VALUE)) != null && postModelValue.equals(originalValue)) {
                return;
            }
        }
        super.sendUpdateAction(bctx, v);
    }

    @Override
    public boolean isDesensitizeField() {
        boolean isPassword = false;
        if (this.prop instanceof TextProp) {
            isPassword = ((TextProp)this.prop).isPassword();
        }
        if (isPassword) {
            return false;
        }
        return super.isDesensitizeField();
    }

    private Object decryptRsaContent(Object value) {
        TextProp property;
        boolean isPassword;
        if (this.getProperty() instanceof TextProp && (isPassword = (property = (TextProp)this.getProperty()).isPassword())) {
            Object content = null;
            try {
                content = DecodeRulesHandle.decryptRsaContent(value);
            }
            catch (Exception e) {
                boolean isForceGet = false;
                if (e instanceof KDException && (BosErrorCode.nullError.getCode().equals(((KDException)((Object)e)).getErrorCode().getCode()) || BosErrorCode.paramError.getCode().equals(((KDException)((Object)e)).getErrorCode().getCode()))) {
                    isForceGet = true;
                }
                LoggerFactory.getLogger(TextEdit.class).error(String.format(ResManager.loadKDString((String)"Rsa\u89e3\u5bc6\u5931\u8d25\uff1a %1$s", (String)"TextEdit_2", (String)"bos-form-metadata", (Object[])new Object[0]), e.getMessage()));
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u5b57\u6bb5\u5f02\u5e38\u5bfc\u81f4\u4fee\u6539\u503c\u65e0\u6548\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TextEdit_1", (String)"bos-form-metadata", (Object[])new Object[0]), property.getName()));
                content = this.getModel().getValue(this.getKey());
                IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                HashMap<String, String> map = new HashMap<String, String>(1);
                map.put("publicKey", DecodeRulesHandle.getRsaPublicKey(isForceGet));
                proxy.addAction("retryPublicKey", map);
            }
            return content;
        }
        return value;
    }

    @KSMethod
    public void showSoftKeyboardWhenFocused(boolean isShow) {
        IClientViewProxy proxy = (IClientViewProxy)this.view.getService(IClientViewProxy.class);
        HashMap<String, Boolean> ctl = new HashMap<String, Boolean>(1);
        ctl.put("isShow", isShow);
        proxy.invokeControlMethod(this.getKey(), "showSoftKeyboardWhenFocused", ctl);
    }

    @KSMethod
    public void hyperLinkClick() {
        HyperLinkClickEvent hyperLinkClickEvent = new HyperLinkClickEvent(this, this.getKey(), -1);
        if (this.hyperLinkClickListeners != null) {
            for (HyperLinkClickListener hyperLinkClickListener : this.hyperLinkClickListeners) {
                EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(hyperLinkClickListener.getClass().getName() + ".hyperLinkClick"));
                Throwable throwable = null;
                try {
                    hyperLinkClickListener.hyperLinkClick(hyperLinkClickEvent);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (span == null) continue;
                    if (throwable != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    span.close();
                }
            }
        }
    }
}

