/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.field;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.BindingContext;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.FieldEdit;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class TimeRangeEdit
extends FieldEdit {
    private String startDateFieldKey;
    private String endDateFieldKey;
    private String aboveEqual = "39";
    private String belowEqual = "16";
    private boolean allowBindData = true;
    private static final String FOCUS_VALUE = "focusValue";
    private static final String ROW_INDEX = "rowIndex";

    @Override
    public void postBack(Object value, int rowIndex, int parentRowIndex) {
        boolean isOnlyStartTimeChanged;
        Object oldEndTimeValue;
        Object oldStartTimeValue;
        String[] strs;
        int startTime = -1;
        int endTime = -1;
        if (value != null && (strs = value.toString().replaceAll("\\s*", "").split(",")).length == 2) {
            startTime = Integer.parseInt(strs[0]);
            endTime = Integer.parseInt(strs[1]);
        }
        IDataModel dataModel = this.view.getModel();
        IDataEntityProperty startTimeProp = dataModel.getProperty(this.startDateFieldKey);
        IDataEntityProperty endTimeProp = dataModel.getProperty(this.endDateFieldKey);
        if (StringUtils.isNotBlank((CharSequence)this.getEntryKey())) {
            DynamicObject rowDynamicObject = dataModel.getEntryRowEntity(this.getEntryKey(), rowIndex);
            if (rowDynamicObject == null) {
                return;
            }
            oldStartTimeValue = rowDynamicObject.getDataStorage().getLocalValue(startTimeProp);
            oldEndTimeValue = rowDynamicObject.getDataStorage().getLocalValue(endTimeProp);
        } else {
            oldStartTimeValue = dataModel.getDataEntity().getDataStorage().getLocalValue(startTimeProp);
            oldEndTimeValue = dataModel.getDataEntity().getDataStorage().getLocalValue(endTimeProp);
        }
        boolean bl = isOnlyStartTimeChanged = !this.isValueEquals(oldStartTimeValue, startTime) && this.isValueEquals(oldEndTimeValue, endTime);
        if (!isOnlyStartTimeChanged) {
            this.setAllowBindData(false);
        }
        dataModel.setValue(this.getStartDateFieldKey(), (Object)startTime, rowIndex, parentRowIndex);
        this.setAllowBindData(true);
        String endTimeFildKey = this.getEndDateFieldKey();
        dataModel.setValue(endTimeFildKey, (Object)endTime, rowIndex, parentRowIndex);
    }

    private boolean isValueEquals(Object v1, Object v2) {
        if (v1 == null && v2 == null) {
            return true;
        }
        if (v1 == null) {
            return false;
        }
        return v1.equals(v2);
    }

    private void setAllowBindData(boolean allowBindData) {
        this.allowBindData = allowBindData;
    }

    private boolean isAllowBindData() {
        return this.allowBindData;
    }

    @Override
    public Object getBindingValue(BindingContext bctx) {
        Object startTime = this.getBindingValue(this.startDateFieldKey, bctx);
        Object endTime = this.getBindingValue(this.endDateFieldKey, bctx);
        return this.getValue(startTime, endTime);
    }

    public Object getBindingValue(String fieldkey, BindingContext bctx) {
        IDataModel dataModel = (IDataModel)this.view.getService(IDataModel.class);
        IDataEntityProperty prop = dataModel.getProperty(fieldkey);
        return prop.getValue(bctx.getDataEntity());
    }

    @Override
    public void bindData(BindingContext bctx) {
        if (!this.isAllowBindData()) {
            return;
        }
        Object startTime = this.getBindingValue(this.getStartDateFieldKey(), bctx);
        Object endTime = this.getBindingValue(this.getEndDateFieldKey(), bctx);
        this.setValue(this.getValue(startTime, endTime), bctx.getRowIndex());
        HashMap<String, String> meta = new HashMap<String, String>();
        meta.put("k", this.getFieldKey());
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.addAction("u", meta);
    }

    private void setValue(Object v, int row) {
        IDataModel dataModel = (IDataModel)this.view.getService(IDataModel.class);
        IDataEntityProperty prop = dataModel.getProperty(this.getStartDateFieldKey());
        if (prop.getParent() instanceof EntryType) {
            EntryGrid grid = this.getEntryGrid();
            this.clientViewProxy.setEntryFieldValue(grid, this.getFieldKey(), row, v);
        } else {
            this.clientViewProxy.setFieldProperty(this.getKey(), "v", v);
        }
    }

    private String getValue(Object startTime, Object endTime) {
        StringBuilder value = new StringBuilder();
        if (startTime == null) {
            value.append("-1");
        } else {
            value.append(String.valueOf(startTime));
        }
        value.append(", ");
        if (endTime == null) {
            value.append("-1");
        } else {
            value.append(String.valueOf(endTime));
        }
        return value.toString();
    }

    @SimplePropertyAttribute(name="StartDateFieldKey")
    public String getStartDateFieldKey() {
        return this.startDateFieldKey;
    }

    public void setStartDateFieldKey(String startDateFieldKey) {
        this.startDateFieldKey = startDateFieldKey;
    }

    @SimplePropertyAttribute(name="EndDateFieldKey")
    public String getEndDateFieldKey() {
        return this.endDateFieldKey;
    }

    public void setEndDateFieldKey(String endDateFieldKey) {
        this.endDateFieldKey = endDateFieldKey;
    }

    @Override
    public IDataEntityProperty getProperty() {
        if (this.view == null) {
            return null;
        }
        if (this.prop == null) {
            if (StringUtils.isNotBlank((CharSequence)this.getStartDateFieldKey())) {
                this.prop = ((IDataModel)this.view.getService(IDataModel.class)).getProperty(this.getStartDateFieldKey());
            } else if (StringUtils.isNotBlank((CharSequence)this.getEndDateFieldKey())) {
                this.prop = ((IDataModel)this.view.getService(IDataModel.class)).getProperty(this.getEndDateFieldKey());
            }
        }
        return this.prop;
    }

    @Override
    public List<Map<String, List<Object>>> getDefaultFilters() {
        ArrayList<Map<String, List<Object>>> defaultFilterList = new ArrayList<Map<String, List<Object>>>();
        IDataEntityProperty prop = this.getModel().getProperty(this.startDateFieldKey);
        if (prop.getParent() instanceof EntryType) {
            return defaultFilterList;
        }
        HashMap startCommonFilter = new HashMap();
        ArrayList<String> compareList = new ArrayList<String>();
        compareList.add(this.aboveEqual);
        ArrayList<String> nameList = new ArrayList<String>();
        nameList.add(this.startDateFieldKey);
        ArrayList<Object> valueList = new ArrayList<Object>();
        valueList.add(this.getModel().getValue(this.startDateFieldKey));
        startCommonFilter.put("FieldName", nameList);
        startCommonFilter.put("Value", valueList);
        startCommonFilter.put("Compare", compareList);
        defaultFilterList.add(startCommonFilter);
        HashMap<String, ArrayList<Object>> endCommonFilter = new HashMap<String, ArrayList<Object>>();
        compareList = new ArrayList();
        compareList.add(this.belowEqual);
        nameList = new ArrayList();
        nameList.add(this.endDateFieldKey);
        valueList = new ArrayList();
        valueList.add(this.getModel().getValue(this.endDateFieldKey));
        endCommonFilter.put("FieldName", nameList);
        endCommonFilter.put("Value", valueList);
        endCommonFilter.put("Compare", compareList);
        defaultFilterList.add(endCommonFilter);
        return defaultFilterList;
    }

    public void setTimeFocusValue(long startTime, long endTime) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(FOCUS_VALUE, Arrays.asList(String.valueOf(startTime), String.valueOf(endTime)));
        map.put(ROW_INDEX, -1);
        proxy.invokeControlMethod(this.getKey(), "setTimeRangeFocusValue", map);
    }

    public void setEntryTimeFocusValue(long startTime, long endTime, int rowIndex) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(FOCUS_VALUE, Arrays.asList(String.valueOf(startTime), String.valueOf(endTime)));
        map.put(ROW_INDEX, rowIndex);
        proxy.invokeControlMethod(this.getKey(), "setTimeRangeFocusValue", map);
    }
}

