/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.field;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import kd.bos.basedata.query.UserQuery;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.FilterUtil;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.UserProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.CoreShowFormHelper;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IMobileView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.MobileListShowParameter;
import kd.bos.list.events.DataSelectEvent;
import kd.bos.list.events.EndSelectEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.param.ParameterReader;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class UserEdit
extends BasedataEdit {
    private static final String SPAN_TYPE_PLUGIN = "plugin";
    private static final String KEY_LIST_MULTI = "isMulti";
    private static final String KEY_LIST_SELECTED = "selected";
    private boolean userF7MultipleSelect;
    private boolean isIncludeAllSub = false;
    private static final String VIEW_STYLE = "view_style";
    private static final String VIEW_STYLE_BILL = "bill";
    private static final String VIEW_STYLE_LIST = "list";
    private static final String VIEW_STYLE_TREE = "tree";
    private static final String BOS_FORM_METADATA = "bos-form-metadata";
    List<Consumer<EndSelectEvent>> endSelectEventListeners = new ArrayList<Consumer<EndSelectEvent>>();
    List<Consumer<DataSelectEvent>> dataSelectEventListeners = new ArrayList<Consumer<DataSelectEvent>>();

    public void addEndSelectEventListener(Consumer<EndSelectEvent> endSelectEventListener) {
        this.endSelectEventListeners.add(endSelectEventListener);
    }

    public void addDataSelectEventListener(Consumer<DataSelectEvent> dataSelectEventListener) {
        this.dataSelectEventListeners.add(dataSelectEventListener);
    }

    @SimplePropertyAttribute
    public boolean getIsIncludeAllSub() {
        return this.isIncludeAllSub;
    }

    public void setIsIncludeAllSub(Boolean isIncludeAllSub) {
        this.isIncludeAllSub = isIncludeAllSub;
    }

    public void showDataSelect() {
        if (!(this.getView() instanceof IMobileView)) {
            return;
        }
        DataSelectEvent dataSelectEvent = new DataSelectEvent(this);
        for (Consumer<DataSelectEvent> dataSelectEventListener : this.dataSelectEventListeners) {
            EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(dataSelectEventListener.getClass().getName() + ".accept"));
            Throwable throwable = null;
            try {
                dataSelectEventListener.accept(dataSelectEvent);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                span.close();
            }
        }
        BasedataProp prop = (BasedataProp)this.getProperty();
        if (prop != null) {
            FormShowParameter para = this.createShowMobilePara(prop);
            para.setCustomParam(KEY_LIST_MULTI, dataSelectEvent.isMultiple());
            para.setCustomParam(KEY_LIST_SELECTED, dataSelectEvent.getSelectedValues());
            CloseCallBack callBack = dataSelectEvent.getCloseCallBack();
            if (callBack == null) {
                callBack = new CloseCallBack();
                callBack.setControlKey(this.getKey());
            }
            para.setCloseCallBack(callBack);
            this.setBeforeF7SelectEvent(para);
        }
    }

    private void setBeforeF7SelectEvent(FormShowParameter para) {
        if (this.beforeF7SelectListeners != null) {
            int row = 0;
            if (this.getProperty().getParent() != null) {
                row = this.getView().getModel().getEntryCurrentRowIndex(this.getProperty().getParent().getName());
            }
            BeforeF7SelectEvent evt = new BeforeF7SelectEvent(this, row, this.getModel().getValue(this.key));
            evt.setFormShowParameter(para);
            for (BeforeF7SelectListener l : this.beforeF7SelectListeners) {
                l.beforeF7Select(evt);
            }
            if (evt.isCancel()) {
                return;
            }
        }
        this.view.showForm(para);
    }

    @Override
    protected List<QFilter> getOtherFilters() {
        List<QFilter> otherFilters = super.getOtherFilters();
        otherFilters.addAll(FilterUtil.buildDataPermissionFilter((String)this.getBaseEntityId(), (boolean)this.isShowUsed(), (boolean)true));
        otherFilters.removeIf(Objects::isNull);
        return otherFilters;
    }

    private FormShowParameter createShowMobilePara(BasedataProp prop) {
        int f7Style = ((UserProp)prop).getF7Style();
        String viewStyle = this.getViewStyleParameter();
        if (VIEW_STYLE_LIST.equals(viewStyle)) {
            f7Style = 2;
        } else if (VIEW_STYLE_TREE.equals(viewStyle)) {
            f7Style = 1;
        }
        if (2 == f7Style) {
            return this.createMobileListShowParameter(prop);
        }
        MobileFormShowParameter para = new MobileFormShowParameter();
        para.setFormId("bos_mobileuserlist");
        para.getOpenStyle().setShowType(ShowType.Floating);
        para.setCustomParam("islookup", true);
        para.setHasRight(true);
        para.setCustomParam("entityId", prop.getBaseEntityId());
        para.setCustomParam(KEY_LIST_MULTI, this.isUserF7MultipleSelect());
        para.setCustomParam("_F7Style_", f7Style);
        List<QFilter> otherFilters = this.getOtherFilters();
        if (!otherFilters.isEmpty()) {
            HashSet<QFilter> otherFilterSet = new HashSet<QFilter>(otherFilters);
            QFilter otherFilter = null;
            for (QFilter otFilter : otherFilterSet) {
                if (otherFilter == null) {
                    otherFilter = otFilter;
                    continue;
                }
                otherFilter = otherFilter.and(otFilter);
            }
            if (otherFilter != null) {
                para.setCustomParam("_otherFilters_", otherFilter.toSerializedString());
            }
        }
        boolean mustInput = prop.isMustInput();
        para.setCustomParam("mustInput", mustInput);
        return para;
    }

    private String getViewStyleParameter() {
        String viewStyle = VIEW_STYLE_BILL;
        DynamicObject billParamObj = ParameterReader.getBillParameter((String)"bos_user");
        if (billParamObj != null && billParamObj.getDataEntityType().getProperties().containsKey((Object)VIEW_STYLE)) {
            viewStyle = billParamObj.getString(VIEW_STYLE);
        }
        return viewStyle;
    }

    private FormShowParameter createMobileListShowParameter(BasedataProp prop) {
        ListFilterParameter listFilterParameter;
        MobileListShowParameter para = new MobileListShowParameter();
        String formId = "bos_user";
        FormConfig formConfig = FormMetadataCache.getMobListFormConfig(formId);
        para.setCaption(formConfig.getCaption().toString());
        para.setLookUp(true);
        para.setHasRight(true);
        para.setBillFormId(formId);
        para.getOpenStyle().setShowType(ShowType.Floating);
        para.setMultiSelect(this.isUserF7MultipleSelect());
        para.setSelectedRows(this.getPkIds());
        para.setMustInput(prop.isMustInput());
        String f7ListFormId = formConfig.getF7ListFormId();
        if (StringUtils.isNotBlank((CharSequence)f7ListFormId)) {
            para.setFormId(f7ListFormId);
        }
        if (null != (listFilterParameter = para.getListFilterParameter())) {
            listFilterParameter.getQFilters().addAll(this.getOtherFilters());
        } else {
            ListFilterParameter filterParameter = new ListFilterParameter();
            filterParameter.setQFilters(this.getOtherFilters());
            para.setListFilterParameter(filterParameter);
        }
        return para;
    }

    @Override
    protected ListShowParameter createShowListForm(BasedataProp prop) {
        String formId = "";
        formId = StringUtils.isNotBlank((CharSequence)prop.getLayoutId()) ? prop.getLayoutId() : prop.getBaseEntityId();
        ListShowParameter para = CoreShowFormHelper.createShowListForm(new CoreShowFormHelper.ListParamCreateOption(formId, this.isEntryProperty(this.getProperty()), ((UserProp)prop).getF7Style(), true));
        this.addFilter(para);
        para.setF7Style(((UserProp)prop).getF7Style());
        para.setCustomParam("isIncludeAllSub", this.isIncludeAllSub);
        return para;
    }

    @Override
    public void click() {
        if (!(this.getView() instanceof IMobileView)) {
            super.click();
            return;
        }
        BasedataProp prop = (BasedataProp)this.getProperty();
        if (prop != null) {
            FormShowParameter para = this.createShowMobilePara(prop);
            para.setCustomParam(KEY_LIST_SELECTED, this.getPkIds());
            CloseCallBack closeCallBack = new CloseCallBack();
            closeCallBack.setControlKey(this.getKey());
            para.setCloseCallBack(closeCallBack);
            this.setBeforeF7SelectEvent(para);
        }
    }

    public void setYzjFilter(String filter) {
        HashMap<String, Object> prop = new HashMap<String, Object>(1);
        prop.put("filter", filter);
        this.view.updateControlMetadata(this.getKey(), prop);
    }

    public void endSelect(Object params) {
        EndSelectEvent endSelectEvent = new EndSelectEvent(this);
        endSelectEvent.setData(params);
        for (Consumer<EndSelectEvent> endSelectEventListener : this.endSelectEventListeners) {
            EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(endSelectEventListener.getClass().getName() + ".accept"));
            Throwable throwable = null;
            try {
                endSelectEventListener.accept(endSelectEvent);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                span.close();
            }
        }
        if (!endSelectEvent.isCancel() && params instanceof ArrayList && !((ArrayList)params).isEmpty()) {
            String openID = ((ArrayList)params).get(0).toString();
            String userId = UserQuery.getUserID((String)openID);
            if (StringUtils.isBlank((CharSequence)userId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7528\u6237\u5728\u5f53\u524d\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff01", (String)"UserEdit_0", (String)BOS_FORM_METADATA, (Object[])new Object[0]));
                return;
            }
            IDataModel model = (IDataModel)this.view.getService(IDataModel.class);
            model.setValue(this.getFieldKey().toLowerCase(), (Object)userId);
        }
    }

    public boolean isUserF7MultipleSelect() {
        return this.userF7MultipleSelect;
    }

    public void setUserF7MultipleSelect(boolean userF7MultipleSelect) {
        this.userF7MultipleSelect = userF7MultipleSelect;
    }
}

