/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.gridconfig;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.CompareType;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.operate.FlexGridConfigRow;
import kd.bos.entity.operate.GridConfigurationRow;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.entity.userconfig.UserConfig;
import kd.bos.filter.ListColumnCompareHelper;
import kd.bos.form.ICallParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormUserConfig;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.OperationColumn;
import kd.bos.form.field.BasedataPropEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.FlexEdit;
import kd.bos.form.flex.FlexSplitColsCache;
import kd.bos.form.flex.FlexSplitColumn;
import kd.bos.list.AbstractListColumn;
import kd.bos.list.IListColumn;
import kd.bos.list.IListColumnConfig;
import kd.bos.list.IListColumnGroupConfig;
import kd.bos.list.ListColumnCompareType;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.param.ParameterReader;
import kd.bos.param.constant.UserParaType;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataService;
import kd.bos.userconfig.GridConfigDAO;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class GridConfigRenderUtils {
    private static final String KEY_ITEMS = "items";
    public static final String ENTRYFIELD_SETTING = "entryfield_setting";
    public static final String SETTING_IN_ENTRY = "setting_in_entry";
    private static final String CHILDREN = "children";
    private static final String TYPE_NAME = "GridConfigUitls";
    private static final String SPAN_COMPARETYPES = "compareTypes";
    private static final String SPAN_FIELDNAME = "fieldname";
    private static final String UPDATE_GRIDCOLUMN_METADATA = "updateGridColumnMetaData";
    private static final String KEY_ORDERANDFILTER = "orderAndFilter";
    private static final List<String> FILTERANDSORT_COLUMN_PROPS = Arrays.asList("sort", "filter", "filterItems", "isBaseData", "comboItems");
    private static final String BOS_ORG = "73f9bf0200001dac";
    private static final int FLEX_SPLIT_STAT = 1;
    private static final int FLEX_MERGE_STAT = 0;

    private GridConfigRenderUtils() {
    }

    @Deprecated
    public static void renderGridConfig(IFormView view, String entryId, List<GridConfigurationRow> gridConfigurationRows) {
        Map<String, Object> entryMeta;
        GridConfigRenderUtils.setCellSum(view, entryId);
        List<Map<String, String>> freezeList = null;
        List<Map<String, String>> initField = null;
        Object control = view.getControl(entryId);
        if (control instanceof EntryGrid) {
            freezeList = ((EntryGrid)view.getControl(entryId)).getFreezeList();
            initField = ((EntryGrid)view.getControl(entryId)).getInitField();
        }
        String formId = view.getFormShowParameter().getFormId();
        IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        if (!(CollectionUtils.isEmpty(gridConfigurationRows) && CollectionUtils.isEmpty(freezeList) && !GridConfigRenderUtils.isServerFilterModle(control) && CollectionUtils.isEmpty(initField) || (entryMeta = GridConfigRenderUtils.getEntryRuntimeMeta(formId, entryId)) == null)) {
            HashMap<String, Object> configMeta = new HashMap<String, Object>(16);
            List columnMeta = (List)entryMeta.get("columns");
            List<Map<String, Object>> dynamicCreateColumns = GridConfigRenderUtils.getDynamicCreateColumns(view, entryId, columnMeta);
            if (!CollectionUtils.isEmpty(dynamicCreateColumns)) {
                columnMeta.addAll(dynamicCreateColumns);
            }
            if (!CollectionUtils.isEmpty(freezeList)) {
                GridConfigRenderUtils.setListColumnFixed(columnMeta, freezeList);
            }
            if (!CollectionUtils.isEmpty(initField)) {
                GridConfigRenderUtils.setInitField(columnMeta, initField);
            }
            if (GridConfigRenderUtils.isServerFilterModle(control)) {
                GridConfigRenderUtils.setColumnCompareOperators(view, columnMeta, entryMeta.get(KEY_ORDERANDFILTER));
            }
            List<Map<String, Object>> reorderMeta = GridConfigRenderUtils.mergeConfigAndMeta(columnMeta, gridConfigurationRows);
            entryMeta.put("columns", reorderMeta);
            configMeta.putAll(entryMeta);
            proxy.removeInvokeControlMethod(param -> Optional.ofNullable(param).filter(p -> entryId.equals(p.getkey()) && "createGridColumns".equals(p.getmethodname())).map(ICallParameter::getargs).filter(args -> ((Object[])args).length > 0 && args[0] instanceof Map && ((Map)args[0]).containsKey("columns")).isPresent());
            proxy.invokeControlMethod(entryId, "createGridColumns", configMeta);
        }
    }

    public static void renderGridConfig(IFormView view, String entryId) {
        List gridConfigurationRows = null;
        IFormUserConfig service = (IFormUserConfig)view.getService(IFormUserConfig.class);
        if (service == null) {
            GridConfigDAO gridConfigDAO = new GridConfigDAO();
            gridConfigurationRows = gridConfigDAO.getGridConfig(view.getFormShowParameter().getFormId(), entryId);
        } else {
            String key = GridConfigDAO.buildUserConfigKey((String)view.getFormShowParameter().getFormId(), (String)entryId);
            UserConfig userConfig = service.loadUserConfig(key);
            gridConfigurationRows = userConfig == null || StringUtils.isBlank((CharSequence)userConfig.getSetting()) ? new ArrayList() : SerializationUtils.fromJsonStringToList((String)userConfig.getSetting(), GridConfigurationRow.class);
        }
        GridConfigRenderUtils.updateGridConfig(view, entryId, gridConfigurationRows);
    }

    public static void resetGridConfig(IFormView view, String entryId) {
        GridConfigRenderUtils.updateGridConfig(view, entryId, null, true);
    }

    private static void updateGridConfig(IFormView view, String entryId, List<GridConfigurationRow> userGridConfigurationRows) {
        GridConfigRenderUtils.updateGridConfig(view, entryId, userGridConfigurationRows, false);
    }

    private static void updateGridConfig(IFormView view, String entryId, List<GridConfigurationRow> userGridConfigurationRows, boolean isReset) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"updateGridConfig");){
            if (span.isRealtime()) {
                span.addTag("entryId", entryId);
                span.addLocaleTag("userGridConfigurationRows", userGridConfigurationRows);
                span.addLocaleTag("isReset", (Object)isReset);
            }
            GridConfigRenderUtils.setCellSum(view, entryId);
            String formId = view.getFormShowParameter().getFormId();
            IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
            Object control = view.getControl(entryId);
            List<Map<String, String>> freezeList = null;
            List<Map<String, String>> initField = null;
            if (control instanceof EntryGrid) {
                freezeList = ((EntryGrid)view.getControl(entryId)).getFreezeList();
                initField = ((EntryGrid)view.getControl(entryId)).getInitField();
            }
            List<GridConfigurationRow> gridConfigurationRows = null;
            boolean serverFilterModle = GridConfigRenderUtils.isServerFilterModle(control);
            if (isReset || !CollectionUtils.isEmpty(userGridConfigurationRows) || !CollectionUtils.isEmpty(freezeList) || serverFilterModle || !CollectionUtils.isEmpty(initField)) {
                Map<String, Object> entryMeta;
                List<GridConfigurationRow> entityGridConfigurationRows = GridConfigRenderUtils.getFieldApInfo(view, formId, entryId);
                if (entityGridConfigurationRows == null) {
                    entityGridConfigurationRows = new ArrayList<GridConfigurationRow>(1);
                }
                if ((entryMeta = GridConfigRenderUtils.getEntryRuntimeMeta(formId, entryId)) == null) {
                    return;
                }
                List columnMetas = (List)entryMeta.get("columns");
                if (!CollectionUtils.isEmpty(freezeList)) {
                    GridConfigRenderUtils.setListColumnFixed(entityGridConfigurationRows, freezeList);
                    GridConfigRenderUtils.setListColumnFixed(columnMetas, freezeList);
                }
                if (!CollectionUtils.isEmpty(initField)) {
                    GridConfigRenderUtils.setInitField(entityGridConfigurationRows, initField);
                }
                gridConfigurationRows = !CollectionUtils.isEmpty(userGridConfigurationRows) ? GridConfigRenderUtils.combineGridConfigurationRow(userGridConfigurationRows, entityGridConfigurationRows) : entityGridConfigurationRows;
                if (columnMetas != null && columnMetas.size() > 0) {
                    List<Map<String, Object>> dynamicColumnList = null;
                    if (serverFilterModle) {
                        dynamicColumnList = GridConfigRenderUtils.getDynamicCreateColumns(view, entryId, columnMetas);
                        if (!CollectionUtils.isEmpty(dynamicColumnList)) {
                            columnMetas.addAll(dynamicColumnList);
                        }
                        GridConfigRenderUtils.setColumnCompareOperators(view, columnMetas, entryMeta.get(KEY_ORDERANDFILTER));
                    }
                    Map<String, Map<String, Object>> columnMetaMap = GridConfigRenderUtils.getColumnMetaMap(columnMetas);
                    List<Map<String, Object>> updateGridConfigurationList = GridConfigRenderUtils.getUpdateGridConfigurationList(gridConfigurationRows, columnMetaMap, isReset, serverFilterModle);
                    if (!CollectionUtils.isEmpty(dynamicColumnList)) {
                        updateGridConfigurationList.addAll(GridConfigRenderUtils.getUpdateGridConfigurationByDynamicColumnList(columnMetaMap, dynamicColumnList));
                    }
                    HashMap<String, List<Map<String, Object>>> configMeta = new HashMap<String, List<Map<String, Object>>>(1);
                    if (!CollectionUtils.isEmpty(updateGridConfigurationList)) {
                        List<Map<String, Object>> sysColumnList = GridConfigRenderUtils.getSysColumnList(columnMetaMap);
                        sysColumnList.addAll(updateGridConfigurationList);
                        configMeta.put("columns", sysColumnList);
                    }
                    if (span.isRealtime()) {
                        span.addLocaleTag("serverFilterModle", (Object)serverFilterModle);
                        span.addLocaleTag("columnMetaMap", columnMetaMap);
                        span.addLocaleTag("freezeList", freezeList);
                        span.addLocaleTag("dynamicColumnList", dynamicColumnList);
                        span.addLocaleTag("configMeta", configMeta);
                    }
                    proxy.removeInvokeControlMethod(param -> Optional.ofNullable(param).filter(p -> entryId.equals(p.getkey()) && UPDATE_GRIDCOLUMN_METADATA.equals(p.getmethodname())).map(ICallParameter::getargs).filter(args -> ((Object[])args).length > 0 && args[0] instanceof Map && GridConfigRenderUtils.isEqUpdateGridColumnMetaData(configMeta, (Map)args[0])).isPresent());
                    proxy.invokeControlMethod(entryId, UPDATE_GRIDCOLUMN_METADATA, configMeta);
                }
            }
        }
    }

    public static void disableGridConfig(IFormView view, String entryId) {
        Map<String, Object> entryMeta = GridConfigRenderUtils.getEntryRuntimeMeta(view.getEntityId(), entryId);
        if (entryMeta != null) {
            List columnMeta = (List)entryMeta.get("columns");
            entryMeta.put("columns", columnMeta);
            IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
            proxy.invokeControlMethod(entryId, "createGridColumns", entryMeta);
        }
    }

    public static List<GridConfigurationRow> getFieldApInfo(IFormView view, String formId, String entryId) {
        Map<String, Object> entryMeta = GridConfigRenderUtils.getEntryRuntimeMeta(formId, entryId);
        List<Map<String, Object>> columnMeta = entryMeta == null ? new ArrayList() : (List)entryMeta.get("columns");
        Iterator iterator = columnMeta.iterator();
        while (iterator.hasNext()) {
            Map colMeta = (Map)iterator.next();
            Object dataIndex = colMeta.get("dataIndex");
            if (!"rk".equals(dataIndex) && !"seq".equals(dataIndex)) continue;
            iterator.remove();
        }
        return GridConfigRenderUtils.buildGridConfiguration(view, columnMeta);
    }

    private static List<GridConfigurationRow> buildGridConfiguration(IFormView view, List<Map<String, Object>> columnMeta) {
        ArrayList<GridConfigurationRow> currentFields = new ArrayList<GridConfigurationRow>(columnMeta.size());
        for (int i = 0; i < columnMeta.size(); ++i) {
            Object object;
            OperationStatus operationStatus;
            BillOperationStatus billOperationStatus;
            int visible;
            String visibleStr;
            Map<String, Object> colMeta = columnMeta.get(i);
            if (colMeta == null) continue;
            String string = visibleStr = colMeta.get("vi") == null ? "" : colMeta.get("vi").toString();
            if (StringUtils.isBlank((CharSequence)visibleStr) || ((visible = Integer.parseInt(visibleStr)) & 8) != 8 || (view instanceof IBillView ? (billOperationStatus = ((BillShowParameter)view.getFormShowParameter()).getBillStatus()) == BillOperationStatus.ADDNEW && (visible & 1) != 1 || billOperationStatus == BillOperationStatus.EDIT && (visible & 2) != 2 || billOperationStatus == BillOperationStatus.VIEW && (visible & 4) != 4 || billOperationStatus == BillOperationStatus.SUBMIT && (visible & 0x10) != 16 || billOperationStatus == BillOperationStatus.AUDIT && (visible & 0x20) != 32 : (operationStatus = view.getFormShowParameter().getStatus()) == OperationStatus.ADDNEW && (visible & 1) != 1 || operationStatus == OperationStatus.EDIT && (visible & 2) != 2 || operationStatus == OperationStatus.VIEW && (visible & 4) != 4)) continue;
            LocaleString name = new LocaleString();
            if (colMeta.get("header") != null) {
                for (Map.Entry entry : ((Map)colMeta.get("header")).entrySet()) {
                    name.setItem((String)entry.getKey(), entry.getValue());
                }
            }
            int width = 0;
            if (colMeta.get("w") != null) {
                for (Map.Entry entry2 : ((Map)colMeta.get("w")).entrySet()) {
                    if (!StringUtils.isNotBlank((CharSequence)((CharSequence)entry2.getValue())) || ((String)entry2.getValue()).contains("%")) continue;
                    width = Integer.parseInt(((String)entry2.getValue()).replace("px", "").split("\\.")[0]);
                    break;
                }
            }
            String textAlign = (object = colMeta.get("text-align")) instanceof String ? (String)object : "default";
            Object k = colMeta.get("dataIndex");
            String key = k instanceof String ? (String)k : null;
            GridConfigurationRow bean = new GridConfigurationRow(name, width, textAlign, key);
            Object children = colMeta.get(CHILDREN);
            if (children != null) {
                bean.setChildren(GridConfigRenderUtils.buildGridConfiguration(view, (List)children));
            }
            bean = GridConfigRenderUtils.buildGridConfigFlex(view, bean, colMeta);
            currentFields.add(bean);
        }
        return currentFields;
    }

    private static GridConfigurationRow buildGridConfigFlex(IFormView view, GridConfigurationRow bean, Map<String, Object> colMeta) {
        Object editor;
        if (colMeta != null && (editor = colMeta.get("editor")) instanceof Map && !StringUtils.equals((CharSequence)"flexfield", (CharSequence)((String)((Map)editor).get("type")))) {
            return bean;
        }
        String pageCacheKey = bean.getFieldKey() + ".splitCols";
        String flexSplitCols = view.getPageCache().get(pageCacheKey);
        if (StringUtils.isBlank((CharSequence)flexSplitCols)) {
            return bean;
        }
        FlexSplitColsCache flexSplitColsCache = (FlexSplitColsCache)SerializationUtils.fromJsonString((String)flexSplitCols, FlexSplitColsCache.class);
        Set<FlexSplitColumn> flexSplitColumnSet = flexSplitColsCache.getAllSplitColumnSet();
        ArrayList<GridConfigurationRow> flexChildren = new ArrayList<GridConfigurationRow>(flexSplitColumnSet.size());
        for (FlexSplitColumn splitColumn : flexSplitColumnSet) {
            LocaleString columnName = splitColumn.getColumnName();
            String dataIndex = (String)splitColumn.getDataIndex();
            GridConfigurationRow configurationRow = new GridConfigurationRow(columnName, 0, "default", dataIndex);
            flexChildren.add(configurationRow);
        }
        if (!flexChildren.isEmpty()) {
            FlexGridConfigRow row = new FlexGridConfigRow();
            row.copy(bean);
            FlexEdit flexEdit = (FlexEdit)view.getControl(bean.getFieldKey());
            row.setDefaultSplit(flexEdit == null || flexEdit.isDefaultSplit());
            if (row.isDefaultSplit()) {
                row.setFlexSplit(1);
            } else {
                row.setFlexSplit(0);
            }
            row.setChildren(flexChildren);
            row.setFlexMaxSize(0);
            return row;
        }
        return bean;
    }

    private static Map<String, Object> getEntryRuntimeMeta(String formId, String entryId) {
        MetadataService metadataService = (MetadataService)ServiceFactory.getService(MetadataService.class);
        String metadataString = metadataService.loadClientFormMeta(formId);
        Map meta = (Map)SerializationUtils.fromJsonString((String)metadataString, Map.class);
        return GridConfigRenderUtils.getEntryRuntimeMeta(entryId, meta);
    }

    private static Map<String, Object> getEntryRuntimeMeta(String entryId, Map<String, Object> meta) {
        List items;
        if (meta != null && meta.containsKey(KEY_ITEMS) && meta.get(KEY_ITEMS) instanceof List && (items = (List)meta.get(KEY_ITEMS)) != null && !items.isEmpty()) {
            for (Map item : items) {
                if (item.containsKey("id") && item.containsKey("columns") && Objects.equals(entryId, item.get("id"))) {
                    return item;
                }
                Map<String, Object> metadata = GridConfigRenderUtils.getEntryRuntimeMeta(entryId, item);
                if (metadata == null) continue;
                return metadata;
            }
        }
        return null;
    }

    private static List<Map<String, Object>> mergeConfigAndMeta(List<Map<String, Object>> columnMeta, List<GridConfigurationRow> setting) {
        if (columnMeta == null || columnMeta.size() < 3) {
            return columnMeta;
        }
        ArrayList<Map<String, Object>> newMeta = new ArrayList<Map<String, Object>>(columnMeta.size());
        newMeta.add(columnMeta.get(0));
        columnMeta.remove(0);
        newMeta.add(columnMeta.get(0));
        columnMeta.remove(0);
        newMeta.addAll(GridConfigRenderUtils.combineRuntimeMeta(columnMeta, setting));
        return newMeta;
    }

    private static List<Map<String, Object>> combineRuntimeMeta(List<Map<String, Object>> columnMeta, List<GridConfigurationRow> setting) {
        if (CollectionUtils.isEmpty(columnMeta) || CollectionUtils.isEmpty(setting)) {
            return columnMeta;
        }
        Map colsRunTimeMetaMap = columnMeta.stream().collect(Collectors.toMap(item -> item.get("dataIndex"), Function.identity(), (o, o2) -> o, LinkedHashMap::new));
        ArrayList<Map<String, Object>> newMeta = new ArrayList<Map<String, Object>>(columnMeta.size());
        for (GridConfigurationRow bean : setting) {
            String fieldKey = bean.getFieldKey();
            Map colMeta = (Map)colsRunTimeMetaMap.get(fieldKey);
            if (colMeta == null) continue;
            if (StringUtils.isBlank(colMeta.get("vi"))) {
                colMeta.put("vi", 63);
            }
            if (bean.isHide()) {
                colMeta.put("vi", 0);
            }
            if (bean.isFreeze()) {
                colMeta.put("isFixed", bean.isFreeze());
            }
            if (bean.isFreezer()) {
                colMeta.put("isFixedRight", true);
            }
            if (bean.getColWidth() != 0) {
                RequestContext rs = RequestContext.get();
                colMeta.put("w", new LocaleString(rs.getLang().name(), (Object)bean.getColWidth()));
            }
            if (bean.getTextAlign() != null) {
                colMeta.put("text-align", bean.getTextAlign());
            }
            colsRunTimeMetaMap.remove(fieldKey);
            newMeta.add(colMeta);
            Object children = colMeta.get(CHILDREN);
            if (children == null) continue;
            colMeta.put(CHILDREN, GridConfigRenderUtils.combineRuntimeMeta((List)colMeta.get(CHILDREN), bean.getChildren()));
        }
        newMeta.addAll(colsRunTimeMetaMap.values());
        return newMeta;
    }

    public static void setListColumnFixed(List<?> listColumns, List<Map<String, String>> freezeList) {
        if (CollectionUtils.isEmpty(freezeList)) {
            return;
        }
        Map<String, String> freezeMap = GridConfigRenderUtils.resetFreezeList(freezeList);
        Map<String, String> freezerMap = GridConfigRenderUtils.resetFreezerList(freezeList);
        for (Object column : listColumns) {
            boolean isFreezer;
            boolean isFreeze;
            String columnkey;
            if (column instanceof IListColumn) {
                columnkey = ((IListColumn)column).getListFieldKey();
                if (StringUtils.isBlank((CharSequence)columnkey) && column instanceof AbstractListColumn) {
                    columnkey = ((AbstractListColumn)column).getKey();
                }
                if (StringUtils.isBlank((CharSequence)columnkey) || !(isFreeze = Boolean.parseBoolean(freezeMap.get(columnkey)))) continue;
                ((IListColumn)column).setFixed(isFreeze);
                continue;
            }
            if (column instanceof IListColumnConfig) {
                columnkey = ((IListColumnConfig)column).getListFieldKey();
                if (StringUtils.isBlank((CharSequence)columnkey) || !(isFreeze = Boolean.parseBoolean(freezeMap.get(columnkey)))) continue;
                ((IListColumnConfig)column).setFixed(isFreeze);
                if (!(column instanceof Container)) continue;
                GridConfigRenderUtils.setFixed(column);
                continue;
            }
            if (column instanceof GridConfigurationRow) {
                columnkey = ((GridConfigurationRow)column).getFieldKey();
                if (StringUtils.isBlank((CharSequence)columnkey)) continue;
                isFreeze = Boolean.parseBoolean(freezeMap.get(columnkey));
                if (isFreeze) {
                    ((GridConfigurationRow)column).setFreeze(isFreeze);
                }
                if (!(isFreezer = Boolean.parseBoolean(freezerMap.get(columnkey)))) continue;
                ((GridConfigurationRow)column).setFreezer(isFreezer);
                continue;
            }
            if (!(column instanceof Map) || StringUtils.isBlank((CharSequence)(columnkey = ((Map)column).get("dataIndex") == null ? "" : (String)((Map)column).get("dataIndex")))) continue;
            isFreeze = Boolean.parseBoolean(freezeMap.get(columnkey));
            if (isFreeze) {
                ((Map)column).put("isFixed", isFreeze);
            }
            if (!(isFreezer = Boolean.parseBoolean(freezerMap.get(columnkey)))) continue;
            ((Map)column).put("isFixedRight", isFreezer);
        }
    }

    private static void setFixed(Object column) {
        if (column instanceof Container) {
            List<Control> items = ((Container)column).getItems();
            for (int i = 0; i < items.size(); ++i) {
                Control control = items.get(i);
                if (control instanceof IListColumnGroupConfig) {
                    ((IListColumnGroupConfig)((Object)control)).setFixed(true);
                    GridConfigRenderUtils.setFixed(control);
                    continue;
                }
                if (!(control instanceof AbstractListColumn)) continue;
                ((AbstractListColumn)control).setFixed(true);
            }
        }
    }

    private static Map<String, String> resetFreezeList(List<Map<String, String>> freezeList) {
        Map<String, String> map = new HashMap<String, String>(16);
        int index = 0;
        if (!CollectionUtils.isEmpty(freezeList)) {
            for (int i = freezeList.size() - 1; i >= 0; --i) {
                boolean isFreeze = Boolean.parseBoolean(freezeList.get(i).get("isfreeze"));
                if (!isFreeze) continue;
                index = i;
                break;
            }
            for (int j = 0; j < index; ++j) {
                freezeList.get(j).put("isfreeze", "true");
            }
            map = freezeList.stream().collect(Collectors.toMap(k -> (String)k.get("freezelistkey"), v -> (String)v.get("isfreeze"), (x, y) -> y));
        }
        return map;
    }

    private static Map<String, String> resetFreezerList(List<Map<String, String>> freezeList) {
        Map<String, String> map = new HashMap<String, String>(16);
        if (!CollectionUtils.isEmpty(freezeList)) {
            int index = freezeList.size() - 1;
            for (int i = 0; i < freezeList.size(); ++i) {
                boolean isFreezer = Boolean.parseBoolean(freezeList.get(i).get("isfreezer"));
                if (!isFreezer) continue;
                index = i;
                break;
            }
            for (int j = freezeList.size() - 1; j > index; --j) {
                freezeList.get(j).put("isfreezer", "true");
            }
            map = freezeList.stream().collect(Collectors.toMap(k -> (String)k.get("freezelistkey"), v -> v.get("isfreezer") != null ? (String)v.get("isfreezer") : "false", (x, y) -> y));
        }
        return map;
    }

    public static void setInitField(List<?> listColumns, List<Map<String, String>> initField) {
        if (CollectionUtils.isEmpty(initField)) {
            return;
        }
        Map<String, String> visibleMap = initField.stream().collect(Collectors.toMap(k -> (String)k.get("fieldkey"), v -> (String)v.get("isvisible"), (x, y) -> y));
        for (Object column : listColumns) {
            GridConfigRenderUtils.setInitFieldVi(column, visibleMap);
        }
    }

    private static void setInitFieldVi(Object column, Map<String, String> visibleMap) {
        block9: {
            block8: {
                if (!(column instanceof GridConfigurationRow)) break block8;
                String columnKey = ((GridConfigurationRow)column).getFieldKey();
                if (!visibleMap.containsKey(columnKey)) {
                    ((GridConfigurationRow)column).setHide(false);
                } else if (Boolean.FALSE.equals(Boolean.parseBoolean(visibleMap.get(columnKey)))) {
                    ((GridConfigurationRow)column).setHide(true);
                }
                List children = ((GridConfigurationRow)column).getChildren();
                if (children == null || children.isEmpty()) break block9;
                for (GridConfigurationRow row : children) {
                    GridConfigRenderUtils.setInitFieldVi(row, visibleMap);
                }
                break block9;
            }
            if (column instanceof Map) {
                List children;
                String columnKey;
                String string = columnKey = ((Map)column).get("dataIndex") == null ? "" : (String)((Map)column).get("dataIndex");
                if (visibleMap.containsKey(columnKey) && Boolean.FALSE.equals(Boolean.parseBoolean(visibleMap.get(columnKey)))) {
                    ((Map)column).put("vi", 0);
                }
                if ((children = (List)((Map)column).get(CHILDREN)) != null && !children.isEmpty()) {
                    for (Map row : children) {
                        GridConfigRenderUtils.setInitFieldVi(row, visibleMap);
                    }
                }
            }
        }
    }

    private static boolean isServerFilterModle(Control control) {
        if (control instanceof EntryGrid) {
            return ((EntryGrid)control).isServerFilterModle();
        }
        return false;
    }

    private static void setColumnCompareOperators(IFormView view, List<Map<String, Object>> columnMeta, Object orderAndFilter) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"setColumnCompareOperators");){
            for (Map<String, Object> column : columnMeta) {
                IDataEntityProperty property;
                ArrayList children;
                String fieldName = (String)column.get("dataIndex");
                ArrayList arrayList = children = column.get(CHILDREN) == null ? null : (ArrayList)column.get(CHILDREN);
                if (!CollectionUtils.isEmpty((Collection)children)) {
                    GridConfigRenderUtils.setColumnCompareOperators(view, children, orderAndFilter);
                }
                if ((property = view.getModel().getProperty(fieldName)) instanceof MulBasedataProp || property instanceof ItemClassProp || property instanceof FlexProp) {
                    column.put("sort", false);
                    column.put("filter", false);
                    continue;
                }
                if (property instanceof TimeProp) {
                    column.put("sort", true);
                    column.put("filter", false);
                    continue;
                }
                Object sort = column.get("sort");
                Object filter = column.get("filter");
                if (GridConfigRenderUtils.isSupportFilter(orderAndFilter, filter)) {
                    Object ctrl;
                    String basedataPropRefDisplayName;
                    String type = null;
                    String[] displayProps = EntityTypeUtil.getBasedataDisplayProps((IDataEntityProperty)property);
                    if (displayProps != null && displayProps.length > 0) {
                        if (GridConfigRenderUtils.isOrgProp(property) && ("fullname".equals(displayProps[0].toLowerCase()) || "longnumber".equals(displayProps[0].toLowerCase()))) {
                            column.put("filter", false);
                            column.put("sort", false);
                            continue;
                        }
                        fieldName = fieldName + "." + displayProps[0];
                        type = "text";
                    }
                    if (StringUtils.isNotBlank((CharSequence)(basedataPropRefDisplayName = GridConfigRenderUtils.getBasedataPropRefDisplayName(ctrl = view.getControl(fieldName))))) {
                        fieldName = basedataPropRefDisplayName;
                    }
                    FilterField filterField = FilterField.create((MainEntityType)view.getModel().getDataEntityType(), (String)fieldName);
                    if (span.isRealtime()) {
                        span.addTag(SPAN_FIELDNAME, fieldName);
                        span.addLocaleTag(SPAN_COMPARETYPES, (Object)(filterField == null ? "null" : SerializationUtils.toJsonString((Object)filterField.getCompareTypes())));
                    }
                    if (ctrl instanceof BasedataPropEdit && filterField != null && (filterField.getFieldProp() instanceof ComboProp || filterField.getFieldProp() instanceof BooleanProp)) {
                        type = "combo";
                    }
                    CompareType inCompareType = null;
                    if (filterField != null) {
                        inCompareType = property instanceof OrgProp ? filterField.getCompareType(CompareTypeEnum.ORGIN.getId()) : filterField.getCompareType(CompareTypeEnum.IN.getId());
                    }
                    column.put("filter", true);
                    ListColumnCompareHelper.setColumnCompareOperators(filterField, column, new HashMap<String, List<CompareType>>(0), null, type, null, null, new ArrayList<String>(), false);
                    if (inCompareType != null && (StringUtils.isNotBlank((CharSequence)basedataPropRefDisplayName) || property instanceof BasedataProp)) {
                        GridConfigRenderUtils.addInCompareTypeByBasedataProp(column, type, inCompareType);
                    }
                } else {
                    column.put("filter", false);
                }
                if (GridConfigRenderUtils.isSupportSort(orderAndFilter, sort)) {
                    column.put("sort", true);
                    continue;
                }
                column.put("sort", false);
            }
        }
    }

    private static List<Map<String, Object>> getDynamicCreateColumns(IFormView view, String entryId, List<Map<String, Object>> columnMetas) {
        String cacheKey = GridConfigRenderUtils.getPageCacheDynamicCreateColumn(view.getRootControl().getKey(), entryId);
        String dynamiccolumnStr = view.getPageCache().get(cacheKey);
        if (StringUtils.isNotBlank((CharSequence)dynamiccolumnStr)) {
            return (List)SerializationUtils.fromJsonString((String)dynamiccolumnStr, List.class);
        }
        Object control = view.getControl(entryId);
        if (control instanceof EntryGrid) {
            List<Control> items = ((EntryGrid)control).getItems();
            if (!CollectionUtils.isEmpty(columnMetas) && !CollectionUtils.isEmpty(items)) {
                Map<String, Map<String, Object>> columnMetaMap = GridConfigRenderUtils.getColumnMetaMap(columnMetas);
                HashSet<Object> dynamicColumnSet = new HashSet<Object>(10);
                List<Map<String, Object>> dynamicColumnList = GridConfigRenderUtils.getDynamicCreateColumns(columnMetaMap, dynamicColumnSet, items);
                view.getPageCache().put(cacheKey, SerializationUtils.toJsonString(dynamicColumnList));
                return dynamicColumnList;
            }
        }
        return new ArrayList<Map<String, Object>>(0);
    }

    private static List<Map<String, Object>> getDynamicCreateColumns(Map<String, Map<String, Object>> columnMetaMap, Set<Object> dynamicColumnSet, List<Control> items) {
        HashMap<String, Object> column = null;
        HashMap<String, String> editor = null;
        ArrayList<Map<String, Object>> dynamicColumnMeta = new ArrayList<Map<String, Object>>(10);
        for (Control ctl : items) {
            String key;
            if (ctl.isInvisible() || columnMetaMap.get(ctl.getKey()) != null || dynamicColumnSet.contains(key = ctl.getKey())) continue;
            if (ctl instanceof FieldEdit) {
                IDataEntityProperty fieldProp;
                FieldEdit edit = (FieldEdit)ctl;
                if (edit.isFlatField() || !((fieldProp = edit.getProperty()) instanceof IFieldHandle)) continue;
                editor = new HashMap<String, String>(1);
                editor.put("type", ((IFieldHandle)fieldProp).getFilterControlType());
                column = new HashMap(5);
                column.put("editor", editor);
                column.put("dataIndex", key);
                column.put("header", edit.getDisplayName());
                column.put("l", ctl.getLockIntegerVal());
                column.put("vi", ctl.getVisibleIntegerVal());
                dynamicColumnMeta.add(column);
                dynamicColumnSet.add(key);
                continue;
            }
            if (ctl instanceof OperationColumn) {
                column = new HashMap<String, Object>(5);
                column.put("sort", false);
                column.put("filter", false);
                column.put("header", key);
                column.put("dataIndex", key);
                column.put("vi", ctl.getVisibleIntegerVal());
                column.put("l", ctl.getLockIntegerVal());
                dynamicColumnMeta.add(column);
                dynamicColumnSet.add(key);
                continue;
            }
            if (!(ctl instanceof Container) || GridConfigRenderUtils.isHasFlatFieldInContainer((Container)ctl)) continue;
            column = new HashMap(4);
            column.put("header", key);
            column.put("dataIndex", key);
            column.put("vi", ctl.getVisibleIntegerVal());
            column.put("l", ctl.getLockIntegerVal());
            dynamicColumnMeta.add(column);
            dynamicColumnSet.add(key);
            if (CollectionUtils.isEmpty(((Container)ctl).getItems())) continue;
            List<Map<String, Object>> dynamicCreateColumns = GridConfigRenderUtils.getDynamicCreateColumns(columnMetaMap, dynamicColumnSet, ((Container)ctl).getItems());
            column.put(CHILDREN, dynamicCreateColumns);
        }
        return dynamicColumnMeta;
    }

    private static String getPageCacheDynamicCreateColumn(String formId, String entryId) {
        return String.format("dynamiccreatecolumn.%s.%s", formId, entryId);
    }

    private static boolean isHasFlatFieldInContainer(Container container) {
        List<Control> items = container.getItems();
        if (CollectionUtils.isEmpty(items)) {
            return true;
        }
        for (Control ctl : items) {
            FieldEdit edit;
            if (!(ctl instanceof FieldEdit ? (edit = (FieldEdit)ctl).isFlatField() : ctl instanceof Container && GridConfigRenderUtils.isHasFlatFieldInContainer((Container)ctl))) continue;
            return true;
        }
        return false;
    }

    private static void setCellSum(IFormView view, String entryId) {
        String formId = view.getFormShowParameter().getFormId();
        DynamicObject parameter = ParameterReader.getUserOptionParameter((Long)RequestContext.get().getCurrUserId(), (String)formId, (String)"bos_gridoptiontpl", (UserParaType)UserParaType.GRID, (String)entryId);
        boolean isCellSum = true;
        if (parameter != null && parameter.containsProperty("iscellsum")) {
            isCellSum = parameter.getBoolean("iscellsum");
        }
        HashMap<String, Boolean> configMeta = new HashMap<String, Boolean>(1);
        configMeta.put("isCellSum", isCellSum);
        IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        proxy.invokeControlMethod(entryId, "createGridColumns", configMeta);
    }

    private static List<Map<String, Object>> getUpdateGridConfigurationList(List<GridConfigurationRow> gridConfigurationRows, Map<String, Map<String, Object>> colMetaMap, boolean isReset, boolean serverFilterModle) {
        if (CollectionUtils.isEmpty(gridConfigurationRows)) {
            return new ArrayList<Map<String, Object>>(0);
        }
        ArrayList<Map<String, Object>> updateGridConfigurationList = new ArrayList<Map<String, Object>>(gridConfigurationRows.size());
        for (GridConfigurationRow gridConfigurationRow : gridConfigurationRows) {
            List<Map<String, Object>> childrenUpdateList;
            Object textAlign;
            String fieldKey = gridConfigurationRow.getFieldKey();
            HashMap<String, Object> updateColInfo = new HashMap<String, Object>(16);
            updateColInfo.put("dataIndex", fieldKey);
            String textAlignMeta = "default";
            int visbleValMeta = 63;
            boolean freezeMeta = false;
            boolean freezerMeta = false;
            Map<String, Object> colMeta = colMetaMap.get(fieldKey);
            if (colMeta != null) {
                textAlignMeta = colMeta.get("text-align") instanceof String ? (String)colMeta.get("text-align") : "default";
                visbleValMeta = colMeta.get("vi") == null ? 63 : Integer.parseInt(colMeta.get("vi").toString());
                freezeMeta = colMeta.get("isFixed") == null ? false : Boolean.parseBoolean(colMeta.get("isFixed").toString());
                boolean bl = freezerMeta = colMeta.get("isFixedRight") == null ? false : Boolean.parseBoolean(colMeta.get("isFixedRight").toString());
            }
            if (isReset) {
                updateColInfo.put("vi", visbleValMeta);
                updateColInfo.put("text-align", textAlignMeta);
                updateColInfo.put("isFixed", gridConfigurationRow.isFreeze());
                updateColInfo.put("isFixedRight", gridConfigurationRow.isFreezer());
            } else {
                if (gridConfigurationRow.isHide()) {
                    updateColInfo.put("vi", 0);
                }
                if (StringUtils.isNotBlank((CharSequence)(textAlign = gridConfigurationRow.getTextAlign())) && !textAlignMeta.equals(textAlign)) {
                    updateColInfo.put("text-align", textAlign);
                }
                boolean freeze = gridConfigurationRow.isFreeze();
                if (gridConfigurationRow.isFreeze() || !freezeMeta == freeze) {
                    updateColInfo.put("isFixed", freeze);
                }
                boolean freezer = gridConfigurationRow.isFreezer();
                if (gridConfigurationRow.isFreezer() || !freezerMeta == freezer) {
                    updateColInfo.put("isFixedRight", freezer);
                }
            }
            if (colMeta != null && serverFilterModle) {
                textAlign = FILTERANDSORT_COLUMN_PROPS.iterator();
                while (textAlign.hasNext()) {
                    String prop = (String)textAlign.next();
                    if (colMeta.get(prop) == null) continue;
                    updateColInfo.put(prop, colMeta.get(prop));
                }
            }
            if (!(CollectionUtils.isEmpty((Collection)gridConfigurationRow.getChildren()) || GridConfigRenderUtils.isFlexfield(colMeta) || CollectionUtils.isEmpty(childrenUpdateList = GridConfigRenderUtils.getUpdateGridConfigurationList(gridConfigurationRow.getChildren(), colMetaMap, isReset, serverFilterModle)))) {
                updateColInfo.put(CHILDREN, childrenUpdateList);
            }
            updateGridConfigurationList.add(updateColInfo);
        }
        return updateGridConfigurationList;
    }

    private static List<Map<String, Object>> getUpdateGridConfigurationByDynamicColumnList(Map<String, Map<String, Object>> colMetaMap, List<Map<String, Object>> dynamicColumnList) {
        if (colMetaMap == null || CollectionUtils.isEmpty(dynamicColumnList)) {
            return null;
        }
        ArrayList<Map<String, Object>> updateGridConfigurationList = new ArrayList<Map<String, Object>>(dynamicColumnList.size());
        for (Map<String, Object> columnMap : dynamicColumnList) {
            List<Map<String, Object>> childrenUpdateList;
            List childrenDynamicColumnList;
            String fieldKey = columnMap.get("dataIndex") == null ? "" : (String)columnMap.get("dataIndex");
            HashMap<String, Object> updateColInfo = new HashMap<String, Object>(16);
            updateColInfo.put("dataIndex", fieldKey);
            Map<String, Object> colMeta = colMetaMap.get(fieldKey);
            if (colMeta != null) {
                for (String prop : FILTERANDSORT_COLUMN_PROPS) {
                    if (colMeta.get(prop) == null) continue;
                    updateColInfo.put(prop, colMeta.get(prop));
                }
            }
            List list = childrenDynamicColumnList = columnMap.get(CHILDREN) == null ? null : (List)columnMap.get(CHILDREN);
            if (childrenDynamicColumnList != null && !CollectionUtils.isEmpty(childrenUpdateList = GridConfigRenderUtils.getUpdateGridConfigurationByDynamicColumnList(colMetaMap, childrenDynamicColumnList))) {
                updateColInfo.put(CHILDREN, childrenUpdateList);
            }
            updateGridConfigurationList.add(updateColInfo);
        }
        return updateGridConfigurationList;
    }

    private static Map<String, Map<String, Object>> getColumnMetaMap(List<Map<String, Object>> columnMetas) {
        HashMap<String, Map<String, Object>> columnMetaMap = new HashMap<String, Map<String, Object>>(columnMetas.size());
        for (Map<String, Object> column : columnMetas) {
            String fieldName = (String)column.get("dataIndex");
            columnMetaMap.put(fieldName, column);
            ArrayList children = column.get(CHILDREN) == null ? null : (ArrayList)column.get(CHILDREN);
            if (CollectionUtils.isEmpty((Collection)children)) continue;
            columnMetaMap.putAll(GridConfigRenderUtils.getColumnMetaMap(children));
        }
        return columnMetaMap;
    }

    private static boolean isEqUpdateGridColumnMetaData(Map<String, Object> configMetaMap, Map<String, Object> lastConfigMetaMap) {
        if (configMetaMap == null || lastConfigMetaMap == null) {
            return false;
        }
        if (!(configMetaMap.get("columns") instanceof List) || !(lastConfigMetaMap.get("columns") instanceof List)) {
            return false;
        }
        List updateGridConfigurationList = (List)configMetaMap.get("columns");
        List lastUpdateGridConfigurationList = (List)lastConfigMetaMap.get("columns");
        if (updateGridConfigurationList.size() != lastUpdateGridConfigurationList.size()) {
            return false;
        }
        return GridConfigRenderUtils.isEqUpdateGridColumnMetaData(updateGridConfigurationList, lastUpdateGridConfigurationList);
    }

    private static boolean isEqUpdateGridColumnMetaData(List<Map<String, Object>> updateGridConfigurationList, List<Map<String, Object>> lastUpdateGridConfigurationList) {
        if (updateGridConfigurationList.size() != lastUpdateGridConfigurationList.size()) {
            return false;
        }
        for (int i = 0; i < updateGridConfigurationList.size(); ++i) {
            Map<String, Object> gridConfigurationMap = updateGridConfigurationList.get(i);
            Map<String, Object> lastGridConfigurationMap = lastUpdateGridConfigurationList.get(i);
            if (gridConfigurationMap.size() != lastGridConfigurationMap.size()) {
                return false;
            }
            for (Map.Entry<String, Object> map : gridConfigurationMap.entrySet()) {
                List lastChildrenUpdateList;
                List childrenUpdateList;
                String key = map.getKey();
                if (FILTERANDSORT_COLUMN_PROPS.contains(key)) continue;
                Object value = map.getValue();
                Object lastValue = lastGridConfigurationMap.get(key);
                if (value == null || lastValue == null) {
                    return false;
                }
                String className = value.getClass().getName();
                if (!className.equals(lastValue.getClass().getName())) {
                    return false;
                }
                if (!(value instanceof String || value instanceof Integer || value instanceof Boolean ? !StringUtils.equals((CharSequence)String.valueOf(value), (CharSequence)String.valueOf(lastValue)) : value instanceof List && !GridConfigRenderUtils.isEqUpdateGridColumnMetaData(childrenUpdateList = (List)value, lastChildrenUpdateList = (List)lastValue))) continue;
                return false;
            }
        }
        return true;
    }

    private static List<Map<String, Object>> getSysColumnList(Map<String, Map<String, Object>> columnMetaMap) {
        HashMap<String, String> updateColInfo;
        ArrayList<Map<String, Object>> sysList = new ArrayList<Map<String, Object>>(2);
        if (columnMetaMap.get("rk") != null) {
            updateColInfo = new HashMap<String, String>(1);
            updateColInfo.put("dataIndex", "rk");
            sysList.add(updateColInfo);
        }
        if (columnMetaMap.get("seq") != null) {
            updateColInfo = new HashMap(1);
            updateColInfo.put("dataIndex", "seq");
            sysList.add(updateColInfo);
        }
        return sysList;
    }

    private static boolean isFlexfield(Map<String, Object> colMeta) {
        if (colMeta != null && colMeta.get("editor") instanceof Map) {
            String type;
            Map editorMap = (Map)colMeta.get("editor");
            String string = type = editorMap.get("type") == null ? "" : (String)editorMap.get("type");
            if ("flexfield".equals(type)) {
                return true;
            }
        }
        return false;
    }

    private static List<GridConfigurationRow> combineGridConfigurationRow(List<GridConfigurationRow> userRows, List<GridConfigurationRow> entityRows) {
        HashMap<String, GridConfigurationRow> entityRowsMap = new HashMap<String, GridConfigurationRow>(entityRows.size());
        for (GridConfigurationRow entityRow : entityRows) {
            entityRowsMap.put(entityRow.getFieldKey(), entityRow);
        }
        ArrayList<GridConfigurationRow> newRows = new ArrayList<GridConfigurationRow>(userRows.size());
        for (GridConfigurationRow userRow : userRows) {
            GridConfigurationRow entityRow = (GridConfigurationRow)entityRowsMap.get(userRow.getFieldKey());
            if (entityRow == null) continue;
            newRows.add(userRow);
            entityRowsMap.remove(userRow.getFieldKey());
            List userRowChildren = userRow.getChildren();
            List entityRowChildren = entityRow.getChildren();
            if (CollectionUtils.isEmpty((Collection)userRowChildren) && CollectionUtils.isEmpty((Collection)entityRowChildren)) continue;
            userRow.setChildren(GridConfigRenderUtils.combineGridConfigurationRow(userRowChildren, entityRowChildren));
        }
        newRows.addAll(entityRowsMap.values());
        return newRows;
    }

    private static boolean isSupportFilter(Object orderAndFilter, Object filter) {
        if (orderAndFilter instanceof Integer) {
            int temp = (Integer)orderAndFilter;
            return temp == 0 || temp == 3;
        }
        return filter == null || filter instanceof Boolean && (Boolean)filter != false;
    }

    private static boolean isSupportSort(Object orderAndFilter, Object sort) {
        if (orderAndFilter instanceof Integer) {
            int temp = (Integer)orderAndFilter;
            return temp == 0 || temp == 2;
        }
        return sort == null || sort instanceof Boolean && (Boolean)sort != false;
    }

    private static void addInCompareTypeByBasedataProp(Map<String, Object> column, String type, CompareType compareType) {
        ArrayList listColumnCompareTypes;
        HashMap editor;
        if (column.get("editor") instanceof Map && (editor = (HashMap)column.get("editor")).get("type") != null && type == null) {
            type = editor.get("type").toString();
        }
        if ("text".equals(type) && column.get("filterItems") instanceof List && !CollectionUtils.isEmpty((Collection)(listColumnCompareTypes = (ArrayList)column.get("filterItems")))) {
            ListColumnCompareType listColumnCompareType = new ListColumnCompareType(compareType.getId(), compareType.getName(), compareType.getValue(), compareType.getInputCtlType(), false);
            if (listColumnCompareTypes.size() >= 4) {
                listColumnCompareTypes.add(4, listColumnCompareType);
            } else {
                listColumnCompareTypes.add(listColumnCompareType);
            }
        }
    }

    @SdkInternal
    public static String getBasedataPropRefDisplayName(Control ctrl) {
        String basedataPropRefDisplayName = null;
        if (ctrl instanceof BasedataPropEdit) {
            BasedataPropEdit basedataPropEdit = (BasedataPropEdit)ctrl;
            if (basedataPropEdit.getRefDisplayProp() == null) {
                BasedataEntityType dt;
                String displayPropertyName;
                BasedataProp baseProp;
                if (basedataPropEdit.getProperty() instanceof BasedataProp && (baseProp = (BasedataProp)basedataPropEdit.getProperty()).getComplexType() instanceof BasedataEntityType && StringUtils.isNotBlank((CharSequence)(displayPropertyName = GridConfigRenderUtils.getBasedataDisplayPropertyName(dt = (BasedataEntityType)baseProp.getComplexType(), baseProp.getDisplayProp())))) {
                    basedataPropRefDisplayName = basedataPropEdit.getRefBasedataProp() + "." + displayPropertyName;
                }
            } else {
                basedataPropRefDisplayName = basedataPropEdit.getRefBasedataProp() + "." + basedataPropEdit.getRefDisplayProp();
            }
        }
        return basedataPropRefDisplayName;
    }

    private static String getBasedataDisplayPropertyName(BasedataEntityType dt, String displayProp) {
        String key;
        IDataEntityProperty prop = dt.findProperty(displayProp);
        if (prop != null) {
            return prop.getName();
        }
        String nameKey = dt.getNameProperty();
        String numberKey = dt.getNumberProperty();
        String string = key = nameKey == null ? numberKey : nameKey;
        if ("number".equalsIgnoreCase(displayProp) && StringUtils.isNotBlank((CharSequence)numberKey)) {
            key = numberKey;
        }
        return key;
    }

    private static boolean isOrgProp(IDataEntityProperty property) {
        BasedataEntityType dt;
        DynamicObjectType dynamicComplexPropertyType;
        if (property instanceof OrgProp) {
            return true;
        }
        return property instanceof DynamicComplexProperty && (dynamicComplexPropertyType = ((DynamicComplexProperty)property).getDynamicComplexPropertyType()) instanceof BasedataEntityType && GridConfigRenderUtils.isExtBosOrg((dt = (BasedataEntityType)dynamicComplexPropertyType).getInheritPath(), dt.getName());
    }

    private static boolean isExtBosOrg(String inheritPath, String name) {
        return StringUtils.equals((CharSequence)"bos_org", (CharSequence)name) || StringUtils.contains((CharSequence)inheritPath, (CharSequence)BOS_ORG);
    }
}

