/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.mcontrol.mobtable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.BindingContext;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.gridconfig.GridConfigRenderUtils;
import kd.bos.form.mcontrol.mobtable.IMobTableModel;
import kd.bos.form.mcontrol.mobtable.MobTableData;
import kd.bos.form.mcontrol.mobtable.MobTableModel;
import kd.bos.form.mcontrol.mobtable.events.BeforeCreateMobTableColumnsEvent;
import kd.bos.form.mcontrol.mobtable.events.IBeforeCreateMobTableColumnsListener;
import kd.bos.form.mcontrol.mobtable.events.IMobTableDataProviderListener;
import kd.bos.form.mcontrol.mobtable.events.IMobTableHyperLinkClickListener;
import kd.bos.form.mcontrol.mobtable.events.IMobTablePackageDataHandlerListener;
import kd.bos.form.mcontrol.mobtable.events.IMobTablePrepareDataListener;
import kd.bos.form.mcontrol.mobtable.events.MobTableDataProviderEvent;
import kd.bos.form.mcontrol.mobtable.events.MobTableHyperLinkClickEvent;
import kd.bos.form.mcontrol.mobtable.events.MobTablePrepareDataArgs;
import kd.bos.form.mcontrol.mobtable.tablecolumn.MobTableColumn;
import kd.bos.mservice.svc.attach.IAttachmentMobTableColumn;
import kd.bos.script.annotations.KSMethod;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataService;
import kd.bos.util.CollectionUtils;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class MobTable
extends Container {
    private static final String SPAN_TYPE_PLUGIN = "plugin";
    private static final String WIDTH = "width";
    private static final String NUMBER_FIELD = "numberfield";
    private static final String IS_COL_PAGE_FIXED = "isColPageFixed";
    private static final String FMT_INFO = "fmtinfo";
    private static final String KEY_ITEMS = "items";
    private static final String ZH_CN = "zh_CN";
    private static final String DATA = "data";
    private static final String ENTITY_ID = "entityId";
    private static final String ENTRY_KEY = "Key";
    private static final String CREATE_GRID_COLUMNS = "createGridColumns";
    private static final String ROW_COUNT = "rowcount";
    private static final String ROWS = "rows";
    private static final String DATA_INDEX = "dataindex";
    private static final String RK = "rk";
    private static final String TABLE_DATA = "table_data";
    private boolean showSeq;
    private String mobTableType;
    private Map<String, Object> mobTableDataSource;
    private MobTableModel mobTableModel;
    private List<MobTableColumn> mobTableColumns = new ArrayList<MobTableColumn>();
    private Map<String, Object> customParams = new HashMap<String, Object>();
    private List<Map<String, String>> freezeList;
    List<Map<String, Object>> cacheDataMapList = null;
    private List<IBeforeCreateMobTableColumnsListener> beforeCreateMobTableColumnsListeners = new ArrayList<IBeforeCreateMobTableColumnsListener>();
    private List<IMobTableDataProviderListener> mobTableDataProviderListeners = new ArrayList<IMobTableDataProviderListener>();
    private List<IMobTablePackageDataHandlerListener> mobTablePackageDataHandlerListeners = new ArrayList<IMobTablePackageDataHandlerListener>();
    private List<IMobTableHyperLinkClickListener> hyperLinkClickListeners = new ArrayList<IMobTableHyperLinkClickListener>();
    private List<IMobTablePrepareDataListener> prepareDataListener = new ArrayList<IMobTablePrepareDataListener>();

    @SimplePropertyAttribute
    public List<Map<String, String>> getFreezeList() {
        return this.freezeList;
    }

    public void setFreezeList(List<Map<String, String>> freezeList) {
        this.freezeList = freezeList;
    }

    @SimplePropertyAttribute(name="ShowSeq")
    public boolean isShowSeq() {
        return this.showSeq;
    }

    public void setShowSeq(boolean showSeq) {
        this.showSeq = showSeq;
    }

    @SimplePropertyAttribute
    public String getMobTableType() {
        return this.mobTableType;
    }

    public void setMobTableType(String mobTableType) {
        this.mobTableType = mobTableType;
    }

    @SimplePropertyAttribute
    public Map<String, Object> getMobTableDataSource() {
        return this.mobTableDataSource;
    }

    public void setMobTableDataSource(Map<String, Object> mobTableDataSource) {
        this.mobTableDataSource = mobTableDataSource;
    }

    public List<MobTableColumn> getMobTableColumns() {
        return this.mobTableColumns;
    }

    public void setMobTableColumns(List<MobTableColumn> mobTableColumns) {
        this.mobTableColumns = mobTableColumns;
    }

    public Map<String, Object> getCustomParams() {
        return this.customParams;
    }

    @KSMethod
    public <T> T getCustomParam(String name) {
        return (T)this.customParams.get(name);
    }

    @KSMethod
    public void setCustomParam(String name, Object value) {
        this.customParams.put(name, value);
    }

    @Override
    public void bindData(BindingContext bctx) {
        this.addMobTableListener();
        this.renderGridColumn();
        MobTableData data = this.getData();
        this.clientViewProxy.setEntryProperty(this.getKey(), DATA, data.getData());
        this.clientViewProxy.setEntryProperty(this.getKey(), FMT_INFO, data.getFmtInfo());
    }

    protected void addMobTableListener() {
        if (this.isFetchDataFromMobDataSource()) {
            Map<String, Object> mobDataSource = this.getMobTableDataSource();
            final String entryKey = String.valueOf(mobDataSource.get(ENTRY_KEY));
            this.addBeforeCreateMobTableColumnsListener(new IBeforeCreateMobTableColumnsListener(){

                @Override
                public void beforeCreateMobTableColumns(BeforeCreateMobTableColumnsEvent event) {
                    List<MobTableColumn> eventMobTableColumns = event.getMobTableColumns();
                    Map entryMeta = MobTable.this.getEntryRuntimeMeta(entryKey);
                    List columnMeta = null;
                    if (entryMeta != null && !entryMeta.isEmpty()) {
                        columnMeta = (List)entryMeta.get("columns");
                    }
                    MobTable.this.mergeColumnAndMeta(columnMeta, eventMobTableColumns);
                }
            });
        }
    }

    private boolean isFetchDataFromMobDataSource() {
        Map<String, Object> mobDataSource = this.getMobTableDataSource();
        return mobDataSource != null && mobDataSource.get(ENTITY_ID) instanceof String && mobDataSource.get(ENTRY_KEY) instanceof String;
    }

    private void renderGridColumn() {
        HashMap<String, Object> meta = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> cols = new ArrayList<Map<String, Object>>();
        this.createHiddenColumn(cols);
        this.createSysInnerColumns(cols);
        for (Control ctl : this.getItems()) {
            if (!(ctl instanceof MobTableColumn)) continue;
            this.getMobTableColumns().add((MobTableColumn)ctl);
        }
        BeforeCreateMobTableColumnsEvent beforeCreateMobTableColumnsEvent = new BeforeCreateMobTableColumnsEvent(this, this.getMobTableColumns());
        beforeCreateMobTableColumnsEvent.setCustomParams(this.getCustomParams());
        beforeCreateMobTableColumnsEvent.setControl(this);
        this.fireBeforeCreateMobTableColumns(beforeCreateMobTableColumnsEvent);
        this.getMobTableColumns().forEach(mobTableColumn -> {
            Map<String, Object> column = mobTableColumn.createColumn();
            cols.add(column);
        });
        GridConfigRenderUtils.setListColumnFixed(cols, this.getFreezeList());
        meta.put("columns", cols);
        meta.put(RK, RK);
        this.clientViewProxy.preInvokeControlMethod(this.getKey(), CREATE_GRID_COLUMNS, meta);
    }

    private void createSysInnerColumns(List<Map<String, Object>> cols) {
        Map<String, Object> col = this.createColumn("fseq", new LocaleString(ZH_CN, ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"MobTable_0", (String)"bos-form-metadata", (Object[])new Object[0])));
        if (!this.isShowSeq()) {
            col.put("visible", false);
        }
        col.put("type", NUMBER_FIELD);
        col.put(IS_COL_PAGE_FIXED, true);
        if (CollectionUtils.isNotEmpty(this.getFreezeList())) {
            col.put("isFixed", true);
        }
        cols.add(col);
    }

    private void createHiddenColumn(List<Map<String, Object>> cols) {
        Map<String, Object> col = this.createColumn(RK, new LocaleString(ZH_CN, RK));
        col.put("visible", false);
        cols.add(col);
    }

    private Map<String, Object> createColumn(String key, LocaleString caption) {
        HashMap<String, Object> col = new HashMap<String, Object>();
        col.put("dataIndex", key);
        col.put("header", caption);
        col.put(WIDTH, 50);
        return col;
    }

    private void mergeColumnAndMeta(List<Map<String, Object>> columnMeta, List<MobTableColumn> mobTableColumns) {
        if (columnMeta == null || columnMeta.size() < 3) {
            return;
        }
        columnMeta.remove(0);
        columnMeta.remove(0);
        HashMap<Object, Map<String, Object>> meta = new HashMap<Object, Map<String, Object>>();
        this.getMeta(columnMeta, meta);
        for (MobTableColumn mobTableColumn : mobTableColumns) {
            Map colMeta = (Map)meta.get(mobTableColumn.getMobTableField());
            if (colMeta == null) continue;
            mobTableColumn.setColumnMeta(colMeta);
        }
    }

    private void getMeta(List<Map<String, Object>> columnMeta, Map<Object, Map<String, Object>> meta) {
        for (Map<String, Object> map : columnMeta) {
            meta.put(map.get("dataIndex"), map);
            Object children = map.get("children");
            if (!(children instanceof List) || ((List)children).size() <= 0) continue;
            this.getMeta((List)children, meta);
        }
    }

    private Map<String, Object> getEntryRuntimeMeta(String entryId) {
        MetadataService metadataService = (MetadataService)ServiceFactory.getService(MetadataService.class);
        String formId = this.getView().getFormShowParameter().getFormId();
        String entityTypeId = FormMetadataCache.getFormConfig(formId).getEntityTypeId();
        String metadataString = metadataService.loadClientFormMeta(entityTypeId);
        Map meta = (Map)SerializationUtils.fromJsonString((String)metadataString, Map.class);
        return MobTable.getEntryRuntimeMeta(entryId, meta);
    }

    private static Map<String, Object> getEntryRuntimeMeta(String entryId, Map<String, Object> meta) {
        List items;
        if (meta != null && meta.containsKey(KEY_ITEMS) && meta.get(KEY_ITEMS) instanceof List && (items = (List)meta.get(KEY_ITEMS)) != null && !items.isEmpty()) {
            for (Map item : items) {
                if (item.containsKey("id") && item.containsKey("columns") && Objects.equals(entryId, item.get("id"))) {
                    return item;
                }
                if (item.containsKey("id") && !item.containsKey("columns") && Objects.equals(entryId, item.get("id"))) {
                    LinkedHashMap<String, Object> cardEntryRuntimeMeta = new LinkedHashMap<String, Object>();
                    ArrayList<Map<String, Object>> columns = new ArrayList<Map<String, Object>>();
                    columns.add(Collections.emptyMap());
                    columns.add(Collections.emptyMap());
                    MobTable.collectCardFieldColumn(item, columns);
                    cardEntryRuntimeMeta.put("columns", columns);
                    return cardEntryRuntimeMeta;
                }
                Map<String, Object> metadata = MobTable.getEntryRuntimeMeta(entryId, item);
                if (metadata == null) continue;
                return metadata;
            }
        }
        return null;
    }

    private static void collectCardFieldColumn(Map<String, Object> cardEntryItem, List<Map<String, Object>> columns) {
        List items;
        if (cardEntryItem != null && cardEntryItem.containsKey(KEY_ITEMS) && cardEntryItem.get(KEY_ITEMS) instanceof List && (items = (List)cardEntryItem.get(KEY_ITEMS)) != null && !items.isEmpty()) {
            for (Map item : items) {
                if (item.containsKey("type") && Objects.equals("cardfield", item.get("type"))) {
                    columns.add(item);
                    continue;
                }
                MobTable.collectCardFieldColumn(item, columns);
            }
        }
    }

    public MobTableData getData() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        IMobTableModel model = this.getMobTableModel();
        MobTableData mobTableData = model.getData();
        result.put(DATA_INDEX, mobTableData.getData().get(DATA_INDEX));
        result.put(ROW_COUNT, mobTableData.getData().get(ROW_COUNT));
        result.put(ROWS, mobTableData.getData().get(ROWS));
        mobTableData.setData(result);
        return mobTableData;
    }

    public IMobTableModel getMobTableModel() {
        if (this.mobTableModel == null) {
            this.mobTableModel = (MobTableModel)TypesContainer.createInstance((String)"kd.bos.form.mcontrol.mobtable.MobTableModel");
            if (this.getMobTableDataSource() != null) {
                this.mobTableModel.setEntityId(String.valueOf(this.getMobTableDataSource().get(ENTITY_ID)));
                this.mobTableModel.setEntryKey(String.valueOf(this.getMobTableDataSource().get(ENTRY_KEY)));
            }
            String formId = this.getView().getFormShowParameter().getFormId();
            String entityTypeId = FormMetadataCache.getFormConfig(formId).getEntityTypeId();
            this.mobTableModel.setEntityTypeId(entityTypeId);
            DynamicObject dataEntity = this.getModel().getDataEntity();
            this.mobTableModel.setPkId(dataEntity.getDataEntityState().getFromDatabase() ? dataEntity.getPkValue() : null);
            this.mobTableModel.setControl(this);
            this.mobTableModel.setMobTableColumns(this.getMobTableColumns());
            this.fireMobTableDataProviderListener(this.mobTableModel);
            this.mobTableModel.setMobTablePackageDataListeners(this.mobTablePackageDataHandlerListeners);
        }
        return this.mobTableModel;
    }

    public void addBeforeCreateMobTableColumnsListener(IBeforeCreateMobTableColumnsListener listener) {
        this.beforeCreateMobTableColumnsListeners.add(listener);
    }

    protected void fireBeforeCreateMobTableColumns(BeforeCreateMobTableColumnsEvent beforeCreateMobTableColumnsEvent) {
        for (IBeforeCreateMobTableColumnsListener listener : this.beforeCreateMobTableColumnsListeners) {
            EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(listener.getClass().getName() + ".beforeCreateMobTableColumns"));
            Throwable throwable = null;
            try {
                listener.beforeCreateMobTableColumns(beforeCreateMobTableColumnsEvent);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                span.close();
            }
        }
    }

    @Deprecated
    public void addMobTableDataProviderListener(IMobTableDataProviderListener listener) {
        this.mobTableDataProviderListeners.add(listener);
    }

    private void fireMobTableDataProviderListener(IMobTableModel model) {
        MobTableDataProviderEvent event = new MobTableDataProviderEvent(this);
        for (IMobTableDataProviderListener listener : this.mobTableDataProviderListeners) {
            listener.createMobTableDataProvider(event);
        }
        if (event.getMobTableDataProvider() != null) {
            model.setMobTableDataProvider(event.getMobTableDataProvider());
        }
    }

    public void addMobTablePackageDataHandlerListener(IMobTablePackageDataHandlerListener listener) {
        this.mobTablePackageDataHandlerListeners.add(listener);
    }

    public void attachmentClick(Map<String, Object> params) {
        String key = params.get("c").toString();
        int row = (Integer)params.get("r");
        IAttachmentMobTableColumn attachmentMobTableColumn = (IAttachmentMobTableColumn)this.getView().getControl(key);
        attachmentMobTableColumn.openMobEntryUploadView(row, true);
    }

    public void addHyperClickListener(IMobTableHyperLinkClickListener listener) {
        this.hyperLinkClickListeners.add(listener);
        this.prepareDataListener.add(listener);
    }

    public List<IMobTableHyperLinkClickListener> getHyperLinkClickListeners() {
        return this.hyperLinkClickListeners;
    }

    public List<IMobTablePrepareDataListener> getPrepareDataListener() {
        return this.prepareDataListener;
    }

    public void hyperLinkClick(String fieldName, int rowIndex) {
        MobTableHyperLinkClickEvent event = new MobTableHyperLinkClickEvent(this, fieldName, rowIndex);
        for (IMobTableHyperLinkClickListener listener : this.getHyperLinkClickListeners()) {
            this.setHyperLinkClickData(listener, event);
            listener.hyperLinkClick(event);
        }
    }

    private void setHyperLinkClickData(IMobTableHyperLinkClickListener listener, MobTableHyperLinkClickEvent event) {
        int rowIndex = event.getRowIndex();
        MobTablePrepareDataArgs prepareDataArgs = new MobTablePrepareDataArgs(this);
        listener.onPrepareData(prepareDataArgs);
        List<String> mobTableColKeys = prepareDataArgs.getMobTableColKeys();
        if (mobTableColKeys.isEmpty()) {
            return;
        }
        String cacheData = this.getView().getPageCache().get(String.format("%s_%s", this.getKey(), TABLE_DATA));
        if (StringUtils.isNotBlank((CharSequence)cacheData) && this.cacheDataMapList == null) {
            this.cacheDataMapList = SerializationUtils.fromJsonStringToList((String)cacheData, Map.class);
        }
        if (this.cacheDataMapList == null || this.cacheDataMapList.isEmpty()) {
            return;
        }
        LinkedHashMap<String, Object> rowDataMap = new LinkedHashMap<String, Object>(16);
        for (Map<String, Object> cacheDataMap : this.cacheDataMapList) {
            if (cacheDataMap.get(RK) == null || rowIndex != (Integer)cacheDataMap.get(RK)) continue;
            for (Map.Entry<String, Object> entry : cacheDataMap.entrySet()) {
                String key = entry.getKey();
                if (!RK.equals(key) && !mobTableColKeys.contains(key)) continue;
                rowDataMap.put(key, entry.getValue());
            }
        }
        event.setRowDataMap(rowDataMap);
    }
}

